package org.thewonderlemming.c4plantuml.mojo.linting.rules.custom;

import java.util.Optional;
import java.util.Properties;

/**
 * A factory to create a {@link AbstractCustomLintingRule}.
 * <p>
 * Extend the following class if you intend to create your own rules but don't want to integrate them to the current
 * plugin.
 * <p>
 * Please note that you'll also have to to implement a {@link AbstractCustomLintingRule}.
 *
 * @author thewonderlemming
 *
 * @param <R> the type of {@link AbstractCustomLintingRule} to build.
 */
public abstract class AbstractCustomLintingRuleFactory<R extends AbstractCustomLintingRule> {

    /**
     * Creates an instance of {@link AbstractCustomLintingRule} given a set of {@link Properties} gathered from the
     * {@code pom.xml} file..
     *
     * @param parameters the {@code pom.xml} configuration.
     * @return an {@link Optional} of the newly created instance, or empty on failure.
     */
    public abstract Optional<R> createCustomRule(final Properties parameters);
}
