/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.testbed.junit;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.easymock.EasyMock;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thewonderlemming.c4plantuml.testingutils.Mock;
import org.thewonderlemming.c4plantuml.testingutils.MockType;
import org.thewonderlemming.c4plantuml.testingutils.TestBedUtils;

public class InjectMocksRule<T>
implements TestRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(InjectMocksRule.class);
    private final Set<Object> mocksToVerifyAfterTests = new HashSet<Object>();
    private final Class<T> testClass;
    private final T testInstance;

    private static boolean isAnnotatedWithMock(Field field) {
        return field.getAnnotation(Mock.class) != null;
    }

    public InjectMocksRule(T testInstance) {
        this.testInstance = testInstance;
        this.testClass = testInstance.getClass();
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                InjectMocksRule.this.mocksToVerifyAfterTests.clear();
                InjectMocksRule.this.injectMocks();
                try {
                    base.evaluate();
                }
                catch (Throwable t) {
                    InjectMocksRule.this.verifyMocks();
                    throw t;
                }
            }
        };
    }

    private void injectMock(Field field) {
        field.setAccessible(true);
        Mock mockAnnotation = field.getAnnotation(Mock.class);
        assert (mockAnnotation != null) : "Expected field " + field.getName() + " to be annotated with annotation " + Mock.class.getName();
        MockType mockType = mockAnnotation.value();
        Object mock = mockType.createMock(field.getType());
        if (mockAnnotation.readyToUse()) {
            EasyMock.replay((Object[])new Object[]{mock});
        }
        try {
            field.set(this.testInstance, mock);
            if (mockAnnotation.verifyMocksAfterEachTest()) {
                this.mocksToVerifyAfterTests.add(mock);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            LOGGER.error("Fatal: could not inject mock into field {} if class {} because of the following: {}", new Object[]{field.getName(), this.testClass.getName(), e.getMessage()});
        }
    }

    private void injectMocks() {
        TestBedUtils.findFieldsInTypeAndParentTypes(this.testClass).stream().filter(InjectMocksRule::isAnnotatedWithMock).forEach(field -> this.injectMock((Field)field));
    }

    private void verifyMocks() {
        this.mocksToVerifyAfterTests.forEach(mock -> EasyMock.verify((Object[])new Object[]{mock}));
    }
}

