/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.testbed.mojo.junit;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thewonderlemming.c4plantuml.testbed.mojo.junit.InjectMojoParameters;
import org.thewonderlemming.c4plantuml.testbed.mojo.junit.MojoParameter;
import org.thewonderlemming.c4plantuml.testingutils.TestBedUtils;

public class InjectMojoParametersRule<T>
implements TestRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(InjectMojoParametersRule.class);
    private final Class<T> testClass;
    private final T testInstance;

    private static <A extends Annotation> boolean isAnnotatedWith(Field field, Class<A> annotationType) {
        return field.getAnnotation(annotationType) != null;
    }

    private static boolean isAnnotatedWithInjectMojoParameters(Field field) {
        return InjectMojoParametersRule.isAnnotatedWith(field, InjectMojoParameters.class);
    }

    private static boolean isAnnotatedWithMojoParameter(Field field) {
        return InjectMojoParametersRule.isAnnotatedWith(field, MojoParameter.class);
    }

    public InjectMojoParametersRule(T testInstance) {
        this.testInstance = testInstance;
        this.testClass = testInstance.getClass();
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                InjectMojoParametersRule.this.injectMojoParameters();
                base.evaluate();
            }
        };
    }

    private Object findSutOrFail() {
        List sutFields = TestBedUtils.findFieldsInTypeAndParentTypes(this.testClass).stream().filter(InjectMojoParametersRule::isAnnotatedWithInjectMojoParameters).collect(Collectors.toList());
        if (sutFields.isEmpty()) {
            throw new RuntimeException("Fatal: No " + InjectMojoParameters.class.getName() + " annotated field found. Cannot guess system under test.");
        }
        if (sutFields.size() != 1) {
            throw new RuntimeException("Fatail: Multiple " + InjectMojoParameters.class.getName() + " annotated fields are not supported by this rule.");
        }
        Field sutField = (Field)sutFields.get(0);
        sutField.setAccessible(true);
        try {
            return sutField.get(this.testInstance);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            String errMessage = String.format("Could not retrieve the SUT instance because the following error happened: %s", e.getMessage());
            LOGGER.error(errMessage);
            throw new RuntimeException(errMessage, e);
        }
    }

    private Map<String, Object> getFieldValueByName() {
        return TestBedUtils.findFieldsInTypeAndParentTypes(this.testClass).stream().filter(InjectMojoParametersRule::isAnnotatedWithMojoParameter).map(field -> {
            try {
                field.setAccessible(true);
                Object value = field.get(this.testInstance);
                MojoParameter annotation = field.getAnnotation(MojoParameter.class);
                String fieldName = annotation.fieldName().isEmpty() ? field.getName() : annotation.fieldName();
                return Optional.of(new AbstractMap.SimpleEntry<String, Object>(fieldName, value));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                LOGGER.error("An error occurred while inject field {} in class {}: {}", new Object[]{field.getName(), this.testClass.getName(), e.getMessage()});
                return Optional.empty();
            }
        }).filter(Optional::isPresent).map(Optional::get).map(entry -> (Map.Entry)entry).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private void injectMojoParameters() {
        Map<String, Object> fieldValueByName = this.getFieldValueByName();
        Object sut = this.findSutOrFail();
        Class<?> sutClass = sut.getClass();
        LOGGER.debug("Getting reading to inject values into SUT fields: {}", (Object)sut.getClass().getName());
        TestBedUtils.findFieldsInTypeAndParentTypes(sutClass).stream().filter(field -> this.isFieldReferenced((Field)field, fieldValueByName.keySet())).forEach(field -> {
            field.setAccessible(true);
            Class<?> fieldType = field.getType();
            Object fieldNewValue = fieldValueByName.get(field.getName());
            LOGGER.debug("Field {} should have expected value {}", (Object)field.getName(), fieldNewValue);
            if (fieldNewValue == null) {
                LOGGER.error("Trying to set field {} of class {} with a null value! The value will be ignored.", (Object)field.getName(), (Object)this.testClass.getName());
            } else if (!this.isFieldCompatibleWithNewValue(fieldType, fieldNewValue.getClass())) {
                LOGGER.error("Trying to set field {} of type {} in class {} with value of type {}. The new value will be ignored.", new Object[]{field.getName(), fieldType.getName(), this.testClass.getName(), fieldNewValue.getClass().getName()});
            } else {
                try {
                    LOGGER.debug("Inject field value {} in class {}, to <{}>", new Object[]{field.getName(), this.testClass.getName(), fieldNewValue});
                    field.set(sut, fieldNewValue);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    LOGGER.error("Could not set field {} with new value in class {} because the following error happened: {}", new Object[]{field.getName(), this.testClass.getName(), e.getMessage()});
                }
            }
        });
    }

    private boolean isFieldCompatibleWithNewValue(Class<?> fieldType, Class<?> valueType) {
        if (fieldType.isPrimitive()) {
            return this.isFieldCompatibleWithPrimitiveNewValue(fieldType, valueType);
        }
        return fieldType.isAssignableFrom(valueType);
    }

    private boolean isFieldCompatibleWithPrimitiveNewValue(Class<?> fieldType, Class<?> valueType) {
        if (Boolean.TYPE == fieldType) {
            return valueType == Boolean.class || valueType == Boolean.TYPE;
        }
        if (Short.TYPE == fieldType) {
            return valueType == Short.class || valueType == Short.TYPE;
        }
        if (Integer.TYPE == fieldType) {
            return valueType == Integer.class || valueType == Integer.TYPE;
        }
        if (Byte.TYPE == fieldType) {
            return valueType == Byte.class || valueType == Byte.TYPE;
        }
        if (Long.TYPE == fieldType) {
            return valueType == Long.class || valueType == Long.TYPE;
        }
        if (Double.TYPE == fieldType) {
            return valueType == Double.class || valueType == Double.TYPE;
        }
        if (Float.TYPE == fieldType) {
            return valueType == Float.class || valueType == Float.TYPE;
        }
        if (Character.TYPE == fieldType) {
            return valueType == Character.class || valueType == Character.TYPE;
        }
        return false;
    }

    private boolean isFieldReferenced(Field needle, Set<String> haystack) {
        boolean results = haystack.contains(needle.getName());
        LOGGER.debug("Checking referenced fields: <{}> is in [{}] returned {}", new Object[]{needle.getName(), haystack.stream().reduce("", (left, right) -> left + ", " + right), results});
        return results;
    }
}

