/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.testbed.mojo.linting.rules.custom;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thewonderlemming.c4plantuml.commons.Reporter;
import org.thewonderlemming.c4plantuml.grammars.C4BaseListener;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L1Parser;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L2Parser;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L3Parser;
import org.thewonderlemming.c4plantuml.linter.rules.RuleParameters;
import org.thewonderlemming.c4plantuml.mojo.linting.rules.custom.AbstractCustomLintingRule;
import org.thewonderlemming.c4plantuml.testingutils.TestBedUtils;

public class TestableAbstractCustomLintingRule
extends AbstractCustomLintingRule {
    public static final String THROW_ASSERT_ON_SYNTAX_ERROR_PARAMETER_NAME = "linting.test.assertOnSyntaxError";
    private static final Logger LOGGER = LoggerFactory.getLogger(TestableAbstractCustomLintingRule.class);
    private final boolean assertOnSyntaxError;

    public static File getReportFile() {
        Path currentDir = TestBedUtils.getResourceAsPath((String)"/org/thewonderlemming/c4plantuml/mojo/linting/rules/custom/.");
        return new File(currentDir.toString() + File.separator + "LintingReportsTest.reports");
    }

    protected TestableAbstractCustomLintingRule(RuleParameters parameters) {
        super(parameters);
        this.assertOnSyntaxError = parameters.getParameterAsBoolean(THROW_ASSERT_ON_SYNTAX_ERROR_PARAMETER_NAME).isPresent() ? (Boolean)parameters.getParameterAsBoolean(THROW_ASSERT_ON_SYNTAX_ERROR_PARAMETER_NAME).get() : false;
    }

    public Set<Class<? extends Parser>> acceptableParsersTypes() {
        return Stream.of(C4L1Parser.class, C4L2Parser.class, C4L3Parser.class).collect(Collectors.toSet());
    }

    public Optional<? extends ParseTreeListener> createParseTreeListener(Reporter reporter, Class<? extends Parser> parser) {
        LOGGER.debug("Asking for a parse tree listener for parser: {}", (Object)parser.getName());
        if (this.acceptableParsersTypes().contains(parser)) {
            LOGGER.debug("Acceptable parser given: {}. Returning listener.", (Object)parser.getName());
            return Optional.of(new TestableParseTreeListener(reporter, TestableAbstractCustomLintingRule.getReportFile()));
        }
        return Optional.empty();
    }

    public Optional<ParseTree> selectParseTree(Parser parser) {
        C4L1Parser.DiagramContext tree;
        LOGGER.debug("Selecting parse tree for parser: {}", (Object)parser.getClass().getSimpleName());
        if (parser instanceof C4L1Parser) {
            tree = ((C4L1Parser)parser).diagram();
        } else if (parser instanceof C4L2Parser) {
            tree = ((C4L2Parser)parser).diagram();
        } else if (parser instanceof C4L3Parser) {
            tree = ((C4L3Parser)parser).diagram();
        } else {
            return Optional.empty();
        }
        return Optional.of(tree);
    }

    public void wrapUp() {
        if (this.assertOnSyntaxError && !this.getSyntaxErrors().isEmpty()) {
            throw new AssertionError((Object)("Syntax errors reported: " + this.getSyntaxErrors().stream().map(error -> error.toString()).reduce("", (left, right) -> left + "|" + right)));
        }
    }

    public class TestableParseTreeListener
    extends C4BaseListener {
        private final Reporter reporter;
        private final File reportFile;

        public TestableParseTreeListener(Reporter reporter, File reportFile) {
            this.reporter = reporter;
            this.reportFile = reportFile;
            if (!this.reportFile.exists()) {
                try {
                    this.reportFile.createNewFile();
                }
                catch (IOException e) {
                    String errMsg = String.format("Cannot create file %s because of the following: %s", reportFile, e);
                    LOGGER.error(errMsg);
                    throw new AssertionError(errMsg, e);
                }
            }
        }

        public void enterTitle(C4L1Parser.TitleContext ctx) {
            this.report(ctx.String());
        }

        public void enterTitle(C4L2Parser.TitleContext ctx) {
            this.report(ctx.String());
        }

        public void enterTitle(C4L3Parser.TitleContext ctx) {
            this.report(ctx.String());
        }

        private void report(List<TerminalNode> nodes) {
            String report = nodes.stream().map(string -> string.getText()).reduce((left, right) -> left + "|" + right).get().replaceAll("\"", "");
            LOGGER.debug("Reporting {}", (Object)report);
            String message = report + "\n";
            try {
                Files.write(this.reportFile.toPath(), message.getBytes(), StandardOpenOption.APPEND);
            }
            catch (IOException e) {
                throw new AssertionError("Failed to report <" + report + "> because of the following: " + e.getMessage(), e);
            }
            this.reporter.report(message);
        }
    }
}

