/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.mojo;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractParentMojo
extends AbstractMojo {
    public static final String DEFAULT_SOURCE_FILE_EXTENSION = ".puml";
    private static final Pattern SOURCE_FILE_EXTENSION_PATTERN = Pattern.compile("^\\.[a-zA-Z0-9]+$");
    private Charset currentCharset;
    private String outputDirectory;
    @Parameter(property="project", defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="sourceFileExtension", defaultValue=".puml", alias="sourceFileExtension")
    private String sourceFileExtension;

    private static boolean isFile(Path path) {
        return path.toFile().isFile();
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        this.validateSourceFileExtension();
        this.setCurrentCharset();
        this.setOutputDirectory();
        this.doExecute();
    }

    protected abstract void doExecute() throws MojoExecutionException, MojoFailureException;

    protected Charset getCurrentCharset() {
        return this.currentCharset;
    }

    protected String getOutputDirectory() {
        return this.outputDirectory;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected String getSourceFileExtension() {
        return this.sourceFileExtension;
    }

    protected void processOutputDirectoryFiles(Consumer<Path> pumlFileProcessor) throws IOException {
        try (Stream<Path> pathStream = Files.walk(Paths.get(this.getOutputDirectory(), new String[0]), new FileVisitOption[0]);){
            pathStream.filter(AbstractParentMojo::isFile).filter(this::isPumlSource).forEach(pumlFileProcessor::accept);
        }
    }

    protected void validateSourceFileExtension() {
        assert (this.sourceFileExtension != null) : "Expecting sourceFileExtension to be set";
        if (!SOURCE_FILE_EXTENSION_PATTERN.matcher(this.sourceFileExtension).matches()) {
            String errMsg = String.format("Bad format for sourceFileExtension: %s. Reverting to default value instead: %s", this.sourceFileExtension, DEFAULT_SOURCE_FILE_EXTENSION);
            this.getLog().warn((CharSequence)errMsg);
            this.sourceFileExtension = DEFAULT_SOURCE_FILE_EXTENSION;
        }
    }

    private boolean isPumlSource(Path path) {
        assert (this.sourceFileExtension != null) : "Expecting sourceFileExtension to be set";
        return path.toString().toLowerCase().endsWith(this.sourceFileExtension);
    }

    private void setCurrentCharset() throws MojoExecutionException {
        try {
            String sourceEncoding = this.project.getProperties().getProperty("project.build.sourceEncoding", StandardCharsets.UTF_8.toString());
            this.currentCharset = Charset.forName(sourceEncoding);
        }
        catch (IllegalArgumentException e) {
            throw new MojoExecutionException("Cannot get character encoding for source files", (Exception)e);
        }
    }

    private void setOutputDirectory() throws MojoExecutionException {
        this.outputDirectory = this.getProject().getBuild().getOutputDirectory();
        if (!new File(this.outputDirectory).exists()) {
            String errMsg = "Cannot process source directory \"" + this.outputDirectory + "\" as it does not exist";
            throw new MojoExecutionException(errMsg);
        }
    }
}

