/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.mojo;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.thewonderlemming.c4plantuml.graphml.C4Graph;
import org.thewonderlemming.c4plantuml.mojo.AbstractParentMojo;

@Mojo(name="report", defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class ReportingMojo
extends AbstractParentMojo {
    public static final String FAIL_ON_PARSE_ERRORS_DEFAULT_VALUE = "false";
    public static final String FORMAT_OUTPUT_DEFAULT_VALUE = "true";
    public static final String OUTPUT_FILENAME_DEFAULT_VALUE = "c4graph.graphml";
    @Parameter(property="failOnParseErrors", defaultValue="false", alias="failOnParseErrors")
    private boolean failOnParseErrors;
    @Parameter(property="formatOutput", defaultValue="true", alias="formatOutput")
    private boolean formatOutput;
    @Parameter(property="outputFilename", defaultValue="c4graph.graphml", alias="outputFilename")
    private String outputFilename;

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        this.validateOutputFilename();
        this.generateReportFile();
    }

    private void generateReportFile() throws MojoFailureException {
        try {
            C4Graph c4Graph = new C4Graph(this.getCurrentCharset(), this.formatOutput, this.failOnParseErrors);
            ArrayList c4Files = new ArrayList();
            this.processOutputDirectoryFiles(c4Files::add);
            if (c4Files.isEmpty()) {
                throw new MojoFailureException("No data found to report");
            }
            Optional content = c4Graph.addAndProcessC4Files(c4Files).export();
            if (!content.isPresent()) {
                throw new MojoFailureException("Unable to export to GraphML format");
            }
            this.writeReportFile((String)content.get());
        }
        catch (Throwable e) {
            String errMsg = String.format("Cannot process output directory: \"%s\" for reporting because of the following: %s", this.getOutputDirectory(), e.getMessage());
            throw new MojoFailureException(errMsg, e);
        }
    }

    private void validateOutputFilename() {
        assert (this.outputFilename != null) : "Expected outputFilename to be set";
        File outputFile = new File(this.outputFilename);
        if (!outputFile.isAbsolute()) {
            this.outputFilename = this.getOutputDirectory() + "/" + this.outputFilename;
            this.getLog().info((CharSequence)("The given report filename is not absolute. \"" + this.outputFilename + "\" will be used instead."));
        }
    }

    private void writeReportFile(String content) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(this.outputFilename);
             DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(fos));){
            dos.write(content.getBytes(this.getCurrentCharset()));
        }
    }
}

