/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.mojo;

import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.thewonderlemming.c4plantuml.commons.Reporter;
import org.thewonderlemming.c4plantuml.mojo.AbstractParentMojo;
import org.thewonderlemming.c4plantuml.mojo.MojoReporter;
import org.thewonderlemming.c4plantuml.syntaxchecker.SyntaxChecker;

@Mojo(name="check-syntax", defaultPhase=LifecyclePhase.COMPILE)
public class SyntaxCheckingMojo
extends AbstractParentMojo {
    private MojoReporter reporter;

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        this.setReporter();
        this.processOutputDirectory();
        this.reportsAndBreakBuildIfNecessary();
    }

    private void processOutputDirectory() throws MojoFailureException {
        assert (this.getOutputDirectory() != null) : "Expected outputDirectory to be set!";
        try {
            SyntaxChecker syntaxChecker = new SyntaxChecker((Reporter)this.reporter);
            this.processOutputDirectoryFiles(path -> syntaxChecker.check(path, this.getCurrentCharset()));
        }
        catch (IOException e) {
            String errMsg = "Cannot process output directory: \"" + this.getOutputDirectory() + "\" for linting";
            throw new MojoFailureException(errMsg);
        }
    }

    private void reportsAndBreakBuildIfNecessary() throws MojoFailureException {
        assert (this.reporter != null) : "Expected reporter to be set";
        if (this.reporter.containsReports()) {
            this.reporter.getReports().forEach(report -> this.getLog().error((CharSequence)report));
            throw new MojoFailureException("The build contains syntax errors. Please fix them then restart the build.");
        }
    }

    private void setReporter() {
        this.reporter = new MojoReporter();
    }
}

