/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.mojo;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.thewonderlemming.c4plantuml.mojo.AbstractParentMojo;

@Mojo(name="watermark", defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class WatermarkingMojo
extends AbstractParentMojo {
    public static final String DEFAULT_COPYRIGHT_NAME = "";
    public static final DateTimeFormatter DEFAULT_DATE_FORMATTER = DateTimeFormatter.ISO_DATE;
    public static final String DEFAULT_WATERMARK_NAME = "changeMe";
    public static final String WATERMARK_FORMAT_STRING = "FOOTER(\"Version %s - Generated on %s - \u00a9%d %s\", \"%s\")";
    private static final String END_UML_TAG = "@enduml";
    @Parameter(property="copyrightName", defaultValue="", alias="copyrightName")
    private String copyrightName;
    @Parameter(property="dateFormat", defaultValue="", alias="dateFormat")
    private String dateFormat;
    @Parameter(property="watermarkName", defaultValue="changeMe", alias="watermarkName")
    private String watermarkName;

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        try {
            this.processOutputDirectory();
        }
        catch (IOException e) {
            String errMsg = "Cannot process output directory \"" + this.getOutputDirectory() + "\" for watermaking";
            throw new MojoFailureException(errMsg, (Throwable)e);
        }
    }

    private void addWatermarkToFile(Path file) throws IOException {
        assert (this.getCurrentCharset() != null) : "Expected currentCharset to be set";
        assert (file != null && file.toFile().exists()) : "Expected given path to exist";
        assert (file.toFile().isFile()) : "Expected given path to be a file";
        String content = new String(Files.readAllBytes(file), this.getCurrentCharset()).replace(END_UML_TAG, this.generateWatermarkString() + "\n" + END_UML_TAG);
        Files.write(file, content.getBytes(this.getCurrentCharset()), new OpenOption[0]);
    }

    private String generateWatermarkString() {
        LocalDate currentDate = LocalDate.now();
        String diagramVersion = this.getProject().getVersion();
        String diagramName = this.watermarkName.isEmpty() ? this.getProject().getGroupId() + ":" + this.getProject().getArtifactId() : this.watermarkName;
        return String.format(WATERMARK_FORMAT_STRING, diagramVersion, currentDate.format(this.getDateTimeFormatter()), currentDate.getYear(), this.copyrightName != null ? this.copyrightName : DEFAULT_COPYRIGHT_NAME, diagramName);
    }

    private DateTimeFormatter getDateTimeFormatter() {
        try {
            return null != this.dateFormat ? DateTimeFormatter.ofPattern(this.dateFormat) : DEFAULT_DATE_FORMATTER;
        }
        catch (IllegalArgumentException e) {
            return DEFAULT_DATE_FORMATTER;
        }
    }

    private void processOutputDirectory() throws IOException {
        assert (this.getOutputDirectory() != null) : "Expected outputDirectory to be set";
        this.processOutputDirectoryFiles(path -> {
            try {
                this.addWatermarkToFile((Path)path);
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Cannot add watermark to file: " + path), (Throwable)e);
            }
        });
    }
}

