/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.mojo.linting;

import java.io.IOException;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.thewonderlemming.c4plantuml.commons.Reporter;
import org.thewonderlemming.c4plantuml.linter.Linter;
import org.thewonderlemming.c4plantuml.linter.rules.AbstractLintingRule;
import org.thewonderlemming.c4plantuml.mojo.AbstractParentMojo;
import org.thewonderlemming.c4plantuml.mojo.MojoReporter;
import org.thewonderlemming.c4plantuml.mojo.linting.BuiltInRules;
import org.thewonderlemming.c4plantuml.mojo.linting.LintingRulesFinder;
import org.thewonderlemming.c4plantuml.mojo.linting.rules.builtin.BuiltInLintingRulesFactory;
import org.thewonderlemming.c4plantuml.mojo.linting.rules.custom.AbstractCustomLintingRule;
import org.thewonderlemming.c4plantuml.mojo.linting.rules.custom.AbstractCustomLintingRuleFactory;

@Mojo(name="lint", defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class LintingMojo
extends AbstractParentMojo {
    private Set<AbstractLintingRule> builtInRules;
    @Parameter(property="rules", alias="rules")
    private BuiltInRules builtInRulesConfiguration;
    private Set<AbstractLintingRule> customRules;
    @Parameter(property="customRules", alias="customRules")
    private Properties customRulesConfiguration;
    @Parameter(property="failOnLintErrors", defaultValue="true", alias="failOnLintErrors")
    private boolean failOnLintErrors;
    private MojoReporter reporter;

    private static boolean isCustomRule(Class<? extends AbstractLintingRule> rule) {
        return AbstractCustomLintingRule.class.isAssignableFrom(rule);
    }

    private static boolean isNotCustomRule(Class<? extends AbstractLintingRule> rule) {
        return !LintingMojo.isCustomRule(rule);
    }

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        this.validateBuiltInRulesConfiguration();
        this.validateCustomRulesConfiguration();
        this.setReporter();
        this.retrieveAndSetRules();
        this.lintOutputDirectory();
        this.reportsAndBreakBuildIfNecessary();
    }

    private Optional<AbstractLintingRule> buildAndConfigureBuiltInRule(Class<? extends AbstractLintingRule> ruleType) {
        Optional<String> ruleName = BuiltInLintingRulesFactory.getRuleNameForType(ruleType);
        assert (ruleName.isPresent()) : "Expected rule " + ruleType.getName() + " to be found in " + BuiltInLintingRulesFactory.class.getName();
        return ruleName.isPresent() ? BuiltInLintingRulesFactory.createInstanceForName(ruleName.get(), this.builtInRulesConfiguration) : Optional.empty();
    }

    private Optional<? extends AbstractCustomLintingRule> buildAndConfigureCustomRules(Class<? extends AbstractCustomLintingRuleFactory<? extends AbstractCustomLintingRule>> factoryClass) {
        try {
            return factoryClass.newInstance().createCustomRule(this.customRulesConfiguration);
        }
        catch (IllegalAccessException | InstantiationException e) {
            String errMsg = String.format("Error while trying to build custom rule from factory %s: %s", factoryClass.getName(), e.getMessage());
            this.getLog().error((CharSequence)errMsg);
            return Optional.empty();
        }
    }

    private void lintOutputDirectory() throws MojoFailureException {
        assert (this.getOutputDirectory() != null) : "Expected outputDirectory to be set";
        assert (this.reporter != null) : "Expected reporter to be set";
        assert (this.builtInRules != null && !this.builtInRules.isEmpty() || this.customRules != null && !this.customRules.isEmpty()) : "Expected rules to be set";
        try {
            Linter linter = Linter.builder().newLinter().withReporter((Reporter)this.reporter).addLintingRules(this.builtInRules).addLintingRules(this.customRules).build();
            this.processOutputDirectoryFiles(path -> linter.lint(path, this.getCurrentCharset()));
        }
        catch (IOException e) {
            String errMsg = "Cannot process output directory: \"" + this.getOutputDirectory() + "\" for linting";
            throw new MojoFailureException(errMsg);
        }
    }

    private AbstractLintingRule logFoundRule(AbstractLintingRule lintingRule) {
        String message = "Linting rule <" + lintingRule.getClass().getName() + "> was detected in the classpath and will be used.";
        this.getLog().debug((CharSequence)message);
        return lintingRule;
    }

    private void reportsAndBreakBuildIfNecessary() throws MojoFailureException {
        assert (this.reporter != null) : "Expected reporter to be set";
        if (this.reporter.containsReports()) {
            this.getLog().debug((CharSequence)"Lint errors found.");
            this.reporter.getReports().forEach(report -> this.getLog().error((CharSequence)report));
            if (this.failOnLintErrors) {
                throw new MojoFailureException("The build contains lint errors. Please fix them then restart the build.");
            }
        } else {
            this.getLog().debug((CharSequence)"No lint errors found.");
        }
    }

    private void retrieveAndSetRules() throws MojoExecutionException {
        this.builtInRules = LintingRulesFinder.findBuiltInLintingRules().stream().filter(LintingMojo::isNotCustomRule).map(this::buildAndConfigureBuiltInRule).filter(Optional::isPresent).map(Optional::get).map(this::logFoundRule).collect(Collectors.toSet());
        this.customRules = LintingRulesFinder.findCustomLintingRuleFactories().stream().map(this::buildAndConfigureCustomRules).filter(Optional::isPresent).map(Optional::get).map(this::logFoundRule).collect(Collectors.toSet());
        if (this.builtInRules.isEmpty() && this.customRules.isEmpty()) {
            throw new MojoExecutionException("No active rules to be found. Skipping.");
        }
    }

    private void setReporter() {
        this.reporter = new MojoReporter();
    }

    private void validateBuiltInRulesConfiguration() {
        if (this.builtInRulesConfiguration == null) {
            this.getLog().info((CharSequence)"No configuration found for built-in rules. Falling back to defaults.");
            this.builtInRulesConfiguration = new BuiltInRules();
        }
    }

    private void validateCustomRulesConfiguration() {
        if (this.customRulesConfiguration == null) {
            this.getLog().debug((CharSequence)"No configuration found for custom rules. Falling back to defaults.");
            this.customRulesConfiguration = new Properties();
        }
    }
}

