/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.mojo.linting;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import java.lang.reflect.Modifier;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thewonderlemming.c4plantuml.linter.rules.AbstractLintingRule;
import org.thewonderlemming.c4plantuml.mojo.linting.rules.custom.AbstractCustomLintingRuleFactory;

public class LintingRulesFinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(LintingRulesFinder.class);

    public static Set<Class<? extends AbstractLintingRule>> findBuiltInLintingRules() {
        try (ScanResult scanResult = new ClassGraph().enableClassInfo().ignoreClassVisibility().scan();){
            Set<Class<? extends AbstractLintingRule>> set = scanResult.getSubclasses(AbstractLintingRule.class.getName()).stream().map(ClassInfo::getName).map(LintingRulesFinder::getClassForName).filter(Optional::isPresent).map(Optional::get).map(clazz -> clazz).filter(LintingRulesFinder::isNotAbstract).collect(Collectors.toSet());
            return set;
        }
    }

    public static Set<Class<? extends AbstractCustomLintingRuleFactory<?>>> findCustomLintingRuleFactories() {
        try (ScanResult scanResult = new ClassGraph().enableClassInfo().ignoreClassVisibility().scan();){
            Set<Class<? extends AbstractCustomLintingRuleFactory<?>>> set = scanResult.getSubclasses(AbstractCustomLintingRuleFactory.class.getName()).stream().map(ClassInfo::getName).map(LintingRulesFinder::getClassForName).filter(Optional::isPresent).map(Optional::get).map(clazz -> clazz).filter(LintingRulesFinder::isNotAbstract).collect(Collectors.toSet());
            return set;
        }
    }

    private static Optional<Class<?>> getClassForName(String className) {
        try {
            return Optional.ofNullable(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Error while scanning classpath to detect linting rules: {}", (Object)e.getMessage());
            return Optional.empty();
        }
    }

    private static boolean isNotAbstract(Class<?> clazz) {
        return !Modifier.isAbstract(clazz.getModifiers());
    }

    private LintingRulesFinder() {
    }
}

