/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.mojo.linting.rules.builtin;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.thewonderlemming.c4plantuml.linter.rules.RuleParameters;
import org.thewonderlemming.c4plantuml.mojo.linting.BuiltInRules;

public abstract class AbstractRuleParametersFactory<P> {
    private final boolean isActivated;
    private final RuleParameters ruleParameters;

    private static Map.Entry<String, String> toStringStringEntry(Map.Entry<String, Optional<String>> entry) {
        assert (entry.getValue().isPresent()) : "Expected value to be non empty";
        String value = entry.getValue().isPresent() ? entry.getValue().get() : "";
        return new AbstractMap.SimpleEntry<String, String>(entry.getKey(), value);
    }

    protected AbstractRuleParametersFactory(BuiltInRules mojoParameters) {
        P pojoParameters = this.getPojoFromBuiltInRules(mojoParameters);
        this.isActivated = this.getActivatedParameter(pojoParameters);
        this.ruleParameters = this.buildRuleParameters(pojoParameters);
    }

    public RuleParameters getRuleParameters() {
        return this.ruleParameters;
    }

    public boolean isActivated() {
        return this.isActivated;
    }

    protected abstract boolean getActivatedParameter(P var1);

    protected abstract P getPojoFromBuiltInRules(BuiltInRules var1);

    protected abstract Set<String> getRuleParametersKeys();

    protected abstract Optional<String> getValueForParameter(String var1, P var2);

    private RuleParameters buildRuleParameters(P pojoParameters) {
        Set<String> parametersKeys = this.getRuleParametersKeys();
        return RuleParameters.builder().addParameters(parametersKeys.stream().map(key -> this.keyToKeyValuePair((String)key, pojoParameters)).filter(entry -> ((Optional)entry.getValue()).isPresent()).map(AbstractRuleParametersFactory::toStringStringEntry).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).build();
    }

    private Map.Entry<String, Optional<String>> keyToKeyValuePair(String key, P pojoParameters) {
        return new AbstractMap.SimpleEntry<String, Optional<String>>(key, this.getValueForParameter(key, pojoParameters));
    }
}

