/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.mojo.linting.rules.builtin;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thewonderlemming.c4plantuml.linter.rules.AbstractLintingRule;
import org.thewonderlemming.c4plantuml.linter.rules.RuleParameters;
import org.thewonderlemming.c4plantuml.linter.rules.builtin.AliasesShouldBeListedInDictionaryRule;
import org.thewonderlemming.c4plantuml.linter.rules.builtin.AliasesShouldBeUniqueRule;
import org.thewonderlemming.c4plantuml.linter.rules.builtin.AliasesShouldFollowStandardConventionRule;
import org.thewonderlemming.c4plantuml.linter.rules.builtin.NoDuplicateRelationshipsRule;
import org.thewonderlemming.c4plantuml.linter.rules.builtin.NoOrphanAliasInBoundariesRule;
import org.thewonderlemming.c4plantuml.linter.rules.builtin.NoOrphanAliasInLayoutsRule;
import org.thewonderlemming.c4plantuml.linter.rules.builtin.NoOrphanAliasInRelationshipsRule;
import org.thewonderlemming.c4plantuml.mojo.linting.BuiltInRules;
import org.thewonderlemming.c4plantuml.mojo.linting.rules.builtin.AbstractRuleParametersFactory;
import org.thewonderlemming.c4plantuml.mojo.linting.rules.builtin.parameters.AliasesShouldBeListedInDictionaryRuleParametersFactory;
import org.thewonderlemming.c4plantuml.mojo.linting.rules.builtin.parameters.AliasesShouldBeUniqueRuleParametersFactory;
import org.thewonderlemming.c4plantuml.mojo.linting.rules.builtin.parameters.AliasesShouldFollowStandardConventionRuleParametersFactory;
import org.thewonderlemming.c4plantuml.mojo.linting.rules.builtin.parameters.NoDuplicateRelationshipsRuleParametersFactory;
import org.thewonderlemming.c4plantuml.mojo.linting.rules.builtin.parameters.NoOrphanAliasInBoundariesRuleParametersFactory;
import org.thewonderlemming.c4plantuml.mojo.linting.rules.builtin.parameters.NoOrphanAliasInLayoutsRuleParametersFactory;
import org.thewonderlemming.c4plantuml.mojo.linting.rules.builtin.parameters.NoOrphanAliasInRelationshipsRuleParametersFactory;

public enum BuiltInLintingRulesFactory {
    ALIASES_SHOULD_BE_LISTED_IN_DICTIONARY("aliasesShouldBeListedInDictionary", AliasesShouldBeListedInDictionaryRule.class, AliasesShouldBeListedInDictionaryRuleParametersFactory.class),
    ALIASES_SHOULD_BE_UNIQUE("aliasesShouldBeUnique", AliasesShouldBeUniqueRule.class, AliasesShouldBeUniqueRuleParametersFactory.class),
    ALIASES_SHOULD_FOLLOW_STANDARD_CONVENTION("aliasesShouldFollowStandardConvention", AliasesShouldFollowStandardConventionRule.class, AliasesShouldFollowStandardConventionRuleParametersFactory.class),
    NO_DUPLICATES_IN_RELATIONSHIPS("noDuplicateRelationships", NoDuplicateRelationshipsRule.class, NoDuplicateRelationshipsRuleParametersFactory.class),
    NO_ORPHAN_ALIAS_IN_BOUNDARIES("noOrphanAliasInBoundaries", NoOrphanAliasInBoundariesRule.class, NoOrphanAliasInBoundariesRuleParametersFactory.class),
    NO_ORPHAN_ALIAS_IN_LAYOUTS("noOrphanAliasInLayouts", NoOrphanAliasInLayoutsRule.class, NoOrphanAliasInLayoutsRuleParametersFactory.class),
    NO_ORPHAN_ALIAS_IN_RELATIONSHIPS("noOrphanAliasInRelationships", NoOrphanAliasInRelationshipsRule.class, NoOrphanAliasInRelationshipsRuleParametersFactory.class);

    private static final Logger LOGGER;
    private static final Map<String, BuiltInLintingRulesFactory> LOOKUP_BY_NAME;
    private static final Map<Class<? extends AbstractLintingRule>, BuiltInLintingRulesFactory> LOOKUP_BY_TYPE;
    private final String ruleName;
    private final Class<? extends AbstractRuleParametersFactory> ruleParametersFactoryType;
    private final Class<? extends AbstractLintingRule> ruleType;

    public static Optional<AbstractLintingRule> createInstanceForName(String ruleName, BuiltInRules parameters) {
        BuiltInLintingRulesFactory rule = LOOKUP_BY_NAME.get(ruleName);
        if (null != rule) {
            try {
                AbstractRuleParametersFactory config = rule.ruleParametersFactoryType.getDeclaredConstructor(BuiltInRules.class).newInstance(parameters);
                LOGGER.debug("Linting rule {} is activated: {}", (Object)ruleName, (Object)config.isActivated());
                return config.isActivated() ? Optional.ofNullable(rule.createInstance(config.getRuleParameters())) : Optional.empty();
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LOGGER.error("Cannot create instance of rule named '{}' because of exception: {}", new Object[]{ruleName, e.getMessage(), e});
            }
        }
        return Optional.empty();
    }

    public static Optional<String> getRuleNameForType(Class<? extends AbstractLintingRule> ruleType) {
        return LOOKUP_BY_TYPE.containsKey(ruleType) ? Optional.ofNullable(LOOKUP_BY_TYPE.get(ruleType).getRuleName()) : Optional.empty();
    }

    public static boolean isBuiltInLintingRule(Class<? extends AbstractLintingRule> lintingRuleType) {
        return LOOKUP_BY_TYPE.containsKey(lintingRuleType);
    }

    private BuiltInLintingRulesFactory(String ruleName, Class<? extends AbstractLintingRule> ruleType, Class<? extends AbstractRuleParametersFactory> ruleParametersFactoryType) {
        this.ruleName = ruleName;
        this.ruleType = ruleType;
        this.ruleParametersFactoryType = ruleParametersFactoryType;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public Class<? extends AbstractLintingRule> getRuleType() {
        return this.ruleType;
    }

    private AbstractLintingRule createInstance(RuleParameters parameters) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.ruleType.getConstructor(RuleParameters.class).newInstance(parameters);
    }

    static {
        LOGGER = LoggerFactory.getLogger(BuiltInLintingRulesFactory.class);
        LOOKUP_BY_NAME = new HashMap<String, BuiltInLintingRulesFactory>();
        LOOKUP_BY_TYPE = new HashMap<Class<? extends AbstractLintingRule>, BuiltInLintingRulesFactory>();
        Stream.of(BuiltInLintingRulesFactory.values()).forEach(value -> {
            LOOKUP_BY_NAME.put(value.ruleName, (BuiltInLintingRulesFactory)((Object)value));
            LOOKUP_BY_TYPE.put(value.getRuleType(), (BuiltInLintingRulesFactory)((Object)value));
        });
    }
}

