/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.syntaxchecker;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Optional;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thewonderlemming.c4plantuml.commons.Reporter;
import org.thewonderlemming.c4plantuml.grammars.C4BaseListener;
import org.thewonderlemming.c4plantuml.grammars.SourceType;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L1Parser;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L2Parser;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L3Parser;
import org.thewonderlemming.c4plantuml.syntaxchecker.SyntaxCheckerErrorListener;

public class SyntaxChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyntaxChecker.class);
    private static final ParseTreeListener PARSE_TREE_LISTENER = new C4BaseListener();
    private final Reporter reporter;

    public SyntaxChecker(Reporter reporter) {
        this.reporter = reporter;
    }

    public void check(Path c4SourceFile) {
        this.check(c4SourceFile, StandardCharsets.UTF_8);
    }

    public void check(Path c4SourceFile, Charset charset) {
        SourceType.getSourceTypeFromFilename((Path)c4SourceFile).ifPresent(sourceType -> {
            SyntaxCheckerErrorListener errorListener = new SyntaxCheckerErrorListener(this.reporter, c4SourceFile);
            sourceType.createParser(c4SourceFile, charset, (BaseErrorListener)errorListener).ifPresent(parser -> this.getParseTree((Parser)parser).ifPresent(tree -> new ParseTreeWalker().walk(PARSE_TREE_LISTENER, tree)));
        });
    }

    private Optional<ParseTree> getParseTree(Parser parser) {
        C4L1Parser.DiagramContext tree;
        if (parser instanceof C4L1Parser) {
            tree = ((C4L1Parser)parser).diagram();
        } else if (parser instanceof C4L2Parser) {
            tree = ((C4L2Parser)parser).diagram();
        } else if (parser instanceof C4L3Parser) {
            tree = ((C4L3Parser)parser).diagram();
        } else {
            LOGGER.error("Unsupported parser type {} was given", parser.getClass());
            return Optional.empty();
        }
        return Optional.ofNullable(tree);
    }
}

