/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.syntaxchecker;

import java.nio.file.Path;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.thewonderlemming.c4plantuml.commons.Reporter;
import org.thewonderlemming.c4plantuml.syntaxchecker.SyntaxErrorMessageMapper;

public class SyntaxCheckerErrorListener
extends BaseErrorListener {
    private static final String SYNTAX_ERROR_FORMAT = "Syntax error in file \"%s\", line %d, position %d, offending symbol: %s.\n\tError message: %s";
    private final Path filepath;
    private final Reporter reporter;

    public SyntaxCheckerErrorListener(Reporter reporter, Path filepath) {
        this.reporter = reporter;
        this.filepath = filepath;
    }

    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException exception) {
        String errorDescription = String.format(SYNTAX_ERROR_FORMAT, this.filepath.toFile().getName(), line, charPositionInLine, offendingSymbol, SyntaxErrorMessageMapper.getMappingForParserMessageOrGetDefault(msg));
        if (null != exception) {
            errorDescription = errorDescription + "\n\t" + exception;
        }
        this.reporter.report(errorDescription);
    }
}

