/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.syntaxchecker;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SyntaxErrorMessageMapper {
    EXPECTING_INCLUDE("mismatched input '!' expecting INCLUDE", "mismatched input. expecting !include");

    private static final Map<String, SyntaxErrorMessageMapper> LOOKUP;
    private final String displayMessage;
    private final String parserMessage;

    public static Optional<SyntaxErrorMessageMapper> getMappingForParserMessage(String message) {
        return Optional.ofNullable(LOOKUP.get(message));
    }

    public static String getMappingForParserMessageOrGetDefault(String message) {
        Optional<SyntaxErrorMessageMapper> value = SyntaxErrorMessageMapper.getMappingForParserMessage(message);
        if (value.isPresent()) {
            return value.get().getDisplayMessage();
        }
        return message;
    }

    private SyntaxErrorMessageMapper(String parserMessage, String displayMessage) {
        this.parserMessage = parserMessage;
        this.displayMessage = displayMessage;
    }

    public String getDisplayMessage() {
        return this.displayMessage;
    }

    public String getParserMessage() {
        return this.parserMessage;
    }

    static {
        LOOKUP = Stream.of(SyntaxErrorMessageMapper.values()).map(value -> new AbstractMap.SimpleEntry<String, SyntaxErrorMessageMapper>(value.getParserMessage(), (SyntaxErrorMessageMapper)((Object)value))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

