/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.testingutils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractUrlAssert;
import org.assertj.core.api.Assertions;

public class TestBedUtils {
    public static void assertExists(String filename) {
        TestBedUtils.getResourceAsPath(filename);
    }

    public static void assertFileDoesNotExists(String filename) {
        File resource;
        URL url = TestBedUtils.class.getResource(filename);
        if (null != url && (resource = new File(url.getFile())).exists()) {
            throw new AssertionError((Object)String.format("Expected %s not to exists but %s was found.", filename, filename));
        }
    }

    public static void copyResourceToFileInPath(String resourceFilename, File targetFilename) throws IOException {
        Path resourcePath = TestBedUtils.getResourceAsPath(resourceFilename);
        Path targetPath = targetFilename.toPath();
        Files.copy(resourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
        Assertions.assertThat((Path)targetPath).exists();
        Assertions.assertThat((Path)resourcePath).hasSameTextualContentAs(targetPath);
    }

    public static void deleteFileContents(Path path) throws IOException {
        Assertions.assertThat((Path)path).exists();
        new FileOutputStream(path.toFile()).close();
    }

    public static Set<Field> findFieldsInTypeAndParentTypes(Class<?> classType) {
        HashSet<Field> foundFields = new HashSet<Field>();
        foundFields.addAll(Stream.of(classType.getDeclaredFields()).collect(Collectors.toSet()));
        return TestBedUtils.findFieldsInTypeAndParentTypes(classType, foundFields);
    }

    public static <A extends Annotation> Optional<A> getAnnotation(Class<?> clazz, Class<A> annotationType) {
        return Optional.ofNullable(clazz.getAnnotation(annotationType));
    }

    public static <A extends Annotation> Optional<A> getAnnotation(Field field, Class<A> annotationType) {
        return Optional.ofNullable(field.getAnnotation(annotationType));
    }

    public static <A extends Annotation> Optional<A> getAnnotation(Method method, Class<A> annotationType) {
        return Optional.ofNullable(method.getAnnotation(annotationType));
    }

    public static File getClassFileDirectoryAsFile(Class<?> clazz) throws URISyntaxException {
        return new File(clazz.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
    }

    public static Path getResourceAsPath(String filename) {
        URL url = TestBedUtils.class.getResource(filename);
        ((AbstractUrlAssert)Assertions.assertThat((URL)url).as("check that filename %s is a valid URL", new Object[]{filename})).isNotNull();
        File resource = new File(url.getFile());
        Assertions.assertThat((File)resource).exists();
        return resource.toPath();
    }

    private static Set<Field> findFieldsInTypeAndParentTypes(Class<?> classType, Set<Field> foundFields) {
        Class<?> superType = classType.getSuperclass();
        if (null == superType || superType == Object.class) {
            return foundFields;
        }
        foundFields.addAll(Stream.of(superType.getDeclaredFields()).collect(Collectors.toSet()));
        return TestBedUtils.findFieldsInTypeAndParentTypes(superType, foundFields);
    }

    private TestBedUtils() {
    }
}

