/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.testingutils.junit;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thewonderlemming.c4plantuml.testingutils.SUT;
import org.thewonderlemming.c4plantuml.testingutils.TestBedUtils;

public class FindSutExtension
implements BeforeAllCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(FindSutExtension.class);

    public void beforeAll(ExtensionContext context) throws Exception {
        Class testClass = context.getRequiredTestClass();
        List<Field> sutFieldAnnotations = this.extractAnnotatedFields(testClass);
        List<Method> sutMethodAnnotations = this.extractAnnotatedMethods(testClass);
        this.checkForAnnotationOrThrowError(testClass, sutFieldAnnotations, sutMethodAnnotations);
        this.checkForAnnotatedTypesConsistencyOrThrowError(testClass, sutFieldAnnotations, sutMethodAnnotations);
    }

    private void checkForAnnotatedTypesConsistencyOrThrowError(Class<?> testClass, List<Field> sutFieldAnnotations, List<Method> sutMethodAnnotations) {
        int multipleTypesForFieldsCount = sutFieldAnnotations.stream().collect(Collectors.groupingBy(Field::getType)).size();
        int multipleMethodsCount = sutMethodAnnotations.size();
        if (multipleTypesForFieldsCount > 1 || multipleMethodsCount > 1 || multipleTypesForFieldsCount + multipleMethodsCount > 1) {
            String message = String.format("Multiple %s annotation found in test class %s on multiple types! This is ambigous.", SUT.class.getName(), testClass.getName());
            throw new RuntimeException(message);
        }
    }

    private void checkForAnnotationOrThrowError(Class<?> testClass, List<Field> sutFieldAnnotations, List<Method> sutMethodAnnotations) {
        if (sutFieldAnnotations.size() + sutMethodAnnotations.size() == 0) {
            String message = String.format("No %s annotation was found in test class %s. Unable to determine the object to test.", SUT.class.getName(), testClass.getName());
            throw new RuntimeException(message);
        }
    }

    private List<Field> extractAnnotatedFields(Class<?> testClass) {
        ArrayList<Field> annotatedFields = new ArrayList<Field>();
        for (Field field : testClass.getDeclaredFields()) {
            TestBedUtils.getAnnotation(field, SUT.class).ifPresent(fieldAnnotation -> annotatedFields.add(field));
        }
        return annotatedFields;
    }

    private List<Method> extractAnnotatedMethods(Class<?> testClass) {
        ArrayList<Method> annotatedMethods = new ArrayList<Method>();
        for (Method method : testClass.getDeclaredMethods()) {
            TestBedUtils.getAnnotation(method, SUT.class).ifPresent(methodAnnotation -> {
                if (method.getParameterCount() == 0) {
                    annotatedMethods.add(method);
                } else {
                    LOGGER.warn("{}\u00a0annotation is not allowed on method with parameters: Method {} of class {} will be ignored.", new Object[]{SUT.class.getName(), method.getName(), testClass.getName()});
                }
            });
        }
        return annotatedMethods;
    }
}

