/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.testingutils.junit;

import java.lang.reflect.Field;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.assertj.core.util.Arrays;
import org.easymock.EasyMock;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thewonderlemming.c4plantuml.testingutils.Mock;
import org.thewonderlemming.c4plantuml.testingutils.MockType;
import org.thewonderlemming.c4plantuml.testingutils.TestBedUtils;
import org.thewonderlemming.c4plantuml.testingutils.junit.InjectMocks;

public class InjectMocksExtension
implements AfterEachCallback,
TestInstancePostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(InjectMocksExtension.class);

    public void afterEach(ExtensionContext context) throws Exception {
        Class testClass = context.getRequiredTestClass();
        TestBedUtils.getAnnotation(testClass, InjectMocks.class).filter(InjectMocks::verifyMocksAfterEachTest).ifPresent(injectMocksAnnotation -> this.verifyMocks(context, testClass));
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) throws Exception {
        Map<Field, Mock> mocksToFields = this.getMocksToInject(testInstance.getClass());
        this.injectMocks(testInstance, mocksToFields);
    }

    private Map<Field, Mock> getMocksToInject(Class<?> testClass) {
        HashMap<Field, Mock> mocksToFields = new HashMap<Field, Mock>();
        LOGGER.debug("Inspecting class {}", (Object)testClass.getName());
        mocksToFields.putAll(Arrays.asList((Object)testClass.getDeclaredFields()).stream().map(declaredField -> (Field)declaredField).filter(field -> null != field.getAnnotation(Mock.class)).map(field -> {
            LOGGER.debug("Retrieving annotated field {}", (Object)field.getName());
            return new AbstractMap.SimpleEntry<Field, Mock>((Field)field, field.getAnnotation(Mock.class));
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        if (mocksToFields.isEmpty()) {
            LOGGER.warn("No field to inject found for class {}", (Object)testClass.getName());
        }
        return mocksToFields;
    }

    private void injectMocks(Object requiredTestInstance, Map<Field, Mock> mockToFields) {
        mockToFields.forEach((field, mockSpec) -> {
            MockType mockType = mockSpec.value();
            Class<?> fieldType = field.getType();
            Object mock = mockType.createMock(fieldType);
            if (mockSpec.readyToUse()) {
                EasyMock.replay((Object[])new Object[]{mock});
            }
            try {
                LOGGER.debug("Injecting mock of type {} into field {} of type {} for test class {}", new Object[]{mock.getClass().getName(), field.getName(), fieldType.getName(), requiredTestInstance.getClass().getName()});
                field.setAccessible(true);
                field.set(requiredTestInstance, mock);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                LOGGER.error(e.getMessage());
                throw new RuntimeException(e);
            }
        });
    }

    private void verifyMocks(ExtensionContext context, Class<?> testClass) {
        for (Field field : testClass.getDeclaredFields()) {
            TestBedUtils.getAnnotation(field, Mock.class).ifPresent(mockAnnotation -> {
                if (mockAnnotation.verifyMocksAfterEachTest()) {
                    try {
                        LOGGER.debug("Verifying mock field {} in test class {}", (Object)field.getName(), (Object)testClass.getName());
                        field.setAccessible(true);
                        EasyMock.verify((Object[])new Object[]{field.get(context.getRequiredTestInstance())});
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        LOGGER.error(e.getMessage());
                        throw new RuntimeException(e);
                    }
                }
            });
        }
    }
}

