/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.testingutils.mock;

import org.easymock.EasyMock;
import org.thewonderlemming.c4plantuml.testingutils.AbstractMockHelper;
import org.thewonderlemming.c4plantuml.testingutils.AndReturn;
import org.thewonderlemming.c4plantuml.testingutils.GivenData;
import org.thewonderlemming.c4plantuml.testingutils.GivenDeep;
import org.thewonderlemming.c4plantuml.testingutils.GivenFeature;
import org.thewonderlemming.c4plantuml.testingutils.GivenHandler;
import org.thewonderlemming.c4plantuml.testingutils.GivenKey;
import org.thewonderlemming.c4plantuml.testingutils.GivenLocalName;
import org.thewonderlemming.c4plantuml.testingutils.GivenNamespaceURI;
import org.thewonderlemming.c4plantuml.testingutils.GivenNode;
import org.thewonderlemming.c4plantuml.testingutils.GivenQualifiedName;
import org.thewonderlemming.c4plantuml.testingutils.GivenRefNode;
import org.thewonderlemming.c4plantuml.testingutils.GivenTarget;
import org.thewonderlemming.c4plantuml.testingutils.GivenVersion;
import org.thewonderlemming.c4plantuml.testingutils.MockType;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;

public class DocumentMockHelper
extends AbstractMockHelper<Document> {
    public static DocumentMockHelper setUpDefaultMock(Document mock) {
        return new DocumentMockHelper(mock, MockType.DEFAULT);
    }

    public static DocumentMockHelper setUpNiceMock(Document mock) {
        return new DocumentMockHelper(mock, MockType.NICE);
    }

    public static DocumentMockHelper setUpStrictMock(Document mock) {
        return new DocumentMockHelper(mock, MockType.STRICT);
    }

    private DocumentMockHelper(Document mock, MockType mockType) {
        super(mock, mockType);
    }

    public DocumentMockHelper notToBeDefaultNamespaceGiven(String namespace) {
        EasyMock.expect((Object)((Document)this.getMock()).isDefaultNamespace((String)EasyMock.eq((Object)namespace))).andReturn((Object)false);
        return this;
    }

    public DocumentMockHelper notToBeEqualNodeGiven(Node node) {
        EasyMock.expect((Object)((Document)this.getMock()).isEqualNode((Node)EasyMock.eq((Object)node))).andReturn((Object)false);
        return this;
    }

    public DocumentMockHelper notToBeSameNodeGiven(Node node) {
        EasyMock.expect((Object)((Document)this.getMock()).isSameNode((Node)EasyMock.eq((Object)node))).andReturn((Object)false);
        return this;
    }

    public GivenFeature<String, GivenVersion<String, DocumentMockHelper>> notToBeSupported() {
        return feature -> version -> {
            EasyMock.expect((Object)((Document)this.getMock()).isSupported((String)EasyMock.eq((Object)feature), (String)EasyMock.eq((Object)version))).andReturn((Object)false);
            return this;
        };
    }

    public DocumentMockHelper toAdoptNode(Node node) {
        EasyMock.expect((Object)((Document)this.getMock()).adoptNode((Node)EasyMock.eq((Object)node))).andStubReturn((Object)node);
        return this;
    }

    public DocumentMockHelper toBeDefaultNamespaceGiven(String namespace) {
        EasyMock.expect((Object)((Document)this.getMock()).isDefaultNamespace((String)EasyMock.eq((Object)namespace))).andReturn((Object)true);
        return this;
    }

    public DocumentMockHelper toBeEqualNodeGiven(Node node) {
        EasyMock.expect((Object)((Document)this.getMock()).isEqualNode((Node)EasyMock.eq((Object)node))).andReturn((Object)true);
        return this;
    }

    public DocumentMockHelper toBeSameNodeGiven(Node node) {
        EasyMock.expect((Object)((Document)this.getMock()).isSameNode((Node)EasyMock.eq((Object)node))).andReturn((Object)true);
        return this;
    }

    public GivenFeature<String, GivenVersion<String, DocumentMockHelper>> toBeSupported() {
        return feature -> version -> {
            EasyMock.expect((Object)((Document)this.getMock()).isSupported((String)EasyMock.eq((Object)feature), (String)EasyMock.eq((Object)version))).andReturn((Object)true);
            return this;
        };
    }

    public AndReturn<Node, DocumentMockHelper> toCloneNodeGiven(boolean deep) {
        return node -> {
            EasyMock.expect((Object)((Document)this.getMock()).cloneNode(EasyMock.eq((boolean)deep))).andStubReturn(node);
            return this;
        };
    }

    public AndReturn<Short, DocumentMockHelper> toCompareDocumentPositionGiven(Node node) {
        return position -> {
            EasyMock.expect((Object)((Document)this.getMock()).compareDocumentPosition((Node)EasyMock.eq((Object)node))).andStubReturn(position);
            return this;
        };
    }

    public AndReturn<Attr, DocumentMockHelper> toCreateAttributeGiven(String name) {
        return attribute -> {
            EasyMock.expect((Object)((Document)this.getMock()).createAttribute((String)EasyMock.eq((Object)name))).andStubReturn(attribute);
            return this;
        };
    }

    public GivenNamespaceURI<String, GivenQualifiedName<String, AndReturn<Attr, DocumentMockHelper>>> toCreateAttributeNS() {
        return namespaceUri -> qualifiedName -> attribute -> {
            EasyMock.expect((Object)((Document)this.getMock()).createAttributeNS((String)EasyMock.eq((Object)namespaceUri), (String)EasyMock.eq((Object)qualifiedName))).andStubReturn(attribute);
            return this;
        };
    }

    public AndReturn<CDATASection, DocumentMockHelper> toCreateCDATASectionGiven(String data) {
        return cdata -> {
            EasyMock.expect((Object)((Document)this.getMock()).createCDATASection((String)EasyMock.eq((Object)data))).andStubReturn(cdata);
            return this;
        };
    }

    public AndReturn<Comment, DocumentMockHelper> toCreateCommentGiven(String data) {
        return comment -> {
            EasyMock.expect((Object)((Document)this.getMock()).createComment((String)EasyMock.eq((Object)data))).andStubReturn(comment);
            return this;
        };
    }

    public DocumentMockHelper toCreateDocumentFragment(DocumentFragment fragment) {
        EasyMock.expect((Object)((Document)this.getMock()).createDocumentFragment()).andStubReturn((Object)fragment);
        return this;
    }

    public AndReturn<Element, DocumentMockHelper> toCreateElementGiven(String name) {
        return element -> {
            EasyMock.expect((Object)((Document)this.getMock()).createElement((String)EasyMock.eq((Object)name))).andStubReturn(element);
            return this;
        };
    }

    public AndReturn<EntityReference, DocumentMockHelper> toCreateEntityReferenceGiven(String name) {
        return reference -> {
            EasyMock.expect((Object)((Document)this.getMock()).createEntityReference((String)EasyMock.eq((Object)name))).andStubReturn(reference);
            return this;
        };
    }

    public GivenTarget<String, GivenData<String, AndReturn<ProcessingInstruction, DocumentMockHelper>>> toCreateProcessingInstruction() {
        return target -> data -> instruction -> {
            EasyMock.expect((Object)((Document)this.getMock()).createProcessingInstruction((String)EasyMock.eq((Object)target), (String)EasyMock.eq((Object)data))).andStubReturn(instruction);
            return this;
        };
    }

    public AndReturn<Text, DocumentMockHelper> toCreateTextNodeGiven(String name) {
        return node -> {
            EasyMock.expect((Object)((Document)this.getMock()).createTextNode((String)EasyMock.eq((Object)name))).andStubReturn(node);
            return this;
        };
    }

    public DocumentMockHelper toGetAttributes(NamedNodeMap attributes) {
        EasyMock.expect((Object)((Document)this.getMock()).getAttributes()).andStubReturn((Object)attributes);
        return this;
    }

    public DocumentMockHelper toGetBaseURI(String baseURI) {
        EasyMock.expect((Object)((Document)this.getMock()).getBaseURI()).andStubReturn((Object)baseURI);
        return this;
    }

    public DocumentMockHelper toGetChildNodes(NodeList nodes) {
        EasyMock.expect((Object)((Document)this.getMock()).getChildNodes()).andStubReturn((Object)nodes);
        return this;
    }

    public DocumentMockHelper toGetDoctype(DocumentType type) {
        EasyMock.expect((Object)((Document)this.getMock()).getDoctype()).andStubReturn((Object)type);
        return this;
    }

    public DocumentMockHelper toGetDocumentElement(Element element) {
        EasyMock.expect((Object)((Document)this.getMock()).getDocumentElement()).andStubReturn((Object)element);
        return this;
    }

    public DocumentMockHelper toGetDocumentURI(String uri) {
        EasyMock.expect((Object)((Document)this.getMock()).getDocumentURI()).andStubReturn((Object)uri);
        return this;
    }

    public DocumentMockHelper toGetDomConfig(DOMConfiguration config) {
        EasyMock.expect((Object)((Document)this.getMock()).getDomConfig()).andStubReturn((Object)config);
        return this;
    }

    public AndReturn<Element, DocumentMockHelper> toGetElementByIdGiven(String id) {
        return element -> {
            EasyMock.expect((Object)((Document)this.getMock()).getElementById((String)EasyMock.eq((Object)id))).andStubReturn(element);
            return this;
        };
    }

    public AndReturn<NodeList, DocumentMockHelper> toGetElementsByTagNameGiven(String tag) {
        return nodes -> {
            EasyMock.expect((Object)((Document)this.getMock()).getElementsByTagName((String)EasyMock.eq((Object)tag))).andStubReturn(nodes);
            return this;
        };
    }

    public GivenNamespaceURI<String, GivenLocalName<String, AndReturn<NodeList, DocumentMockHelper>>> toGetElementsByTagNameNS() {
        return namespaceUri -> localName -> nodes -> {
            EasyMock.expect((Object)((Document)this.getMock()).getElementsByTagNameNS((String)EasyMock.eq((Object)namespaceUri), (String)EasyMock.eq((Object)localName))).andReturn(nodes);
            return this;
        };
    }

    public GivenFeature<String, GivenVersion<String, AndReturn<Object, DocumentMockHelper>>> toGetFeature() {
        return featureName -> version -> feature -> {
            EasyMock.expect((Object)((Document)this.getMock()).getFeature((String)EasyMock.eq((Object)featureName), (String)EasyMock.eq((Object)version))).andReturn(feature);
            return this;
        };
    }

    public DocumentMockHelper toGetFirstChild(Node child) {
        EasyMock.expect((Object)((Document)this.getMock()).getFirstChild()).andStubReturn((Object)child);
        return this;
    }

    public DocumentMockHelper toGetImplementation(DOMImplementation impl) {
        EasyMock.expect((Object)((Document)this.getMock()).getImplementation()).andStubReturn((Object)impl);
        return this;
    }

    public DocumentMockHelper toGetInputEncoding(String encoding) {
        EasyMock.expect((Object)((Document)this.getMock()).getInputEncoding()).andReturn((Object)encoding);
        return this;
    }

    public DocumentMockHelper toGetLastChild(Node lastChild) {
        EasyMock.expect((Object)((Document)this.getMock()).getLastChild()).andReturn((Object)lastChild);
        return this;
    }

    public DocumentMockHelper toGetLocalName(String localName) {
        EasyMock.expect((Object)((Document)this.getMock()).getLocalName()).andReturn((Object)localName);
        return this;
    }

    public DocumentMockHelper toGetNamespaceURI(String namespaceURI) {
        EasyMock.expect((Object)((Document)this.getMock()).getNamespaceURI()).andReturn((Object)namespaceURI);
        return this;
    }

    public DocumentMockHelper toGetNextSibling(Node sibling) {
        EasyMock.expect((Object)((Document)this.getMock()).getNextSibling()).andReturn((Object)sibling);
        return this;
    }

    public DocumentMockHelper toGetNodeName(String name) {
        EasyMock.expect((Object)((Document)this.getMock()).getNodeName()).andReturn((Object)name);
        return this;
    }

    public DocumentMockHelper toGetNodeValue(String value) {
        EasyMock.expect((Object)((Document)this.getMock()).getNodeValue()).andReturn((Object)value);
        return this;
    }

    public DocumentMockHelper toGetOwnerDocument(Document ownerDocument) {
        EasyMock.expect((Object)((Document)this.getMock()).getOwnerDocument()).andReturn((Object)ownerDocument);
        return this;
    }

    public DocumentMockHelper toGetParentNode(Node parentNode) {
        EasyMock.expect((Object)((Document)this.getMock()).getParentNode()).andReturn((Object)parentNode);
        return this;
    }

    public DocumentMockHelper toGetPrefix(String prefix) {
        EasyMock.expect((Object)((Document)this.getMock()).getPrefix()).andReturn((Object)prefix);
        return this;
    }

    public DocumentMockHelper toGetPreviousSibling(Node sibling) {
        EasyMock.expect((Object)((Document)this.getMock()).getPreviousSibling()).andReturn((Object)sibling);
        return this;
    }

    public DocumentMockHelper toGetStrictErrorChecking(boolean checking) {
        EasyMock.expect((Object)((Document)this.getMock()).getStrictErrorChecking()).andReturn((Object)checking);
        return this;
    }

    public DocumentMockHelper toGetTextContent(String content) {
        EasyMock.expect((Object)((Document)this.getMock()).getTextContent()).andReturn((Object)content);
        return this;
    }

    public AndReturn<Object, DocumentMockHelper> toGetUserDataGiven(String key) {
        return userData -> {
            EasyMock.expect((Object)((Document)this.getMock()).getUserData((String)EasyMock.eq((Object)key))).andReturn(userData);
            return this;
        };
    }

    public DocumentMockHelper toGetXmlEncoding(String encoding) {
        EasyMock.expect((Object)((Document)this.getMock()).getXmlEncoding()).andReturn((Object)encoding);
        return this;
    }

    public DocumentMockHelper toGetXmlStandalone(boolean isStandalone) {
        EasyMock.expect((Object)((Document)this.getMock()).getXmlStandalone()).andReturn((Object)isStandalone);
        return this;
    }

    public DocumentMockHelper toGetXmlVersion(String version) {
        EasyMock.expect((Object)((Document)this.getMock()).getXmlVersion()).andReturn((Object)version);
        return this;
    }

    public DocumentMockHelper toHaveAttributes(boolean hasAttributes) {
        EasyMock.expect((Object)((Document)this.getMock()).hasAttributes()).andReturn((Object)hasAttributes);
        return this;
    }

    public DocumentMockHelper toHaveChildNodes(boolean hasChildNodes) {
        EasyMock.expect((Object)((Document)this.getMock()).hasChildNodes()).andReturn((Object)hasChildNodes);
        return this;
    }

    public GivenNode<Node, GivenDeep<Boolean, AndReturn<Node, DocumentMockHelper>>> toImportNode() {
        return newNode -> deep -> node -> {
            EasyMock.expect((Object)((Document)this.getMock()).importNode((Node)EasyMock.eq((Object)newNode), (Boolean)EasyMock.eq((Object)deep))).andReturn(node);
            return this;
        };
    }

    public GivenNode<Node, GivenRefNode<Node, AndReturn<Node, DocumentMockHelper>>> toInsertBefore() {
        return newChildNode -> childRefNode -> node -> {
            EasyMock.expect((Object)((Document)this.getMock()).insertBefore((Node)EasyMock.eq((Object)newChildNode), (Node)EasyMock.eq((Object)childRefNode))).andReturn(node);
            return this;
        };
    }

    public AndReturn<String, DocumentMockHelper> toLookupNamespaceURIGiven(String prefix) {
        return namespaceURI -> {
            EasyMock.expect((Object)((Document)this.getMock()).lookupNamespaceURI((String)EasyMock.eq((Object)prefix))).andReturn(namespaceURI);
            return this;
        };
    }

    public AndReturn<String, DocumentMockHelper> toLookupPrefixGiven(String namespace) {
        return prefix -> {
            EasyMock.expect((Object)((Document)this.getMock()).lookupPrefix((String)EasyMock.eq((Object)namespace))).andReturn(prefix);
            return this;
        };
    }

    public DocumentMockHelper toNormalize() {
        ((Document)this.getMock()).normalize();
        EasyMock.expectLastCall();
        return this;
    }

    public DocumentMockHelper toNormalizeDocument() {
        ((Document)this.getMock()).normalizeDocument();
        EasyMock.expectLastCall();
        return this;
    }

    public AndReturn<Node, DocumentMockHelper> toRemoveChildGiven(Node childNode) {
        return returnedNode -> {
            EasyMock.expect((Object)((Document)this.getMock()).removeChild((Node)EasyMock.eq((Object)childNode))).andReturn(returnedNode);
            return this;
        };
    }

    public GivenNode<Node, GivenNamespaceURI<String, GivenQualifiedName<String, AndReturn<Node, DocumentMockHelper>>>> toRenameNode() {
        return node -> namespaceURI -> qualifiedName -> returnedNode -> {
            EasyMock.expect((Object)((Document)this.getMock()).renameNode((Node)EasyMock.eq((Object)node), (String)EasyMock.eq((Object)namespaceURI), (String)EasyMock.eq((Object)qualifiedName))).andReturn(returnedNode);
            return this;
        };
    }

    public GivenNode<Node, GivenRefNode<Node, AndReturn<Node, DocumentMockHelper>>> toReplaceChild() {
        return node -> refNode -> returnedNode -> {
            EasyMock.expect((Object)((Document)this.getMock()).replaceChild((Node)EasyMock.eq((Object)node), (Node)EasyMock.eq((Object)refNode))).andReturn(returnedNode);
            return this;
        };
    }

    public DocumentMockHelper toSetDocumentURIGiven(String uri) {
        ((Document)this.getMock()).setDocumentURI((String)EasyMock.eq((Object)uri));
        EasyMock.expectLastCall();
        return this;
    }

    public DocumentMockHelper toSetNodeValue(String value) {
        ((Document)this.getMock()).setNodeValue((String)EasyMock.eq((Object)value));
        EasyMock.expectLastCall();
        return this;
    }

    public DocumentMockHelper toSetPrefix(String prefix) {
        ((Document)this.getMock()).setPrefix((String)EasyMock.eq((Object)prefix));
        EasyMock.expectLastCall();
        return this;
    }

    public DocumentMockHelper toSetStrictErrorChecking(boolean errorChecking) {
        ((Document)this.getMock()).setStrictErrorChecking(EasyMock.eq((boolean)errorChecking));
        EasyMock.expectLastCall();
        return this;
    }

    public DocumentMockHelper toSetTextContent(String content) {
        ((Document)this.getMock()).setTextContent((String)EasyMock.eq((Object)content));
        EasyMock.expectLastCall();
        return this;
    }

    public GivenKey<String, GivenData<Object, GivenHandler<UserDataHandler, AndReturn<Object, DocumentMockHelper>>>> toSetUserData() {
        return key -> userData -> userDataHandler -> data -> {
            EasyMock.expect((Object)((Document)this.getMock()).setUserData((String)EasyMock.eq((Object)key), EasyMock.eq((Object)userData), (UserDataHandler)EasyMock.eq((Object)userDataHandler))).andReturn(data);
            return this;
        };
    }

    public DocumentMockHelper toSetXmlStandalone(boolean standalone) {
        ((Document)this.getMock()).setXmlStandalone(EasyMock.eq((boolean)standalone));
        EasyMock.expectLastCall();
        return this;
    }

    public DocumentMockHelper toSetXmlVersion(String version) {
        ((Document)this.getMock()).setXmlVersion((String)EasyMock.eq((Object)version));
        EasyMock.expectLastCall();
        return this;
    }
}

