/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.testingutils.testcase;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.slf4j.LoggerFactory;
import org.thewonderlemming.c4plantuml.testingutils.SUT;
import org.thewonderlemming.c4plantuml.testingutils.junit.FindSut;

@FindSut
public interface SutTestCase<T> {
    default public Optional<T> findFirstSutFromFields() {
        List<Field> fields = Arrays.asList(this.getClass().getDeclaredFields());
        fields.sort((left, right) -> left.getName().compareTo(right.getName()));
        for (Field field : fields) {
            SUT fieldAnnotation = field.getAnnotation(SUT.class);
            if (null == fieldAnnotation || !this.getSutType().isAssignableFrom(field.getType())) continue;
            try {
                field.setAccessible(true);
                return Optional.ofNullable(field.get(this));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                LoggerFactory.getLogger((String)this.getClass().getName()).error(e.getMessage());
            }
        }
        return Optional.empty();
    }

    default public Optional<T> findFirstSutFromMethods() {
        List<Method> methods = Arrays.asList(this.getClass().getDeclaredMethods());
        methods.sort((left, right) -> left.getName().compareTo(right.getName()));
        for (Method method : methods) {
            SUT fieldAnnotation = method.getAnnotation(SUT.class);
            if (null == fieldAnnotation || !this.getSutType().isAssignableFrom(method.getReturnType())) continue;
            try {
                method.setAccessible(true);
                return Optional.ofNullable(method.invoke((Object)this, new Object[0]));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                LoggerFactory.getLogger((String)this.getClass().getName()).error(e.getMessage());
            }
        }
        return Optional.empty();
    }

    public Class<T> getSutType();

    default public T sut() {
        if (this.findFirstSutFromFields().isPresent()) {
            return this.findFirstSutFromFields().get();
        }
        if (this.findFirstSutFromMethods().isPresent()) {
            return this.findFirstSutFromMethods().get();
        }
        String errorMessage = String.format("Could not retrieve the test target. Please check that it is properly annotated with the %s annotation and that it is a subsclass of %s", SUT.class.getName(), this.getSutType().getName());
        throw new RuntimeException(errorMessage);
    }
}

