/*
 * Decompiled with CFR 0.152.
 */
package org.thiki.lark.foundation.comparator;

import com.alibaba.fastjson.JSONArray;
import java.util.List;
import java.util.Map;
import org.thiki.lark.foundation.comparator.Comparator;
import org.thiki.lark.foundation.comparator.MapComparator;
import org.thiki.lark.foundation.comparator.People;

public class ListComparator
extends Comparator {
    public static boolean compare(Object beforeItem, Object afterItem, Object[] excludeFields) {
        JSONArray beforeArray = (JSONArray)JSONArray.toJSON((Object)beforeItem);
        JSONArray afterArray = (JSONArray)JSONArray.toJSON((Object)afterItem);
        if (beforeArray.size() != afterArray.size()) {
            return false;
        }
        for (Object field : excludeFields) {
            for (int i = 0; i < beforeArray.size(); ++i) {
                if (!beforeArray.getJSONObject(i).containsKey(field) && !afterArray.getJSONObject(i).containsKey(field)) continue;
                beforeArray.getJSONObject(i).remove(field);
                afterArray.getJSONObject(i).remove(field);
            }
        }
        return ListComparator.compare((List)beforeArray, (List)afterArray);
    }

    public static Boolean compare(List beforeItem, List afterItem) {
        if (beforeItem == null || afterItem == null) {
            ListComparator.printDiff("\u4e24\u4e2aList\u4e2d\uff0c\u6709\u4e00\u4e2a\u4e3anull", beforeItem, afterItem);
            return false;
        }
        if (beforeItem.size() != afterItem.size()) {
            ListComparator.printDiff("\u4e24\u4e2aList\u7684Size\u4e0d\u540c", beforeItem, afterItem);
            return false;
        }
        for (Object item : beforeItem) {
            if (ListComparator.isContain(item, afterItem).booleanValue()) continue;
            ListComparator.printDiff("\u4e00\u4e2a\u5bf9\u8c61\u6ca1\u6709\u5728\u4e24\u4e2aList\u4e2d\u540c\u65f6\u51fa\u73b0\uff0c\u5177\u4f53\u4fe1\u606f\u8bf7\u7ee7\u7eed\u67e5\u770b\u4e0b\u4e00\u6761\u8f93\u51fa\u3002\u5f02\u5e38\u5bf9\u8c61->" + item, beforeItem, afterItem);
            return false;
        }
        for (Object item : afterItem) {
            if (ListComparator.isContain(item, beforeItem).booleanValue()) continue;
            ListComparator.printDiff("\u4e00\u4e2a\u5bf9\u8c61\u6ca1\u6709\u5728\u4e24\u4e2aList\u4e2d\u540c\u65f6\u51fa\u73b0\uff0c\u5177\u4f53\u4fe1\u606f\u8bf7\u7ee7\u7eed\u67e5\u770b\u4e0a\u4e00\u6761\u8f93\u51fa\u3002\u5f02\u5e38\u5bf9\u8c61->" + item, afterItem, beforeItem);
            return false;
        }
        return true;
    }

    private static Boolean isContain(Object item, List targetList) {
        boolean result;
        if (item instanceof Map) {
            for (Object targetItem : targetList) {
                if (!(targetItem instanceof Map)) continue;
                result = MapComparator.compare((Map)item, (Map)targetItem, false);
                if (!result) break;
                return true;
            }
            ListComparator.findOutWhatsDiffInDetail((Map)item, targetList);
        }
        if (item instanceof List) {
            for (Object targetItem : targetList) {
                if (!(targetItem instanceof List) || !(result = ListComparator.compare((List)item, (List)targetItem).booleanValue())) continue;
                return true;
            }
        }
        for (Object targetItem : targetList) {
            if (!targetItem.equals(item)) continue;
            return true;
        }
        return false;
    }

    private static void findOutWhatsDiffInDetail(Map item, List targetList) {
        for (Object key : item.keySet()) {
            boolean isHasKey = false;
            boolean isHasValue = false;
            for (Object targetItem : targetList) {
                if (!(targetItem instanceof Map)) continue;
                Map targetMap = (Map)targetItem;
                if (targetMap.containsKey(key)) {
                    isHasKey = true;
                }
                if (!People.compare(item.get(key), targetMap.get(key), new Object[0])) continue;
                isHasValue = true;
            }
            if (!isHasKey) {
                ListComparator.printDiff("\u6ca1\u6709\u627e\u5230Key:" + key, item, targetList);
            }
            if (isHasValue) continue;
            ListComparator.printDiff("\u76ee\u6807\u96c6\u5408\u5143\u7d20\u4e2d\u6ca1\u6709\u5339\u914d\u5230\u7684key\uff1a" + key + "->" + item.get(key), item, targetList);
        }
    }
}

