/*
 * Decompiled with CFR 0.152.
 */
package org.thiki.lark.foundation.comparator;

import java.util.List;
import java.util.Map;
import org.thiki.lark.foundation.comparator.Comparator;
import org.thiki.lark.foundation.comparator.ListComparator;
import org.thiki.lark.foundation.comparator.People;

public class MapComparator
extends Comparator {
    public static boolean compare(Object beforeItem, Object afterItem, Object[] excludeFields, boolean isPrintDiff) {
        Map<String, Object> beforeMap = People.toMap(beforeItem);
        Map<String, Object> afterMap = People.toMap(afterItem);
        for (Object field : excludeFields) {
            if (beforeMap.containsKey(field)) {
                beforeMap.remove(field);
            }
            if (!afterMap.containsKey(field)) continue;
            afterMap.remove(field);
        }
        return MapComparator.compare(beforeMap, afterMap, isPrintDiff);
    }

    public static boolean compare(Map beforeItem, Map afterItem, boolean isPrintDiff) {
        if (beforeItem == null && afterItem == null) {
            return true;
        }
        if (beforeItem == null || afterItem == null) {
            MapComparator.printDiff("\u4e24\u4e2aMap\u4e2d\uff0c\u6709\u4e00\u4e2a\u4e3anull", beforeItem, afterItem, isPrintDiff);
            return false;
        }
        if (beforeItem.size() != afterItem.size()) {
            MapComparator.printDiff("\u4e24\u4e2aMap\u7684Size\u4e0d\u540c", beforeItem, afterItem, isPrintDiff);
            return false;
        }
        for (Object key : beforeItem.keySet()) {
            if (!afterItem.containsKey(key)) {
                MapComparator.printDiff("\u53d1\u73b0\u4e86\u7f3a\u5931\u7684Key", key, null, isPrintDiff);
                return false;
            }
            if (MapComparator.isEquals(key, beforeItem.get(key), afterItem.get(key), isPrintDiff).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private static Boolean isEquals(Object key, Object beforeValue, Object afterValue, boolean isPrintDiff) {
        if (beforeValue == null && afterValue == null) {
            return true;
        }
        if (beforeValue == null || afterValue == null) {
            MapComparator.printDiff("Key{" + key + "}\u4e24\u4e2a\u503c\u4e2d\uff0c\u6709\u4e00\u4e2a\u4e3anull", beforeValue, afterValue, isPrintDiff);
            return false;
        }
        if (MapComparator.isMapCompare(beforeValue, afterValue).booleanValue()) {
            return MapComparator.compare((Map)beforeValue, (Map)afterValue, isPrintDiff);
        }
        if (MapComparator.isListCompare(beforeValue, afterValue).booleanValue()) {
            return ListComparator.compare((List)beforeValue, (List)afterValue);
        }
        if (beforeValue == null) {
            System.out.println("======================================error");
            return false;
        }
        if (!beforeValue.equals(afterValue)) {
            MapComparator.printDiff("Key{" + key + "}\u5728\u4e24\u4e2a\u5bf9\u8c61\u4e2d\u7684\u503c\u6216\u7c7b\u578b\u4e0d\u76f8\u7b49", beforeValue, afterValue, isPrintDiff);
            return false;
        }
        return true;
    }

    private static Boolean isMapCompare(Object beforeValue, Object afterValue) {
        return beforeValue instanceof Map && afterValue instanceof Map;
    }

    private static Boolean isListCompare(Object beforeValue, Object afterValue) {
        return beforeValue instanceof List && afterValue instanceof List;
    }
}

