/*
 * Decompiled with CFR 0.152.
 */
package org.thiki.lark.foundation.date;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.thiki.lark.foundation.date.DateStyle;
import org.thiki.lark.foundation.date.Week;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateUtil {
    private static final ThreadLocal<SimpleDateFormat> threadLocal = new ThreadLocal();
    private static final Object object = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SimpleDateFormat getDateFormat(String pattern) throws RuntimeException {
        SimpleDateFormat dateFormat = threadLocal.get();
        if (dateFormat == null) {
            Object object = DateUtil.object;
            synchronized (object) {
                if (dateFormat == null) {
                    dateFormat = new SimpleDateFormat(pattern);
                    dateFormat.setLenient(false);
                    threadLocal.set(dateFormat);
                }
            }
        }
        dateFormat.applyPattern(pattern);
        return dateFormat;
    }

    private static int getInteger(Date date, int dateType) {
        int num = 0;
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
            num = calendar.get(dateType);
        }
        return num;
    }

    private static String addInteger(String date, int dateType, int amount) {
        String dateString = null;
        DateStyle dateStyle = DateUtil.getDateStyle(date);
        if (dateStyle != null) {
            Date myDate = DateUtil.StringToDate(date, dateStyle);
            myDate = DateUtil.addInteger(myDate, dateType, amount);
            dateString = DateUtil.DateToString(myDate, dateStyle);
        }
        return dateString;
    }

    private static Date addInteger(Date date, int dateType, int amount) {
        Date myDate = null;
        if (date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(dateType, amount);
            myDate = calendar.getTime();
        }
        return myDate;
    }

    private static Date getAccurateDate(List<Long> timestamps) {
        Date date = null;
        long timestamp = 0L;
        HashMap<Long, long[]> map = new HashMap<Long, long[]>();
        ArrayList<Long> absoluteValues = new ArrayList<Long>();
        if (timestamps != null && timestamps.size() > 0) {
            if (timestamps.size() > 1) {
                for (int i = 0; i < timestamps.size(); ++i) {
                    for (int j = i + 1; j < timestamps.size(); ++j) {
                        long absoluteValue = Math.abs(timestamps.get(i) - timestamps.get(j));
                        absoluteValues.add(absoluteValue);
                        long[] timestampTmp = new long[]{timestamps.get(i), timestamps.get(j)};
                        map.put(absoluteValue, timestampTmp);
                    }
                }
                long minAbsoluteValue = -1L;
                if (!absoluteValues.isEmpty()) {
                    minAbsoluteValue = (Long)absoluteValues.get(0);
                    for (int i = 1; i < absoluteValues.size(); ++i) {
                        if (minAbsoluteValue <= (Long)absoluteValues.get(i)) continue;
                        minAbsoluteValue = (Long)absoluteValues.get(i);
                    }
                }
                if (minAbsoluteValue != -1L) {
                    long[] timestampsLastTmp = (long[])map.get(minAbsoluteValue);
                    long dateOne = timestampsLastTmp[0];
                    long dateTwo = timestampsLastTmp[1];
                    if (absoluteValues.size() > 1) {
                        timestamp = Math.abs(dateOne) > Math.abs(dateTwo) ? dateOne : dateTwo;
                    }
                }
            } else {
                timestamp = timestamps.get(0);
            }
        }
        if (timestamp != 0L) {
            date = new Date(timestamp);
        }
        return date;
    }

    public static boolean isDate(String date) {
        boolean isDate = false;
        if (date != null && DateUtil.getDateStyle(date) != null) {
            isDate = true;
        }
        return isDate;
    }

    public static DateStyle getDateStyle(String date) {
        DateStyle dateStyle = null;
        HashMap<Long, DateStyle> map = new HashMap<Long, DateStyle>();
        ArrayList<Long> timestamps = new ArrayList<Long>();
        for (DateStyle style : DateStyle.values()) {
            if (style.isShowOnly()) continue;
            Date dateTmp = null;
            if (date != null) {
                try {
                    ParsePosition pos = new ParsePosition(0);
                    dateTmp = DateUtil.getDateFormat(style.getValue()).parse(date, pos);
                    if (pos.getIndex() != date.length()) {
                        dateTmp = null;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (dateTmp == null) continue;
            timestamps.add(dateTmp.getTime());
            map.put(dateTmp.getTime(), style);
        }
        Date accurateDate = DateUtil.getAccurateDate(timestamps);
        if (accurateDate != null) {
            dateStyle = (DateStyle)((Object)map.get(accurateDate.getTime()));
        }
        return dateStyle;
    }

    public static Date StringToDate(String date) {
        DateStyle dateStyle = DateUtil.getDateStyle(date);
        return DateUtil.StringToDate(date, dateStyle);
    }

    public static Date StringToDate(String date, String pattern) {
        Date myDate = null;
        if (date != null) {
            try {
                myDate = DateUtil.getDateFormat(pattern).parse(date);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return myDate;
    }

    public static Date StringToDate(String date, DateStyle dateStyle) {
        Date myDate = null;
        if (dateStyle != null) {
            myDate = DateUtil.StringToDate(date, dateStyle.getValue());
        }
        return myDate;
    }

    public static String DateToString(Date date, String pattern) {
        String dateString = null;
        if (date != null) {
            try {
                dateString = DateUtil.getDateFormat(pattern).format(date);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return dateString;
    }

    public static String DateToString(Date date, DateStyle dateStyle) {
        String dateString = null;
        if (dateStyle != null) {
            dateString = DateUtil.DateToString(date, dateStyle.getValue());
        }
        return dateString;
    }

    public static String StringToString(String date, String newPattern) {
        DateStyle oldDateStyle = DateUtil.getDateStyle(date);
        return DateUtil.StringToString(date, oldDateStyle, newPattern);
    }

    public static String StringToString(String date, DateStyle newDateStyle) {
        DateStyle oldDateStyle = DateUtil.getDateStyle(date);
        return DateUtil.StringToString(date, oldDateStyle, newDateStyle);
    }

    public static String StringToString(String date, String olddPattern, String newPattern) {
        return DateUtil.DateToString(DateUtil.StringToDate(date, olddPattern), newPattern);
    }

    public static String StringToString(String date, DateStyle olddDteStyle, String newParttern) {
        String dateString = null;
        if (olddDteStyle != null) {
            dateString = DateUtil.StringToString(date, olddDteStyle.getValue(), newParttern);
        }
        return dateString;
    }

    public static String StringToString(String date, String olddPattern, DateStyle newDateStyle) {
        String dateString = null;
        if (newDateStyle != null) {
            dateString = DateUtil.StringToString(date, olddPattern, newDateStyle.getValue());
        }
        return dateString;
    }

    public static String StringToString(String date, DateStyle olddDteStyle, DateStyle newDateStyle) {
        String dateString = null;
        if (olddDteStyle != null && newDateStyle != null) {
            dateString = DateUtil.StringToString(date, olddDteStyle.getValue(), newDateStyle.getValue());
        }
        return dateString;
    }

    public static String addYear(String date, int yearAmount) {
        return DateUtil.addInteger(date, 1, yearAmount);
    }

    public static Date addYear(Date date, int yearAmount) {
        return DateUtil.addInteger(date, 1, yearAmount);
    }

    public static String addMonth(String date, int monthAmount) {
        return DateUtil.addInteger(date, 2, monthAmount);
    }

    public static Date addMonth(Date date, int monthAmount) {
        return DateUtil.addInteger(date, 2, monthAmount);
    }

    public static String addDay(String date, int dayAmount) {
        return DateUtil.addInteger(date, 5, dayAmount);
    }

    public static Date addDay(Date date, int dayAmount) {
        return DateUtil.addInteger(date, 5, dayAmount);
    }

    public static String addHour(String date, int hourAmount) {
        return DateUtil.addInteger(date, 11, hourAmount);
    }

    public static Date addHour(Date date, int hourAmount) {
        return DateUtil.addInteger(date, 11, hourAmount);
    }

    public static String addMinute(String date, int minuteAmount) {
        return DateUtil.addInteger(date, 12, minuteAmount);
    }

    public static Date addMinute(Date date, int minuteAmount) {
        return DateUtil.addInteger(date, 12, minuteAmount);
    }

    public static String addSecond(String date, int secondAmount) {
        return DateUtil.addInteger(date, 13, secondAmount);
    }

    public static Date addSecond(Date date, int secondAmount) {
        return DateUtil.addInteger(date, 13, secondAmount);
    }

    public static int getYear(String date) {
        return DateUtil.getYear(DateUtil.StringToDate(date));
    }

    public static int getYear(Date date) {
        return DateUtil.getInteger(date, 1);
    }

    public static int getMonth(String date) {
        return DateUtil.getMonth(DateUtil.StringToDate(date));
    }

    public static int getMonth(Date date) {
        return DateUtil.getInteger(date, 2) + 1;
    }

    public static int getDay(String date) {
        return DateUtil.getDay(DateUtil.StringToDate(date));
    }

    public static int getDay(Date date) {
        return DateUtil.getInteger(date, 5);
    }

    public static int getHour(String date) {
        return DateUtil.getHour(DateUtil.StringToDate(date));
    }

    public static int getHour(Date date) {
        return DateUtil.getInteger(date, 11);
    }

    public static int getMinute(String date) {
        return DateUtil.getMinute(DateUtil.StringToDate(date));
    }

    public static int getMinute(Date date) {
        return DateUtil.getInteger(date, 12);
    }

    public static int getSecond(String date) {
        return DateUtil.getSecond(DateUtil.StringToDate(date));
    }

    public static int getSecond(Date date) {
        return DateUtil.getInteger(date, 13);
    }

    public static String getDate(String date) {
        return DateUtil.StringToString(date, DateStyle.YYYY_MM_DD);
    }

    public static String getDate(Date date) {
        return DateUtil.DateToString(date, DateStyle.YYYY_MM_DD);
    }

    public static String getTime(String date) {
        return DateUtil.StringToString(date, DateStyle.HH_MM_SS);
    }

    public static String getTime(Date date) {
        return DateUtil.DateToString(date, DateStyle.HH_MM_SS);
    }

    public static String getNow() {
        return DateUtil.DateToString(new Date(), DateStyle.YYYY_MM_DD_HH_MM_SS_CN);
    }

    public static Week getWeek(String date) {
        Week week = null;
        DateStyle dateStyle = DateUtil.getDateStyle(date);
        if (dateStyle != null) {
            Date myDate = DateUtil.StringToDate(date, dateStyle);
            week = DateUtil.getWeek(myDate);
        }
        return week;
    }

    public static Week getWeek(Date date) {
        Week week = null;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int weekNumber = calendar.get(7) - 1;
        switch (weekNumber) {
            case 0: {
                week = Week.SUNDAY;
                break;
            }
            case 1: {
                week = Week.MONDAY;
                break;
            }
            case 2: {
                week = Week.TUESDAY;
                break;
            }
            case 3: {
                week = Week.WEDNESDAY;
                break;
            }
            case 4: {
                week = Week.THURSDAY;
                break;
            }
            case 5: {
                week = Week.FRIDAY;
                break;
            }
            case 6: {
                week = Week.SATURDAY;
            }
        }
        return week;
    }

    public static int getIntervalDays(String date, String otherDate) {
        return DateUtil.getIntervalDays(DateUtil.StringToDate(date), DateUtil.StringToDate(otherDate));
    }

    public static int getIntervalDays(Date date, Date otherDate) {
        int num = -1;
        Date dateTmp = DateUtil.StringToDate(DateUtil.getDate(date), DateStyle.YYYY_MM_DD);
        Date otherDateTmp = DateUtil.StringToDate(DateUtil.getDate(otherDate), DateStyle.YYYY_MM_DD);
        if (dateTmp != null && otherDateTmp != null) {
            long time = Math.abs(dateTmp.getTime() - otherDateTmp.getTime());
            num = (int)(time / 86400000L);
        }
        return num;
    }
}

