/*
 * Decompiled with CFR 0.152.
 */
package org.thiki.lark.foundation.response;

import com.alibaba.fastjson.JSONObject;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.thiki.lark.foundation.assmbler.LarkAssembler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Response {
    private ResourceSupport restResource;
    private HttpStatus httpStatus = HttpStatus.OK;

    public ResourceSupport getRestResource() {
        return this.restResource;
    }

    public void setRestResource(ResourceSupport restResource) {
        this.restResource = restResource;
    }

    public HttpStatus getHttpStatus() {
        return this.httpStatus;
    }

    public void setHttpStatus(HttpStatus httpStatus) {
        this.httpStatus = httpStatus;
    }

    public static HttpEntity<ResourceSupport> build(Object domain, LarkAssembler resourceAssembler) {
        Response response = new Response();
        ResourceSupport domainResource = resourceAssembler.toResource(domain, new Integer[0]);
        ResourceSupport resource = new ResourceSupport();
        Response.setResponse(domain, response, domainResource, resource);
        return new ResponseEntity((Object)response.getRestResource(), response.getHttpStatus());
    }

    public static HttpEntity<ResourceSupport> build(Object domain, LarkAssembler resourceAssembler, Object ... pathOrRequestVariables) {
        Response response = new Response();
        ResourceSupport domainResource = resourceAssembler.toResource(domain, pathOrRequestVariables);
        ResourceSupport resource = new ResourceSupport();
        Response.setResponse(domain, response, domainResource, resource);
        return new ResponseEntity((Object)response.getRestResource(), response.getHttpStatus());
    }

    private static void setResponse(Object domain, Response response, ResourceSupport domainResource, ResourceSupport resource) {
        if (domain == null) {
            response.setHttpStatus(HttpStatus.NOT_FOUND);
            resource.add((Iterable)domainResource.getLinks());
            response.setRestResource(resource);
        } else {
            response.setRestResource(domainResource);
        }
    }

    public static ResponseEntity ok() {
        return new ResponseEntity(HttpStatus.OK);
    }

    public static ResponseEntity ok(ResourceSupport resourceSupport) {
        return new ResponseEntity((Object)resourceSupport, HttpStatus.OK);
    }

    public static ResponseEntity created(ResourceSupport resourceSupport) {
        return new ResponseEntity((Object)resourceSupport, HttpStatus.CREATED);
    }

    public static JSONObject error(Exception exception) {
        JSONObject message = new JSONObject();
        message.put("message", (Object)exception.getMessage());
        return message;
    }
}

