/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.tests.core;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.TestCase;
import org.junit.Assert;
import org.mvel2.CompileException;
import org.mvel2.ExecutionContext;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.SandboxedParserContext;
import org.mvel2.ScriptMemoryOverflowException;
import org.mvel2.ScriptRuntimeException;
import org.mvel2.execution.ExecutionArrayList;
import org.mvel2.execution.ExecutionHashMap;
import org.mvel2.optimizers.OptimizerFactory;
import org.mvel2.util.MethodStub;

public class TbExpressionsTest
extends TestCase {
    private SandboxedParserContext parserContext;
    private ExecutionContext currentExecutionContext;

    protected void setUp() throws Exception {
        OptimizerFactory.setDefaultOptimizer((String)OptimizerFactory.SAFE_REFLECTIVE);
        super.setUp();
        this.parserContext = new SandboxedParserContext();
    }

    public void testCreateSingleValueArray() {
        Object res = this.executeScript("m = {5}; m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof List));
        TbExpressionsTest.assertEquals((int)1, (int)((List)res).size());
        TbExpressionsTest.assertEquals((Object)5, ((List)res).get(0));
    }

    public void testCreateMap() {
        Object res = this.executeScript("m = {a: 1}; m.a");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)1, (Object)res);
    }

    public void testCreateEmptyMapAndAssignField() {
        Object res = this.executeScript("m = {}; m.test = 1; m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Map));
        TbExpressionsTest.assertEquals((int)1, (int)((Map)res).size());
        TbExpressionsTest.assertEquals((Object)1, ((Map)res).get("test"));
    }

    public void testNonExistentMapField() {
        Object res = this.executeScript("m = {}; t = m.test; t");
        TbExpressionsTest.assertNull((Object)res);
    }

    public void testEqualsOperator() {
        Object res = this.executeScript("m = 'abc'; m === 'abc'");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Boolean));
        TbExpressionsTest.assertTrue((boolean)((Boolean)res));
        res = this.executeScript("m = 'abc'; m = 1; m == 1");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Boolean));
        TbExpressionsTest.assertTrue((boolean)((Boolean)res));
    }

    public void testFunctionOrder() {
        Object res = this.executeScript("function testFunc(m) {m.a +=1;} m = {a: 1}; testFunc(m);   m.a");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)2, (Object)res);
        res = this.executeScript("m = {a: 1}; testFunc(m); function testFunc(m) {m.a +=1;}  m.a");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)2, (Object)res);
    }

    public void testComments() {
        Object res = this.executeScript("//var df = sdfsdf; \n // test comment: comment2 \n m = {\n// c: d, \n /* e: \n\nf, */ a: 2 }; m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof HashMap));
        TbExpressionsTest.assertEquals((int)1, (int)((Map)res).size());
        TbExpressionsTest.assertEquals((Object)2, ((Map)res).get("a"));
    }

    public void testStopExecution() throws Exception {
        AtomicReference capturedException = new AtomicReference();
        CountDownLatch countDown = new CountDownLatch(1);
        Thread thread = new Thread(() -> {
            try {
                this.executeScript("t = 0; while(true) { t  = 1}; t");
            }
            catch (Exception e) {
                capturedException.set(e);
            }
            finally {
                countDown.countDown();
            }
        });
        thread.start();
        boolean result = countDown.await(500L, TimeUnit.MILLISECONDS);
        TbExpressionsTest.assertFalse((boolean)result);
        this.currentExecutionContext.stop();
        result = countDown.await(500L, TimeUnit.MILLISECONDS);
        TbExpressionsTest.assertTrue((boolean)result);
        Exception exception = (Exception)capturedException.get();
        TbExpressionsTest.assertNotNull((Object)exception);
        TbExpressionsTest.assertEquals((String)"Script execution is stopped!", (String)exception.getMessage());
    }

    public void testMemoryOverflowVariable() {
        long memoryLimit = 0x500000L;
        try {
            this.executeScript("t = 'abc'; while(true) { t  += t}; t", new HashMap(), new ExecutionContext(memoryLimit));
            TbExpressionsTest.fail((String)"Should throw ScriptMemoryOverflowException");
        }
        catch (ScriptMemoryOverflowException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Script memory overflow"));
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("" + memoryLimit));
        }
    }

    public void testMemoryOverflowInnerMap1() {
        long memoryLimit = 0x500000L;
        try {
            this.executeScript("m = {}; m.put('a', {}); i =0; while(true) { m.get('a').put(i++, 'aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa' + Math.random());}; m", new HashMap(), new ExecutionContext(memoryLimit));
            TbExpressionsTest.fail((String)"Should throw ScriptMemoryOverflowException");
        }
        catch (ScriptMemoryOverflowException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Script memory overflow"));
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("" + memoryLimit));
        }
    }

    public void testMemoryOverflowInnerMap2() {
        long memoryLimit = 0x500000L;
        try {
            this.executeScript("m = {}; m.a = {}; i =0; while(true) { m.a[i++] = 'aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa' + Math.random();}; m", new HashMap(), new ExecutionContext(memoryLimit));
            TbExpressionsTest.fail((String)"Should throw ScriptMemoryOverflowException");
        }
        catch (ScriptMemoryOverflowException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Script memory overflow"));
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("" + memoryLimit));
        }
    }

    public void testMemoryOverflowArray() {
        long memoryLimit = 0x500000L;
        try {
            this.executeScript("m = []; i =0; while(true) { m.add('aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa' + Math.random())}; m", new HashMap(), new ExecutionContext(memoryLimit));
            TbExpressionsTest.fail((String)"Should throw ScriptMemoryOverflowException");
        }
        catch (ScriptMemoryOverflowException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Script memory overflow"));
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("" + memoryLimit));
        }
    }

    public void testMemoryOverflowArrayInnerMap() {
        long memoryLimit = 0x500000L;
        try {
            this.executeScript("m = [1]; m[0] = {}; i =0; while(true) { m[0].put(i++, 'aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa' + Math.random())}; m", new HashMap(), new ExecutionContext(memoryLimit));
            TbExpressionsTest.fail((String)"Should throw ScriptMemoryOverflowException");
        }
        catch (ScriptMemoryOverflowException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Script memory overflow"));
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("" + memoryLimit));
        }
    }

    public void testMemoryOverflowAddAll() throws Exception {
        long memoryLimit = 0x500000L;
        try {
            this.executeScript("a = ['aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa']; b = []; while(true) { b.addAll(a)}; m", new HashMap(), new ExecutionContext(memoryLimit), 10000L);
            TbExpressionsTest.fail((String)"Should throw ScriptMemoryOverflowException");
        }
        catch (ScriptMemoryOverflowException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Script memory overflow"));
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("" + memoryLimit));
        }
    }

    public void testForbidCustomObjects() throws Exception {
        try {
            this.executeScript("m = new java.util.HashMap(); m");
            TbExpressionsTest.fail((String)"Should throw ScriptRuntimeException");
        }
        catch (ScriptRuntimeException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Unsupported value type: class java.util.HashMap"));
        }
    }

    public void testForbiddenClassAccess() {
        try {
            this.executeScript("m = {5}; System.exit(-1); m");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("unresolvable property or identifier: System"));
        }
        try {
            this.executeScript("m = {5}; exit(-1); m");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("function not found: exit"));
        }
        try {
            this.executeScript("m = {5}; java.lang.System.exit(-1); m");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("unresolvable property or identifier: java"));
        }
        try {
            this.executeScript("m = {5}; Runtime.getRuntime().exec(\"echo hi\"); m");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("unresolvable property or identifier: Runtime"));
        }
        try {
            this.executeScript("m = {5}; m.getClass().getClassLoader()");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("unable to resolve method: getClass()"));
        }
        try {
            this.executeScript("m = {5}; m.class");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("could not access property: class"));
        }
        Object res = this.executeScript("m = {class: 5}; m.class");
        TbExpressionsTest.assertNotNull((Object)res);
        TbExpressionsTest.assertEquals((Object)5, (Object)res);
    }

    public void testUseClassImport() {
        try {
            this.executeScript("MyTestUtil.getFoo({foo: 'foo-bar'})");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            junit.framework.Assert.assertTrue((boolean)e.getMessage().contains("unresolvable property or identifier: MyTestUtil"));
        }
        this.parserContext.addImport("MyTestUtil", TestUtil.class);
        Object res = this.executeScript("MyTestUtil.getFoo({foo: 'foo-bar'})");
        TbExpressionsTest.assertEquals((Object)"foo-bar", (Object)res);
        res = this.executeScript("MyTestUtil.getFoo({})");
        TbExpressionsTest.assertEquals((Object)"Not found!", (Object)res);
        res = this.executeScript("MyTestUtil.methodWithExecContext('key1', 'val1')");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Map));
        TbExpressionsTest.assertEquals((Object)"val1", ((Map)res).get("key1"));
        res = this.executeScript("MyTestUtil.methodWithExecContext2('key2', 'val2')");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Map));
        TbExpressionsTest.assertEquals((Object)"val2", ((Map)res).get("key2"));
        res = this.executeScript("MyTestUtil.methodWithExecContext3('key3', 'val3')");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Map));
        TbExpressionsTest.assertEquals((Object)"val3", ((Map)res).get("key3"));
        res = this.executeScript("MyTestUtil.methodWithExecContextVarArgs('a1', 'a2', 'a3', 'a4', 'a5')");
        TbExpressionsTest.assertTrue((boolean)(res instanceof List));
        TbExpressionsTest.assertEquals((int)5, (int)((List)res).size());
        Assert.assertArrayEquals((Object[])new String[]{"a1", "a2", "a3", "a4", "a5"}, (Object[])((List)res).toArray(new String[5]));
    }

    public void testUseStaticMethodImport() throws Exception {
        this.parserContext.addImport("getFoo", new MethodStub(TestUtil.class.getMethod("getFoo", Map.class)));
        Object res = this.executeScript("getFoo({foo: 'foo-bar'})");
        TbExpressionsTest.assertEquals((Object)"foo-bar", (Object)res);
        res = this.executeScript("getFoo({})");
        TbExpressionsTest.assertEquals((Object)"Not found!", (Object)res);
        try {
            this.executeScript("currentTimeMillis()");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            junit.framework.Assert.assertTrue((boolean)e.getMessage().contains("function not found: currentTimeMillis"));
        }
        this.parserContext.addImport("currentTimeMillis", new MethodStub(System.class.getMethod("currentTimeMillis", new Class[0])));
        res = this.executeScript("currentTimeMillis()");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Long));
        TbExpressionsTest.assertEquals((long)(System.currentTimeMillis() / 100L), (long)((Long)res / 100L));
        this.parserContext.addImport("methodWithExecContext", new MethodStub(TestUtil.class.getMethod("methodWithExecContext", String.class, Object.class, ExecutionContext.class)));
        res = this.executeScript("methodWithExecContext('key1', 'val1')");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Map));
        TbExpressionsTest.assertEquals((Object)"val1", ((Map)res).get("key1"));
        this.parserContext.addImport("methodWithExecContext2", new MethodStub(TestUtil.class.getMethod("methodWithExecContext2", String.class, ExecutionContext.class, Object.class)));
        res = this.executeScript("methodWithExecContext2('key2', 'val2')");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Map));
        TbExpressionsTest.assertEquals((Object)"val2", ((Map)res).get("key2"));
        this.parserContext.addImport("methodWithExecContext3", new MethodStub(TestUtil.class.getMethod("methodWithExecContext3", ExecutionContext.class, String.class, Object.class)));
        res = this.executeScript("methodWithExecContext3('key3', 'val3')");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Map));
        TbExpressionsTest.assertEquals((Object)"val3", ((Map)res).get("key3"));
        this.parserContext.addImport("methodWithExecContextVarArgs", new MethodStub(TestUtil.class.getMethod("methodWithExecContextVarArgs", ExecutionContext.class, Object[].class)));
        res = this.executeScript("methodWithExecContextVarArgs('a1', 'a2', 'a3', 'a4', 'a5')");
        TbExpressionsTest.assertTrue((boolean)(res instanceof List));
        TbExpressionsTest.assertEquals((int)5, (int)((List)res).size());
        Assert.assertArrayEquals((Object[])new String[]{"a1", "a2", "a3", "a4", "a5"}, (Object[])((List)res).toArray(new String[5]));
    }

    private Object executeScript(String ex, Map vars, ExecutionContext executionContext, long timeoutMs) throws Exception {
        CountDownLatch countDown = new CountDownLatch(1);
        AtomicReference result = new AtomicReference();
        AtomicReference exception = new AtomicReference();
        Thread thread = new Thread(() -> {
            try {
                result.set(this.executeScript(ex, vars, executionContext));
            }
            catch (Exception e) {
                exception.set(e);
            }
            finally {
                countDown.countDown();
            }
        });
        thread.start();
        try {
            countDown.await(timeoutMs, TimeUnit.MILLISECONDS);
            executionContext.stop();
            countDown.await(500L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (exception.get() != null) {
            throw (Exception)exception.get();
        }
        return result.get();
    }

    private Object executeScript(String ex) {
        return this.executeScript(ex, new HashMap());
    }

    private Object executeScript(String ex, Map vars) {
        return this.executeScript(ex, vars, new ExecutionContext());
    }

    private Object executeScript(String ex, Map vars, ExecutionContext executionContext) {
        Serializable compiled = MVEL.compileExpression((String)ex, (ParserContext)this.parserContext);
        this.currentExecutionContext = executionContext;
        return MVEL.executeExpression((Object)compiled, (Object)this.currentExecutionContext, (Map)vars);
    }

    public static final class TestUtil {
        public static String getFoo(Map input) {
            if (input.containsKey("foo")) {
                return input.get("foo") != null ? input.get("foo").toString() : "null";
            }
            return "Not found!";
        }

        public static Map methodWithExecContext(String key, Object val, ExecutionContext ctx) {
            ExecutionHashMap map = new ExecutionHashMap(1, ctx);
            map.put(key, val);
            return map;
        }

        public static Map methodWithExecContext2(String key, ExecutionContext ctx, Object val) {
            ExecutionHashMap map = new ExecutionHashMap(1, ctx);
            map.put(key, val);
            return map;
        }

        public static Map methodWithExecContext3(ExecutionContext ctx, String key, Object val) {
            ExecutionHashMap map = new ExecutionHashMap(1, ctx);
            map.put(key, val);
            return map;
        }

        public static List methodWithExecContextVarArgs(ExecutionContext ctx, Object ... vals) {
            ExecutionArrayList list = new ExecutionArrayList(Arrays.asList(vals), ctx);
            return list;
        }
    }
}

