/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.mvel2.ExecutionContext;
import org.mvel2.execution.ExecutionArrayList;
import org.mvel2.execution.ExecutionHashMap;

public class ArgsRepackUtil {
    public static Object repack(ExecutionContext ctx, Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            ExecutionArrayList<Object> list = new ExecutionArrayList<Object>(ctx);
            int size = Array.getLength(value);
            for (int i = 0; i < size; ++i) {
                list.add(ArgsRepackUtil.repack(ctx, Array.get(value, i)));
            }
            return list;
        }
        if (value instanceof Map) {
            Map src = (Map)value;
            ExecutionHashMap map = new ExecutionHashMap(src.size(), ctx);
            src.forEach((k, v) -> map.put(k, ArgsRepackUtil.repack(ctx, v)));
            return map;
        }
        if (value instanceof Collection) {
            ExecutionArrayList<Object> list = new ExecutionArrayList<Object>(ctx);
            for (Object o : (Collection)value) {
                list.add(ArgsRepackUtil.repack(ctx, o));
            }
            return list;
        }
        return value;
    }

    public static Object unpack(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            ArrayList<Object> list = new ArrayList<Object>();
            int size = Array.getLength(value);
            for (int i = 0; i < size; ++i) {
                list.add(ArgsRepackUtil.unpack(Array.get(value, i)));
            }
            return list;
        }
        if (value instanceof Map) {
            Map src = (Map)value;
            HashMap map = new HashMap(src.size());
            src.forEach((k, v) -> map.put(k, ArgsRepackUtil.unpack(v)));
            return map;
        }
        if (value instanceof Collection) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object o : (Collection)value) {
                list.add(ArgsRepackUtil.unpack(o));
            }
            return list;
        }
        return value;
    }
}

