/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2;

import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mvel2.compiler.AbstractParser;

public class SandboxedClassLoader
extends URLClassLoader {
    protected static final Set<String> forbiddenClassLiterals = Set.of("System", "Runtime", "Class", "ClassLoader", "Thread", "Compiler", "ThreadLocal", "SecurityManager");
    protected static final Set<Method> forbiddenMethods = Set.of(SandboxedClassLoader.getMethod(Object.class, "getClass"), SandboxedClassLoader.getMethod(Class.class, "getClassLoader"));
    private final Set<String> allowedClasses = new HashSet<String>();
    private final Set<String> allowedPackages = new HashSet<String>();
    private final Set<String> forbiddenPackages = new HashSet<String>();

    static Method getMethod(Class<?> cls, String method) {
        Method m = null;
        try {
            m = cls.getMethod(method, new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return m;
    }

    public SandboxedClassLoader() {
        super(new URL[0], Thread.currentThread().getContextClassLoader());
        this.forbiddenPackages.add("java.util.concurrent");
        this.allowedPackages.add("java.util");
        AbstractParser.CLASS_LITERALS.entrySet().stream().filter(entry -> !forbiddenClassLiterals.contains(entry.getKey())).map(Map.Entry::getValue).forEach(val -> this.allowedClasses.add(((Class)val).getName()));
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (!this.classNameAllowed(name)) {
            throw new ClassNotFoundException(name);
        }
        return super.loadClass(name, resolve);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (!this.classNameAllowed(name)) {
            throw new ClassNotFoundException(name);
        }
        return super.loadClass(name);
    }

    public void addAllowedClass(Class cls) {
        this.allowedClasses.add(cls.getName());
    }

    public void addAllowedPackage(String packageName) {
        this.allowedPackages.add(packageName);
    }

    private boolean classNameAllowed(String name) {
        if (this.allowedClasses.contains(name)) {
            return true;
        }
        for (String pkgName : this.forbiddenPackages) {
            if (!name.startsWith(pkgName)) continue;
            return false;
        }
        for (String pkgName : this.allowedPackages) {
            if (!name.startsWith(pkgName)) continue;
            return true;
        }
        return false;
    }
}

