/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.tests.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.mvel2.MVEL;
import org.mvel2.tests.core.AbstractTest;
import org.mvel2.tests.core.res.Base;

public class ProjectionsTests
extends AbstractTest {
    public void testProjectionSupport() {
        ProjectionsTests.assertEquals((Object)true, (Object)this.test("(name in things)contains'Bob'"));
    }

    public void testProjectionSupport1() {
        ProjectionsTests.assertEquals((Object)true, (Object)this.test("(name in things) contains 'Bob'"));
    }

    public void testProjectionSupport2() {
        String ex = "(name in things).size()";
        Map vars = ProjectionsTests.createTestMap();
        ProjectionsTests.assertEquals((Object)3, (Object)MVEL.eval((String)ex, (Object)new Base(), (Map)vars));
        ProjectionsTests.assertEquals((Object)3, (Object)this.test("(name in things).size()"));
    }

    public void testProjectionSupport3() {
        String ex = "(toUpperCase() in ['bar', 'foo'])[1]";
        Map vars = ProjectionsTests.createTestMap();
        ProjectionsTests.assertEquals((Object)"FOO", (Object)MVEL.eval((String)ex, (Object)new Base(), (Map)vars));
        ProjectionsTests.assertEquals((Object)"FOO", (Object)this.test("(toUpperCase() in ['bar', 'foo'])[1]"));
    }

    public void testProjectionSupport4() {
        Collection col = (Collection)this.test("(toUpperCase() in ['zero', 'zen', 'bar', 'foo'] if ($ == 'bar'))");
        ProjectionsTests.assertEquals((int)1, (int)col.size());
        ProjectionsTests.assertEquals((Object)"BAR", col.iterator().next());
    }

    public void testProjectionSupport5() {
        Collection col = (Collection)this.test("(toUpperCase() in ['zero', 'zen', 'bar', 'foo'] if ($.startsWith('z')))");
        ProjectionsTests.assertEquals((int)2, (int)col.size());
        Iterator iter = col.iterator();
        ProjectionsTests.assertEquals((Object)"ZERO", iter.next());
        ProjectionsTests.assertEquals((Object)"ZEN", iter.next());
    }

    public void testProjectionSupport6() {
        ProjectionsTests.assertEquals((Object)true, (Object)this.test("( name in things ) contains 'Bob'"));
    }

    public void testConcatProjection() {
        Map vars = this.createTestVars();
        ProjectionsTests.assertEquals(Arrays.asList("George", "Michael", "Laura"), (Object)MVEL.eval((String)"def concat(lists) {res = []; foreach (list : lists) {res += list} res;} familyMembers = (name in concat((familyMembers in users)));", (Map)vars));
    }

    private Map createTestVars() {
        ArrayList<User> users = new ArrayList<User>();
        User user1 = new User("John");
        user1.getFamilyMembers().add(new User("George"));
        User user2 = new User("Bob");
        User user3 = new User("Cindy");
        user3.getFamilyMembers().add(new User("Michael"));
        user3.getFamilyMembers().add(new User("Laura"));
        users.add(user1);
        users.add(user2);
        users.add(user3);
        HashMap<String, ArrayList<User>> vars = new HashMap<String, ArrayList<User>>();
        vars.put("users", users);
        return vars;
    }

    public static final class User {
        private String name;
        private Collection familyMembers = new ArrayList();

        public User(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Collection getFamilyMembers() {
            return this.familyMembers;
        }

        public void setFamilyMembers(Collection familyMembers) {
            this.familyMembers = familyMembers;
        }
    }
}

