/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.mvel2.CompileException;
import org.mvel2.DataConversion;
import org.mvel2.ExecutionContext;
import org.mvel2.MVEL;
import org.mvel2.OptimizationFailure;
import org.mvel2.ParserContext;
import org.mvel2.ast.ASTNode;
import org.mvel2.compiler.AbstractParser;
import org.mvel2.compiler.BlankLiteral;
import org.mvel2.compiler.CompiledExpression;
import org.mvel2.compiler.ExecutableAccessor;
import org.mvel2.compiler.ExecutableAccessorSafe;
import org.mvel2.compiler.ExecutableLiteral;
import org.mvel2.compiler.ExpressionCompiler;
import org.mvel2.integration.ResolverTools;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.ClassImportResolverFactory;
import org.mvel2.math.MathProcessor;
import org.mvel2.util.NullType;
import org.mvel2.util.StringAppender;

public class ParseTools {
    public static final Object[] EMPTY_OBJ_ARR = new Object[0];
    public static final Class[] EMPTY_CLS_ARR = new Class[0];
    private static final Map<Constructor, WeakReference<Class[]>> CONSTRUCTOR_PARMS_CACHE = Collections.synchronizedMap(new WeakHashMap(10));
    private static final Map<ClassLoader, Map<String, WeakReference<Class>>> CLASS_RESOLVER_CACHE = Collections.synchronizedMap(new WeakHashMap(1, 1.0f));
    private static final Map<Class, WeakReference<Constructor[]>> CLASS_CONSTRUCTOR_CACHE = Collections.synchronizedMap(new WeakHashMap(10));
    private static final HashMap<Class, Integer> typeResolveMap;
    private static final Map<Class, Integer> typeCodes;

    public static List<char[]> parseMethodOrConstructor(char[] parm) {
        int start = -1;
        for (int i = 0; i < parm.length; ++i) {
            if (parm[i] != '(') continue;
            start = ++i;
            break;
        }
        if (start != -1) {
            return ParseTools.parseParameterList(parm, --start + 1, ParseTools.balancedCapture(parm, start, '(') - start - 1);
        }
        return Collections.emptyList();
    }

    public static String[] parseParameterDefList(char[] parm, int offset, int length) {
        String s;
        int i;
        LinkedList<String> list = new LinkedList<String>();
        if (length == -1) {
            length = parm.length;
        }
        int start = offset;
        int end = i + length;
        block6: for (i = offset; i < end; ++i) {
            switch (parm[i]) {
                case '(': 
                case '[': 
                case '{': {
                    i = ParseTools.balancedCapture(parm, i, parm[i]);
                    continue block6;
                }
                case '\'': {
                    i = ParseTools.captureStringLiteral('\'', parm, i, parm.length);
                    continue block6;
                }
                case '\"': {
                    i = ParseTools.captureStringLiteral('\"', parm, i, parm.length);
                    continue block6;
                }
                case ',': {
                    if (i > start) {
                        while (ParseTools.isWhitespace(parm[start])) {
                            ++start;
                        }
                        s = new String(parm, start, i - start);
                        ParseTools.checkNameSafety(s);
                        list.add(s);
                    }
                    while (ParseTools.isWhitespace(parm[i])) {
                        ++i;
                    }
                    start = i + 1;
                    continue block6;
                }
                default: {
                    if (ParseTools.isWhitespace(parm[i]) || ParseTools.isIdentifierPart(parm[i])) continue block6;
                    throw new CompileException("expected parameter", parm, start);
                }
            }
        }
        if (start < length + offset && i > start) {
            s = ParseTools.createStringTrimmed(parm, start, i - start);
            if (s.length() > 0) {
                ParseTools.checkNameSafety(s);
                list.add(s);
            }
        } else if (list.size() == 0 && (s = ParseTools.createStringTrimmed(parm, start, length)).length() > 0) {
            ParseTools.checkNameSafety(s);
            list.add(s);
        }
        return list.toArray(new String[list.size()]);
    }

    public static List<char[]> parseParameterList(char[] parm, int offset, int length) {
        char[] s;
        int i;
        ArrayList<char[]> list = new ArrayList<char[]>();
        if (length == -1) {
            length = parm.length;
        }
        int start = offset;
        int end = i + length;
        block6: for (i = offset; i < end; ++i) {
            switch (parm[i]) {
                case '(': 
                case '[': 
                case '{': {
                    i = ParseTools.balancedCapture(parm, i, parm[i]);
                    continue block6;
                }
                case '\'': {
                    i = ParseTools.captureStringLiteral('\'', parm, i, parm.length);
                    continue block6;
                }
                case '\"': {
                    i = ParseTools.captureStringLiteral('\"', parm, i, parm.length);
                    continue block6;
                }
                case ',': {
                    if (i > start) {
                        while (ParseTools.isWhitespace(parm[start])) {
                            ++start;
                        }
                        list.add(ParseTools.subsetTrimmed(parm, start, i - start));
                    }
                    while (ParseTools.isWhitespace(parm[i])) {
                        ++i;
                    }
                    start = i + 1;
                }
            }
        }
        if (start < length + offset && i > start) {
            char[] s2 = ParseTools.subsetTrimmed(parm, start, i - start);
            if (s2.length > 0) {
                list.add(s2);
            }
        } else if (list.size() == 0 && (s = ParseTools.subsetTrimmed(parm, start, length)).length > 0) {
            list.add(s);
        }
        return list;
    }

    public static Method getBestCandidate(Object[] arguments, String method, Class decl, Method[] methods, boolean requireExact) {
        Class[] targetParms = new Class[arguments.length];
        for (int i = 0; i != arguments.length; ++i) {
            targetParms[i] = arguments[i] != null ? arguments[i].getClass() : null;
        }
        return ParseTools.getBestCandidate(targetParms, method, decl, methods, requireExact);
    }

    public static Method getBestCandidate(Class[] arguments, String method, Class decl, Method[] methods, boolean requireExact) {
        return ParseTools.getBestCandidate(arguments, method, decl, methods, requireExact, false);
    }

    public static Method getBestCandidate(Class[] arguments, String method, Class decl, Method[] methods, boolean requireExact, boolean classTarget) {
        if (methods.length == 0) {
            return null;
        }
        Method bestCandidate = null;
        int bestScore = -1;
        boolean retry = false;
        while (true) {
            int i;
            for (Method meth : methods) {
                int score;
                if (classTarget && !Modifier.isStatic(meth.getModifiers()) || !method.equals(meth.getName())) continue;
                Class<?>[] parmTypes = ParseTools.removeExecutionContextParam(meth.getParameterTypes());
                if (parmTypes.length == 0 && arguments.length == 0) {
                    if (bestCandidate != null && !ParseTools.isMoreSpecialized(meth, bestCandidate)) continue;
                    bestCandidate = meth;
                    continue;
                }
                boolean isVarArgs = meth.isVarArgs();
                if (ParseTools.isArgsNumberNotCompatible(arguments, parmTypes, isVarArgs) || (score = ParseTools.getMethodScore(arguments, requireExact, parmTypes, isVarArgs)) == 0) continue;
                if (score > bestScore) {
                    bestCandidate = meth;
                    bestScore = score;
                    continue;
                }
                if (score != bestScore || !ParseTools.isMoreSpecialized(meth, bestCandidate) && !ParseTools.isMorePreciseForBigDecimal(meth, bestCandidate, arguments) || isVarArgs) continue;
                bestCandidate = meth;
            }
            if (bestCandidate != null || retry || !decl.isInterface()) break;
            Method[] objMethods = Object.class.getMethods();
            Method[] nMethods = new Method[methods.length + objMethods.length];
            for (i = 0; i < methods.length; ++i) {
                nMethods[i] = methods[i];
            }
            for (i = 0; i < objMethods.length; ++i) {
                nMethods[i + methods.length] = objMethods[i];
            }
            methods = nMethods;
            retry = true;
        }
        return bestCandidate;
    }

    public static Class<?>[] removeExecutionContextParam(Class<?>[] paramsTypes) {
        List<Class<?>> paramTypesList;
        int executionContextIndex;
        if (paramsTypes != null && (executionContextIndex = (paramTypesList = Arrays.asList(paramsTypes)).indexOf(ExecutionContext.class)) > -1) {
            ArrayList newParamTypesList = new ArrayList(paramTypesList);
            newParamTypesList.remove(executionContextIndex);
            paramsTypes = newParamTypesList.toArray(new Class[paramsTypes.length - 1]);
        }
        return paramsTypes;
    }

    public static Object[] updateArgsWithExecutionContextIfNeeded(Class<?>[] paramsTypes, Object[] args, Object ctx) {
        int executionContextIndex = Arrays.asList(paramsTypes).indexOf(ExecutionContext.class);
        if (executionContextIndex > -1) {
            ArrayList<Object> newArgsList = new ArrayList<Object>(Arrays.asList(args));
            newArgsList.add(executionContextIndex, ctx instanceof ExecutionContext ? ctx : null);
            args = newArgsList.toArray();
        }
        return args;
    }

    private static boolean isArgsNumberNotCompatible(Class[] arguments, Class<?>[] parmTypes, boolean isVarArgs) {
        return isVarArgs && parmTypes.length - 1 > arguments.length || !isVarArgs && parmTypes.length != arguments.length;
    }

    private static boolean isMoreSpecialized(Method newCandidate, Method oldCandidate) {
        return oldCandidate.getReturnType().isAssignableFrom(newCandidate.getReturnType()) && oldCandidate.getDeclaringClass().isAssignableFrom(newCandidate.getDeclaringClass());
    }

    private static boolean isMorePreciseForBigDecimal(Executable newCandidate, Executable oldCandidate, Class[] arguments) {
        Class<?>[] newParmTypes = newCandidate.getParameterTypes();
        Class<?>[] oldParmTypes = oldCandidate.getParameterTypes();
        int score = 0;
        for (int i = 0; i != arguments.length; ++i) {
            Class<?> newParmType = newParmTypes[i];
            Class<?> oldParmType = oldParmTypes[i];
            if (arguments[i] != BigDecimal.class || !ParseTools.isNumeric(oldParmType) || !ParseTools.isNumeric(newParmType)) continue;
            score += ParseTools.comparePrecision(ParseTools.unboxPrimitive(newParmType), ParseTools.unboxPrimitive(oldParmType));
        }
        return score > 0;
    }

    private static int comparePrecision(Class<?> numeric1, Class<?> numeric2) {
        if (numeric1 == numeric2) {
            return 0;
        }
        if (numeric1 == BigDecimal.class) {
            return 1;
        }
        if (numeric1 == Double.TYPE && (numeric2 == Float.TYPE || numeric2 == Long.TYPE || numeric2 == Integer.TYPE || numeric2 == Short.TYPE || numeric2 == BigInteger.class)) {
            return 1;
        }
        if (numeric1 == Float.TYPE && (numeric2 == Long.TYPE || numeric2 == Integer.TYPE || numeric2 == Short.TYPE || numeric2 == BigInteger.class)) {
            return 1;
        }
        if (numeric1 == BigInteger.class && (numeric2 == Long.TYPE || numeric2 == Integer.TYPE || numeric2 == Short.TYPE)) {
            return 1;
        }
        if (numeric1 == Long.TYPE && (numeric2 == Integer.TYPE || numeric2 == Short.TYPE)) {
            return 1;
        }
        if (numeric1 == Integer.TYPE && numeric2 == Short.TYPE) {
            return 1;
        }
        return -1;
    }

    private static int getMethodScore(Class[] arguments, boolean requireExact, Class<?>[] parmTypes, boolean varArgs) {
        int score = 0;
        for (int i = 0; i != arguments.length; ++i) {
            Class<?> actualParamType = varArgs && i >= parmTypes.length - 1 ? parmTypes[parmTypes.length - 1].getComponentType() : parmTypes[i];
            if (arguments[i] == null) {
                if (!actualParamType.isPrimitive()) {
                    score += 7;
                    continue;
                }
                score = 0;
                break;
            }
            if (actualParamType == arguments[i]) {
                score += 8;
                continue;
            }
            if (actualParamType.isPrimitive() && ParseTools.boxPrimitive(actualParamType) == arguments[i]) {
                score += 7;
                continue;
            }
            if (arguments[i].isPrimitive() && ParseTools.unboxPrimitive(arguments[i]) == actualParamType) {
                score += 7;
                continue;
            }
            if (actualParamType.isAssignableFrom(arguments[i])) {
                score += 6;
                continue;
            }
            if (ParseTools.isPrimitiveSubtype(arguments[i], actualParamType)) {
                score += 5;
                continue;
            }
            if (ParseTools.isNumericallyCoercible(arguments[i], actualParamType)) {
                score += 4;
                continue;
            }
            if (ParseTools.boxPrimitive(actualParamType).isAssignableFrom(ParseTools.boxPrimitive(arguments[i])) && Object.class != arguments[i]) {
                score += 3 + ParseTools.scoreInterface(actualParamType, arguments[i]);
                continue;
            }
            if (!requireExact && DataConversion.canConvert(actualParamType, arguments[i])) {
                if (actualParamType.isArray() && arguments[i].isArray()) {
                    ++score;
                } else if (actualParamType == Character.TYPE && arguments[i] == String.class) {
                    ++score;
                }
                ++score;
                continue;
            }
            if (actualParamType == Object.class || arguments[i] == NullType.class) {
                ++score;
                continue;
            }
            score = 0;
            break;
        }
        if (score == 0 && varArgs && parmTypes.length - 1 == arguments.length) {
            score += 3;
        }
        return score;
    }

    public static int scoreInterface(Class<?> parm, Class<?> arg) {
        Class<?>[] iface;
        if (parm.isInterface() && (iface = arg.getInterfaces()) != null) {
            for (Class<?> c : iface) {
                if (c == parm) {
                    return 1;
                }
                if (!parm.isAssignableFrom(c)) continue;
                return ParseTools.scoreInterface(parm, arg.getSuperclass());
            }
        }
        return 0;
    }

    public static Method getExactMatch(String name, Class[] args, Class returnType, Class cls) {
        block0: for (Method meth : cls.getMethods()) {
            Class<?>[] parameterTypes;
            if (!name.equals(meth.getName()) || returnType != meth.getReturnType() || (parameterTypes = meth.getParameterTypes()).length != args.length) continue;
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (parameterTypes[i] != args[i]) continue block0;
            }
            return meth;
        }
        return null;
    }

    public static Method getWidenedTarget(Method method) {
        return ParseTools.getWidenedTarget(method.getDeclaringClass(), method);
    }

    public static Method getWidenedTarget(Class cls, Method method) {
        Class currentCls;
        if (Modifier.isStatic(method.getModifiers())) {
            return method;
        }
        Method m = method;
        Method best = method;
        Class[] args = method.getParameterTypes();
        String name = method.getName();
        Class<?> rt = m.getReturnType();
        for (currentCls = cls; currentCls != null; currentCls = currentCls.getSuperclass()) {
            for (Class<?> iface : currentCls.getInterfaces()) {
                m = ParseTools.getExactMatch(name, args, rt, iface);
                if (m == null) continue;
                best = m;
            }
        }
        if (best != method) {
            return best;
        }
        for (currentCls = cls; currentCls != null; currentCls = currentCls.getSuperclass()) {
            m = ParseTools.getExactMatch(name, args, rt, currentCls);
            if (m == null) continue;
            best = m;
        }
        return best;
    }

    private static Class[] getConstructors(Constructor cns) {
        Class[] parms;
        WeakReference<Class[]> ref = CONSTRUCTOR_PARMS_CACHE.get(cns);
        if (ref != null && (parms = (Class[])ref.get()) != null) {
            return parms;
        }
        parms = cns.getParameterTypes();
        CONSTRUCTOR_PARMS_CACHE.put(cns, new WeakReference<Class<?>[]>(parms));
        return parms;
    }

    public static Constructor getBestConstructorCandidate(Object[] args, Class cls, boolean requireExact) {
        Class[] arguments = new Class[args.length];
        for (int i = 0; i != args.length; ++i) {
            if (args[i] == null) continue;
            arguments[i] = args[i].getClass();
        }
        return ParseTools.getBestConstructorCandidate(arguments, cls, requireExact);
    }

    public static Constructor getBestConstructorCandidate(Class[] arguments, Class cls, boolean requireExact) {
        Constructor bestCandidate = null;
        int bestScore = 0;
        boolean bestCandidateIsVarArgs = false;
        for (Constructor construct : ParseTools.getConstructors(cls)) {
            boolean isVarArgs = construct.isVarArgs();
            Class[] parmTypes = ParseTools.getConstructors(construct);
            if (ParseTools.isArgsNumberNotCompatible(arguments, parmTypes, isVarArgs)) continue;
            if (arguments.length == 0 && parmTypes.length == 0) {
                return construct;
            }
            int score = ParseTools.getMethodScore(arguments, requireExact, parmTypes, isVarArgs);
            if (score == 0) continue;
            if (score > bestScore) {
                bestCandidate = construct;
                bestScore = score;
                bestCandidateIsVarArgs = isVarArgs;
                continue;
            }
            if (score != bestScore || !ParseTools.isMorePreciseForBigDecimal(construct, bestCandidate, arguments) && (!bestCandidateIsVarArgs || isVarArgs)) continue;
            bestCandidate = construct;
            bestCandidateIsVarArgs = isVarArgs;
        }
        return bestCandidate;
    }

    public static Class createClass(String className, ParserContext pCtx) throws ClassNotFoundException {
        Class<?> cls;
        WeakReference<Class> ref;
        ClassLoader classLoader = pCtx != null ? pCtx.getClassLoader() : Thread.currentThread().getContextClassLoader();
        Map<String, WeakReference<Class<Object>>> cache = CLASS_RESOLVER_CACHE.get(classLoader);
        if (cache == null) {
            cache = Collections.synchronizedMap(new WeakHashMap(10));
            CLASS_RESOLVER_CACHE.put(classLoader, cache);
        }
        if ((ref = cache.get(className)) != null && (cls = (Class<?>)ref.get()) != null) {
            return cls;
        }
        cls = Class.forName(className, true, classLoader);
        cache.put(className, new WeakReference(cls));
        return cls;
    }

    public static Constructor[] getConstructors(Class cls) {
        Constructor[] cns;
        WeakReference<Constructor[]> ref = CLASS_CONSTRUCTOR_CACHE.get(cls);
        if (ref != null && (cns = (Constructor[])ref.get()) != null) {
            return cns;
        }
        cns = cls.getConstructors();
        CLASS_CONSTRUCTOR_CACHE.put(cls, new WeakReference<Constructor<?>[]>(cns));
        return cns;
    }

    public static String[] captureContructorAndResidual(char[] cs, int start, int offset) {
        int depth = 0;
        int end = start + offset;
        boolean inQuotes = false;
        block5: for (int i = start; i < end; ++i) {
            switch (cs[i]) {
                case '\"': {
                    inQuotes = !inQuotes;
                    continue block5;
                }
                case '(': {
                    ++depth;
                    continue block5;
                }
                case ')': {
                    if (inQuotes || 1 != depth--) continue block5;
                    return new String[]{ParseTools.createStringTrimmed(cs, start, ++i - start), ParseTools.createStringTrimmed(cs, i, end - i)};
                }
            }
        }
        return new String[]{new String(cs, start, offset)};
    }

    public static Class<?> boxPrimitive(Class cls) {
        if (cls == Integer.TYPE || cls == Integer.class) {
            return Integer.class;
        }
        if (cls == int[].class || cls == Integer[].class) {
            return Integer[].class;
        }
        if (cls == Character.TYPE || cls == Character.class) {
            return Character.class;
        }
        if (cls == char[].class || cls == Character[].class) {
            return Character[].class;
        }
        if (cls == Long.TYPE || cls == Long.class) {
            return Long.class;
        }
        if (cls == long[].class || cls == Long[].class) {
            return Long[].class;
        }
        if (cls == Short.TYPE || cls == Short.class) {
            return Short.class;
        }
        if (cls == short[].class || cls == Short[].class) {
            return Short[].class;
        }
        if (cls == Double.TYPE || cls == Double.class) {
            return Double.class;
        }
        if (cls == double[].class || cls == Double[].class) {
            return Double[].class;
        }
        if (cls == Float.TYPE || cls == Float.class) {
            return Float.class;
        }
        if (cls == float[].class || cls == Float[].class) {
            return Float[].class;
        }
        if (cls == Boolean.TYPE || cls == Boolean.class) {
            return Boolean.class;
        }
        if (cls == boolean[].class || cls == Boolean[].class) {
            return Boolean[].class;
        }
        if (cls == Byte.TYPE || cls == Byte.class) {
            return Byte.class;
        }
        if (cls == byte[].class || cls == Byte[].class) {
            return Byte[].class;
        }
        return cls;
    }

    public static Class unboxPrimitive(Class cls) {
        if (cls == Integer.class || cls == Integer.TYPE) {
            return Integer.TYPE;
        }
        if (cls == Integer[].class || cls == int[].class) {
            return int[].class;
        }
        if (cls == Long.class || cls == Long.TYPE) {
            return Long.TYPE;
        }
        if (cls == Long[].class || cls == long[].class) {
            return long[].class;
        }
        if (cls == Character.class || cls == Character.TYPE) {
            return Character.TYPE;
        }
        if (cls == Character[].class || cls == char[].class) {
            return char[].class;
        }
        if (cls == Short.class || cls == Short.TYPE) {
            return Short.TYPE;
        }
        if (cls == Short[].class || cls == short[].class) {
            return short[].class;
        }
        if (cls == Double.class || cls == Double.TYPE) {
            return Double.TYPE;
        }
        if (cls == Double[].class || cls == double[].class) {
            return double[].class;
        }
        if (cls == Float.class || cls == Float.TYPE) {
            return Float.TYPE;
        }
        if (cls == Float[].class || cls == float[].class) {
            return float[].class;
        }
        if (cls == Boolean.class || cls == Boolean.TYPE) {
            return Boolean.TYPE;
        }
        if (cls == Boolean[].class || cls == boolean[].class) {
            return boolean[].class;
        }
        if (cls == Byte.class || cls == Byte.TYPE) {
            return Byte.TYPE;
        }
        if (cls == Byte[].class || cls == byte[].class) {
            return byte[].class;
        }
        return cls;
    }

    public static boolean containsCheck(Object compareTo, Object compareTest) {
        if (compareTo == null) {
            return false;
        }
        if (compareTo instanceof String) {
            return ((String)compareTo).contains(String.valueOf(compareTest));
        }
        if (compareTo instanceof Collection) {
            return ((Collection)compareTo).contains(compareTest);
        }
        if (compareTo instanceof Map) {
            return ((Map)compareTo).containsKey(compareTest);
        }
        if (compareTo.getClass().isArray()) {
            if (compareTo.getClass().getComponentType().isPrimitive()) {
                return ParseTools.containsCheckOnPrimitveArray(compareTo, compareTest);
            }
            for (Object o : (Object[])compareTo) {
                if (compareTest == null && o == null) {
                    return true;
                }
                if (!((Boolean)MathProcessor.doOperations(o, 18, compareTest)).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean containsCheckOnPrimitveArray(Object primitiveArray, Object compareTest) {
        Class<?> primitiveType = primitiveArray.getClass().getComponentType();
        if (primitiveType == Boolean.TYPE) {
            return compareTest instanceof Boolean && ParseTools.containsCheckOnBooleanArray((boolean[])primitiveArray, (Boolean)compareTest);
        }
        if (primitiveType == Integer.TYPE) {
            return compareTest instanceof Integer && ParseTools.containsCheckOnIntArray((int[])primitiveArray, (Integer)compareTest);
        }
        if (primitiveType == Long.TYPE) {
            return compareTest instanceof Long && ParseTools.containsCheckOnLongArray((long[])primitiveArray, (Long)compareTest);
        }
        if (primitiveType == Double.TYPE) {
            return compareTest instanceof Double && ParseTools.containsCheckOnDoubleArray((double[])primitiveArray, (Double)compareTest);
        }
        if (primitiveType == Float.TYPE) {
            return compareTest instanceof Float && ParseTools.containsCheckOnFloatArray((float[])primitiveArray, (Float)compareTest);
        }
        if (primitiveType == Character.TYPE) {
            return compareTest instanceof Character && ParseTools.containsCheckOnCharArray((char[])primitiveArray, (Character)compareTest);
        }
        if (primitiveType == Short.TYPE) {
            return compareTest instanceof Short && ParseTools.containsCheckOnShortArray((short[])primitiveArray, (Short)compareTest);
        }
        if (primitiveType == Byte.TYPE) {
            return compareTest instanceof Byte && ParseTools.containsCheckOnByteArray((byte[])primitiveArray, (Byte)compareTest);
        }
        return false;
    }

    private static boolean containsCheckOnBooleanArray(boolean[] array, Boolean compareTest) {
        boolean test = compareTest;
        for (boolean b : array) {
            if (b != test) continue;
            return true;
        }
        return false;
    }

    private static boolean containsCheckOnIntArray(int[] array, Integer compareTest) {
        int test = compareTest;
        for (int i : array) {
            if (i != test) continue;
            return true;
        }
        return false;
    }

    private static boolean containsCheckOnLongArray(long[] array, Long compareTest) {
        long test = compareTest;
        for (long l : array) {
            if (l != test) continue;
            return true;
        }
        return false;
    }

    private static boolean containsCheckOnDoubleArray(double[] array, Double compareTest) {
        double test = compareTest;
        for (double d : array) {
            if (d != test) continue;
            return true;
        }
        return false;
    }

    private static boolean containsCheckOnFloatArray(float[] array, Float compareTest) {
        float test = compareTest.floatValue();
        for (float f : array) {
            if (f != test) continue;
            return true;
        }
        return false;
    }

    private static boolean containsCheckOnCharArray(char[] array, Character compareTest) {
        char test = compareTest.charValue();
        for (char c : array) {
            if (c != test) continue;
            return true;
        }
        return false;
    }

    private static boolean containsCheckOnShortArray(short[] array, Short compareTest) {
        short test = compareTest;
        for (short s : array) {
            if (s != test) continue;
            return true;
        }
        return false;
    }

    private static boolean containsCheckOnByteArray(byte[] array, Byte compareTest) {
        byte test = compareTest;
        for (byte b : array) {
            if (b != test) continue;
            return true;
        }
        return false;
    }

    public static int handleEscapeSequence(char[] escapeStr, int pos) {
        escapeStr[pos - 1] = '\u0000';
        switch (escapeStr[pos]) {
            case '\\': {
                escapeStr[pos] = 92;
                return 1;
            }
            case 'b': {
                escapeStr[pos] = 8;
                return 1;
            }
            case 'f': {
                escapeStr[pos] = 12;
                return 1;
            }
            case 't': {
                escapeStr[pos] = 9;
                return 1;
            }
            case 'r': {
                escapeStr[pos] = 13;
                return 1;
            }
            case 'n': {
                escapeStr[pos] = 10;
                return 1;
            }
            case '\'': {
                escapeStr[pos] = 39;
                return 1;
            }
            case '\"': {
                escapeStr[pos] = 34;
                return 1;
            }
            case 'u': {
                int s = pos;
                if (s + 4 > escapeStr.length) {
                    throw new CompileException("illegal unicode escape sequence", escapeStr, pos);
                }
                while (++pos - s != 5) {
                    if (escapeStr[pos] > '/' && escapeStr[pos] < ':' || escapeStr[pos] > '@' && escapeStr[pos] < 'G') continue;
                    throw new CompileException("illegal unicode escape sequence", escapeStr, pos);
                }
                escapeStr[s - 1] = (char)Integer.decode("0x" + new String(escapeStr, s + 1, 4)).intValue();
                escapeStr[s] = '\u0000';
                escapeStr[s + 1] = '\u0000';
                escapeStr[s + 2] = '\u0000';
                escapeStr[s + 3] = '\u0000';
                escapeStr[s + 4] = '\u0000';
                return 5;
            }
        }
        int s = pos;
        while (escapeStr[pos] >= '0' && escapeStr[pos] < '8') {
            if (pos != s && escapeStr[s] > '3') {
                escapeStr[s - 1] = (char)Integer.decode("0" + new String(escapeStr, s, pos - s + 1)).intValue();
                escapeStr[s] = '\u0000';
                escapeStr[s + 1] = '\u0000';
                return 2;
            }
            if (pos - s == 2) {
                escapeStr[s - 1] = (char)Integer.decode("0" + new String(escapeStr, s, pos - s + 1)).intValue();
                escapeStr[s] = '\u0000';
                escapeStr[s + 1] = '\u0000';
                escapeStr[s + 2] = '\u0000';
                return 3;
            }
            if (pos + 1 == escapeStr.length || escapeStr[pos] < '0' || escapeStr[pos] > '7') {
                escapeStr[s - 1] = (char)Integer.decode("0" + new String(escapeStr, s, pos - s + 1)).intValue();
                escapeStr[s] = '\u0000';
                return 1;
            }
            ++pos;
        }
        throw new CompileException("illegal escape sequence: " + escapeStr[pos], escapeStr, pos);
    }

    public static char[] createShortFormOperativeAssignment(String name, char[] statement, int start, int offset, int operation) {
        if (operation == -1) {
            return statement;
        }
        int op = 0;
        switch (operation) {
            case 0: {
                op = 43;
                break;
            }
            case 20: {
                op = 35;
                break;
            }
            case 1: {
                op = 45;
                break;
            }
            case 2: {
                op = 42;
                break;
            }
            case 4: {
                op = 37;
                break;
            }
            case 3: {
                op = 47;
                break;
            }
            case 6: {
                op = 38;
                break;
            }
            case 7: {
                op = 124;
                break;
            }
            case 10: {
                op = 171;
                break;
            }
            case 9: {
                op = 187;
                break;
            }
            case 11: {
                op = 172;
            }
        }
        char[] stmt = new char[name.length() + offset + 1];
        System.arraycopy(name.toCharArray(), 0, stmt, 0, name.length());
        stmt[name.length()] = op;
        System.arraycopy(statement, start, stmt, name.length() + 1, offset);
        return stmt;
    }

    public static ClassImportResolverFactory findClassImportResolverFactory(VariableResolverFactory factory, ParserContext pCtx) {
        if (factory == null) {
            throw new OptimizationFailure("unable to import classes.  no variable resolver factory available.");
        }
        for (VariableResolverFactory v = factory; v != null; v = v.getNextFactory()) {
            if (!(v instanceof ClassImportResolverFactory)) continue;
            return (ClassImportResolverFactory)v;
        }
        return ResolverTools.appendFactory(factory, new ClassImportResolverFactory(null, null, false));
    }

    public static Class findClass(VariableResolverFactory factory, String name, ParserContext pCtx) throws ClassNotFoundException {
        try {
            if (pCtx != null && pCtx.hasLiteral(name) || pCtx == null && AbstractParser.LITERALS.containsKey(name)) {
                return (Class)(pCtx != null ? pCtx.getLiteral(name) : AbstractParser.LITERALS.get(name));
            }
            if (factory != null && factory.isResolveable(name)) {
                return (Class)factory.getVariableResolver(name).getValue();
            }
            if (pCtx != null && pCtx.hasImport(name)) {
                return pCtx.getImport(name);
            }
            return ParseTools.createClass(name, pCtx);
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("class not found: " + name, e);
        }
    }

    public static char[] subsetTrimmed(char[] array, int start, int length) {
        int end;
        if (length <= 0) {
            return new char[0];
        }
        for (end = start + length; end > 0 && ParseTools.isWhitespace(array[end - 1]); --end) {
        }
        while (ParseTools.isWhitespace(array[start]) && start < end) {
            ++start;
        }
        length = end - start;
        if (length == 0) {
            return new char[0];
        }
        return ParseTools.subset(array, start, length);
    }

    public static char[] subset(char[] array, int start, int length) {
        char[] newArray = new char[length];
        for (int i = 0; i < newArray.length; ++i) {
            newArray[i] = array[i + start];
        }
        return newArray;
    }

    public static char[] subset(char[] array, int start) {
        char[] newArray = new char[array.length - start];
        for (int i = 0; i < newArray.length; ++i) {
            newArray[i] = array[i + start];
        }
        return newArray;
    }

    public static int resolveType(Object o) {
        if (o == null) {
            return 0;
        }
        return ParseTools.__resolveType(o.getClass());
    }

    public static int __resolveType(Class cls) {
        Integer code = typeCodes.get(cls);
        if (code == null) {
            if (cls != null && Collection.class.isAssignableFrom(cls)) {
                return 50;
            }
            return 0;
        }
        return code;
    }

    private static boolean isPrimitiveSubtype(Class argument, Class<?> actualParamType) {
        if (!actualParamType.isPrimitive()) {
            return false;
        }
        Class primitiveArgument = ParseTools.unboxPrimitive(argument);
        if (!primitiveArgument.isPrimitive()) {
            return false;
        }
        return actualParamType == Double.TYPE && primitiveArgument == Float.TYPE || actualParamType == Float.TYPE && primitiveArgument == Long.TYPE || actualParamType == Long.TYPE && primitiveArgument == Integer.TYPE || actualParamType == Integer.TYPE && primitiveArgument == Character.TYPE || actualParamType == Integer.TYPE && primitiveArgument == Short.TYPE || actualParamType == Short.TYPE && primitiveArgument == Byte.TYPE;
    }

    public static boolean isNumericallyCoercible(Class target, Class parm) {
        Class<?> boxedTarget;
        Class<?> clazz = boxedTarget = target.isPrimitive() ? ParseTools.boxPrimitive(target) : target;
        if (boxedTarget != null && Number.class.isAssignableFrom(target) && (boxedTarget = parm.isPrimitive() ? ParseTools.boxPrimitive(parm) : parm) != null) {
            return Number.class.isAssignableFrom(boxedTarget);
        }
        return false;
    }

    public static Object narrowType(BigDecimal result, int returnTarget) {
        if (returnTarget == 109 || result.scale() > 0) {
            return result.doubleValue();
        }
        if (returnTarget == 107 || result.longValue() > Integer.MAX_VALUE) {
            return result.longValue();
        }
        return result.intValue();
    }

    public static Method determineActualTargetMethod(Method method) {
        return ParseTools.determineActualTargetMethod(method.getDeclaringClass(), method);
    }

    private static Method determineActualTargetMethod(Class clazz, Method method) {
        String name = method.getName();
        for (Class<?> cls : clazz.getInterfaces()) {
            for (Method meth : cls.getMethods()) {
                if (meth.getParameterTypes().length != 0 || !name.equals(meth.getName())) continue;
                return meth;
            }
        }
        return clazz.getSuperclass() != null ? ParseTools.determineActualTargetMethod(clazz.getSuperclass(), method) : null;
    }

    public static int captureToNextTokenJunction(char[] expr, int cursor, int end, ParserContext pCtx) {
        block4: while (cursor != expr.length) {
            switch (expr[cursor]) {
                case '(': 
                case '{': {
                    return cursor;
                }
                case '[': {
                    cursor = ParseTools.balancedCaptureWithLineAccounting(expr, cursor, end, '[', pCtx) + 1;
                    continue block4;
                }
            }
            if (ParseTools.isWhitespace(expr[cursor])) {
                return cursor;
            }
            ++cursor;
        }
        return cursor;
    }

    public static int nextNonBlank(char[] expr, int cursor) {
        int i;
        if (cursor + 1 >= expr.length) {
            throw new CompileException("unexpected end of statement", expr, cursor);
        }
        for (i = cursor; i != expr.length && ParseTools.isWhitespace(expr[i]); ++i) {
        }
        return i;
    }

    public static int skipWhitespace(char[] expr, int cursor) {
        block8: while (cursor != expr.length) {
            switch (expr[cursor]) {
                case '\n': 
                case '\r': {
                    ++cursor;
                    continue block8;
                }
                case '/': {
                    if (cursor + 1 != expr.length) {
                        switch (expr[cursor + 1]) {
                            case '/': {
                                expr[cursor++] = 32;
                                while (cursor != expr.length && expr[cursor] != '\n') {
                                    expr[cursor++] = 32;
                                }
                                if (cursor == expr.length) continue block8;
                                expr[cursor++] = 32;
                                continue block8;
                            }
                            case '*': {
                                int len = expr.length - 1;
                                expr[cursor++] = 32;
                                while (cursor != len && (expr[cursor] != '*' || expr[cursor + 1] != '/')) {
                                    expr[cursor++] = 32;
                                }
                                if (cursor == len) continue block8;
                                int n = cursor++;
                                expr[cursor++] = 32;
                                expr[n] = 32;
                                continue block8;
                            }
                        }
                        break block8;
                    }
                }
                default: {
                    if (!ParseTools.isWhitespace(expr[cursor])) break block8;
                    ++cursor;
                    continue block8;
                }
            }
        }
        return cursor;
    }

    public static boolean isStatementNotManuallyTerminated(char[] expr, int cursor) {
        int c;
        if (cursor >= expr.length) {
            return false;
        }
        for (c = cursor; c != expr.length && ParseTools.isWhitespace(expr[c]); ++c) {
        }
        return c == expr.length || expr[c] != ';';
    }

    public static int captureToEOS(char[] expr, int cursor, int end, ParserContext pCtx) {
        while (cursor != expr.length) {
            switch (expr[cursor]) {
                case '(': 
                case '[': 
                case '{': {
                    cursor = ParseTools.balancedCaptureWithLineAccounting(expr, cursor, end, expr[cursor], pCtx);
                    if (cursor < expr.length) break;
                    return cursor;
                }
                case '\"': 
                case '\'': {
                    cursor = ParseTools.captureStringLiteral(expr[cursor], expr, cursor, expr.length);
                    break;
                }
                case ',': 
                case ';': 
                case '}': {
                    return cursor;
                }
            }
            ++cursor;
        }
        return cursor;
    }

    public static int trimLeft(char[] expr, int start, int pos) {
        if (pos > expr.length) {
            pos = expr.length;
        }
        while (pos != 0 && pos >= start && ParseTools.isWhitespace(expr[pos - 1])) {
            --pos;
        }
        return pos;
    }

    public static int trimRight(char[] expr, int pos) {
        while (pos != expr.length && ParseTools.isWhitespace(expr[pos])) {
            ++pos;
        }
        return pos;
    }

    public static char[] subArray(char[] expr, int start, int end) {
        if (start >= end) {
            return new char[0];
        }
        char[] newA = new char[end - start];
        for (int i = 0; i != newA.length; ++i) {
            newA[i] = expr[i + start];
        }
        return newA;
    }

    public static int balancedCapture(char[] chars, int start, char type) {
        return ParseTools.balancedCapture(chars, start, chars.length, type);
    }

    public static int balancedCapture(char[] chars, int start, int end, char type) {
        int depth = 1;
        char term = type;
        switch (type) {
            case '[': {
                term = ']';
                break;
            }
            case '{': {
                term = '}';
                break;
            }
            case '(': {
                term = ')';
            }
        }
        if (type == term) {
            ++start;
            while (start < end) {
                if (chars[start] == type) {
                    return start;
                }
                ++start;
            }
        } else {
            ++start;
            while (start < end) {
                block32: {
                    if (start < end && chars[start] == '/') {
                        if (start + 1 == end) {
                            return start;
                        }
                        if (chars[start + 1] == '/') {
                            ++start;
                            while (start < end && chars[start] != '\n') {
                                ++start;
                            }
                        } else if (chars[start + 1] == '*') {
                            start += 2;
                            block16: while (start < end) {
                                switch (chars[start]) {
                                    case '*': {
                                        if (start + 1 < end && chars[start + 1] == '/') break block32;
                                    }
                                    default: {
                                        ++start;
                                        continue block16;
                                    }
                                }
                            }
                        }
                    }
                }
                if (start == end) {
                    return start;
                }
                if (chars[start] == '\'' || chars[start] == '\"') {
                    start = ParseTools.captureStringLiteral(chars[start], chars, start, end);
                } else if (chars[start] == type) {
                    ++depth;
                } else if (chars[start] == term && --depth == 0) {
                    return start;
                }
                ++start;
            }
        }
        switch (type) {
            case '[': {
                throw new CompileException("unbalanced braces [ ... ]", chars, start);
            }
            case '{': {
                throw new CompileException("unbalanced braces { ... }", chars, start);
            }
            case '(': {
                throw new CompileException("unbalanced braces ( ... )", chars, start);
            }
        }
        throw new CompileException("unterminated string literal", chars, start);
    }

    public static int balancedCaptureWithLineAccounting(char[] chars, int start, int end, char type, ParserContext pCtx) {
        int st;
        block40: {
            char term;
            int depth;
            block39: {
                depth = 1;
                st = start;
                term = type;
                switch (type) {
                    case '[': {
                        term = ']';
                        break;
                    }
                    case '{': {
                        term = '}';
                        break;
                    }
                    case '(': {
                        term = ')';
                    }
                }
                if (type != term) break block39;
                ++start;
                while (start != end) {
                    if (chars[start] == type) {
                        return start;
                    }
                    ++start;
                }
                break block40;
            }
            int lines = 0;
            ++start;
            while (start < end) {
                block42: {
                    block38: {
                        block41: {
                            if (!ParseTools.isWhitespace(chars[start])) break block41;
                            switch (chars[start]) {
                                case '\r': {
                                    break block42;
                                }
                                case '\n': {
                                    if (pCtx != null) {
                                        pCtx.setLineOffset((short)start);
                                    }
                                    ++lines;
                                }
                            }
                            break block38;
                        }
                        if (start < end && chars[start] == '/') {
                            if (start + 1 == end) {
                                return start;
                            }
                            if (chars[start + 1] == '/') {
                                ++start;
                                while (start < end && chars[start] != '\n') {
                                    ++start;
                                }
                            } else if (chars[start + 1] == '*') {
                                start += 2;
                                block21: while (start != end) {
                                    switch (chars[start]) {
                                        case '*': {
                                            if (start + 1 < end && chars[start + 1] == '/') break block38;
                                        }
                                        case '\n': 
                                        case '\r': {
                                            if (pCtx != null) {
                                                pCtx.setLineOffset((short)start);
                                            }
                                            ++lines;
                                        }
                                        default: {
                                            ++start;
                                            continue block21;
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if (start == end) {
                        return start;
                    }
                    if (chars[start] == '\'' || chars[start] == '\"') {
                        start = ParseTools.captureStringLiteral(chars[start], chars, start, end);
                    } else if (chars[start] == type) {
                        ++depth;
                    } else if (chars[start] == term && --depth == 0) {
                        if (pCtx != null) {
                            pCtx.incrementLineCount(lines);
                        }
                        return start;
                    }
                }
                ++start;
            }
        }
        switch (type) {
            case '[': {
                throw new CompileException("unbalanced braces [ ... ]", chars, st);
            }
            case '{': {
                throw new CompileException("unbalanced braces { ... }", chars, st);
            }
            case '(': {
                throw new CompileException("unbalanced braces ( ... )", chars, st);
            }
        }
        throw new CompileException("unterminated string literal", chars, st);
    }

    public static String handleStringEscapes(char[] input) {
        int escapes = 0;
        for (int i = 0; i < input.length; ++i) {
            if (input[i] != '\\') continue;
            escapes += ParseTools.handleEscapeSequence(input, ++i);
        }
        if (escapes == 0) {
            return new String(input);
        }
        char[] processedEscapeString = new char[input.length - escapes];
        int cursor = 0;
        for (char aName : input) {
            if (aName == '\u0000') continue;
            processedEscapeString[cursor++] = aName;
        }
        return new String(processedEscapeString);
    }

    public static int captureStringLiteral(char type, char[] expr, int cursor, int end) {
        while (++cursor < end && expr[cursor] != type) {
            if (expr[cursor] != '\\') continue;
            ++cursor;
        }
        if (cursor >= end || expr[cursor] != type) {
            throw new CompileException("unterminated string literal", expr, cursor);
        }
        return cursor;
    }

    public static void parseWithExpressions(String nestParm, char[] block, int start, int offset, Object ctx, VariableResolverFactory factory) {
        int _st = start;
        int _end = -1;
        int end = start + offset;
        int oper = -1;
        String parm = "";
        block13: for (int i = start; i < end; ++i) {
            switch (block[i]) {
                case '\"': 
                case '\'': 
                case '(': 
                case '[': 
                case '{': {
                    i = ParseTools.balancedCapture(block, i, end, block[i]);
                    continue block13;
                }
                case '/': {
                    if (i < end && block[i + 1] == '/') {
                        while (i < end && block[i] != '\n') {
                            block[i++] = 32;
                        }
                        if (parm != null) continue block13;
                        _st = i;
                        continue block13;
                    }
                    if (i < end && block[i + 1] == '*') {
                        int len = end - 1;
                        while (i < len && (block[i] != '*' || block[i + 1] != '/')) {
                            block[i++] = 32;
                        }
                        block[i++] = 32;
                        block[i++] = 32;
                        if (parm != null) continue block13;
                        _st = i;
                        continue block13;
                    }
                    if (i >= end || block[i + 1] != '=') continue block13;
                    oper = 3;
                    continue block13;
                }
                case '%': 
                case '*': 
                case '+': 
                case '-': {
                    if (i + 1 >= end || block[i + 1] != '=') continue block13;
                    oper = ParseTools.opLookup(block[i]);
                    continue block13;
                }
                case '=': {
                    parm = new String(block, _st, i - _st - (oper != -1 ? 1 : 0)).trim();
                    _st = i + 1;
                    continue block13;
                }
                case ',': {
                    if (_end == -1) {
                        _end = i;
                    }
                    if (parm == null) {
                        try {
                            if (nestParm == null) {
                                MVEL.eval(new String(block, _st, _end - _st), ctx, factory);
                            } else {
                                MVEL.eval(new StringBuilder(nestParm).append('.').append(block, _st, _end - _st).toString(), ctx, factory);
                            }
                        }
                        catch (CompileException e) {
                            e.setCursor(_st + (e.getCursor() - (e.getExpr().length - offset)));
                            e.setExpr(block);
                            throw e;
                        }
                        oper = -1;
                        _st = ++i;
                    } else {
                        try {
                            if (oper != -1) {
                                if (nestParm == null) {
                                    throw new CompileException("operative assignment not possible here", block, start);
                                }
                                String rewrittenExpr = new String(ParseTools.createShortFormOperativeAssignment(nestParm + "." + parm, block, _st, _end - _st, oper));
                                MVEL.setProperty(ctx, parm, MVEL.eval(rewrittenExpr, ctx, factory));
                            } else {
                                MVEL.setProperty(ctx, parm, MVEL.eval(block, _st, _end - _st, ctx, factory));
                            }
                        }
                        catch (CompileException e) {
                            e.setCursor(_st + (e.getCursor() - (e.getExpr().length - offset)));
                            e.setExpr(block);
                            throw e;
                        }
                        parm = null;
                        oper = -1;
                        _st = ++i;
                    }
                    _end = -1;
                }
            }
        }
        _end = end;
        if (_st != _end) {
            try {
                if (parm == null || "".equals(parm)) {
                    if (nestParm == null) {
                        MVEL.eval(new String(block, _st, _end - _st), ctx, factory);
                    } else {
                        MVEL.eval(new StringAppender(nestParm).append('.').append(block, _st, _end - _st).toString(), ctx, factory);
                    }
                } else if (oper != -1) {
                    if (nestParm == null) {
                        throw new CompileException("operative assignment not possible here", block, start);
                    }
                    MVEL.setProperty(ctx, parm, MVEL.eval(new String(ParseTools.createShortFormOperativeAssignment(nestParm + "." + parm, block, _st, _end - _st, oper)), ctx, factory));
                } else {
                    MVEL.setProperty(ctx, parm, MVEL.eval(block, _st, end - _st, ctx, factory));
                }
            }
            catch (CompileException e) {
                e.setCursor(_st + (e.getCursor() - (e.getExpr().length - offset)));
                e.setExpr(block);
                throw e;
            }
        }
    }

    public static Object handleNumericConversion(char[] val, int start, int offset) {
        if (offset != 1 && val[start] == '0' && val[start + 1] != '.') {
            if (!ParseTools.isDigit(val[start + offset - 1])) {
                switch (val[start + offset - 1]) {
                    case 'L': 
                    case 'l': {
                        return Long.decode(new String(val, start, offset - 1));
                    }
                    case 'I': {
                        return new BigInteger(new String(val, start, offset - 1));
                    }
                    case 'B': {
                        if (val[start + 1] == 'x') break;
                        return new BigDecimal(new String(val, start, offset - 1));
                    }
                }
            }
            return Integer.decode(new String(val, start, offset));
        }
        if (!ParseTools.isDigit(val[start + offset - 1])) {
            switch (val[start + offset - 1]) {
                case 'L': 
                case 'l': {
                    return Long.parseLong(new String(val, start, offset - 1));
                }
                case '.': 
                case 'D': 
                case 'd': {
                    return Double.parseDouble(new String(val, start, offset - 1));
                }
                case 'F': 
                case 'f': {
                    return Float.valueOf(Float.parseFloat(new String(val, start, offset - 1)));
                }
                case 'I': {
                    return new BigInteger(new String(val, start, offset - 1));
                }
                case 'B': {
                    return new BigDecimal(new String(val, start, offset - 1));
                }
            }
            throw new CompileException("unrecognized numeric literal", val, start);
        }
        switch (ParseTools.numericTest(val, start, offset)) {
            case 104: {
                return Float.valueOf(Float.parseFloat(new String(val, start, offset)));
            }
            case 101: {
                return Integer.parseInt(new String(val, start, offset));
            }
            case 102: {
                return Long.parseLong(new String(val, start, offset));
            }
            case 103: {
                return Double.parseDouble(new String(val, start, offset));
            }
            case 110: {
                return new BigDecimal(val, MathContext.DECIMAL128);
            }
        }
        return new String(val, start, offset);
    }

    public static boolean isNumeric(Object val) {
        if (val == null) {
            return false;
        }
        Class<?> clz = val instanceof Class ? (Class<?>)val : val.getClass();
        return clz == Integer.TYPE || clz == Long.TYPE || clz == Short.TYPE || clz == Double.TYPE || clz == Float.TYPE || Number.class.isAssignableFrom(clz);
    }

    public static int numericTest(char[] val, int start, int offset) {
        boolean fp = false;
        int i = start;
        if (offset > 1) {
            if (val[start] == '-') {
                ++i;
            } else if (val[start] == '~') {
                ++i;
                if (val[start + 1] == '-') {
                    ++i;
                }
            }
        }
        int end = start + offset;
        while (i < end) {
            char c = val[i];
            if (!ParseTools.isDigit(c)) {
                switch (c) {
                    case '.': {
                        fp = true;
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        fp = true;
                        if (i++ >= end || val[i] != '-') break;
                        ++i;
                        break;
                    }
                    default: {
                        return -1;
                    }
                }
            }
            ++i;
        }
        if (offset != 0) {
            if (fp) {
                return 103;
            }
            if (offset > 9) {
                return 102;
            }
            return 101;
        }
        return -1;
    }

    public static boolean isNumber(Object val) {
        if (val == null) {
            return false;
        }
        if (val instanceof String) {
            return ParseTools.isNumber((String)val);
        }
        if (val instanceof char[]) {
            return ParseTools.isNumber(new String((char[])val));
        }
        return val instanceof Integer || val instanceof BigDecimal || val instanceof BigInteger || val instanceof Float || val instanceof Double || val instanceof Long || val instanceof Short || val instanceof Character;
    }

    public static boolean isNumber(String val) {
        int len = val.length();
        boolean f = true;
        int i = 0;
        if (len > 1) {
            if (val.charAt(0) == '-') {
                ++i;
            } else if (val.charAt(0) == '~') {
                ++i;
                if (val.charAt(1) == '-') {
                    ++i;
                }
            }
        }
        while (i < len) {
            char c = val.charAt(i);
            if (!ParseTools.isDigit(c)) {
                if (c == '.' && f) {
                    f = false;
                } else {
                    return false;
                }
            }
            ++i;
        }
        return len > 0;
    }

    public static boolean isNumber(char[] val, int start, int offset) {
        boolean f = true;
        int i = start;
        int end = start + offset;
        if (offset > 1) {
            switch (val[start]) {
                case '-': {
                    if (val[start + 1] == '-') {
                        ++i;
                    }
                }
                case '~': {
                    ++i;
                }
            }
        }
        while (i < end) {
            char c = val[i];
            if (!ParseTools.isDigit(c)) {
                if (f && c == '.') {
                    f = false;
                } else {
                    if (offset != 1 && i == start + offset - 1) {
                        switch (c) {
                            case 'B': 
                            case 'D': 
                            case 'F': 
                            case 'I': 
                            case 'L': 
                            case 'd': 
                            case 'f': 
                            case 'l': {
                                return true;
                            }
                            case '.': {
                                throw new CompileException("invalid number literal: " + new String(val), val, start);
                            }
                        }
                        return false;
                    }
                    if (i == start + 1 && c == 'x' && val[start] == '0') {
                        ++i;
                        while (i < end) {
                            c = val[i];
                            if (!(ParseTools.isDigit(c) || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f')) {
                                if (i == offset - 1) {
                                    switch (c) {
                                        case 'B': 
                                        case 'I': 
                                        case 'L': 
                                        case 'l': {
                                            return true;
                                        }
                                    }
                                }
                                return false;
                            }
                            ++i;
                        }
                        return offset - 2 > 0;
                    }
                    if (i != start && i + 1 < end && (c == 'E' || c == 'e')) {
                        if (val[++i] == '-' || val[i] == '+') {
                            ++i;
                        }
                    } else {
                        if (i != start) {
                            throw new CompileException("invalid number literal: " + new String(val, start, offset), val, start);
                        }
                        return false;
                    }
                }
            }
            ++i;
        }
        return end > start;
    }

    public static int find(char[] c, int start, int offset, char find) {
        int length = start + offset;
        for (int i = start; i < length; ++i) {
            if (c[i] != find) continue;
            return i;
        }
        return -1;
    }

    public static int findLast(char[] c, int start, int offset, char find) {
        for (int i = start + offset; i >= start; --i) {
            if (c[i] != find) continue;
            return i;
        }
        return -1;
    }

    public static String createStringTrimmed(char[] s) {
        int start;
        int end = s.length;
        for (start = 0; start != end && s[start] < '!'; ++start) {
        }
        while (end != start && s[end - 1] < '!') {
            --end;
        }
        return new String(s, start, end - start);
    }

    public static String createStringTrimmed(char[] s, int start, int length) {
        if ((length = start + length) > s.length) {
            return new String(s);
        }
        while (start != length && s[start] < '!') {
            ++start;
        }
        while (length != start && s[length - 1] < '!') {
            --length;
        }
        return new String(s, start, length - start);
    }

    public static boolean endsWith(char[] c, int start, int offset, char[] test) {
        if (test.length > c.length) {
            return false;
        }
        int tD = test.length - 1;
        int cD = start + offset - 1;
        while (tD >= 0) {
            if (c[cD--] == test[tD--]) continue;
            return false;
        }
        return true;
    }

    public static boolean isIdentifierPart(int c) {
        return c > 96 && c < 123 || c > 64 && c < 91 || c > 47 && c < 58 || c == 95 || c == 36 || Character.isJavaIdentifierPart(c);
    }

    public static boolean isDigit(int c) {
        return c > 47 && c < 58;
    }

    public static float similarity(String s1, String s2) {
        char[] against;
        char[] comp;
        float baselength;
        if (s1 == null || s2 == null) {
            return s1 == null && s2 == null ? 1.0f : 0.0f;
        }
        char[] c1 = s1.toCharArray();
        char[] c2 = s2.toCharArray();
        float same = 0.0f;
        int cur1 = 0;
        if (c1.length > c2.length) {
            baselength = c1.length;
            comp = c1;
            against = c2;
        } else {
            baselength = c2.length;
            comp = c2;
            against = c1;
        }
        while (cur1 < comp.length && cur1 < against.length) {
            if (comp[cur1] == against[cur1]) {
                same += 1.0f;
            }
            ++cur1;
        }
        return same / baselength;
    }

    public static int findAbsoluteLast(char[] array) {
        int depth = 0;
        for (int i = array.length - 1; i >= 0; --i) {
            if (array[i] == ']') {
                ++depth;
            }
            if (array[i] == '[') {
                --depth;
            }
            if ((depth != 0 || array[i] != '.') && array[i] != '[') continue;
            return i;
        }
        return -1;
    }

    public static Class getBaseComponentType(Class cls) {
        while (cls.isArray()) {
            cls = cls.getComponentType();
        }
        return cls;
    }

    public static Class getSubComponentType(Class cls) {
        if (cls.isArray()) {
            cls = cls.getComponentType();
        }
        return cls;
    }

    public static boolean isJunct(char c) {
        switch (c) {
            case '(': 
            case '[': {
                return true;
            }
        }
        return ParseTools.isWhitespace(c);
    }

    public static int opLookup(char c) {
        switch (c) {
            case '|': {
                return 7;
            }
            case '&': {
                return 6;
            }
            case '^': {
                return 8;
            }
            case '*': {
                return 2;
            }
            case '/': {
                return 3;
            }
            case '+': {
                return 0;
            }
            case '%': {
                return 4;
            }
            case '\u00ab': {
                return 10;
            }
            case '\u00bb': {
                return 9;
            }
            case '\u00ac': {
                return 11;
            }
        }
        return -1;
    }

    public static boolean isReservedWord(String name) {
        return AbstractParser.LITERALS.containsKey(name) || AbstractParser.OPERATORS.containsKey(name);
    }

    public static boolean isNotValidNameorLabel(String name) {
        for (char c : name.toCharArray()) {
            if (c == '.') {
                return true;
            }
            if (ParseTools.isIdentifierPart(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPropertyOnly(char[] array, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (ParseTools.isIdentifierPart(array[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isArrayType(char[] array, int start, int end) {
        return end > start + 2 && ParseTools.isPropertyOnly(array, start, end - 2) && array[end - 2] == '[' && array[end - 1] == ']';
    }

    public static void checkNameSafety(String name) {
        if (ParseTools.isReservedWord(name)) {
            throw new RuntimeException("illegal use of reserved word: " + name);
        }
        if (ParseTools.isDigit(name.charAt(0))) {
            throw new RuntimeException("not an identifier: " + name);
        }
    }

    public static FileWriter getDebugFileWriter() throws IOException {
        return new FileWriter(new File(MVEL.getDebuggingOutputFileName()), true);
    }

    public static boolean isPrimitiveWrapper(Class clazz) {
        return clazz == Integer.class || clazz == Boolean.class || clazz == Long.class || clazz == Double.class || clazz == Float.class || clazz == Character.class || clazz == Short.class || clazz == Byte.class;
    }

    public static Serializable subCompileExpression(char[] expression) {
        return ParseTools._optimizeTree(new ExpressionCompiler(expression)._compile());
    }

    public static Serializable subCompileExpression(char[] expression, ParserContext ctx) {
        ExpressionCompiler c = new ExpressionCompiler(expression, ctx);
        return ParseTools._optimizeTree(c._compile());
    }

    public static Serializable subCompileExpression(char[] expression, int start, int offset, ParserContext ctx) {
        ExpressionCompiler c = new ExpressionCompiler(expression, start, offset, ctx);
        return ParseTools._optimizeTree(c._compile());
    }

    public static Serializable subCompileExpression(String expression, ParserContext ctx) {
        ExpressionCompiler c = new ExpressionCompiler(expression, ctx);
        return ParseTools._optimizeTree(c._compile());
    }

    public static Serializable optimizeTree(CompiledExpression compiled) {
        if (!compiled.isImportInjectionRequired() && compiled.getParserConfiguration().isAllowBootstrapBypass() && compiled.isSingleNode()) {
            return ParseTools._optimizeTree(compiled);
        }
        return compiled;
    }

    private static Serializable _optimizeTree(CompiledExpression compiled) {
        if (compiled.isSingleNode()) {
            ASTNode tk = compiled.getFirstNode();
            if (tk.isLiteral() && !tk.isThisVal()) {
                return new ExecutableLiteral(tk.getLiteralValue());
            }
            return tk.canSerializeAccessor() ? new ExecutableAccessorSafe(tk, compiled.getKnownEgressType()) : new ExecutableAccessor(tk, compiled.getKnownEgressType());
        }
        return compiled;
    }

    public static boolean isWhitespace(char c) {
        return c < '!';
    }

    public static String repeatChar(char c, int times) {
        char[] n = new char[times];
        for (int i = 0; i < times; ++i) {
            n[i] = c;
        }
        return new String(n);
    }

    public static char[] loadFromFile(File file) throws IOException {
        return ParseTools.loadFromFile(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] loadFromFile(File file, String encoding) throws IOException {
        if (!file.exists()) {
            throw new RuntimeException("cannot find file: " + file.getName());
        }
        FileInputStream inStream = null;
        FileChannel fc = null;
        try {
            inStream = new FileInputStream(file);
            fc = inStream.getChannel();
            ByteBuffer buf = ByteBuffer.allocateDirect(10);
            StringAppender sb = new StringAppender((int)file.length(), encoding);
            int read = 0;
            while (read >= 0) {
                buf.rewind();
                buf.rewind();
                for (read = fc.read(buf); read > 0; --read) {
                    sb.append(buf.get());
                }
            }
            char[] cArray = sb.toChars();
            return cArray;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
            if (fc != null) {
                fc.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] readIn(InputStream inStream, String encoding) throws IOException {
        try {
            int bytesRead;
            byte[] buf = new byte[10];
            StringAppender sb = new StringAppender(10, encoding);
            while ((bytesRead = inStream.read(buf)) > 0) {
                for (int i = 0; i < bytesRead; ++i) {
                    sb.append(buf[i]);
                }
            }
            char[] cArray = sb.toChars();
            return cArray;
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
        }
    }

    public static Class forNameWithInner(String className, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            return ParseTools.findInnerClass(className, classLoader, cnfe);
        }
    }

    public static Class findInnerClass(String className, ClassLoader classLoader, ClassNotFoundException cnfe) throws ClassNotFoundException {
        int lastDotPos = ((String)className).lastIndexOf(46);
        while (lastDotPos > 0) {
            className = ((String)className).substring(0, lastDotPos) + "$" + ((String)className).substring(lastDotPos + 1);
            try {
                return classLoader.loadClass((String)className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                lastDotPos = ((String)className).lastIndexOf(46);
            }
        }
        throw cnfe;
    }

    static {
        HashMap<Class, Integer> t = typeResolveMap = new HashMap();
        t.put(BigDecimal.class, 110);
        t.put(BigInteger.class, 111);
        t.put(String.class, 1);
        t.put(Integer.TYPE, 101);
        t.put(Integer.class, 106);
        t.put(Short.TYPE, 100);
        t.put(Short.class, 105);
        t.put(Float.TYPE, 104);
        t.put(Float.class, 108);
        t.put(Double.TYPE, 103);
        t.put(Double.class, 109);
        t.put(Long.TYPE, 102);
        t.put(Long.class, 107);
        t.put(Boolean.TYPE, 7);
        t.put(Boolean.class, 15);
        t.put(Byte.TYPE, 9);
        t.put(Byte.class, 99);
        t.put(Character.TYPE, 8);
        t.put(Character.class, 112);
        t.put(BlankLiteral.class, 200);
        typeCodes = new HashMap<Class, Integer>(30, 0.5f);
        typeCodes.put(Integer.class, 106);
        typeCodes.put(Double.class, 109);
        typeCodes.put(Boolean.class, 15);
        typeCodes.put(String.class, 1);
        typeCodes.put(Long.class, 107);
        typeCodes.put(Short.class, 105);
        typeCodes.put(Float.class, 108);
        typeCodes.put(Byte.class, 99);
        typeCodes.put(Character.class, 112);
        typeCodes.put(BigDecimal.class, 110);
        typeCodes.put(BigInteger.class, 111);
        typeCodes.put(Integer.TYPE, 101);
        typeCodes.put(Double.TYPE, 103);
        typeCodes.put(Boolean.TYPE, 7);
        typeCodes.put(Long.TYPE, 102);
        typeCodes.put(Short.TYPE, 100);
        typeCodes.put(Float.TYPE, 104);
        typeCodes.put(Byte.TYPE, 9);
        typeCodes.put(Character.TYPE, 8);
        typeCodes.put(BlankLiteral.class, 200);
    }
}

