/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.tests.core;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.TestCase;
import org.junit.Assert;
import org.mvel2.CompileException;
import org.mvel2.ExecutionContext;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.SandboxedParserConfiguration;
import org.mvel2.SandboxedParserContext;
import org.mvel2.ScriptMemoryOverflowException;
import org.mvel2.ScriptRuntimeException;
import org.mvel2.execution.ExecutionArrayList;
import org.mvel2.execution.ExecutionHashMap;
import org.mvel2.optimizers.OptimizerFactory;
import org.mvel2.util.MethodStub;

public class TbExpressionsTest
extends TestCase {
    private SandboxedParserConfiguration parserConfig;
    private ExecutionContext currentExecutionContext;

    protected void setUp() throws Exception {
        OptimizerFactory.setDefaultOptimizer((String)OptimizerFactory.SAFE_REFLECTIVE);
        super.setUp();
        this.parserConfig = new SandboxedParserConfiguration();
    }

    public void testCreateSingleValueArray() {
        Object res = this.executeScript("m = {5}; m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof List));
        TbExpressionsTest.assertEquals((int)1, (int)((List)res).size());
        TbExpressionsTest.assertEquals((Object)5, ((List)res).get(0));
    }

    public void testCreateMap() {
        Object res = this.executeScript("m = {a: 1}; m.a");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)1, (Object)res);
    }

    public void testCreateEmptyMapAndAssignField() {
        Object res = this.executeScript("m = {}; m.test = 1; m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Map));
        TbExpressionsTest.assertEquals((int)1, (int)((Map)res).size());
        TbExpressionsTest.assertEquals((Object)1, ((Map)res).get("test"));
    }

    public void testNonExistentMapField() {
        Object res = this.executeScript("m = {}; t = m.test; t");
        TbExpressionsTest.assertNull((Object)res);
    }

    public void testEqualsOperator() {
        Object res = this.executeScript("m = 'abc'; m === 'abc'");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Boolean));
        TbExpressionsTest.assertTrue((boolean)((Boolean)res));
        res = this.executeScript("m = 'abc'; m = 1; m == 1");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Boolean));
        TbExpressionsTest.assertTrue((boolean)((Boolean)res));
    }

    public void testFunctionOrder() {
        Object res = this.executeScript("function testFunc(m) {m.a +=1;} m = {a: 1}; testFunc(m);   m.a");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)2, (Object)res);
        res = this.executeScript("m = {a: 1}; testFunc(m); function testFunc(m) {m.a +=1;}  m.a");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)2, (Object)res);
    }

    public void testVariableScope() {
        Object res = this.executeScript("var m = 25; function testFunc(a) {   function testFunc3(e) {       var m = e + 5\n        return m   };   var t = 2\n   m = a * t;   return testFunc3(testFunc2(m + t));}function testFunc2(b) {   var c = 3;m = b * c; return m;}function testFunc4(m) {   return m * 2;}var m2 = m + testFunc(m) \nreturn testFunc4(m2);");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)372, (Object)res);
    }

    public void testComments() {
        Object res = this.executeScript("//var df = sdfsdf; \n // test comment: comment2 \n m = {\n// c: d, \n /* e: \n\nf, */ a: 2 }; m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof HashMap));
        TbExpressionsTest.assertEquals((int)1, (int)((Map)res).size());
        TbExpressionsTest.assertEquals((Object)2, ((Map)res).get("a"));
    }

    public void testStopExecution() throws Exception {
        AtomicReference capturedException = new AtomicReference();
        CountDownLatch countDown = new CountDownLatch(1);
        Thread thread = new Thread(() -> {
            try {
                this.executeScript("t = 0; while(true) { t  = 1}; t");
            }
            catch (Exception e) {
                capturedException.set(e);
            }
            finally {
                countDown.countDown();
            }
        });
        thread.start();
        boolean result = countDown.await(500L, TimeUnit.MILLISECONDS);
        TbExpressionsTest.assertFalse((boolean)result);
        this.currentExecutionContext.stop();
        result = countDown.await(500L, TimeUnit.MILLISECONDS);
        TbExpressionsTest.assertTrue((boolean)result);
        Exception exception = (Exception)capturedException.get();
        TbExpressionsTest.assertNotNull((Object)exception);
        TbExpressionsTest.assertEquals((String)"Script execution is stopped!", (String)exception.getMessage());
    }

    public void testMemoryOverflowVariable() {
        long memoryLimit = 0x500000L;
        try {
            this.executeScript("t = 'abc'; while(true) { t  += t}; t", new HashMap(), new ExecutionContext(this.parserConfig, memoryLimit));
            TbExpressionsTest.fail((String)"Should throw ScriptMemoryOverflowException");
        }
        catch (ScriptMemoryOverflowException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Script memory overflow"));
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("" + memoryLimit));
        }
    }

    public void testMemoryOverflowVariable2() {
        long memoryLimit = 0x500000L;
        try {
            this.executeScript("t = 'abc'; for (int i=0;i<100; i++) { t  += t}; t", new HashMap(), new ExecutionContext(this.parserConfig, memoryLimit));
            TbExpressionsTest.fail((String)"Should throw ScriptMemoryOverflowException");
        }
        catch (ScriptMemoryOverflowException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Script memory overflow"));
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("" + memoryLimit));
        }
    }

    public void testMemoryOverflowInnerVariable() {
        long memoryLimit = 0x500000L;
        try {
            this.executeScript("doMemoryOverflow(); function doMemoryOverflow() { var t = 'abc'; while(true) { t  += t}; } ", new HashMap(), new ExecutionContext(this.parserConfig, memoryLimit));
            TbExpressionsTest.fail((String)"Should throw ScriptMemoryOverflowException");
        }
        catch (ScriptMemoryOverflowException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Script memory overflow"));
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("" + memoryLimit));
        }
    }

    public void testMemoryOverflowInnerVariable2() {
        long memoryLimit = 0x500000L;
        try {
            this.executeScript("doMemoryOverflow(); function doMemoryOverflow() { var t = 'abc'; for (int i=0;i<100; i++) { t  += t}; } ", new HashMap(), new ExecutionContext(this.parserConfig, memoryLimit));
            TbExpressionsTest.fail((String)"Should throw ScriptMemoryOverflowException");
        }
        catch (ScriptMemoryOverflowException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Script memory overflow"));
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("" + memoryLimit));
        }
    }

    public void testMemoryOverflowInnerMap1() {
        long memoryLimit = 0x500000L;
        try {
            this.executeScript("m = {}; m.put('a', {}); i =0; while(true) { m.get('a').put(i++, 'aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa' + Math.random());}; m", new HashMap(), new ExecutionContext(this.parserConfig, memoryLimit));
            TbExpressionsTest.fail((String)"Should throw ScriptMemoryOverflowException");
        }
        catch (ScriptMemoryOverflowException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Script memory overflow"));
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("" + memoryLimit));
        }
    }

    public void testMemoryOverflowInnerMap2() {
        long memoryLimit = 0x500000L;
        try {
            this.executeScript("m = {}; m.a = {}; i =0; while(true) { m.a[i++] = 'aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa' + Math.random();}; m", new HashMap(), new ExecutionContext(this.parserConfig, memoryLimit));
            TbExpressionsTest.fail((String)"Should throw ScriptMemoryOverflowException");
        }
        catch (ScriptMemoryOverflowException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Script memory overflow"));
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("" + memoryLimit));
        }
    }

    public void testMemoryOverflowArray() {
        long memoryLimit = 0x500000L;
        try {
            this.executeScript("m = []; i =0; while(true) { m.add('aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa' + Math.random())}; m", new HashMap(), new ExecutionContext(this.parserConfig, memoryLimit));
            TbExpressionsTest.fail((String)"Should throw ScriptMemoryOverflowException");
        }
        catch (ScriptMemoryOverflowException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Script memory overflow"));
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("" + memoryLimit));
        }
    }

    public void testMemoryOverflowArrayInnerMap() {
        long memoryLimit = 0x500000L;
        try {
            this.executeScript("m = [1]; m[0] = {}; i =0; while(true) { m[0].put(i++, 'aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa' + Math.random())}; m", new HashMap(), new ExecutionContext(this.parserConfig, memoryLimit));
            TbExpressionsTest.fail((String)"Should throw ScriptMemoryOverflowException");
        }
        catch (ScriptMemoryOverflowException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Script memory overflow"));
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("" + memoryLimit));
        }
    }

    public void testMemoryOverflowAddAll() throws Exception {
        long memoryLimit = 0x500000L;
        try {
            this.executeScript("a = ['aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa']; b = []; while(true) { b.addAll(a)}; m", new HashMap(), new ExecutionContext(this.parserConfig, memoryLimit), 10000L);
            TbExpressionsTest.fail((String)"Should throw ScriptMemoryOverflowException");
        }
        catch (ScriptMemoryOverflowException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Script memory overflow"));
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("" + memoryLimit));
        }
    }

    public void testArrayMemoryOverflow() {
        long memoryLimit = 0x500000L;
        try {
            this.executeScript("m = new byte[5 * 1024 * 1024]; m", new HashMap(), new ExecutionContext(this.parserConfig, memoryLimit));
            TbExpressionsTest.fail((String)"Should throw ScriptMemoryOverflowException");
        }
        catch (ScriptMemoryOverflowException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Max array length overflow"));
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("" + memoryLimit / 2L));
        }
    }

    public void testForbidCustomObjects() throws Exception {
        try {
            this.executeScript("m = new java.util.HashMap(); m");
            TbExpressionsTest.fail((String)"Should throw ScriptRuntimeException");
        }
        catch (ScriptRuntimeException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Invalid statement: new java.util.HashMap()"));
        }
    }

    public void testForbiddenClassAccess() {
        try {
            this.executeScript("m = {5}; System.exit(-1); m");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("unresolvable property or identifier: System"));
        }
        try {
            this.executeScript("m = {5}; for (int i=0;i<10; i++) {System.exit(-1);} m");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("unresolvable property or identifier: System"));
        }
        try {
            this.executeScript("m = {5}; while(true) {\n System.exit(-1); \n } m");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("unresolvable property or identifier: System"));
        }
        try {
            this.executeScript("m = {5}; function badFunction() {System.exit(-1);}; badFunction(); m ");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("unresolvable property or identifier: System"));
        }
        try {
            this.executeScript("m = {5}; exit(-1); m");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("function not found: exit"));
        }
        try {
            this.executeScript("m = {5}; java.lang.System.exit(-1); m");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("unresolvable property or identifier: java"));
        }
        try {
            this.executeScript("m = {5}; Runtime.getRuntime().exec(\"echo hi\"); m");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("unresolvable property or identifier: Runtime"));
        }
        try {
            this.executeScript("m = {5}; m.getClass().getClassLoader()");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("unable to resolve method: getClass()"));
        }
        try {
            this.executeScript("m = {5}; m.class");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("could not access property: class"));
        }
        try {
            this.executeScript("m = new java.io.File(\"password.txt\").exists(); m");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("could not resolve class: java.io.File"));
        }
        try {
            this.executeScript("m = MVEL.eval(\"System.exit(-1);\"); m");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("unresolvable property or identifier: MVEL"));
        }
        try {
            this.executeScript("m = org.mvel2.MVEL.eval(\"System.exit(-1);\"); m");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("unresolvable property or identifier: org"));
        }
        try {
            this.executeScript("java.util.concurrent.Executors.newFixedThreadPool(2)");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("unresolvable property or identifier: java"));
        }
        Object res = this.executeScript("m = {class: 5}; m.class");
        TbExpressionsTest.assertNotNull((Object)res);
        TbExpressionsTest.assertEquals((Object)5, (Object)res);
    }

    public void testForbidImport() {
        try {
            this.executeScript("import java.util.HashMap; m = new HashMap(); m.put('t', 10); m");
            TbExpressionsTest.fail((String)"Should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Import is forbidden!"));
        }
    }

    public void testPrimitiveArray() {
        Object res = this.executeScript("var m = new byte[1000]; m[5] = 1; m[500] = 20; m[40] = 0x0B; m");
        TbExpressionsTest.assertNotNull((Object)res);
        TbExpressionsTest.assertTrue((boolean)(res instanceof List));
        TbExpressionsTest.assertEquals((int)1000, (int)((List)res).size());
        TbExpressionsTest.assertEquals((Object)1, ((List)res).get(5));
        TbExpressionsTest.assertEquals((Object)20, ((List)res).get(500));
        TbExpressionsTest.assertEquals((Object)11, ((List)res).get(40));
        res = this.executeScript("var m = 'Hello world'; a = m.toCharArray(); a");
        TbExpressionsTest.assertNotNull((Object)res);
        TbExpressionsTest.assertTrue((boolean)(res instanceof List));
        Object[] boxedArray = ((List)res).toArray();
        int len = boxedArray.length;
        char[] array = new char[len];
        for (int i = 0; i < len; ++i) {
            array[i] = ((Character)boxedArray[i]).charValue();
        }
        TbExpressionsTest.assertEquals((String)"Hello world", (String)String.valueOf(array));
        res = this.executeScript("var m = new int[]{1, 2, 3}; m");
        TbExpressionsTest.assertNotNull((Object)res);
        TbExpressionsTest.assertTrue((boolean)(res instanceof List));
        TbExpressionsTest.assertEquals((int)3, (int)((List)res).size());
        TbExpressionsTest.assertEquals((Object)1, ((List)res).get(0));
        TbExpressionsTest.assertEquals((Object)2, ((List)res).get(1));
        TbExpressionsTest.assertEquals((Object)3, ((List)res).get(2));
    }

    public void testByteOperations() {
        Object res = this.executeScript("var m = new byte[]{(byte)0x0F,(byte)0x02}; b = m[0] == 0x0F; b");
        TbExpressionsTest.assertNotNull((Object)res);
        TbExpressionsTest.assertTrue((boolean)(res instanceof Boolean));
        TbExpressionsTest.assertTrue((boolean)((Boolean)res));
        res = this.executeScript("var a = 0x0F; b = 0x0A; c = a + b; c");
        TbExpressionsTest.assertNotNull((Object)res);
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)25, (Object)res);
        res = this.executeScript("var a = (byte)0x0F; b = a << 24 >> 16; b");
        TbExpressionsTest.assertNotNull((Object)res);
        TbExpressionsTest.assertEquals((Object)3840, (Object)res);
    }

    public void testUnterminatedStatement() {
        Object res = this.executeScript("var a = \"A\";\nvar b = \"B\"\nvar c = \"C\"\nresult = a + b\nresult = c\n\n{msg: result, \n\nmetadata: {}, msgType: ''}");
        TbExpressionsTest.assertNotNull((Object)res);
        TbExpressionsTest.assertTrue((boolean)(res instanceof Map));
        TbExpressionsTest.assertEquals((Object)"C", ((Map)res).get("msg"));
    }

    public void testRuntimeAndCompileErrors() {
        try {
            this.executeScript("threshold = def (x) { x >= 10 ? x : 0 };\nresult = cost + threshold(lowerBound);");
            TbExpressionsTest.fail((String)"Should throw ScriptRuntimeException");
        }
        catch (ScriptRuntimeException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().equals("[Error: Invalid statement: def (x) { x >= 10 ? x : 0 }]\n[Near : {... threshold = def (x) { x >= 10 ? x : 0 }; ....}]\n                         ^\n[Line: 1, Column: 13]"));
        }
        try {
            this.executeScript("a = [1,2;\n");
            TbExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().equals("[Error: unbalanced braces [ ... ]]\n[Near : {... a = [1,2; ....}]\n                 ^\n[Line: 1, Column: 5]"));
        }
        try {
            this.executeScript("a = [1,2];\n function c(a) {\nvar b = 0;\nb += a[0].toInt();\nreturn b;}\n c(a);");
            TbExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().equals("[Error: unable to resolve method: java.lang.Integer.toInt() [arglength=0]]\n[Near : {... b += a[0].toInt(); ....}]\n                 ^\n[Line: 4, Column: 5]"));
        }
    }

    public void testUseClassImport() {
        try {
            this.executeScript("MyTestUtil.getFoo({foo: 'foo-bar'})");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            junit.framework.Assert.assertTrue((boolean)e.getMessage().contains("unresolvable property or identifier: MyTestUtil"));
        }
        this.parserConfig.addImport("MyTestUtil", TestUtil.class);
        Object res = this.executeScript("MyTestUtil.getFoo({foo: 'foo-bar'})");
        TbExpressionsTest.assertEquals((Object)"foo-bar", (Object)res);
        res = this.executeScript("MyTestUtil.getFoo({})");
        TbExpressionsTest.assertEquals((Object)"Not found!", (Object)res);
        res = this.executeScript("MyTestUtil.methodWithExecContext('key1', 'val1')");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Map));
        TbExpressionsTest.assertEquals((Object)"val1", ((Map)res).get("key1"));
        res = this.executeScript("MyTestUtil.methodWithExecContext2('key2', 'val2')");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Map));
        TbExpressionsTest.assertEquals((Object)"val2", ((Map)res).get("key2"));
        res = this.executeScript("MyTestUtil.methodWithExecContext3('key3', 'val3')");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Map));
        TbExpressionsTest.assertEquals((Object)"val3", ((Map)res).get("key3"));
        res = this.executeScript("MyTestUtil.methodWithExecContextVarArgs('a1', 'a2', 'a3', 'a4', 'a5')");
        TbExpressionsTest.assertTrue((boolean)(res instanceof List));
        TbExpressionsTest.assertEquals((int)5, (int)((List)res).size());
        Assert.assertArrayEquals((Object[])new String[]{"a1", "a2", "a3", "a4", "a5"}, (Object[])((List)res).toArray(new String[5]));
    }

    public void testUseStaticMethodImport() throws Exception {
        this.parserConfig.addImport("getFoo", new MethodStub(TestUtil.class.getMethod("getFoo", Map.class)));
        Object res = this.executeScript("getFoo({foo: 'foo-bar'})");
        TbExpressionsTest.assertEquals((Object)"foo-bar", (Object)res);
        res = this.executeScript("getFoo({})");
        TbExpressionsTest.assertEquals((Object)"Not found!", (Object)res);
        try {
            this.executeScript("currentTimeMillis()");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            junit.framework.Assert.assertTrue((boolean)e.getMessage().contains("function not found: currentTimeMillis"));
        }
        this.parserConfig.addImport("currentTimeMillis", new MethodStub(System.class.getMethod("currentTimeMillis", new Class[0])));
        res = this.executeScript("currentTimeMillis()");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Long));
        TbExpressionsTest.assertEquals((long)(System.currentTimeMillis() / 100L), (long)((Long)res / 100L));
        this.parserConfig.addImport("methodWithExecContext", new MethodStub(TestUtil.class.getMethod("methodWithExecContext", String.class, Object.class, ExecutionContext.class)));
        res = this.executeScript("methodWithExecContext('key1', 'val1')");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Map));
        TbExpressionsTest.assertEquals((Object)"val1", ((Map)res).get("key1"));
        this.parserConfig.addImport("methodWithExecContext2", new MethodStub(TestUtil.class.getMethod("methodWithExecContext2", String.class, ExecutionContext.class, Object.class)));
        res = this.executeScript("methodWithExecContext2('key2', 'val2')");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Map));
        TbExpressionsTest.assertEquals((Object)"val2", ((Map)res).get("key2"));
        this.parserConfig.addImport("methodWithExecContext3", new MethodStub(TestUtil.class.getMethod("methodWithExecContext3", ExecutionContext.class, String.class, Object.class)));
        res = this.executeScript("methodWithExecContext3('key3', 'val3')");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Map));
        TbExpressionsTest.assertEquals((Object)"val3", ((Map)res).get("key3"));
        this.parserConfig.addImport("methodWithExecContextVarArgs", new MethodStub(TestUtil.class.getMethod("methodWithExecContextVarArgs", ExecutionContext.class, Object[].class)));
        res = this.executeScript("methodWithExecContextVarArgs('a1', 'a2', 'a3', 'a4', 'a5')");
        TbExpressionsTest.assertTrue((boolean)(res instanceof List));
        TbExpressionsTest.assertEquals((int)5, (int)((List)res).size());
        Assert.assertArrayEquals((Object[])new String[]{"a1", "a2", "a3", "a4", "a5"}, (Object[])((List)res).toArray(new String[5]));
    }

    public void testRegisterDataType() {
        try {
            this.executeScript("var t = new MyTest('test val'); t");
            TbExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            junit.framework.Assert.assertTrue((boolean)e.getMessage().contains("could not resolve class: MyTest"));
        }
        this.parserConfig.registerDataType("MyTest", MyTestClass.class, val -> val.getValue().getBytes().length);
        Object res = this.executeScript("var t = new MyTest('test val'); t");
        TbExpressionsTest.assertTrue((boolean)(res instanceof MyTestClass));
        TbExpressionsTest.assertEquals((String)"test val", (String)((MyTestClass)res).getValue());
        try {
            this.executeScript("var t = new MyTest('test val'); t", new HashMap(), new ExecutionContext(this.parserConfig, 7L));
            TbExpressionsTest.fail((String)"Should throw ScriptMemoryOverflowException");
        }
        catch (ScriptMemoryOverflowException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Script memory overflow"));
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("8 > 7"));
        }
    }

    public void testDate() {
        Object res = this.executeScript("var t = new java.util.Date(); t");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Date));
        TbExpressionsTest.assertEquals((long)(System.currentTimeMillis() / 100L), (long)(((Date)res).getTime() / 100L));
        res = this.executeScript("var t = new java.util.Date(); var m = {date: t}; m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Map));
        TbExpressionsTest.assertTrue((boolean)(((Map)res).get("date") instanceof Date));
    }

    private Object executeScript(String ex, Map vars, ExecutionContext executionContext, long timeoutMs) throws Exception {
        CountDownLatch countDown = new CountDownLatch(1);
        AtomicReference result = new AtomicReference();
        AtomicReference exception = new AtomicReference();
        Thread thread = new Thread(() -> {
            try {
                result.set(this.executeScript(ex, vars, executionContext));
            }
            catch (Exception e) {
                exception.set(e);
            }
            finally {
                countDown.countDown();
            }
        });
        thread.start();
        try {
            countDown.await(timeoutMs, TimeUnit.MILLISECONDS);
            executionContext.stop();
            countDown.await(500L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (exception.get() != null) {
            throw (Exception)exception.get();
        }
        return result.get();
    }

    private Object executeScript(String ex) {
        return this.executeScript(ex, new HashMap());
    }

    private Object executeScript(String ex, Map vars) {
        return this.executeScript(ex, vars, new ExecutionContext(this.parserConfig));
    }

    private Object executeScript(String ex, Map vars, ExecutionContext executionContext) {
        Serializable compiled = MVEL.compileExpression((String)ex, (ParserContext)new SandboxedParserContext(this.parserConfig));
        this.currentExecutionContext = executionContext;
        return MVEL.executeTbExpression((Object)compiled, (ExecutionContext)this.currentExecutionContext, (Map)vars);
    }

    public static final class MyTestClass {
        private final String innerValue;

        public MyTestClass(String val) {
            this.innerValue = val;
        }

        public String getValue() {
            return this.innerValue;
        }
    }

    public static final class TestUtil {
        public static String getFoo(Map input) {
            if (input.containsKey("foo")) {
                return input.get("foo") != null ? input.get("foo").toString() : "null";
            }
            return "Not found!";
        }

        public static Map methodWithExecContext(String key, Object val, ExecutionContext ctx) {
            ExecutionHashMap map = new ExecutionHashMap(1, ctx);
            map.put(key, val);
            return map;
        }

        public static Map methodWithExecContext2(String key, ExecutionContext ctx, Object val) {
            ExecutionHashMap map = new ExecutionHashMap(1, ctx);
            map.put(key, val);
            return map;
        }

        public static Map methodWithExecContext3(ExecutionContext ctx, String key, Object val) {
            ExecutionHashMap map = new ExecutionHashMap(1, ctx);
            map.put(key, val);
            return map;
        }

        public static List methodWithExecContextVarArgs(ExecutionContext ctx, Object ... vals) {
            ExecutionArrayList list = new ExecutionArrayList(Arrays.asList(vals), ctx);
            return list;
        }
    }
}

