/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.tests.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.mvel2.MVEL;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.tests.core.AbstractTest;
import org.mvel2.tests.core.res.Base;
import org.mvel2.tests.core.res.Foo;

public class ControlFlowTests
extends AbstractTest {
    private static Map<String, Boolean> JIRA124_CTX = Collections.singletonMap("testValue", true);

    public void testSimpleIfStatement() {
        this.test("if (true) { System.out.println(\"test!\") }     \n");
    }

    public void testAnd() {
        ControlFlowTests.assertEquals((Object)true, (Object)this.test("c != null && foo.bar.name == 'dog' && foo.bar.woof"));
    }

    public void testAnd2() {
        ControlFlowTests.assertEquals((Object)true, (Object)this.test("c!=null&&foo.bar.name=='dog'&&foo.bar.woof"));
    }

    public void testComplexAnd() {
        ControlFlowTests.assertEquals((Object)true, (Object)this.test("(pi * hour) > 0 && foo.happy() == 'happyBar'"));
    }

    public void testShortPathExpression() {
        ControlFlowTests.assertEquals(null, (Object)MVEL.eval((String)"3 > 4 && foo.toUC('test'); foo.register", (Object)new Base(), (Map)ControlFlowTests.createTestMap()));
    }

    public void testShortPathExpression2() {
        ControlFlowTests.assertEquals((Object)true, (Object)this.test("4 > 3 || foo.toUC('test')"));
    }

    public void testShortPathExpression4() {
        ControlFlowTests.assertEquals((Object)true, (Object)this.test("4>3||foo.toUC('test')"));
    }

    public void testOr() {
        ControlFlowTests.assertEquals((Object)true, (Object)this.test("fun || true"));
    }

    public void testOrOperator() {
        ControlFlowTests.assertEquals((Object)true, (Object)this.test("true||true"));
    }

    public void testOrOperator2() {
        ControlFlowTests.assertEquals((Object)true, (Object)this.test("2 > 3 || 3 > 2"));
    }

    public void testOrOperator3() {
        ControlFlowTests.assertEquals((Object)true, (Object)this.test("pi > 5 || pi > 6 || pi > 3"));
    }

    public void testShortPathExpression3() {
        ControlFlowTests.assertEquals((Object)false, (Object)this.test("defnull != null  && defnull.length() > 0"));
    }

    public void testMultiStatement() {
        ControlFlowTests.assertEquals((Object)true, (Object)this.test("populate(); barfoo == 'sarah'"));
    }

    public void testTernary() {
        ControlFlowTests.assertEquals((Object)"foobie", (Object)this.test("zero==0?'foobie':zero"));
    }

    public void testTernary2() {
        ControlFlowTests.assertEquals((Object)"blimpie", (Object)this.test("zero==1?'foobie':'blimpie'"));
    }

    public void testTernary3() {
        ControlFlowTests.assertEquals((Object)"foobiebarbie", (Object)this.test("zero==1?'foobie':'foobie'+'barbie'"));
    }

    public void testTernary5() {
        ControlFlowTests.assertEquals((Object)"skat!", (Object)this.test("isdef someWierdVar ? 'squid' : 'skat!';"));
    }

    public void testEmptyIf() {
        ControlFlowTests.assertEquals((Object)5, (Object)this.test("a = 5; if (a == 5) { }; return a;"));
    }

    public void testEmptyIf2() {
        ControlFlowTests.assertEquals((Object)5, (Object)this.test("a=5;if(a==5){};return a;"));
    }

    public void testIf() {
        String ex = "if (5 > 4) { return 10; } else { return 5; }";
        ControlFlowTests.assertEquals((Object)10, (Object)MVEL.eval((String)ex));
        Serializable s = MVEL.compileExpression((String)ex);
        ControlFlowTests.assertEquals((Object)10, (Object)MVEL.executeExpression((Object)s));
    }

    public void testIf2() {
        ControlFlowTests.assertEquals((Object)10, (Object)this.test("if (5 < 4) { return 5; } else { return 10; }"));
    }

    public void testIf3() {
        String ex = "if(5<4){return 5;}else{return 10;}";
        ControlFlowTests.assertEquals((Object)10, (Object)MVEL.eval((String)ex));
        ControlFlowTests.assertEquals((Object)10, (Object)this.test("if(5<4){return 5;}else{return 10;}"));
    }

    public void testIfAndElse() {
        ControlFlowTests.assertEquals((Object)true, (Object)this.test("if (false) { return false; } else { return true; }"));
    }

    public void testIfAndElseif() {
        ControlFlowTests.assertEquals((Object)true, (Object)this.test("if (false) { return false; } else if(100 < 50) { return false; } else if (10 > 5) return true;"));
    }

    public void testIfAndElseif2() {
        ControlFlowTests.assertEquals((Object)true, (Object)MVEL.eval((String)"if (false) { return false; } else if(100 < 50) { return false; } else if (10 > 5) return true;"));
    }

    public void testIfAndElseif3() {
        ControlFlowTests.assertEquals((Object)true, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"if (false) { return false; } else if(100 < 50) { return false; } else if (10 > 5) return true;")));
    }

    public void testIfAndElseIfCondensedGrammar() {
        ControlFlowTests.assertEquals((Object)"Foo244", (Object)this.test("if (false) return 'Bar'; else return 'Foo244';"));
    }

    public void testTernary4() {
        ControlFlowTests.assertEquals((Object)"<test>", (Object)this.test("true ? '<test>' : '<poo>'"));
    }

    public void testPrecedenceOrder1() {
        String ex = "50 > 60 && 20 < 10 || 100 > 90";
        System.out.println("Expression: " + ex);
        ControlFlowTests.assertTrue((boolean)((Boolean)MVEL.eval((String)ex)));
    }

    public void testDoLoop() {
        ControlFlowTests.assertEquals((Object)10, (Object)this.test("i = 0; do { i++ } while (i != 10); i"));
    }

    public void testDoLoop2() {
        ControlFlowTests.assertEquals((Object)50, (Object)this.test("i=100;do{i--}until(i==50); i"));
    }

    public void testForLoop() {
        String ex = "String str = ''; for(i=0;i<6;i++) { str += i }; str";
        ControlFlowTests.assertEquals((Object)"012345", (Object)MVEL.eval((String)ex, new HashMap()));
        ControlFlowTests.assertEquals((Object)"012345", (Object)this.test(ex));
    }

    public void testForLoop2() {
        ControlFlowTests.assertEquals((Object)"012345", (Object)MVEL.eval((String)"String str='';for(i=0;i<6;i++){str+=i};str", new HashMap()));
    }

    public void testUntilLoop() {
        ControlFlowTests.assertEquals((Object)"012345", (Object)this.test("String str = ''; int i = 0; until (i == 6) { str += i++; }; str"));
    }

    public void testQualifiedForLoop() {
        ParserContext pCtx = new ParserContext();
        pCtx.setStrongTyping(true);
        pCtx.addImport(Foo.class);
        pCtx.addInput("l", ArrayList.class, new Class[]{Foo.class});
        ArrayList<Foo> l = new ArrayList<Foo>();
        l.add(new Foo());
        l.add(new Foo());
        l.add(new Foo());
        HashMap<String, ArrayList<Foo>> vars = new HashMap<String, ArrayList<Foo>>();
        vars.put("l", l);
        Serializable s = MVEL.compileExpression((String)"String s = ''; for (Foo f : l) { s += f.name }; s", (ParserContext)pCtx);
        String r = (String)MVEL.executeExpression((Object)s, vars);
        ControlFlowTests.assertEquals((String)"dogdogdog", (String)r);
    }

    public void testForLoopWithVar() {
        String str = "int height = 100; int j = 0; for (i = 0; i < height; i++) {j++ }; return j;";
        ParserConfiguration pconf = new ParserConfiguration();
        ParserContext pctx = new ParserContext(pconf);
        pctx.setStrongTyping(true);
        ExecutableStatement stmt = (ExecutableStatement)MVEL.compileExpression((String)str, (ParserContext)pctx);
        HashMap vars = new HashMap();
        ControlFlowTests.assertEquals((Object)new Integer(100), (Object)MVEL.executeExpression((Object)stmt, vars));
    }

    public void testEmptyLoopSemantics() {
        Serializable s = MVEL.compileExpression((String)"for (i = 0; i < 100000000000; i++) { }");
        MVEL.executeExpression((Object)s, new HashMap());
    }

    public void testLoopWithEscape() {
        Serializable s = MVEL.compileExpression((String)"x = 0; for (; x < 10000; x++) {}");
        HashMap vars = new HashMap();
        MVEL.executeExpression((Object)s, vars);
        ControlFlowTests.assertEquals((Object)10000, vars.get("x"));
        vars.remove("x");
        MVEL.eval((String)"x = 0; for (; x < 10000; x++) {}", vars);
        ControlFlowTests.assertEquals((Object)10000, vars.get("x"));
    }

    public void testNestedMethodCall() {
        ArrayList<TargetClass> elements = new ArrayList<TargetClass>();
        elements.add(new TargetClass());
        HashMap<String, ArrayList<TargetClass>> variableMap = new HashMap<String, ArrayList<TargetClass>>();
        variableMap.put("elements", elements);
        MVEL.eval((String)"results = new java.util.ArrayList(); foreach (element : elements) { if( {5} contains element.targetValue.intValue()) { results.add(element); } }; results", variableMap);
    }

    public void testStaticallyTypedItemInForEach() {
        ControlFlowTests.assertEquals((Object)"1234", (Object)this.test("StringBuffer sbuf = new StringBuffer(); foreach (int i : new int[] { 1,2,3,4 }) { sbuf.append(i); }; sbuf.toString()"));
    }

    public void testJIRA115() {
        String exp = "results = new java.util.ArrayList(); foreach (element : elements) { if( {1,32769,32767} contains element ) { results.add(element);  } }; results";
        HashMap<String, int[]> map = new HashMap<String, int[]>();
        map.put("elements", new int[]{1, 32769, Short.MAX_VALUE});
        ArrayList result = (ArrayList)MVEL.eval((String)exp, map);
        ControlFlowTests.assertEquals((int)3, (int)result.size());
    }

    public void testStringWithTernaryIf() {
        this.test("System.out.print(\"Hello : \" + (foo != null ? \"FOO!\" : \"NO FOO\") + \". Bye.\");");
    }

    private static Object testTernary(int i, String expression) throws Exception {
        Object val2;
        Object val;
        try {
            val = MVEL.executeExpression((Object)MVEL.compileExpression((String)expression), JIRA124_CTX);
        }
        catch (Exception e) {
            System.out.println("FailedCompiled[" + i + "]:" + expression);
            throw e;
        }
        try {
            val2 = MVEL.eval((String)expression, JIRA124_CTX);
        }
        catch (Exception e) {
            System.out.println("FailedEval[" + i + "]:" + expression);
            throw e;
        }
        if ((val == null || val2 == null) && val != val2 || val != null && !val.equals(val2)) {
            throw new AssertionError((Object)("results do not match (" + String.valueOf(val) + " != " + String.valueOf(val2) + ")"));
        }
        return val;
    }

    public void testJIRA124() throws Exception {
        ControlFlowTests.assertEquals((Object)"A", (Object)ControlFlowTests.testTernary(1, "testValue == true ? 'A' :  'B' + 'C'"));
        ControlFlowTests.assertEquals((Object)"AB", (Object)ControlFlowTests.testTernary(2, "testValue ? 'A' +  'B' : 'C'"));
        ControlFlowTests.assertEquals((Object)"A", (Object)ControlFlowTests.testTernary(3, "(testValue ? 'A' :  'B' + 'C')"));
        ControlFlowTests.assertEquals((Object)"AB", (Object)ControlFlowTests.testTernary(4, "(testValue ? 'A' +  'B' : 'C')"));
        ControlFlowTests.assertEquals((Object)"A", (Object)ControlFlowTests.testTernary(5, "(testValue ? 'A' :  ('B' + 'C'))"));
        ControlFlowTests.assertEquals((Object)"AB", (Object)ControlFlowTests.testTernary(6, "(testValue ? ('A' + 'B') : 'C')"));
        JIRA124_CTX = Collections.singletonMap("testValue", false);
        ControlFlowTests.assertEquals((Object)"BC", (Object)ControlFlowTests.testTernary(1, "testValue ? 'A' :  'B' + 'C'"));
        ControlFlowTests.assertEquals((Object)"C", (Object)ControlFlowTests.testTernary(2, "testValue ? 'A' +  'B' : 'C'"));
        ControlFlowTests.assertEquals((Object)"BC", (Object)ControlFlowTests.testTernary(3, "(testValue ? 'A' :  'B' + 'C')"));
        ControlFlowTests.assertEquals((Object)"C", (Object)ControlFlowTests.testTernary(4, "(testValue ? 'A' +  'B' : 'C')"));
        ControlFlowTests.assertEquals((Object)"BC", (Object)ControlFlowTests.testTernary(5, "(testValue ? 'A' :  ('B' + 'C'))"));
        ControlFlowTests.assertEquals((Object)"C", (Object)ControlFlowTests.testTernary(6, "(testValue ? ('A' + 'B') : 'C')"));
    }

    public void testCalculateAge() {
        Calendar c1 = Calendar.getInstance();
        c1.set(1999, 0, 10);
        HashMap objectMap = new HashMap(1);
        HashMap<String, Date> propertyMap = new HashMap<String, Date>(1);
        propertyMap.put("GEBDAT", c1.getTime());
        objectMap.put("EV_VI_ANT1", propertyMap);
        ControlFlowTests.assertEquals((Object)"N", (Object)ControlFlowTests.testCompiledSimple("new org.mvel2.tests.core.res.PDFFieldUtil().calculateAge(EV_VI_ANT1.GEBDAT) >= 25 ? 'Y' : 'N'", null, objectMap));
    }

    public void testSubEvaluation() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EV_BER_BER_NR", "12345");
        map.put("EV_BER_BER_PRIV", Boolean.FALSE);
        ControlFlowTests.assertEquals((Object)"12345", (Object)ControlFlowTests.testCompiledSimple("EV_BER_BER_NR + ((EV_BER_BER_PRIV != empty && EV_BER_BER_PRIV == true) ? \"/PRIVAT\" : '')", null, map));
        map.put("EV_BER_BER_PRIV", Boolean.TRUE);
        ControlFlowTests.assertEquals((Object)"12345/PRIVAT", (Object)ControlFlowTests.testCompiledSimple("EV_BER_BER_NR + ((EV_BER_BER_PRIV != empty && EV_BER_BER_PRIV == true) ? \"/PRIVAT\" : '')", null, map));
    }

    public void testCompactIfElse() {
        ControlFlowTests.assertEquals((Object)"foo", (Object)this.test("if (false) 'bar'; else 'foo';"));
    }

    public void testForInitializerScope() {
        String ex = "for (int i = 0; i < 10; i++) { 'fop'; }\nfor (int i = 0; i < 10; i++) { 'foo'; }";
        Serializable s = MVEL.compileExpression((String)ex);
        MVEL.executeExpression((Object)s, new HashMap());
    }

    public void testForEachTerminateFlow() {
        String ex = "for(int i=0;i<5;i++) {\nSystem.out.println(\"LOOP\" + i);\nreturn true;\n}\nSystem.out.println(\"END\");";
        Serializable s = MVEL.compileExpression((String)ex);
        ControlFlowTests.assertEquals((Object)true, (Object)MVEL.executeExpression((Object)s, new HashMap()));
    }

    public final void testFunctionCall() {
        MVEL.eval((String)"def test() { for(i = 0; i < 3; i++) { System.out.println('...') } } \ntest()", new HashMap());
    }

    public void testMultipleArgumentsInFunction() {
        String expression = "def cond(x, y) {\n\tif (x ~= \"fet.*\") {\n\t\tif ((x.endsWith(('sock')))) {\n \t\t\treturn 1;\n\t\t}  else if ((x.endsWith(('lock')))) {\n \t\t\treturn [1: ((y > 12) ? 1 : 2), 2: (12 + 1)];\n\t\t} ;\n\t}\n(null).print();\n\n}\n\ncond('fetlock', 12)";
        System.out.println(expression);
        Exception thrown = null;
        try {
            MVEL.executeExpression((Object)MVEL.compileExpression((String)expression), new HashMap());
        }
        catch (Exception e) {
            thrown = e;
        }
        ControlFlowTests.assertNull((String)"Return statement not being honored!", (Object)thrown);
    }

    public void testDhanji1() {
        String expression = "def insert(i, ls) {\n  if (ls == empty) {\n    return [];\n  }\n  if (ls is java.util.List) {\n    x = ls[0];\n    xs = ls.size() == 1 ? [] : ls.subList(1, ls.size());\n    return (((i <= x) ? ([i, x] + xs) : insert(i, xs)));\n  }\n}\n\ninsert(2, [1, 3, 4])";
        Object o = MVEL.eval((String)expression, new HashMap());
        System.out.println(o);
    }

    public void testDhanji2() {
        ControlFlowTests.assertEquals(Arrays.asList(1, 2, 3, 4), (Object)MVEL.eval((String)"x = 1; y = 2; [x,y] + [3,4]", new HashMap()));
    }

    private static int fibonacci(int n) {
        if (n < 2) {
            return 1;
        }
        return ControlFlowTests.fibonacci(n - 2) + ControlFlowTests.fibonacci(n - 1);
    }

    public static class TargetClass {
        private short _targetValue = (short)5;

        public short getTargetValue() {
            return this._targetValue;
        }
    }
}

