/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Collection;
import org.mvel2.DataConversion;
import org.mvel2.Unit;
import org.mvel2.compiler.BlankLiteral;
import org.mvel2.debug.DebugTools;
import org.mvel2.util.ParseTools;
import org.mvel2.util.Soundex;

public strictfp class MathProcessor {
    private static final MathContext MATH_CONTEXT = MathContext.DECIMAL128;

    public static Object doOperations(Object val1, int operation, Object val2) {
        return MathProcessor.doOperations(val1 == null ? 0 : ParseTools.__resolveType(val1.getClass()), val1, operation, val2 == null ? -1 : ParseTools.__resolveType(val2.getClass()), val2);
    }

    public static Object doOperations(Object val1, int operation, int type2, Object val2) {
        return MathProcessor.doOperations(val1 == null ? 0 : ParseTools.__resolveType(val1.getClass()), val1, operation, type2, val2);
    }

    public static Object doOperations(int type1, Object val1, int operation, int type2, Object val2) {
        if (type1 < 1) {
            int n = type1 = val1 == null ? 0 : ParseTools.__resolveType(val1.getClass());
        }
        if (type2 < 1) {
            int n = type2 = val2 == null ? 0 : ParseTools.__resolveType(val2.getClass());
        }
        if (type1 == 110) {
            if (type2 == 110) {
                return MathProcessor.doBigDecimalArithmetic((BigDecimal)val1, operation, (BigDecimal)val2, false, -1);
            }
            if (type2 >= 99) {
                return MathProcessor.doBigDecimalArithmetic((BigDecimal)val1, operation, MathProcessor.asBigDecimal(val2), false, -1);
            }
            return MathProcessor._doOperations(type1, val1, operation, type2, val2);
        }
        return MathProcessor._doOperations(type1, val1, operation, type2, val2);
    }

    private static Object doPrimWrapperArithmetic(Number val1, int operation, Number val2, int returnTarget) {
        switch (operation) {
            case 0: {
                return MathProcessor.toType(val1.doubleValue() + val2.doubleValue(), returnTarget);
            }
            case 3: {
                return MathProcessor.toType(val1.doubleValue() / val2.doubleValue(), returnTarget);
            }
            case 1: {
                return MathProcessor.toType(val1.doubleValue() - val2.doubleValue(), returnTarget);
            }
            case 2: {
                return MathProcessor.toType(val1.doubleValue() * val2.doubleValue(), returnTarget);
            }
            case 5: {
                return MathProcessor.toType(Math.pow(val1.doubleValue(), val2.doubleValue()), returnTarget);
            }
            case 4: {
                return MathProcessor.toType(val1.doubleValue() % val2.doubleValue(), returnTarget);
            }
            case 15: {
                return val1.doubleValue() > val2.doubleValue();
            }
            case 17: {
                return val1.doubleValue() >= val2.doubleValue();
            }
            case 14: {
                return val1.doubleValue() < val2.doubleValue();
            }
            case 16: {
                return val1.doubleValue() <= val2.doubleValue();
            }
            case 18: {
                return val1.doubleValue() == val2.doubleValue();
            }
            case 19: {
                return val1.doubleValue() != val2.doubleValue();
            }
        }
        return null;
    }

    private static Object toType(Number val, int returnType) {
        switch (returnType) {
            case 103: 
            case 109: {
                return val.doubleValue();
            }
            case 104: 
            case 108: {
                return Float.valueOf(val.floatValue());
            }
            case 101: 
            case 106: {
                return val.intValue();
            }
            case 102: 
            case 107: {
                return val.longValue();
            }
            case 100: 
            case 105: {
                return val.shortValue();
            }
            case 9: 
            case 99: {
                return val.byteValue();
            }
            case 110: {
                return new BigDecimal(val.doubleValue());
            }
            case 111: {
                return BigInteger.valueOf(val.longValue());
            }
            case 1: {
                return val.doubleValue();
            }
        }
        throw new RuntimeException("internal error: " + returnType);
    }

    private static Object doBigDecimalArithmetic(BigDecimal val1, int operation, BigDecimal val2, boolean iNumber, int returnTarget) {
        switch (operation) {
            case 0: {
                if (iNumber) {
                    return ParseTools.narrowType(val1.add(val2, MATH_CONTEXT), returnTarget);
                }
                return val1.add(val2, MATH_CONTEXT);
            }
            case 3: {
                if (iNumber) {
                    return ParseTools.narrowType(val1.divide(val2, MATH_CONTEXT), returnTarget);
                }
                return val1.divide(val2, MATH_CONTEXT);
            }
            case 1: {
                if (iNumber) {
                    return ParseTools.narrowType(val1.subtract(val2, MATH_CONTEXT), returnTarget);
                }
                return val1.subtract(val2, MATH_CONTEXT);
            }
            case 2: {
                if (iNumber) {
                    return ParseTools.narrowType(val1.multiply(val2, MATH_CONTEXT), returnTarget);
                }
                return val1.multiply(val2, MATH_CONTEXT);
            }
            case 5: {
                if (iNumber) {
                    return ParseTools.narrowType(val1.pow(val2.intValue(), MATH_CONTEXT), returnTarget);
                }
                return val1.pow(val2.intValue(), MATH_CONTEXT);
            }
            case 4: {
                if (iNumber) {
                    return ParseTools.narrowType(val1.remainder(val2), returnTarget);
                }
                return val1.remainder(val2);
            }
            case 15: {
                return val1 != null && val2 != null && val1.compareTo(val2) > 0;
            }
            case 17: {
                return val1 != null && val2 != null && val1.compareTo(val2) >= 0;
            }
            case 14: {
                return val1 != null && val2 != null && val1.compareTo(val2) < 0;
            }
            case 16: {
                return val1 != null && val2 != null && val1.compareTo(val2) <= 0;
            }
            case 18: {
                return val1 == null ? val2 == null : val2 != null && val1.compareTo(val2) == 0;
            }
            case 19: {
                return val1 == null ? val2 != null : val2 == null || val1.compareTo(val2) != 0;
            }
        }
        return null;
    }

    private static Object _doOperations(int type1, Object val1, int operation, int type2, Object val2) {
        if (operation < 20) {
            if ((type1 > 49 || operation == 18 || operation == 19) && type1 == type2 || MathProcessor.isIntegerType(type1) && MathProcessor.isIntegerType(type2) && operation >= 6 && operation <= 13) {
                return MathProcessor.doOperationsSameType(type1, val1, operation, val2);
            }
            if (val2 != null && MathProcessor.isNumericOperation(type1, val1, operation, type2, val2)) {
                return MathProcessor.doPrimWrapperArithmetic(MathProcessor.getNumber(val1, type1), operation, MathProcessor.getNumber(val2, type2), Math.max(MathProcessor.box(type2), MathProcessor.box(type1)));
            }
            if (operation != 0 && (type1 == 15 || type2 == 15) && type1 != type2 && type1 != 200 && type2 != 200) {
                return MathProcessor.doOperationNonNumeric(type1, DataConversion.convert(val1, Boolean.class), operation, DataConversion.convert(val2, Boolean.class));
            }
            if (!(type1 != 1 && type2 != 1 || type1 != 8 && type1 != 112 && type2 != 8 && type2 != 112)) {
                if (type1 == 1) {
                    return MathProcessor.doOperationNonNumeric(type1, val1, operation, String.valueOf(val2));
                }
                return MathProcessor.doOperationNonNumeric(type1, String.valueOf(val1), operation, val2);
            }
        }
        return MathProcessor.doOperationNonNumeric(type1, val1, operation, val2);
    }

    private static boolean isNumericOperation(int type1, Object val1, int operation, int type2, Object val2) {
        return type1 >= 99 && type2 >= 99 || operation != 0 && (type1 >= 99 || type2 >= 99 || operation < 14 || operation > 17) && ParseTools.isNumber(val1) && ParseTools.isNumber(val2);
    }

    private static boolean isIntegerType(int type) {
        return type == 9 || type == 99 || type == 101 || type == 106 || type == 102 || type == 107;
    }

    private static Object doOperationNonNumeric(int type1, Object val1, int operation, Object val2) {
        switch (operation) {
            case 0: {
                if (type1 == 50) {
                    ArrayList<Object> list = new ArrayList<Object>((Collection)val1);
                    list.add(val2);
                    return list;
                }
                return String.valueOf(val1) + String.valueOf(val2);
            }
            case 18: {
                return MathProcessor.safeEquals(val2, val1);
            }
            case 19: {
                return MathProcessor.safeNotEquals(val2, val1);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return null;
            }
            case 15: {
                if (val1 instanceof Comparable) {
                    try {
                        return val2 != null && ((Comparable)val1).compareTo(val2) >= 1;
                    }
                    catch (ClassCastException e) {
                        throw new RuntimeException("uncomparable values <<" + val1 + ">> and <<" + val2 + ">>", e);
                    }
                }
                return Boolean.FALSE;
            }
            case 17: {
                if (val1 instanceof Comparable) {
                    try {
                        return val2 != null && ((Comparable)val1).compareTo(val2) >= 0;
                    }
                    catch (ClassCastException e) {
                        throw new RuntimeException("uncomparable values <<" + val1 + ">> and <<" + val2 + ">>", e);
                    }
                }
                return Boolean.FALSE;
            }
            case 14: {
                if (val1 instanceof Comparable) {
                    try {
                        return val2 != null && ((Comparable)val1).compareTo(val2) <= -1;
                    }
                    catch (ClassCastException e) {
                        throw new RuntimeException("uncomparable values <<" + val1 + ">> and <<" + val2 + ">>", e);
                    }
                }
                return Boolean.FALSE;
            }
            case 16: {
                if (val1 instanceof Comparable) {
                    try {
                        return val2 != null && ((Comparable)val1).compareTo(val2) <= 0;
                    }
                    catch (ClassCastException e) {
                        throw new RuntimeException("uncomparable values <<" + val1 + ">> and <<" + val2 + ">>", e);
                    }
                }
                return Boolean.FALSE;
            }
            case 27: {
                return Soundex.soundex(String.valueOf(val1)).equals(Soundex.soundex(String.valueOf(val2)));
            }
            case 20: {
                return String.valueOf(val1) + String.valueOf(val2);
            }
        }
        throw new RuntimeException("could not perform numeric operation on non-numeric types: left-type=" + (val1 != null ? val1.getClass().getName() : "null") + "; right-type=" + (val2 != null ? val2.getClass().getName() : "null") + " [vals (" + String.valueOf(val1) + ", " + String.valueOf(val2) + ") operation=" + DebugTools.getOperatorName(operation) + " (opcode:" + operation + ") ]");
    }

    private static Boolean safeEquals(Object val1, Object val2) {
        if (val1 != null) {
            return val1.equals(val2);
        }
        return val2 == null;
    }

    private static Boolean safeNotEquals(Object val1, Object val2) {
        if (val1 != null) {
            return !val1.equals(val2);
        }
        return val2 != null;
    }

    private static Object doOperationsSameType(int type1, Object val1, int operation, Object val2) {
        switch (type1) {
            case 50: {
                switch (operation) {
                    case 0: {
                        ArrayList list = new ArrayList((Collection)val1);
                        list.addAll((Collection)val2);
                        return list;
                    }
                    case 18: {
                        return val1.equals(val2);
                    }
                    case 19: {
                        return !val1.equals(val2);
                    }
                }
                throw new UnsupportedOperationException("illegal operation on Collection type");
            }
            case 101: 
            case 106: {
                switch (operation) {
                    case 0: {
                        return MathProcessor.toInteger(val1) + MathProcessor.toInteger(val2);
                    }
                    case 1: {
                        return MathProcessor.toInteger(val1) - MathProcessor.toInteger(val2);
                    }
                    case 3: {
                        return MathProcessor.toDouble(val1) / (double)MathProcessor.toInteger(val2);
                    }
                    case 2: {
                        return MathProcessor.toInteger(val1) * MathProcessor.toInteger(val2);
                    }
                    case 5: {
                        double d = Math.pow(MathProcessor.toInteger(val1), MathProcessor.toInteger(val2));
                        if (d > 2.147483647E9) {
                            return d;
                        }
                        return (int)d;
                    }
                    case 4: {
                        return MathProcessor.toInteger(val1) % MathProcessor.toInteger(val2);
                    }
                    case 15: {
                        return val1 != null && val2 != null && MathProcessor.toInteger(val1) > MathProcessor.toInteger(val2);
                    }
                    case 17: {
                        return val1 != null && val2 != null && MathProcessor.toInteger(val1) >= MathProcessor.toInteger(val2);
                    }
                    case 14: {
                        return val1 != null && val2 != null && MathProcessor.toInteger(val1) < MathProcessor.toInteger(val2);
                    }
                    case 16: {
                        return val1 != null && val2 != null && MathProcessor.toInteger(val1) <= MathProcessor.toInteger(val2);
                    }
                    case 18: {
                        return val1 == null ? val2 == null : MathProcessor.toInteger(val1) == MathProcessor.toInteger(val2);
                    }
                    case 19: {
                        return val1 == null ? val2 != null : MathProcessor.toInteger(val1) != MathProcessor.toInteger(val2);
                    }
                    case 6: {
                        if (val2 instanceof Long) {
                            return (long)((Integer)val1).intValue() & (Long)val2;
                        }
                        return (Integer)val1 & (Integer)val2;
                    }
                    case 7: {
                        if (val2 instanceof Long) {
                            return (long)((Integer)val1).intValue() | (Long)val2;
                        }
                        return (Integer)val1 | (Integer)val2;
                    }
                    case 10: {
                        if (val2 instanceof Long) {
                            return (Integer)val1 << (int)((Long)val2).longValue();
                        }
                        return (Integer)val1 << (Integer)val2;
                    }
                    case 9: {
                        if (val2 instanceof Long) {
                            return (Integer)val1 >> (int)((Long)val2).longValue();
                        }
                        return (Integer)val1 >> (Integer)val2;
                    }
                    case 11: {
                        if (val2 instanceof Long) {
                            return (Integer)val1 >>> (int)((Long)val2).longValue();
                        }
                        return (Integer)val1 >>> (Integer)val2;
                    }
                    case 8: {
                        if (val2 instanceof Long) {
                            return (long)((Integer)val1).intValue() ^ (Long)val2;
                        }
                        return (Integer)val1 ^ (Integer)val2;
                    }
                }
            }
            case 9: 
            case 99: {
                switch (operation) {
                    case 0: {
                        return MathProcessor.toInteger(val1) + MathProcessor.toInteger(val2);
                    }
                    case 1: {
                        return MathProcessor.toInteger(val1) - MathProcessor.toInteger(val2);
                    }
                    case 3: {
                        return MathProcessor.toDouble(val1) / (double)MathProcessor.toInteger(val2);
                    }
                    case 2: {
                        return MathProcessor.toInteger(val1) * MathProcessor.toInteger(val2);
                    }
                    case 5: {
                        double d = Math.pow(MathProcessor.toInteger(val1), MathProcessor.toInteger(val2));
                        if (d > 2.147483647E9) {
                            return d;
                        }
                        return (int)d;
                    }
                    case 4: {
                        return MathProcessor.toInteger(val1) % MathProcessor.toInteger(val2);
                    }
                    case 15: {
                        return val1 != null && val2 != null && MathProcessor.toInteger(val1) > MathProcessor.toInteger(val2);
                    }
                    case 17: {
                        return val1 != null && val2 != null && MathProcessor.toInteger(val1) >= MathProcessor.toInteger(val2);
                    }
                    case 14: {
                        return val1 != null && val2 != null && MathProcessor.toInteger(val1) < MathProcessor.toInteger(val2);
                    }
                    case 16: {
                        return val1 != null && val2 != null && MathProcessor.toInteger(val1) <= MathProcessor.toInteger(val2);
                    }
                    case 18: {
                        return val1 == null ? val2 == null : MathProcessor.toInteger(val1) == MathProcessor.toInteger(val2);
                    }
                    case 19: {
                        return val1 == null ? val2 != null : MathProcessor.toInteger(val1) != MathProcessor.toInteger(val2);
                    }
                    case 6: {
                        if (val2 instanceof Long) {
                            return (long)((Byte)val1).byteValue() & (Long)val2;
                        }
                        return (Byte)val1 & (Integer)val2;
                    }
                    case 7: {
                        if (val2 instanceof Long) {
                            return (long)((Byte)val1).byteValue() | (Long)val2;
                        }
                        return (Byte)val1 | (Integer)val2;
                    }
                    case 10: {
                        if (val2 instanceof Long) {
                            return (Byte)val1 << (int)((Long)val2).longValue();
                        }
                        return (Byte)val1 << (Integer)val2;
                    }
                    case 9: {
                        if (val2 instanceof Long) {
                            return (Byte)val1 >> (int)((Long)val2).longValue();
                        }
                        return (Byte)val1 >> (Integer)val2;
                    }
                    case 11: {
                        if (val2 instanceof Long) {
                            return (Byte)val1 >>> (int)((Long)val2).longValue();
                        }
                        return (Byte)val1 >>> (Integer)val2;
                    }
                    case 8: {
                        if (val2 instanceof Long) {
                            return (long)((Byte)val1).byteValue() ^ (Long)val2;
                        }
                        return (Byte)val1 ^ (Integer)val2;
                    }
                }
            }
            case 100: 
            case 105: {
                switch (operation) {
                    case 0: {
                        return MathProcessor.toShort(val1) + MathProcessor.toShort(val2);
                    }
                    case 1: {
                        return MathProcessor.toShort(val1) - MathProcessor.toShort(val2);
                    }
                    case 3: {
                        return MathProcessor.toDouble(val1) / MathProcessor.toDouble(val2);
                    }
                    case 2: {
                        return MathProcessor.toShort(val1) * MathProcessor.toShort(val2);
                    }
                    case 5: {
                        double d = Math.pow(MathProcessor.toShort(val1), MathProcessor.toShort(val2));
                        if (d > 32767.0) {
                            return d;
                        }
                        return (short)d;
                    }
                    case 4: {
                        return MathProcessor.toShort(val1) % MathProcessor.toShort(val2);
                    }
                    case 15: {
                        return val1 != null && val2 != null && MathProcessor.toShort(val1) > MathProcessor.toShort(val2);
                    }
                    case 17: {
                        return val1 != null && val2 != null && MathProcessor.toShort(val1) >= MathProcessor.toShort(val2);
                    }
                    case 14: {
                        return val1 != null && val2 != null && MathProcessor.toShort(val1) < MathProcessor.toShort(val2);
                    }
                    case 16: {
                        return val1 != null && val2 != null && MathProcessor.toShort(val1) <= MathProcessor.toShort(val2);
                    }
                    case 18: {
                        return val1 == null ? val2 == null : MathProcessor.toShort(val1) == MathProcessor.toShort(val2);
                    }
                    case 19: {
                        return val1 == null ? val2 != null : MathProcessor.toShort(val1) != MathProcessor.toShort(val2);
                    }
                    case 6: {
                        return (Short)val1 & (Short)val2;
                    }
                    case 7: {
                        return (Short)val1 | (Short)val2;
                    }
                    case 10: {
                        return (Short)val1 << (Short)val2;
                    }
                    case 9: {
                        return (Short)val1 >> (Short)val2;
                    }
                    case 11: {
                        return (Short)val1 >>> (Short)val2;
                    }
                    case 8: {
                        return (Short)val1 ^ (Short)val2;
                    }
                }
            }
            case 102: 
            case 107: {
                switch (operation) {
                    case 0: {
                        return MathProcessor.toLong(val1) + MathProcessor.toLong(val2);
                    }
                    case 1: {
                        return MathProcessor.toLong(val1) - MathProcessor.toLong(val2);
                    }
                    case 3: {
                        return MathProcessor.toDouble(val1) / MathProcessor.toDouble(val2);
                    }
                    case 2: {
                        return MathProcessor.toLong(val1) * MathProcessor.toLong(val2);
                    }
                    case 5: {
                        double d = Math.pow(MathProcessor.toLong(val1), MathProcessor.toLong(val2));
                        if (d > 9.223372036854776E18) {
                            return d;
                        }
                        return (long)d;
                    }
                    case 4: {
                        return MathProcessor.toLong(val1) % MathProcessor.toLong(val2);
                    }
                    case 15: {
                        return val1 != null && val2 != null && MathProcessor.toLong(val1) > MathProcessor.toLong(val2);
                    }
                    case 17: {
                        return val1 != null && val2 != null && MathProcessor.toLong(val1) >= MathProcessor.toLong(val2);
                    }
                    case 14: {
                        return val1 != null && val2 != null && MathProcessor.toLong(val1) < MathProcessor.toLong(val2);
                    }
                    case 16: {
                        return val1 != null && val2 != null && MathProcessor.toLong(val1) <= MathProcessor.toLong(val2);
                    }
                    case 18: {
                        return val1 == null ? val2 == null : MathProcessor.toLong(val1) == MathProcessor.toLong(val2);
                    }
                    case 19: {
                        return val1 == null ? val2 != null : MathProcessor.toLong(val1) != MathProcessor.toLong(val2);
                    }
                    case 6: {
                        if (val2 instanceof Integer) {
                            return (Long)val1 & (long)((Integer)val2).intValue();
                        }
                        return (Long)val1 & (Long)val2;
                    }
                    case 7: {
                        if (val2 instanceof Integer) {
                            return (Long)val1 | (long)((Integer)val2).intValue();
                        }
                        return (Long)val1 | (Long)val2;
                    }
                    case 10: {
                        if (val2 instanceof Integer) {
                            return (Long)val1 << (Integer)val2;
                        }
                        return (Long)val1 << (int)((Long)val2).longValue();
                    }
                    case 12: {
                        throw new UnsupportedOperationException("unsigned left-shift not supported");
                    }
                    case 9: {
                        if (val2 instanceof Integer) {
                            return (Long)val1 >> (Integer)val2;
                        }
                        return (Long)val1 >> (int)((Long)val2).longValue();
                    }
                    case 11: {
                        if (val2 instanceof Integer) {
                            return (Long)val1 >>> (Integer)val2;
                        }
                        return (Long)val1 >>> (int)((Long)val2).longValue();
                    }
                    case 8: {
                        if (val2 instanceof Integer) {
                            return (Long)val1 ^ (long)((Integer)val2).intValue();
                        }
                        return (Long)val1 ^ (Long)val2;
                    }
                }
            }
            case 300: {
                val2 = ((Unit)val1).convertFrom(val2);
                val1 = ((Unit)val1).getValue();
            }
            case 103: 
            case 109: {
                switch (operation) {
                    case 0: {
                        return MathProcessor.toDouble(val1) + MathProcessor.toDouble(val2);
                    }
                    case 1: {
                        return MathProcessor.toDouble(val1) - MathProcessor.toDouble(val2);
                    }
                    case 3: {
                        return MathProcessor.toDouble(val1) / MathProcessor.toDouble(val2);
                    }
                    case 2: {
                        return MathProcessor.toDouble(val1) * MathProcessor.toDouble(val2);
                    }
                    case 5: {
                        return Math.pow(MathProcessor.toDouble(val1), MathProcessor.toDouble(val2));
                    }
                    case 4: {
                        return MathProcessor.toDouble(val1) % MathProcessor.toDouble(val2);
                    }
                    case 15: {
                        return val1 != null && val2 != null && MathProcessor.toDouble(val1) > MathProcessor.toDouble(val2);
                    }
                    case 17: {
                        return val1 != null && val2 != null && MathProcessor.toDouble(val1) >= MathProcessor.toDouble(val2);
                    }
                    case 14: {
                        return val1 != null && val2 != null && MathProcessor.toDouble(val1) < MathProcessor.toDouble(val2);
                    }
                    case 16: {
                        return val1 != null && val2 != null && MathProcessor.toDouble(val1) <= MathProcessor.toDouble(val2);
                    }
                    case 18: {
                        return val1 == null ? val2 == null : MathProcessor.toDouble(val1) == MathProcessor.toDouble(val2);
                    }
                    case 19: {
                        return val1 == null ? val2 != null : MathProcessor.toDouble(val1) != MathProcessor.toDouble(val2);
                    }
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        throw new RuntimeException("bitwise operation on a non-fixed-point number.");
                    }
                }
            }
            case 104: 
            case 108: {
                switch (operation) {
                    case 0: {
                        return Float.valueOf(MathProcessor.toFloat(val1) + MathProcessor.toFloat(val2));
                    }
                    case 1: {
                        return Float.valueOf(MathProcessor.toFloat(val1) - MathProcessor.toFloat(val2));
                    }
                    case 3: {
                        return MathProcessor.toDouble(val1) / MathProcessor.toDouble(val2);
                    }
                    case 2: {
                        return Float.valueOf(MathProcessor.toFloat(val1) * MathProcessor.toFloat(val2));
                    }
                    case 5: {
                        return ParseTools.narrowType(MathProcessor.asBigDecimal(val1).pow(((Number)val2).intValue(), MATH_CONTEXT), -1);
                    }
                    case 4: {
                        return Float.valueOf(MathProcessor.toFloat(val1) % MathProcessor.toFloat(val2));
                    }
                    case 15: {
                        return val1 != null && val2 != null && MathProcessor.toFloat(val1) > MathProcessor.toFloat(val2);
                    }
                    case 17: {
                        return val1 != null && val2 != null && MathProcessor.toFloat(val1) >= MathProcessor.toFloat(val2);
                    }
                    case 14: {
                        return val1 != null && val2 != null && MathProcessor.toFloat(val1) < MathProcessor.toFloat(val2);
                    }
                    case 16: {
                        return val1 != null && val2 != null && MathProcessor.toFloat(val1) <= MathProcessor.toFloat(val2);
                    }
                    case 18: {
                        return val1 == null ? val2 == null : MathProcessor.toFloat(val1) == MathProcessor.toFloat(val2);
                    }
                    case 19: {
                        return val1 == null ? val2 != null : MathProcessor.toFloat(val1) != MathProcessor.toFloat(val2);
                    }
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        throw new RuntimeException("bitwise operation on a non-fixed-point number.");
                    }
                }
            }
            case 111: {
                switch (operation) {
                    case 0: {
                        return ((BigInteger)val1).add((BigInteger)val2);
                    }
                    case 1: {
                        return ((BigInteger)val1).subtract((BigInteger)val2);
                    }
                    case 3: {
                        return ((BigInteger)val1).divide((BigInteger)val2);
                    }
                    case 2: {
                        return ((BigInteger)val1).multiply((BigInteger)val2);
                    }
                    case 5: {
                        return ((BigInteger)val1).pow(((BigInteger)val2).intValue());
                    }
                    case 4: {
                        return ((BigInteger)val1).remainder((BigInteger)val2);
                    }
                    case 15: {
                        return ((BigInteger)val1).compareTo((BigInteger)val2) > 0;
                    }
                    case 17: {
                        return ((BigInteger)val1).compareTo((BigInteger)val2) >= 0;
                    }
                    case 14: {
                        return ((BigInteger)val1).compareTo((BigInteger)val2) < 0;
                    }
                    case 16: {
                        return ((BigInteger)val1).compareTo((BigInteger)val2) <= 0;
                    }
                    case 18: {
                        return ((BigInteger)val1).compareTo((BigInteger)val2) == 0;
                    }
                    case 19: {
                        return ((BigInteger)val1).compareTo((BigInteger)val2) != 0;
                    }
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        throw new RuntimeException("bitwise operation on a number greater than 32-bits not possible");
                    }
                }
            }
        }
        switch (operation) {
            case 18: {
                return MathProcessor.safeEquals(val2, val1);
            }
            case 19: {
                return MathProcessor.safeNotEquals(val2, val1);
            }
            case 0: {
                return String.valueOf(val1) + String.valueOf(val2);
            }
        }
        return null;
    }

    private static short toShort(Object val) {
        return val instanceof Short ? ((Short)val).shortValue() : ((Number)val).shortValue();
    }

    private static int toInteger(Object val) {
        return val instanceof Integer ? ((Integer)val).intValue() : ((Number)val).intValue();
    }

    private static long toLong(Object val) {
        return val instanceof Long ? ((Long)val).longValue() : ((Number)val).longValue();
    }

    private static double toDouble(Object val) {
        return val instanceof Double ? ((Double)val).doubleValue() : ((Number)val).doubleValue();
    }

    private static float toFloat(Object val) {
        return val instanceof Float ? ((Float)val).floatValue() : ((Number)val).floatValue();
    }

    private static int box(int type) {
        switch (type) {
            case 101: {
                return 106;
            }
            case 103: {
                return 109;
            }
            case 102: {
                return 107;
            }
            case 100: {
                return 105;
            }
            case 9: {
                return 99;
            }
            case 104: {
                return 108;
            }
            case 8: {
                return 112;
            }
            case 7: {
                return 15;
            }
        }
        return type;
    }

    private static Double getNumber(Object in, int type) {
        if (in == null || in == BlankLiteral.INSTANCE) {
            return 0.0;
        }
        switch (type) {
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                return ((Number)in).doubleValue();
            }
            case 1: 
            case 8: 
            case 112: {
                return Double.parseDouble(String.valueOf(in));
            }
            case 7: 
            case 15: {
                return (Boolean)in != false ? 1.0 : 0.0;
            }
            case 9: 
            case 99: {
                return ((Byte)in).doubleValue();
            }
            case 0: {
                return in instanceof Number ? ((Number)in).doubleValue() : Double.parseDouble((String)in);
            }
        }
        throw new RuntimeException("cannot convert <" + in + "> to a numeric type: " + in.getClass() + " [" + type + "]");
    }

    private static BigDecimal asBigDecimal(Object in) {
        if (in == null || in == BlankLiteral.INSTANCE) {
            return null;
        }
        if (in instanceof BigDecimal) {
            return (BigDecimal)in;
        }
        if (in instanceof String) {
            return new BigDecimal((String)in);
        }
        if (in instanceof Number) {
            return new BigDecimal(((Number)in).doubleValue());
        }
        throw new RuntimeException("cannot convert <" + in + "> to a numeric type: " + in.getClass());
    }
}

