/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.tests.core;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;

public class StaticMethodImportTests {
    private static final String IMPORTS = "import_static org.mvel2.tests.core.StaticMethodImportTests$MatcherAssert.assertThat;\nimport_static org.mvel2.tests.core.StaticMethodImportTests$IsEqual.equalTo;\nimport_static org.mvel2.tests.core.StaticMethodImportTests$IsInstanceOf.instanceOf;\nimport_static org.mvel2.tests.core.StaticMethodImportTests$CoreMatcher.is;\n";

    @Test
    public void testJava() {
        MatcherAssert.assertThat(150, CoreMatcher.is(150));
        this.testMVEL("assertThat('xxx', 150, is(150));");
        MatcherAssert.assertThat(150, CoreMatcher.is(IsEqual.equalTo(150)));
        this.testMVEL("assertThat('xxx', 150, is(equalTo(150)));");
        try {
            MatcherAssert.assertThat(149, CoreMatcher.is(150));
            Assert.fail((String)"should have thrown exception");
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        try {
            this.testMVEL("assertThat(149, is(150));");
            Assert.fail((String)"should have thrown exception");
        }
        catch (Exception e) {
            Assert.assertEquals(AssertionError.class, e.getCause().getCause().getClass());
        }
        try {
            MatcherAssert.assertThat(149, CoreMatcher.is(IsEqual.equalTo(150)));
            Assert.fail((String)"should have thrown exception");
        }
        catch (AssertionError e) {
            // empty catch block
        }
        try {
            this.testMVEL("assertThat(149, is(equalTo(150)));");
            Assert.fail((String)"should have thrown exception");
        }
        catch (Exception e) {
            Assert.assertEquals(AssertionError.class, e.getCause().getCause().getClass());
        }
        MatcherAssert.assertThat("yoda", CoreMatcher.is("yoda"));
        this.testMVEL("assertThat('yoda', is('yoda'));");
        MatcherAssert.assertThat("yoda", CoreMatcher.is(IsEqual.equalTo("yoda")));
        this.testMVEL("assertThat('yoda', is(equalTo('yoda')));");
        try {
            MatcherAssert.assertThat("darth", CoreMatcher.is("yoda"));
            Assert.fail((String)"should have thrown exception");
        }
        catch (AssertionError e) {
            // empty catch block
        }
        try {
            this.testMVEL("assertThat('darth', is('yoda'));");
            Assert.fail((String)"should have thrown exception");
        }
        catch (Exception e) {
            Assert.assertEquals(AssertionError.class, e.getCause().getCause().getClass());
        }
        MatcherAssert.assertThat("yoda", CoreMatcher.is(IsInstanceOf.instanceOf(String.class)));
        this.testMVEL("assertThat('yoda', is(instanceOf(String)));");
        MatcherAssert.assertThat("yoda", CoreMatcher.is(String.class));
        this.testMVEL("assertThat('yoda', is(String));");
    }

    private void testMVEL(String text) {
        this.testMVELUntyped(text);
        this.testMVELTyped(text);
    }

    private void testMVELUntyped(String text) {
        String str = IMPORTS + text;
        ParserContext pctx = new ParserContext();
        HashMap vars = new HashMap();
        Serializable o = MVEL.compileExpression((String)str, (ParserContext)pctx);
        MVEL.executeExpression((Object)o, vars);
    }

    private void testMVELTyped(String text) {
        String str = IMPORTS + text;
        ParserContext pctx = new ParserContext();
        pctx.setStrongTyping(true);
        HashMap vars = new HashMap();
        Serializable o = MVEL.compileExpression((String)str, (ParserContext)pctx);
        MVEL.executeExpression((Object)o, vars);
    }

    public static interface Matcher<T> {
        public boolean matches(Object var1);
    }

    public static class IsInstanceOf
    implements Matcher<Object> {
        private final Class<?> expectedClass;
        private final Class<?> matchableClass;

        public IsInstanceOf(Class<?> expectedClass) {
            this.expectedClass = expectedClass;
            this.matchableClass = IsInstanceOf.matchableClass(expectedClass);
        }

        @Override
        public boolean matches(Object item) {
            if (null == item) {
                return false;
            }
            return this.matchableClass.isInstance(item);
        }

        private static Class<?> matchableClass(Class<?> expectedClass) {
            if (Boolean.TYPE.equals(expectedClass)) {
                return Boolean.class;
            }
            if (Byte.TYPE.equals(expectedClass)) {
                return Byte.class;
            }
            if (Character.TYPE.equals(expectedClass)) {
                return Character.class;
            }
            if (Double.TYPE.equals(expectedClass)) {
                return Double.class;
            }
            if (Float.TYPE.equals(expectedClass)) {
                return Float.class;
            }
            if (Integer.TYPE.equals(expectedClass)) {
                return Integer.class;
            }
            if (Long.TYPE.equals(expectedClass)) {
                return Long.class;
            }
            if (Short.TYPE.equals(expectedClass)) {
                return Short.class;
            }
            return expectedClass;
        }

        public static <T> Matcher<T> instanceOf(Class<?> type) {
            return new IsInstanceOf(type);
        }

        public static <T> Matcher<T> any(Class<T> type) {
            return new IsInstanceOf(type);
        }
    }

    public static class IsEqual<T>
    implements Matcher<T> {
        private final Object object;

        public IsEqual(T equalArg) {
            this.object = equalArg;
        }

        @Override
        public boolean matches(Object arg) {
            return IsEqual.areEqual(arg, this.object);
        }

        public static <T> Matcher<T> equalTo(T operand) {
            return new IsEqual<T>(operand);
        }

        private static boolean areEqual(Object o1, Object o2) {
            if (o1 == null) {
                return o2 == null;
            }
            if (o2 != null && IsEqual.isArray(o1)) {
                return IsEqual.isArray(o2) && IsEqual.areArraysEqual(o1, o2);
            }
            return o1.equals(o2);
        }

        private static boolean areArraysEqual(Object o1, Object o2) {
            return IsEqual.areArrayLengthsEqual(o1, o2) && IsEqual.areArrayElementsEqual(o1, o2);
        }

        private static boolean areArrayLengthsEqual(Object o1, Object o2) {
            return Array.getLength(o1) == Array.getLength(o2);
        }

        private static boolean areArrayElementsEqual(Object o1, Object o2) {
            for (int i = 0; i < Array.getLength(o1); ++i) {
                if (IsEqual.areEqual(Array.get(o1, i), Array.get(o2, i))) continue;
                return false;
            }
            return true;
        }

        private static boolean isArray(Object o) {
            return o.getClass().isArray();
        }
    }

    public static class Is<T>
    implements Matcher<T> {
        private final Matcher<T> matcher;

        public Is(Matcher<T> matcher) {
            this.matcher = matcher;
        }

        @Override
        public boolean matches(Object arg) {
            return this.matcher.matches(arg);
        }

        public static <T> Matcher<T> is(Matcher<T> matcher) {
            return new Is<T>(matcher);
        }

        public static <T> Matcher<T> is(T value) {
            return Is.is(IsEqual.equalTo(value));
        }

        public static <T> Matcher<T> is(Class<T> type) {
            Matcher typeMatcher = IsInstanceOf.instanceOf(type);
            return Is.is(typeMatcher);
        }
    }

    public static class CoreMatcher {
        public static <T> Matcher<T> is(Matcher<T> matcher) {
            return Is.is(matcher);
        }

        public static <T> Matcher<T> is(T value) {
            return Is.is(value);
        }

        public static <T> Matcher<T> is(Class<T> type) {
            return Is.is(type);
        }
    }

    public static class MatcherAssert {
        public static <T> void assertThat(T actual, Matcher<? super T> matcher) {
            if (!matcher.matches(actual)) {
                throw new AssertionError();
            }
        }

        public static <T> void assertThat(String reason, T actual, Matcher<? super T> matcher) {
            if (!matcher.matches(actual)) {
                throw new AssertionError((Object)reason);
            }
        }
    }
}

