/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.util;

import org.junit.Assert;
import org.junit.Test;
import org.mvel2.util.StringAppender;

public class StringAppenderTest {
    @Test
    public void testCharConstructor() {
        StringAppender stringAppender = new StringAppender('a');
        Assert.assertEquals((Object)"", (Object)stringAppender.toString());
    }

    @Test
    public void testAppendNull() {
        StringAppender stringAppender = new StringAppender("a");
        String s = null;
        stringAppender.append(s);
        Assert.assertEquals((Object)"a", (Object)stringAppender.toString());
    }

    @Test
    public void testAppendByteArr() {
        StringAppender stringAppender = new StringAppender("a");
        stringAppender.append("b".getBytes());
        stringAppender.append("c".getBytes());
        Assert.assertEquals((Object)"abc", (Object)stringAppender.toString());
    }

    @Test
    public void testAppendByteArrSubSequence() {
        StringAppender stringAppender = new StringAppender("a");
        stringAppender.append("bcd".getBytes(), 1, 2);
        stringAppender.append("e".getBytes(), 1, 0);
        Assert.assertEquals((Object)"acd", (Object)stringAppender.toString());
    }

    @Test
    public void testAppendCharArrSubSequence() {
        StringAppender stringAppender = new StringAppender(new char[]{'a'});
        stringAppender.append(new char[]{'b', 'c', 'd'}, 1, 2);
        stringAppender.append(new char[]{'e'}, 1, 0);
        Assert.assertEquals((Object)"acd", (Object)stringAppender.toString());
    }

    @Test
    public void testGetChars() {
        StringAppender stringAppender = new StringAppender((CharSequence)new StringBuffer("abc"));
        Assert.assertArrayEquals((char[])new char[]{'a', 'b', 'c'}, (char[])stringAppender.getChars(0, 3));
    }

    @Test
    public void testGetCharsSubSequence() {
        StringAppender stringAppender = new StringAppender((CharSequence)new StringBuffer("abcdef"));
        char[] target = new char[]{'g', 'h', 'i'};
        stringAppender.getChars(1, 2, target, 1);
        Assert.assertArrayEquals((char[])new char[]{'g', 'b', 'i'}, (char[])target);
    }

    @Test
    public void testCharAt() {
        StringAppender stringAppender = new StringAppender("abc");
        Assert.assertEquals((long)98L, (long)stringAppender.charAt(1));
    }

    @Test
    public void testToCharsUnsupportedEncoding() {
        StringAppender stringAppender = new StringAppender(0, "invalid");
        stringAppender.append("a".getBytes()[0]);
        char[] expected = new char[15];
        expected[0] = 97;
        Assert.assertArrayEquals((char[])expected, (char[])stringAppender.toChars());
    }

    @Test
    public void testToString() {
        StringAppender stringAppender = new StringAppender();
        stringAppender.append("a".getBytes()[0]);
        Assert.assertEquals((Object)"a", (Object)stringAppender.toString());
    }

    @Test
    public void testToStringUnsupportedEncoding() {
        StringAppender stringAppender = new StringAppender(0, "invalid");
        stringAppender.append("a".getBytes()[0]);
        Assert.assertEquals((Object)"a", (Object)stringAppender.toString());
    }

    @Test
    public void testReset() {
        StringAppender stringAppender = new StringAppender("abc");
        Assert.assertEquals((long)3L, (long)stringAppender.length());
        stringAppender.reset();
        Assert.assertEquals((long)0L, (long)stringAppender.length());
    }

    @Test
    public void testSubSequence() {
        StringAppender stringAppender = new StringAppender("abcd");
        Assert.assertEquals((Object)"bc", (Object)stringAppender.subSequence(1, 3));
    }
}

