/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2;

import org.mvel2.CompileException;
import org.mvel2.ScriptExecutionStoppedException;
import org.mvel2.ScriptMemoryOverflowException;
import org.mvel2.ScriptRuntimeException;
import org.mvel2.ast.ASTNode;
import org.mvel2.ast.DoNode;
import org.mvel2.ast.DoUntilNode;
import org.mvel2.ast.ForEachNode;
import org.mvel2.ast.ForNode;
import org.mvel2.ast.Function;
import org.mvel2.ast.LineLabel;
import org.mvel2.ast.WhileNode;
import org.mvel2.compiler.CompiledExpression;
import org.mvel2.debug.Debugger;
import org.mvel2.debug.DebuggerContext;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.optimizers.OptimizerFactory;
import org.mvel2.util.ErrorUtil;
import org.mvel2.util.ExecutionStack;
import org.mvel2.util.PropertyTools;

public class MVELRuntime {
    private static ThreadLocal<DebuggerContext> debuggerContext;

    public static Object execute(boolean debugger, CompiledExpression expression, Object ctx, VariableResolverFactory variableFactory) {
        ExecutionStack stk = new ExecutionStack();
        ASTNode tk = expression.getFirstNode();
        if (tk == null) {
            return null;
        }
        ASTNode node = expression.getFirstNode();
        while (node != null) {
            if (node instanceof Function) {
                node.getReducedValueAccelerated(ctx, ctx, variableFactory);
            } else if (node instanceof ForNode || node instanceof ForEachNode || node instanceof WhileNode || node instanceof DoNode || node instanceof DoUntilNode) {
                variableFactory.setFinishBreakFlag(true);
            }
            node = node.nextASTNode;
        }
        try {
            block23: do {
                if (tk.fields == -1) {
                    if (!debugger && !(debugger = MVELRuntime.hasDebuggerContext())) continue;
                    try {
                        debuggerContext.get().checkBreak((LineLabel)tk, variableFactory, expression);
                    }
                    catch (NullPointerException nullPointerException) {}
                    continue;
                }
                if (stk.isEmpty()) {
                    stk.push(tk.getReducedValueAccelerated(ctx, ctx, variableFactory));
                }
                if (variableFactory.tiltFlag()) {
                    if (variableFactory.finishBreakFlag()) {
                        variableFactory.setTiltFlag(false);
                    } else {
                        Object object = stk.pop();
                        return object;
                    }
                }
                Integer operator = tk.getOperator();
                switch (operator) {
                    case 99: 
                    case 117: {
                        variableFactory.setTiltFlag(true);
                        Object object = stk.pop();
                        return object;
                    }
                    case -1: {
                        break;
                    }
                    case 29: {
                        if (!stk.popBoolean().booleanValue()) {
                            while (tk.nextASTNode != null && !(tk = tk.nextASTNode).isOperator(30)) {
                            }
                        }
                        stk.clear();
                        break;
                    }
                    case 30: {
                        Object object = stk.pop();
                        return object;
                    }
                    case 37: {
                        if (tk.nextASTNode == null) continue block23;
                        stk.clear();
                        break;
                    }
                    default: {
                        stk.push(tk.nextASTNode.getReducedValueAccelerated(ctx, ctx, variableFactory), operator);
                        try {
                            while (stk.isReduceable()) {
                                if ((Integer)stk.peek() == 23) {
                                    stk.pop();
                                    Object v1 = stk.pop();
                                    Object v2 = stk.pop();
                                    if (!PropertyTools.isEmpty(v2) || !PropertyTools.isEmpty(v1)) {
                                        stk.clear();
                                        stk.push(!PropertyTools.isEmpty(v2) ? v2 : v1);
                                        continue;
                                    }
                                    stk.push(null);
                                    continue;
                                }
                                stk.op();
                            }
                            continue block23;
                        }
                        catch (ClassCastException e) {
                            throw new CompileException("syntax error or incomptable types", new char[0], 0, e);
                        }
                        catch (CompileException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw new CompileException("failed to compileShared sub expression", new char[0], 0, e);
                        }
                    }
                }
            } while ((tk = tk.nextASTNode) != null);
            Object e = stk.peek();
            return e;
        }
        catch (NullPointerException e) {
            if (tk != null && tk.isOperator() && tk.nextASTNode != null) {
                throw new CompileException("incomplete statement: " + tk.getName() + " (possible use of reserved keyword as identifier: " + tk.getName() + ")", tk.getExpr(), tk.getStart());
            }
            throw e;
        }
        catch (Exception e) {
            if (tk != null) {
                if (e instanceof CompileException) {
                    throw ErrorUtil.rewriteIfNeeded((CompileException)e, tk.getExpr(), tk.getStart());
                }
                if (e instanceof ScriptMemoryOverflowException || e instanceof ScriptExecutionStoppedException) {
                    throw e;
                }
                CompileException ce = new CompileException("Invalid statement: " + tk.getName(), tk.getExpr(), tk.getStart(), e);
                if (e instanceof ScriptRuntimeException) {
                    throw new ScriptRuntimeException(ce.getMessage(), e);
                }
                throw ce;
            }
            throw e;
        }
        finally {
            OptimizerFactory.clearThreadAccessorOptimizer();
        }
    }

    public static void registerBreakpoint(String source, int line) {
        MVELRuntime.ensureDebuggerContext();
        debuggerContext.get().registerBreakpoint(source, line);
    }

    public static void removeBreakpoint(String source, int line) {
        if (MVELRuntime.hasDebuggerContext()) {
            debuggerContext.get().removeBreakpoint(source, line);
        }
    }

    public static boolean hasDebuggerContext() {
        return debuggerContext != null && debuggerContext.get() != null;
    }

    private static void ensureDebuggerContext() {
        if (debuggerContext == null) {
            debuggerContext = new ThreadLocal();
        }
        if (debuggerContext.get() == null) {
            debuggerContext.set(new DebuggerContext());
        }
    }

    public static void clearAllBreakpoints() {
        if (MVELRuntime.hasDebuggerContext()) {
            debuggerContext.get().clearAllBreakpoints();
        }
    }

    public static boolean hasBreakpoints() {
        return MVELRuntime.hasDebuggerContext() && debuggerContext.get().hasBreakpoints();
    }

    public static void setThreadDebugger(Debugger debugger) {
        MVELRuntime.ensureDebuggerContext();
        debuggerContext.get().setDebugger(debugger);
    }

    public static void resetDebugger() {
        debuggerContext = null;
    }
}

