/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.tests.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.TestCase;
import org.junit.Assert;
import org.mvel2.CompileException;
import org.mvel2.ExecutionContext;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.SandboxedParserConfiguration;
import org.mvel2.ScriptMemoryOverflowException;
import org.mvel2.ScriptRuntimeException;
import org.mvel2.execution.ExecutionArrayList;
import org.mvel2.execution.ExecutionHashMap;
import org.mvel2.optimizers.OptimizerFactory;
import org.mvel2.util.MethodStub;

public class TbExpressionsTest
extends TestCase {
    private static final Comparator numericCompAsc = new Comparator(){

        public int compare(Object o1, Object o2) {
            Double first = Double.parseDouble(String.valueOf(o1));
            Double second = Double.parseDouble(String.valueOf(o2));
            return first.compareTo(second);
        }
    };
    private SandboxedParserConfiguration parserConfig;
    private ExecutionContext currentExecutionContext;

    protected void setUp() throws Exception {
        OptimizerFactory.setDefaultOptimizer((String)OptimizerFactory.SAFE_REFLECTIVE);
        super.setUp();
        this.parserConfig = ParserContext.enableSandboxedMode();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        ParserContext.disableSandboxedMode();
    }

    public void testCreateSingleValueArray() {
        Object res = this.executeScript("m = {5}; m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof List));
        TbExpressionsTest.assertEquals((int)1, (int)((List)res).size());
        TbExpressionsTest.assertEquals((Object)5, ((List)res).get(0));
    }

    public void testCreateMap() {
        Object res = this.executeScript("m = {a: 1}; m.a");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)1, (Object)res);
    }

    public void testCreateEmptyMapAndAssignField() {
        Object res = this.executeScript("m = {}; m.test = 1; m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Map));
        TbExpressionsTest.assertEquals((int)1, (int)((Map)res).size());
        TbExpressionsTest.assertEquals((Object)1, ((Map)res).get("test"));
    }

    public void testAssignmentWhitespaces() {
        Object res = this.executeScript("var m= 2; m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)2, (Object)res);
        res = this.executeScript("var m=2; m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)2, (Object)res);
        res = this.executeScript("var m =2; m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)2, (Object)res);
        res = this.executeScript("m=2; m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)2, (Object)res);
        res = this.executeScript("m= 2; m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)2, (Object)res);
        res = this.executeScript("int m= 2; m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)2, (Object)res);
        res = this.executeScript("int m=2; m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)2, (Object)res);
        res = this.executeScript("int m=2; m=3; m= 4; m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)4, (Object)res);
        res = this.executeScript("int m=2; m+=3; m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)5, (Object)res);
        res = this.executeScript("int m=2; m +=3; m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)5, (Object)res);
        res = this.executeScript("int m=2; m+= 3; m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)5, (Object)res);
        res = this.executeScript("int m=2; m\n+=\n3; m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)5, (Object)res);
        res = this.executeScript("var \n\n  m= 2;     m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)2, (Object)res);
        res = this.executeScript("var   m= 2;     m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)2, (Object)res);
        res = this.executeScript("var  m= 2;     m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)2, (Object)res);
        res = this.executeScript("var m= 2;     m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)2, (Object)res);
        res = this.executeScript("int   m =  2;     m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)2, (Object)res);
        res = this.executeScript("  \n\n    m  \n\n  =  \n\n 2;  \n\n   m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)2, (Object)res);
        res = this.executeScript("  \n\n  var \n\n  m  \n\n  =  \n\n 2;  \n\n   m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)2, (Object)res);
    }

    public void testNonExistentMapField() {
        Object res = this.executeScript("m = {}; t = m.test; t");
        TbExpressionsTest.assertNull((Object)res);
    }

    public void testEqualsOperator() {
        Object res = this.executeScript("m = 'abc'; m === 'abc'");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Boolean));
        TbExpressionsTest.assertTrue((boolean)((Boolean)res));
        res = this.executeScript("m = 'abc'; m = 1; m == 1");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Boolean));
        TbExpressionsTest.assertTrue((boolean)((Boolean)res));
    }

    public void testFunctionOrder() {
        Object res = this.executeScript("function testFunc(m) {m.a +=1;} m = {a: 1}; testFunc(m);   m.a");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)2, (Object)res);
        res = this.executeScript("m = {a: 1}; testFunc(m); function testFunc(m) {m.a +=1;}  m.a");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)2, (Object)res);
    }

    public void testVariableScope() {
        Object res = this.executeScript("var m = 25; function testFunc(a) {   function testFunc3(e) {       var m;       m = e + 5\n;        return m   };   var t = 2;\n   m = a * t;   return testFunc3(testFunc2(m + t));}function testFunc2(b) {   var c = 3;m = b * c; return m;}function testFunc4(m) {   return m * 2;}var m2 = m + testFunc(m); \nreturn testFunc4(m2)");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)372, (Object)res);
        res = this.executeScript("var array = [1, 2, 3];\nfunction sum(array){\n    var result = 0;\n    for(int i = 0; i < array.length; i++){\n        result += array[i];\n        var element = array[i];\n        result += element;\n    }\n    return result;\n}\nreturn sum(array)");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)12, (Object)res);
        res = this.executeScript("var array = [1, 2, 3];\n    var result = 0;\n    for(int i = 0; i < array.length; i++){\n        result += array[i];\n        var element = array[i];\n        result += element;\n    }\nreturn result");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)12, (Object)res);
        res = this.executeScript("var array = [1, 2, 3];\nfunction sum(array){\n    var result = 0;\n    var i = 0;\n    while(i < array.length){\n        result += array[i];\n        var element = array[i];\n        result += element;\n        i++;\n    }\n    return result;\n}\nreturn sum(array)");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)12, (Object)res);
        res = this.executeScript("var array = [1, 2, 3];\n    var result = 0;\n    var i = 0;\n    while(i < array.length){\n        result += array[i];\n        var element = array[i];\n        result += element;\n        i++;\n    }\nreturn result");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)12, (Object)res);
    }

    public void testComments() {
        Object res = this.executeScript("//var df = sdfsdf; \n // test comment: comment2 \n m = {\n// c: d, \n /* e: \n\nf, */ a: 2 }; m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof HashMap));
        TbExpressionsTest.assertEquals((int)1, (int)((Map)res).size());
        TbExpressionsTest.assertEquals((Object)2, ((Map)res).get("a"));
    }

    public void testStopExecution() throws Exception {
        AtomicReference capturedException = new AtomicReference();
        CountDownLatch countDown = new CountDownLatch(1);
        Thread thread = new Thread(() -> {
            try {
                this.executeScript("t = 0; while(true) { t  = 1}; t");
            }
            catch (Exception e) {
                capturedException.set(e);
            }
            finally {
                countDown.countDown();
            }
        });
        thread.start();
        boolean result = countDown.await(500L, TimeUnit.MILLISECONDS);
        TbExpressionsTest.assertFalse((boolean)result);
        this.currentExecutionContext.stop();
        result = countDown.await(500L, TimeUnit.MILLISECONDS);
        TbExpressionsTest.assertTrue((boolean)result);
        Exception exception = (Exception)capturedException.get();
        TbExpressionsTest.assertNotNull((Object)exception);
        TbExpressionsTest.assertEquals((String)"Script execution is stopped!", (String)exception.getMessage());
    }

    public void testMemoryOverflowVariable() {
        long memoryLimit = 0x500000L;
        try {
            this.executeScript("t = 'abc'; while(true) { t  += t}; t", new HashMap(), new ExecutionContext(this.parserConfig, memoryLimit));
            TbExpressionsTest.fail((String)"Should throw ScriptMemoryOverflowException");
        }
        catch (ScriptMemoryOverflowException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Script memory overflow"));
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("" + memoryLimit));
        }
    }

    public void testMemoryOverflowInnerVariable() {
        long memoryLimit = 0x500000L;
        try {
            this.executeScript("doMemoryOverflow(); function doMemoryOverflow() { var t = 'abc'; while(true) { t  += t}; } ", new HashMap(), new ExecutionContext(this.parserConfig, memoryLimit));
            TbExpressionsTest.fail((String)"Should throw ScriptMemoryOverflowException");
        }
        catch (ScriptMemoryOverflowException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Script memory overflow"));
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("" + memoryLimit));
        }
    }

    public void testMemoryOverflowInnerMap1() {
        long memoryLimit = 0x500000L;
        try {
            this.executeScript("m = {}; m.put('a', {}); i =0; while(true) { m.get('a').put(i++, 'aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa' + Math.random());}; m", new HashMap(), new ExecutionContext(this.parserConfig, memoryLimit));
            TbExpressionsTest.fail((String)"Should throw ScriptMemoryOverflowException");
        }
        catch (ScriptMemoryOverflowException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Script memory overflow"));
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("" + memoryLimit));
        }
    }

    public void testMemoryOverflowInnerMap2() {
        long memoryLimit = 0x500000L;
        try {
            this.executeScript("m = {}; m.a = {}; i =0; while(true) { m.a[i++] = 'aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa' + Math.random();}; m", new HashMap(), new ExecutionContext(this.parserConfig, memoryLimit));
            TbExpressionsTest.fail((String)"Should throw ScriptMemoryOverflowException");
        }
        catch (ScriptMemoryOverflowException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Script memory overflow"));
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("" + memoryLimit));
        }
    }

    public void testMemoryOverflowArray() {
        long memoryLimit = 0x500000L;
        try {
            this.executeScript("m = []; i =0; while(true) { m.add('aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa' + Math.random())}; m", new HashMap(), new ExecutionContext(this.parserConfig, memoryLimit));
            TbExpressionsTest.fail((String)"Should throw ScriptMemoryOverflowException");
        }
        catch (ScriptMemoryOverflowException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Script memory overflow"));
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("" + memoryLimit));
        }
    }

    public void testMemoryOverflowArrayInnerMap() {
        long memoryLimit = 0x500000L;
        try {
            this.executeScript("m = [1]; m[0] = {}; i =0; while(true) { m[0].put(i++, 'aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa' + Math.random())}; m", new HashMap(), new ExecutionContext(this.parserConfig, memoryLimit));
            TbExpressionsTest.fail((String)"Should throw ScriptMemoryOverflowException");
        }
        catch (ScriptMemoryOverflowException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Script memory overflow"));
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("" + memoryLimit));
        }
    }

    public void testMemoryOverflowAddAll() throws Exception {
        long memoryLimit = 0x500000L;
        try {
            this.executeScript("a = ['aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa']; b = []; while(true) { b.addAll(a)}; m", new HashMap(), new ExecutionContext(this.parserConfig, memoryLimit), 10000L);
            TbExpressionsTest.fail((String)"Should throw ScriptMemoryOverflowException");
        }
        catch (ScriptMemoryOverflowException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Script memory overflow"));
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("" + memoryLimit));
        }
    }

    public void testArrayMemoryOverflow() {
        long memoryLimit = 0x500000L;
        try {
            this.executeScript("m = new byte[5 * 1024 * 1024]; m", new HashMap(), new ExecutionContext(this.parserConfig, memoryLimit));
            TbExpressionsTest.fail((String)"Should throw ScriptMemoryOverflowException");
        }
        catch (ScriptMemoryOverflowException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Max array length overflow"));
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("" + memoryLimit / 2L));
        }
    }

    public void testMethodArgumentsLength() {
        long memoryLimit = 0x500000L;
        int argsLimit = 5;
        try {
            this.executeScript("var s = '%s'; for (var i = 0; i < 20; i++) { s = s + s; }\n\nreturn '\\n12Result is :\\n' + String.format(s, s, s, s, s, s, s, s, s, s, s);", new HashMap(), new ExecutionContext(this.parserConfig, memoryLimit, argsLimit));
            TbExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Maximum method arguments count overflow"));
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("" + argsLimit));
        }
    }

    public void testMethodInvocationForStringRepeat() {
        long memoryLimit = 0x500000L;
        try {
            this.executeScript("'a'.repeat(Integer.MAX_VALUE-100)", new HashMap(), new ExecutionContext(this.parserConfig, memoryLimit));
            TbExpressionsTest.fail((String)"Should throw ScriptMemoryOverflowException");
        }
        catch (ScriptMemoryOverflowException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Max string length overflow"));
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("" + memoryLimit / 2L));
        }
    }

    public void testMethodInvocationForStringConcat() {
        long memoryLimit = 0x500000L;
        try {
            this.executeScript("var toConcat = 'a'.repeat(5 * 1024 * 1024 / 2 - 'abc'.length() + 1); 'abc'.concat(toConcat);", new HashMap(), new ExecutionContext(this.parserConfig, memoryLimit));
            TbExpressionsTest.fail((String)"Should throw ScriptMemoryOverflowException");
        }
        catch (ScriptMemoryOverflowException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Max string length overflow"));
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("" + memoryLimit / 2L));
        }
    }

    public void testMethodInvocationForStringReplace() {
        long memoryLimit = 0x500000L;
        try {
            this.executeScript("var repl = 'a'.repeat(5 * 1024 * 1024 / 100 + 1); 'abc'.replace('a', repl);", new HashMap(), new ExecutionContext(this.parserConfig, memoryLimit));
            TbExpressionsTest.fail((String)"Should throw ScriptMemoryOverflowException");
        }
        catch (ScriptMemoryOverflowException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Max replacement length overflow"));
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("" + memoryLimit / 100L));
        }
        try {
            this.executeScript("var repl = 'a'.repeat(5 * 1024 * 1024 / 100 + 1); 'abc'.replaceAll('a', repl);", new HashMap(), new ExecutionContext(this.parserConfig, memoryLimit));
            TbExpressionsTest.fail((String)"Should throw ScriptMemoryOverflowException");
        }
        catch (ScriptMemoryOverflowException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Max replacement length overflow"));
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("" + memoryLimit / 100L));
        }
    }

    public void testForbidCustomObjects() {
        try {
            this.executeScript("m = new java.util.HashMap(); m");
            TbExpressionsTest.fail((String)"Should throw ScriptRuntimeException");
        }
        catch (ScriptRuntimeException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Invalid statement: new java.util.HashMap()"));
        }
    }

    public void testForbiddenMethodAccess() {
        try {
            this.parserConfig.addImport("JSON", MyTestClass.class);
            this.executeScript("JSON.getModule().getClassLoader().loadClass(\"java.lang.Runtime\")");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("unable to resolve method: " + MyTestClass.class.getName() + ".getModule"));
        }
    }

    public void testForbiddenClassAccess() {
        try {
            this.executeScript("new StringBuffer();");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("could not resolve class: StringBuffer"));
        }
        try {
            this.executeScript("new java.lang.StringBuffer();");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("could not resolve class: java.lang.StringBuffer"));
        }
        try {
            this.executeScript("new StringBuilder();");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("could not resolve class: StringBuilder"));
        }
        try {
            this.executeScript("new java.lang.StringBuilder();");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("could not resolve class: java.lang.StringBuilder"));
        }
        try {
            this.executeScript("\n\nClass c;");
            TbExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("unknown class or illegal statement: Class"));
        }
        try {
            this.executeScript("m = {5}; System.exit(-1); m");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("unresolvable property or identifier: System"));
        }
        try {
            this.executeScript("m = {5}; for (int i=0;i<10;i++) {System.exit(-1);}; m");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("unresolvable property or identifier: System"));
        }
        try {
            this.executeScript("m = {5}; function test() {System.exit(-1);}; test(); m");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("unresolvable property or identifier: System"));
        }
        try {
            this.executeScript("m = {5}; exit(-1); m");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("function not found: exit"));
        }
        try {
            this.executeScript("m = {5}; java.lang.System.exit(-1); m");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("unresolvable property or identifier: java"));
        }
        try {
            this.executeScript("m = {5}; Runtime.getRuntime().exec(\"echo hi\"); m");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("unresolvable property or identifier: Runtime"));
        }
        try {
            this.executeScript("m = {5}; m.getClass().getClassLoader()");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("unable to resolve method: getClass()"));
        }
        try {
            this.executeScript("Array.newInstance(Object, 1000, 1000, 1000, 1000);");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("unresolvable property or identifier: Array"));
        }
        try {
            this.executeScript("m = {5}; m.class");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("could not access property: class"));
        }
        try {
            this.executeScript("m = new java.io.File(\"password.txt\").exists(); m");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("could not resolve class: java.io.File"));
        }
        try {
            this.executeScript("m = MVEL.eval(\"System.exit(-1);\"); m");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("unresolvable property or identifier: MVEL"));
        }
        try {
            this.executeScript("m = org.mvel2.MVEL.eval(\"System.exit(-1);\"); m");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("unresolvable property or identifier: org"));
        }
        try {
            this.executeScript("java.util.concurrent.Executors.newFixedThreadPool(2)");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("unresolvable property or identifier: java"));
        }
        Object res = this.executeScript("m = {class: 5}; m.class");
        TbExpressionsTest.assertNotNull((Object)res);
        TbExpressionsTest.assertEquals((Object)5, (Object)res);
    }

    public void testForbidImport() {
        try {
            this.executeScript("import java.util.HashMap; m = new HashMap(); m.put('t', 10); m");
            TbExpressionsTest.fail((String)"Should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Import is forbidden!"));
        }
    }

    public void testPrimitiveArray() {
        Object res = this.executeScript("var m = new byte[1000]; m[5] = 1; m[500] = 20; m[40] = 0x0B; m");
        TbExpressionsTest.assertNotNull((Object)res);
        TbExpressionsTest.assertTrue((boolean)(res instanceof List));
        TbExpressionsTest.assertEquals((int)1000, (int)((List)res).size());
        TbExpressionsTest.assertEquals((Object)1, ((List)res).get(5));
        TbExpressionsTest.assertEquals((Object)20, ((List)res).get(500));
        TbExpressionsTest.assertEquals((Object)11, ((List)res).get(40));
        res = this.executeScript("var m = 'Hello world'; a = m.toCharArray(); a");
        TbExpressionsTest.assertNotNull((Object)res);
        TbExpressionsTest.assertTrue((boolean)(res instanceof List));
        Object[] boxedArray = ((List)res).toArray();
        int len = boxedArray.length;
        char[] array = new char[len];
        for (int i = 0; i < len; ++i) {
            array[i] = ((Character)boxedArray[i]).charValue();
        }
        TbExpressionsTest.assertEquals((String)"Hello world", (String)String.valueOf(array));
        res = this.executeScript("var m = new int[]{1, 2, 3}; m");
        TbExpressionsTest.assertNotNull((Object)res);
        TbExpressionsTest.assertTrue((boolean)(res instanceof List));
        TbExpressionsTest.assertEquals((int)3, (int)((List)res).size());
        TbExpressionsTest.assertEquals((Object)1, ((List)res).get(0));
        TbExpressionsTest.assertEquals((Object)2, ((List)res).get(1));
        TbExpressionsTest.assertEquals((Object)3, ((List)res).get(2));
    }

    public void testByteOperations() {
        Object res = this.executeScript("var m = new byte[]{(byte)0x0F,(byte)0x02}; b = m[0] == 0x0F; b");
        TbExpressionsTest.assertNotNull((Object)res);
        TbExpressionsTest.assertTrue((boolean)(res instanceof Boolean));
        TbExpressionsTest.assertTrue((boolean)((Boolean)res));
        res = this.executeScript("var a = 0x0F; b = 0x0A; c = a + b; c");
        TbExpressionsTest.assertNotNull((Object)res);
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)25, (Object)res);
        res = this.executeScript("var a = (byte)0x0F; b = a << 24 >> 16; b");
        TbExpressionsTest.assertNotNull((Object)res);
        TbExpressionsTest.assertEquals((Object)3840, (Object)res);
    }

    public void testUnterminatedStatement() {
        Object res = this.executeScript("var a = \"A\";\nvar b = \"B\"\n;var c = \"C\"\n;result = a + b\n;result = c\t\n;\n{msg: result, \n\nmetadata: {}, msgType: ''}");
        TbExpressionsTest.assertNotNull((Object)res);
        TbExpressionsTest.assertTrue((boolean)(res instanceof Map));
        TbExpressionsTest.assertEquals((Object)"C", ((Map)res).get("msg"));
        try {
            this.executeScript("var a = \"A\";\nvar b = \"B\"\n;var c = \"C\"\n;result = a + b\n;result = c\n\n{msg: result, \n\nmetadata: {}, msgType: ''}");
            TbExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().equals("[Error: Unterminated statement!]\n[Near : {... ;result = c ....}]\n                       ^\n[Line: 5, Column: 11]"));
        }
    }

    public void testStringTermination() {
        Object res = this.executeScript("var c = 'abc' + \n'def1' + ('a' + 'b') + \n 'def2';\n c");
        TbExpressionsTest.assertNotNull((Object)res);
        TbExpressionsTest.assertEquals((Object)"abcdef1abdef2", (Object)res);
    }

    public void testRuntimeAndCompileErrors() {
        try {
            this.executeScript("threshold = def (x) { x >= 10 ? x : 0 };\nresult = cost + threshold(lowerBound);");
            TbExpressionsTest.fail((String)"Should throw ScriptRuntimeException");
        }
        catch (ScriptRuntimeException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().equals("[Error: Invalid statement: def (x) { x >= 10 ? x : 0 }]\n[Near : {... threshold = def (x) { x >= 10 ? x : 0 }; ....}]\n                         ^\n[Line: 1, Column: 13]"));
        }
        try {
            this.executeScript("a = [1,2;\n");
            TbExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().equals("[Error: unbalanced braces [ ... ]]\n[Near : {... a = [1,2; ....}]\n                 ^\n[Line: 1, Column: 5]"));
        }
        try {
            this.executeScript("a = [1,2];\n function c(a) {\nvar b = 0;\nb += a[0].toInt();\nreturn b;}\n c(a);");
            TbExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().equals("[Error: unable to resolve method: java.lang.Integer.toInt() [arglength=0]]\n[Near : {... b += a[0].toInt(); ....}]\n                 ^\n[Line: 4, Column: 5]"));
        }
    }

    public void testUseClassImport() {
        try {
            this.executeScript("MyTestUtil.getFoo({foo: 'foo-bar'})");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            junit.framework.Assert.assertTrue((boolean)e.getMessage().contains("unresolvable property or identifier: MyTestUtil"));
        }
        this.parserConfig.addImport("MyTestUtil", TestUtil.class);
        Object res = this.executeScript("MyTestUtil.getFoo({foo: 'foo-bar'})");
        TbExpressionsTest.assertEquals((Object)"foo-bar", (Object)res);
        res = this.executeScript("MyTestUtil.getFoo({})");
        TbExpressionsTest.assertEquals((Object)"Not found!", (Object)res);
        res = this.executeScript("MyTestUtil.methodWithExecContext('key1', 'val1')");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Map));
        TbExpressionsTest.assertEquals((Object)"val1", ((Map)res).get("key1"));
        res = this.executeScript("MyTestUtil.methodWithExecContext2('key2', 'val2')");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Map));
        TbExpressionsTest.assertEquals((Object)"val2", ((Map)res).get("key2"));
        res = this.executeScript("MyTestUtil.methodWithExecContext3('key3', 'val3')");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Map));
        TbExpressionsTest.assertEquals((Object)"val3", ((Map)res).get("key3"));
        res = this.executeScript("MyTestUtil.methodWithExecContextVarArgs('a1', 'a2', 'a3', 'a4', 'a5')");
        TbExpressionsTest.assertTrue((boolean)(res instanceof List));
        TbExpressionsTest.assertEquals((int)5, (int)((List)res).size());
        Assert.assertArrayEquals((Object[])new String[]{"a1", "a2", "a3", "a4", "a5"}, (Object[])((List)res).toArray(new String[5]));
    }

    public void testUseStaticMethodImport() throws Exception {
        this.parserConfig.addImport("getFoo", new MethodStub(TestUtil.class.getMethod("getFoo", Map.class)));
        Object res = this.executeScript("getFoo({foo: 'foo-bar'})");
        TbExpressionsTest.assertEquals((Object)"foo-bar", (Object)res);
        res = this.executeScript("getFoo({})");
        TbExpressionsTest.assertEquals((Object)"Not found!", (Object)res);
        try {
            this.executeScript("currentTimeMillis()");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            junit.framework.Assert.assertTrue((boolean)e.getMessage().contains("function not found: currentTimeMillis"));
        }
        this.parserConfig.addImport("currentTimeMillis", new MethodStub(System.class.getMethod("currentTimeMillis", new Class[0])));
        res = this.executeScript("currentTimeMillis()");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Long));
        TbExpressionsTest.assertEquals((long)(System.currentTimeMillis() / 100L), (long)((Long)res / 100L));
        this.parserConfig.addImport("methodWithExecContext", new MethodStub(TestUtil.class.getMethod("methodWithExecContext", String.class, Object.class, ExecutionContext.class)));
        res = this.executeScript("methodWithExecContext('key1', 'val1')");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Map));
        TbExpressionsTest.assertEquals((Object)"val1", ((Map)res).get("key1"));
        this.parserConfig.addImport("methodWithExecContext2", new MethodStub(TestUtil.class.getMethod("methodWithExecContext2", String.class, ExecutionContext.class, Object.class)));
        res = this.executeScript("methodWithExecContext2('key2', 'val2')");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Map));
        TbExpressionsTest.assertEquals((Object)"val2", ((Map)res).get("key2"));
        this.parserConfig.addImport("methodWithExecContext3", new MethodStub(TestUtil.class.getMethod("methodWithExecContext3", ExecutionContext.class, String.class, Object.class)));
        res = this.executeScript("methodWithExecContext3('key3', 'val3')");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Map));
        TbExpressionsTest.assertEquals((Object)"val3", ((Map)res).get("key3"));
        this.parserConfig.addImport("methodWithExecContextVarArgs", new MethodStub(TestUtil.class.getMethod("methodWithExecContextVarArgs", ExecutionContext.class, Object[].class)));
        res = this.executeScript("methodWithExecContextVarArgs('a1', 'a2', 'a3', 'a4', 'a5')");
        TbExpressionsTest.assertTrue((boolean)(res instanceof List));
        TbExpressionsTest.assertEquals((int)5, (int)((List)res).size());
        Assert.assertArrayEquals((Object[])new String[]{"a1", "a2", "a3", "a4", "a5"}, (Object[])((List)res).toArray(new String[5]));
    }

    public void testRegisterDataType() {
        try {
            this.executeScript("var t = new MyTest('test val'); t");
            TbExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            junit.framework.Assert.assertTrue((boolean)e.getMessage().contains("could not resolve class: MyTest"));
        }
        this.parserConfig.registerDataType("MyTest", MyTestClass.class, val -> val.getValue().getBytes().length);
        Object res = this.executeScript("var t = new MyTest('test val'); t");
        TbExpressionsTest.assertTrue((boolean)(res instanceof MyTestClass));
        TbExpressionsTest.assertEquals((String)"test val", (String)((MyTestClass)res).getValue());
        try {
            this.executeScript("var t = new MyTest('test val'); t", new HashMap(), new ExecutionContext(this.parserConfig, 7L));
            TbExpressionsTest.fail((String)"Should throw ScriptMemoryOverflowException");
        }
        catch (ScriptMemoryOverflowException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Script memory overflow"));
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("8 > 7"));
        }
    }

    public void testDate() {
        Object res = this.executeScript("var t = new java.util.Date(); t");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Date));
        TbExpressionsTest.assertEquals((long)(System.currentTimeMillis() / 100L), (long)(((Date)res).getTime() / 100L));
        res = this.executeScript("var t = new java.util.Date(); var m = {date: t}; m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Map));
        TbExpressionsTest.assertTrue((boolean)(((Map)res).get("date") instanceof Date));
    }

    public void testIdIdJsFormat() {
        String scriptBodyTestIdIdPointStr = "var msg = {};\nvar msg_sub = {};\nmsg_sub[\"entityGroup\"] = \"ENTITY_GROUP\";\nmsg_sub[\"id2\"] = \"4e7b7e10-c27d-11ed-a0ab-058763ffd58e\";\nmsg[\"id1\"] =  msg_sub;\nreturn {\n    msg: {\n        entryPoint_bad: \"/api/entityGroup/\" + msg.id1.id2\n    }\n};";
        String scriptBodyTestIdIdJsFormatStr = "var msg = {};\nvar msg_sub = {};\nmsg_sub[\"entityGroup\"] = \"ENTITY_GROUP\";\nmsg_sub[\"id2\"] = \"4e7b7e10-c27d-11ed-a0ab-058763ffd58e\";\nmsg[\"id1\"] =  msg_sub;\nreturn {\n    msg: {\n        entryPoint_bad: \"/api/entityGroup/\" + msg[\"id1\"][\"id2\"]\n    }\n};";
        Object actual = this.executeScript(scriptBodyTestIdIdJsFormatStr);
        Object expected = this.executeScript(scriptBodyTestIdIdPointStr);
        TbExpressionsTest.assertEquals((Object)expected, (Object)actual);
    }

    public void testSwitchNodeStandardCaseOneValue_Ok() {
        String scriptBodyTestSwitchNodeStr = "\nvar msg = {};\nmsg[\"temperature\"] = 120;\nswitch (msg.temperature){\n    case 120.0:\n        msg.temperature = 1.0;\n         break;\n    case 241:\n        msg.temperature = 2.0;\n        break;\n    default:\n        msg.temperature = 3.0;\n\n}\nreturn {temp: msg.temperature};\n";
        LinkedHashMap<String, Double> expected = new LinkedHashMap<String, Double>();
        Double dd = 1.0;
        expected.put("temp", dd);
        Object actual = this.executeScript(scriptBodyTestSwitchNodeStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testSwitchNodeStandardCaseTwoValue_Ok() {
        String scriptBodyTestSwitchNodeStr = "\nvar msg = {};\nmsg[\"temperature\"] = 241;\nswitch (msg.temperature){\n    case 120.0:\n        msg.temperature = 1.0;\n         break;\n    case 241:\n        msg.temperature = 2.0;\n        break;\n    default:\n        msg.temperature = 3.0;\n\n}\nreturn {temp: msg.temperature};\n";
        LinkedHashMap<String, Double> expected = new LinkedHashMap<String, Double>();
        Double dd = 2.0;
        expected.put("temp", dd);
        Object actual = this.executeScript(scriptBodyTestSwitchNodeStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testSwitchNodeStandardDefault_Ok() {
        String scriptBodyTestSwitchNodeStr = "\nvar msg = {};\nmsg[\"temperature\"] = 130.0;\nswitch (msg.temperature){\n    case 120.0:\n        msg.temperature = 1.0;\n         break;\n    case 241:\n        msg.temperature = 2.0;\n        break;\n    default:\n        msg.temperature = msg.temperature;\n\n}\nreturn {temp: msg.temperature};\n";
        LinkedHashMap<String, Double> expected = new LinkedHashMap<String, Double>();
        Double dd = 130.0;
        expected.put("temp", dd);
        Object actual = this.executeScript(scriptBodyTestSwitchNodeStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testSwitchNodeOnlyCase_Ok() {
        String scriptBodyTestSwitchNodeStr = "\nvar msg = {};\nmsg[\"temperature\"] = 120.0;\nswitch (msg.temperature){\n    case 120.0:\n        msg.temperature = 1.0;\n\n}\nreturn {temp: msg.temperature};\n";
        LinkedHashMap<String, Double> expected = new LinkedHashMap<String, Double>();
        Double dd = 1.0;
        expected.put("temp", dd);
        Object actual = this.executeScript(scriptBodyTestSwitchNodeStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testSwitchNodeCaseDoubleValue_Ok() {
        String scriptBodyTestSwitchNodeStr = "\nvar msg = {};\nmsg[\"temperature\"] = 123;\nswitch (msg.temperature){\n    case 120.0:\n    case 123.0:\n    case 126.0:\n        msg.temperature = 1.0;\n         break;\n    case 241:\n        msg.temperature = 2.0;\n        break;\n    default:\n        msg.temperature = 3.0;\n\n}\nreturn {temp: msg.temperature};\n";
        LinkedHashMap<String, Double> expected = new LinkedHashMap<String, Double>();
        Double dd = 1.0;
        expected.put("temp", dd);
        Object actual = this.executeScript(scriptBodyTestSwitchNodeStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testSwitchNodeSwitchInSwitch_Ok() {
        String scriptBodyTestSwitchNodeStr = "\nvar msg = {};\nmsg[\"temperature\"] = 19.0;\nvar a = 25;\n\nif (msg.temperature === 19){\n    msg.temperature = 20.0;\n} else if (msg.temperature === 24){\n    msg.temperature = 23.11;\n}  else {\n    msg.temperature = msg.temperature;\n}\n\nswitch (msg.temperature){\n    case 20.0:\n    case 120.0:\n         switch (msg.temperature){\n            case 122.4:\n            case 100.0:\n                 msg.temperature = 130.1;\n                 break;\n            case 112.0:\n                msg.temperature = 101;\n                break;\n            case 20.0:\n                msg.temperature = 105.6789;\n                msg.temperature += a;\n                msg.temperature = msg.temperature/2;\n                break;\n           default:\n                msg.temperature = 105.6789;\n                msg.temperature += a;\n                msg.temperature = msg.temperature/2;\n        }\n         break;\n    case 12.0:\n        msg.temperature = 1;\n        break;\n    case 15.0:\n        msg.temperature = 5;\n        break;\n    default:\n        msg.temperature = 2;\n\n}\nreturn {temp: msg.temperature};\n";
        LinkedHashMap<String, Double> expected = new LinkedHashMap<String, Double>();
        Double dd = 65.33945;
        expected.put("temp", dd);
        Object actual = this.executeScript(scriptBodyTestSwitchNodeStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testSwitchNodeParameterString_Ok() {
        String scriptBodyTestSwitchNodeStr = "\nvar msg = {};\nmsg[\"temperature\"] = 120.0;\nvar par = \"test1\";\n\nswitch (par){\n    case \"test\":\n         msg.temperature = 1.0;\n         break;\n    case \"test1\":\n        msg.temperature = 2.0;\n        break;\n    case 15.0:\n        msg.temperature = 3;\n        break;\n    default:\n        msg.temperature = 4;\n}\nreturn {temp: msg.temperature};\n";
        LinkedHashMap<String, Double> expected = new LinkedHashMap<String, Double>();
        Double dd = 2.0;
        expected.put("temp", dd);
        Object actual = this.executeScript(scriptBodyTestSwitchNodeStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testSwitchNodeInFunctionWithReturn_Ok() {
        String scriptBodyTestSwitchNodeStr = "\nvar msg = {};\nmsg[\"temperature\"] = 120.0;\nvar par = \"test\";\n\nswitch (par){\n    case \"test\":\n         msg.temperature = switchReturn(par) ;\n         return {temp: msg.temperature};\n    case \"test2\":\n         msg.temperature = 1.0;\n}\nreturn {temp: msg.temperature};\nfunction switchReturn(val) {\n    switch (val) {\n        case \"test\":\n            return 48.0;\n        case 12.0:\n            msg.temperature = 4.0 / 2;\n           return 5.0;\n        case 15.0:\n            msg.temperature = 3;\n            break;\n        default:\n            msg.temperature = msg.temperature;\n    }\n    return 48;\n\n}";
        LinkedHashMap<String, Double> expected = new LinkedHashMap<String, Double>();
        Double dd = 48.0;
        expected.put("temp", dd);
        Object actual = this.executeScript(scriptBodyTestSwitchNodeStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testSwitchNodeWithReturnInCase_Ok() {
        String scriptBodyTestSwitchNodeStr = "\nvar msg = {};\nmsg[\"temperature\"] = 120.0;\nvar par = \"test\";\n\nswitch (par){\n    case \"test\":\n         msg.temperature = 3.0;\n         return {temp: msg.temperature};\n    case \"test2\":\n         msg.temperature = 1.0;\n}\nreturn {temp: msg.temperature};\n";
        LinkedHashMap<String, Double> expected = new LinkedHashMap<String, Double>();
        Double dd = 3.0;
        expected.put("temp", dd);
        Object actual = this.executeScript(scriptBodyTestSwitchNodeStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testSwitchNodeWithComments_Ok() {
        String scriptBodyTestSwitchNodeStr = " \n//switch (parCase){\nvar msg = {};\nmsg[\"temperature\"] = 120.0;\nvar parCase = 15.0;\n\nswitch (parCase){\n    case \"test\":\n        /**\n         // commit3\n         **/\n         msg.temperature = 1.0;\n        // bdreak_stop; \n         break;\n    case 12.0:\n        /*\n        commit2\n        \n        */\n        msg.temperature = 4.0;\n        break;\n        // case:;\n    case 15.0:\n        msg.temperature = 3.3;\n        break;\n        // default:;\n    default:\n        msg.temperature = msg.temperature;\n}\nreturn {temp: msg.temperature};\n";
        LinkedHashMap<String, Double> expected = new LinkedHashMap<String, Double>();
        Double dd = 3.3;
        expected.put("temp", dd);
        Object actual = this.executeScript(scriptBodyTestSwitchNodeStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testSwitchNodeParameterNumberAsStringQuotes() {
        String scriptBodyTestSwitchNodeStr = "\nvar msg = {};\nmsg[\"temperature\"] = 120.0;\nvar par = \"203\";\n\nswitch (par){\n    case \"test\":\n         msg.temperature = 1.0;\n         break;\n    case 203:\n        msg.temperature = 2.0;\n        break;\n    case 15.0:\n        msg.temperature = 3;\n        break;\n    default:\n        msg.temperature = 4;\n}\nreturn {temp: msg.temperature};\n";
        LinkedHashMap<String, Double> expected = new LinkedHashMap<String, Double>();
        Double dd = 2.0;
        expected.put("temp", dd);
        Object actual = this.executeScript(scriptBodyTestSwitchNodeStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testSwitchNodeWithoutDefault() {
        String scriptBodyTestSwitchNodeStr = "\nvar msg = {};\nmsg[\"temperature\"] = 115.0;\nvar a = 25;\n\nif (msg.temperature === 19){\n    msg.temperature = 19;\n} else if (msg.temperature === 24){\n    msg.temperature = 23.11;\n}  else {\n    msg.temperature = msg.temperature;\n}\n\nswitch (msg.temperature){\n    case 115.0:\n    case 10.0:\n         switch (msg.temperature){\n            case 122.4:\n            case 10.0:\n                 msg.temperature = 130.1;\n                 break;\n            case 112.0:\n                msg.temperature = 101;\n                break;\n            case 115.0:\n                msg.temperature = 105.6789;\n                msg.temperature += a;\n                msg.temperature = msg.temperature/2;\n        }\n         break;\n    case 12.0:\n        msg.temperature = 1;\n        break;\n    case 15.0:\n        msg.temperature = 5;\n        break;\n    default:\n        msg.temperature = 2;\n\n}\nreturn {temp: msg.temperature};\n";
        LinkedHashMap<String, Double> expected = new LinkedHashMap<String, Double>();
        Double dd = 65.33945;
        expected.put("temp", dd);
        Object actual = this.executeScript(scriptBodyTestSwitchNodeStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testSwitchNodeParameterStringWithoutEscapingQuotes_Error() {
        String scriptBodyTestSwitchNodeStr = "\nvar msg = {};\nmsg[\"temperature\"] = 120.0;\nvar par = \"test1\";\n\nswitch (par){\n    case test:\n         msg.temperature = 1.0;\n         break;\n    case \"test1\":\n        msg.temperature = 2.0;\n        break;\n    case 15.0:\n        msg.temperature = 3;\n        break;\n    default:\n        msg.temperature = 4;\n}\nreturn {temp: msg.temperature};\n";
        LinkedHashMap<String, Double> expected = new LinkedHashMap<String, Double>();
        Double dd = 2.0;
        expected.put("temp", dd);
        try {
            Object actual = this.executeScript(scriptBodyTestSwitchNodeStr);
            TbExpressionsTest.assertEquals(expected, (Object)actual);
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("unresolvable property or identifier: test"));
        }
    }

    public void testSwitchNodeWithout_Bracket_Error() {
        try {
            String scriptBodyTestSwitchNodeStr = "\nvar msg = {};\nmsg[\"temperature\"] = 100.0;\nvar a = 25;\n\nswitch msg.temperature){\n    case 115.0:\n    case 100.0:\n        msg.temperature = 1;\n        break;\n    case 12.0:\n        msg.temperature = 2;\n        break;\n    case 15.0:\n        msg.temperature = 5;\n        break;\n    default:\n        msg.temperature = 6;\n}\nreturn {temp: msg.temperature};\n";
            this.executeScript(scriptBodyTestSwitchNodeStr);
            TbExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Switch without expression or not find start/end of switch block"));
        }
    }

    public void testSwitchNodeWithout_Brace_Error() {
        try {
            String scriptBodyTestSwitchNodeStr = "\nvar msg = {};\nmsg[\"temperature\"] = 100.0;\nvar a = 25;\n\nswitch (msg.temperature) \n    case 115.0:\n    case 100.0:\n        msg.temperature = 1;\n        break;\n    case 12.0:\n        msg.temperature = 2;\n        break;\n    case 15.0:\n        msg.temperature = 5;\n        break;\n    default:\n        msg.temperature = 6;\n}\nreturn {temp: msg.temperature};\n";
            this.executeScript(scriptBodyTestSwitchNodeStr);
            TbExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Switch without expression or not find start/end of switch block"));
        }
    }

    public void testSwitchNodeWithout_BraceClose_Error() {
        try {
            String scriptBodyTestSwitchNodeStr = "\nvar msg = {};\nmsg[\"temperature\"] = 100.0;\nvar a = 25;\n\nswitch (msg.temperature) {\n    case 115.0:\n    case 100.0:\n        msg.temperature = 1;\n        break;\n    case 12.0:\n        msg.temperature = 2;\n        break;\n    case 15.0:\n        msg.temperature = 5;\n        break;\n    default:\n        msg.temperature = 6;\n\nreturn {temp: msg.temperature};\n";
            this.executeScript(scriptBodyTestSwitchNodeStr);
            TbExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("unbalanced braces { ... }"));
        }
    }

    public void testSwitchNodeFailedDefault_Error() {
        try {
            String scriptBodyTestSwitchNodeStr = "\nvar msg = {};\nmsg[\"temperature\"] = 100.0;\nvar a = 25;\n\nswitch (msg.temperature) {\n    case 115.0:\n    case 100.0:\n        msg.temperature = 1;\n        break;\n    case 12.0:\n        msg.temperature = 2;\n        break;\n    case 15.0:\n        msg.temperature = 5;\n        break;\n    default r :\n        msg.temperature = 6;\n}\nreturn {temp: msg.temperature};\n";
            this.executeScript(scriptBodyTestSwitchNodeStr);
            TbExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("after \"default\" expected ':' but encountered: r"));
        }
    }

    public void testSwitchNodeWithoutCaseWithDefault_Error() {
        try {
            String scriptBodyTestSwitchNodeStr = "\nvar msg = {};\nmsg[\"temperature\"] = 100.0;\nvar a = 25;\n\nswitch (msg.temperature) {\n    default:\n        msg.temperature = 6;\n}\nreturn {temp: msg.temperature};\n";
            this.executeScript(scriptBodyTestSwitchNodeStr);
            TbExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("statement expected"));
        }
    }

    public void testSwitchNodeEmpty_Error() {
        try {
            String scriptBodyTestSwitchNodeStr = "\nvar msg = {};\nmsg[\"temperature\"] = 100.0;\nvar a = 25;\n\nswitch (msg.temperature) {\n}\nreturn {temp: msg.temperature};\n";
            this.executeScript(scriptBodyTestSwitchNodeStr);
            TbExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Switch without expression or not find start/end of switch block"));
        }
    }

    public void testSwitchNodeWithoutCaseAndDefault_Error() {
        try {
            String scriptBodyTestSwitchNodeStr = "\nvar msg = {};\nmsg[\"temperature\"] = 100.0;\nvar a = 25;\n\nswitch (msg.temperature) {\nrty\n}\nreturn {temp: msg.temperature};\n";
            this.executeScript(scriptBodyTestSwitchNodeStr);
            TbExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("statement expected"));
        }
    }

    public void testSwitchNode_CaseWithoutSwitch_Error() {
        String scriptBodyTestSwitchNodeStr = "\nvar msg = {};\nmsg[\"temperature\"] = 120;\ncase (msg.temperature){\n    case 120.0:\n        msg.temperature = 1.0;\n         break;\n    case 241:\n        msg.temperature = 2.0;\n        break;\n    default:\n        msg.temperature = 3.0;\n\n}\nreturn {temp: msg.temperature};\n";
        try {
            this.executeScript(scriptBodyTestSwitchNodeStr);
            TbExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("case without switch"));
        }
    }

    public void testSwitchNodeDefaultWithoutCase_Error() {
        String scriptBodyTestSwitchNodeStr = "\nvar msg = {};\nmsg[\"temperature\"] = 120;\nswitch (msg.temperature){\n    default:\n        msg.temperature = 3.0;\n\n}\nreturn {temp: msg.temperature};\n";
        try {
            this.executeScript(scriptBodyTestSwitchNodeStr);
            TbExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("statement expected"));
        }
    }

    public void testSwitchNodeDefaultWithoutSwitch_Error() {
        String scriptBodyTestSwitchNodeStr = "\nvar msg = {};\nmsg[\"temperature\"] = 120;\ndefault (msg.temperature){\n    case 120.0:\n        msg.temperature = 1.0;\n         break;\n    default:\n        msg.temperature = 3.0;\n\n}\nreturn {temp: msg.temperature};\n";
        try {
            this.executeScript(scriptBodyTestSwitchNodeStr);
            TbExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("default without switch"));
        }
    }

    public void testForWithBreakInIf_OnlyBreak() {
        String scriptBodyTestForWithBreakInIfStr = "var y = 0;\nfor (int i =0; i< 100; i++) {\n        y=i;\n        if (i > 2) {\n            break;\n        }\n    }\nreturn {\n    msg: y\n};";
        LinkedHashMap<String, Integer> expected = new LinkedHashMap<String, Integer>();
        expected.put("msg", 3);
        Object actual = this.executeScript(scriptBodyTestForWithBreakInIfStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testForWithBreakInIf_Function() {
        String scriptBodyTestForWithBreakInIfStr = "var input = [1, 2, 3, 4];\nvar output = 10;\nforBreak();\nfunction forBreak() {\n    for (var i = 0; i < input.size; i++) {\n        output = i;\n        if (i === 1) {\n            output = input[i];\n            break;\n        }\n        output = i;\n    }\n}return {\n    msg: output\n};\n";
        LinkedHashMap<String, Integer> expected = new LinkedHashMap<String, Integer>();
        expected.put("msg", 2);
        Object actual = this.executeScript(scriptBodyTestForWithBreakInIfStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testForWithBreakOneFor() {
        String scriptBodyTestForWithBreakInIfStr = "var input = [-1, -7, -3, -4];\nvar output = 9;\nfor (var i = 0; i < input.size; i++) {\n    output = i * 10;\n    if (i === 3) {\n        output = input[i];\n        break;\n        output = i * 100;\n    }\n    output = i * 1000;\n}\n    output = output * 10000;\nreturn {msg: output};";
        LinkedHashMap<String, Integer> expected = new LinkedHashMap<String, Integer>();
        expected.put("msg", -40000);
        Object actual = this.executeScript(scriptBodyTestForWithBreakInIfStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testForWithBreakIncludesForWithBreak() {
        String scriptBodyTestForWithBreakInIfStr = "var input = [-1, -7, -3, -4];\nvar output = 9;\nvar outputY = 19;\nfor (var i = 0; i < input.size; i++) {\n      output = i*10;\n    if (i === 2) {\n      output = input[i];\n      break;\n      output = i*100;\n    } else if ( i === 0) {\n      outputY = 19;\n      for (var y = 0; y < input.size; y++) {\n        outputY = y*10*2;\n        if (y === 1) {\n          outputY = input[y];\n          break;\n          outputY = y*100*2;\n        }\n        outputY = y*1000*2;\n      }\n    }\n    output = i*1000;\n}\nreturn {msg: [output, outputY]};";
        LinkedHashMap expected = new LinkedHashMap();
        ArrayList<Integer> expIntList = new ArrayList<Integer>();
        expIntList.add(-3);
        expIntList.add(-7);
        expected.put("msg", expIntList);
        Object actual = this.executeScript(scriptBodyTestForWithBreakInIfStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testForWithBreakWithIncrementIndex() {
        String scriptBodyTestSwitchNodeStr = "var input = [0x02, 0x75, 45, 0x01, 0x75, 55, 0x03, 0x76,  75];\nvar output = { \"telemetry\": {\"battery\": 130}};\nfor (var i = 0; i < input.size;) {\n        var channel_id = input[i++];\n        var channel_type = input[i++];\n        // BATTERY\n        if (channel_id === 0x01 && channel_type === 0x75) {\n            output.telemetry.battery = input[i];\n            break;\n        }\n        i += 1;\n\n}\n\nreturn {msg: output.telemetry.battery};";
        LinkedHashMap<String, Integer> expected = new LinkedHashMap<String, Integer>();
        expected.put("msg", 55);
        Object actual = this.executeScript(scriptBodyTestSwitchNodeStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testForeachWithBreakIncludesForeachWithBreak() {
        String scriptBodyTestForWithBreakInIfStr = "var input = [-1, -10, -3, -4];\nvar output = 9;\nvar outputY = 19;\nvar i = 0;\nvar y = 0;\nforeach(a: input) {\n    output = i * 10;\n    if (i === 2) {\n        output = a;\n        break;\n        output = i * 100;\n    } else if (i === 0) {\n        outputY = 19;\n        y = 0;\n        foreach(b: input) {\n            outputY = y * 10 * 2;\n            if (y === 1) {\n                outputY = b;\n                break;\n                outputY = y * 100 * 2;\n            }\n            outputY = y * 1000 * 2;\n            y++;\n        }\n    }\n    output = i * 1000;\n    i++;\n}\noutput = output * 4;\noutputY = outputY / 2;\nreturn {\n    msg: [output, outputY, i, y]\n};";
        LinkedHashMap expected = new LinkedHashMap();
        ArrayList<Integer> expIntList = new ArrayList<Integer>();
        expIntList.add(-12);
        expIntList.add(-5);
        expIntList.add(2);
        expIntList.add(1);
        expected.put("msg", expIntList);
        Object actual = this.executeScript(scriptBodyTestForWithBreakInIfStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testForeachWithBreakInIf_Function() {
        String scriptBodyTestForWithBreakInIfStr = "var input = [-1, -2, -3, -4];\nvar output = 10;\nvar i = 0;\nforBreak();\nfunction forBreak() {\n    foreach(a: input) {\n        output = i;\n        if (i === 1) {\n            output = a;\n            break;\n        }\n        output = i;\n        i++;\n    }\n}return {\n    msg: output\n};\n";
        LinkedHashMap<String, Integer> expected = new LinkedHashMap<String, Integer>();
        expected.put("msg", -2);
        Object actual = this.executeScript(scriptBodyTestForWithBreakInIfStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testWhileWithBreak() {
        String scriptBodyTestForWithBreakInIfStr = "var input = [-1, -7, -3, -4];\nvar output = -9;\nvar i = 0;\nwhile (i < input.size()) {\n    output = i * 10;\n    if (i === 1) {\n        output = input[i];\n        break;\n        output = i * 100;\n    }\n    i++;\n    output = i * 1000;\n}\noutput = output * 4;\nreturn {\n    msg: [output, i]\n};";
        LinkedHashMap expected = new LinkedHashMap();
        ArrayList<Integer> expIntList = new ArrayList<Integer>();
        expIntList.add(-28);
        expIntList.add(1);
        expected.put("msg", expIntList);
        Object actual = this.executeScript(scriptBodyTestForWithBreakInIfStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testWhileWithBreakIncludesWhileWithBreak() {
        String scriptBodyTestForWithBreakInIfStr = "var input = [-1, -10, -3, -4];\nvar output = -9;\nvar outputY = -19;\nvar i = 0;\nvar y = 0;\nwhile (i < input.size()) {\n    output = i * 10;\n    if (i === 2) {\n        output = input[i];\n        break;\n        output = i * 100;\n    } else if (i === 0) {\n        outputY = -20;\n        y = 0;\n       while (y < input.size()) {\n            outputY = y * 10 * 2;\n            if (y === 1) {\n                outputY = input[y];\n                break;\n                outputY = y * 100 * 2;\n            }\n            outputY = y * 1000 * 2;\n            y++;\n        }\n    }\n    output = i * 1000;\n    i++;\n}\noutput = output * 4;\noutputY = outputY / 2;\nreturn {\n    msg: [output, outputY, i, y]\n};";
        LinkedHashMap expected = new LinkedHashMap();
        ArrayList<Integer> expIntList = new ArrayList<Integer>();
        expIntList.add(-12);
        expIntList.add(-5);
        expIntList.add(2);
        expIntList.add(1);
        expected.put("msg", expIntList);
        Object actual = this.executeScript(scriptBodyTestForWithBreakInIfStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testWhileWithBreakInIf_Function() {
        String scriptBodyTestForWithBreakInIfStr = "var input = [-1, -2, -3, -4];\nvar output = 10;\nvar i = 0;\nforBreak();\nfunction forBreak() {\n    while (i < input.size()) {\n        output = i;\n        if (i === 1) {\n            output = input[i];\n            break;\n        }\n        output = i;\n        i++;\n    }\n}return {\n    msg: [output, i]\n};\n";
        LinkedHashMap expected = new LinkedHashMap();
        ArrayList<Integer> expIntList = new ArrayList<Integer>();
        expIntList.add(-2);
        expIntList.add(1);
        expected.put("msg", expIntList);
        Object actual = this.executeScript(scriptBodyTestForWithBreakInIfStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testDoWithBreak() {
        String scriptBodyTestForWithBreakInIfStr = "var input = [-1, -7, -3, -4];\nvar output = -9;\nvar i = 0;\ndo {\n    output = i * 10;\n    if (i === 1) {\n        output = input[i];\n        break;\n        output = i * 100;\n    }\n    i++;\n    output = i * 1000;\n}\nwhile (i < input.size()) \noutput = output * 4;\nreturn {\n    msg: [output, i]\n};";
        LinkedHashMap expected = new LinkedHashMap();
        ArrayList<Integer> expIntList = new ArrayList<Integer>();
        expIntList.add(-28);
        expIntList.add(1);
        expected.put("msg", expIntList);
        Object actual = this.executeScript(scriptBodyTestForWithBreakInIfStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testDoWithBreakIncludesDoWithBreak() {
        String scriptBodyTestForWithBreakInIfStr = "var input = [-1, -10, -3, -4];\nvar output = -9;\nvar outputY = -19;\nvar i = 0;\nvar y = 0;\ndo {\n    output = i * 10;\n    if (i === 2) {\n        output = input[i];\n        break;\n        output = i * 100;\n    } else if (i === 0) {\n        outputY = -20;\n        y = 0;\n       do {\n            outputY = y * 10 * 2;\n            if (y === 1) {\n                outputY = input[y];\n                break;\n                outputY = y * 100 * 2;\n            }\n            outputY = y * 1000 * 2;\n            y++;\n        }\n       while (y < input.size()) \n    }\n    output = i * 1000;\n    i++;\n}\nwhile (i < input.size()) \noutput = output * 4;\noutputY = outputY / 2;\nreturn {\n    msg: [output, outputY, i, y]\n};";
        LinkedHashMap expected = new LinkedHashMap();
        ArrayList<Integer> expIntList = new ArrayList<Integer>();
        expIntList.add(-12);
        expIntList.add(-5);
        expIntList.add(2);
        expIntList.add(1);
        expected.put("msg", expIntList);
        Object actual = this.executeScript(scriptBodyTestForWithBreakInIfStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testDoWithBreakInIf_Function() {
        String scriptBodyTestForWithBreakInIfStr = "var input = [-1, -2, -3, -4];\nvar output = 10;\nvar i = 0;\nforBreak();\nfunction forBreak() {\n   do {\n        output = i;\n        if (i === 1) {\n            output = input[i];\n            break;\n        }\n        output = i;\n        i++;\n    }\n    while (i < input.size()) \n}return {\n    msg: [output, i]\n};\n";
        LinkedHashMap expected = new LinkedHashMap();
        ArrayList<Integer> expIntList = new ArrayList<Integer>();
        expIntList.add(-2);
        expIntList.add(1);
        expected.put("msg", expIntList);
        Object actual = this.executeScript(scriptBodyTestForWithBreakInIfStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testDoUntilWithBreak() {
        String scriptBodyTestForWithBreakInIfStr = "var input = [-1, -7, -3, -4];\nvar output = -9;\nvar i = 0;\ndo {\n    output = i * 10;\n    if (i === 2) {\n        output = input[i];\n        break;\n        output = i * 100;\n    }\n    i++;\n    output = i * 1000;\n}\nuntil (i > input.size()) \noutput = output * 4;\nreturn {\n    msg: [output, i]\n};";
        LinkedHashMap expected = new LinkedHashMap();
        ArrayList<Integer> expIntList = new ArrayList<Integer>();
        expIntList.add(-12);
        expIntList.add(2);
        expected.put("msg", expIntList);
        Object actual = this.executeScript(scriptBodyTestForWithBreakInIfStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testDoUntilWithBreakIncludesDoWithBreak() {
        String scriptBodyTestForWithBreakInIfStr = "var input = [-1, -7, -3, -4];\nvar output = -9;\nvar outputY = -19;\nvar i = 0;\nvar y = 0;\ndo {\n    output = i * 10;\n    if (i === 2) {\n        output = input[i];\n        break;\n        output = i * 100;\n    } else if (i === 0) {\n        outputY = -20;\n        y = 0;\n       do {\n            outputY = y * 10 * 2;\n            if (y === 1) {\n                outputY = input[y];\n                break;\n                outputY = y * 100 * 2;\n            }\n            outputY = y * 1000 * 2;\n            y++;\n       }\n       until (y > input.size()) \n    }\n    i++;\n    output = i * 1000;\n}\nuntil (i > input.size()) \noutput = output * 4;\nreturn {\n    msg: [output, outputY, i, y]\n};";
        LinkedHashMap expected = new LinkedHashMap();
        ArrayList<Integer> expIntList = new ArrayList<Integer>();
        expIntList.add(-12);
        expIntList.add(-7);
        expIntList.add(2);
        expIntList.add(1);
        expected.put("msg", expIntList);
        Object actual = this.executeScript(scriptBodyTestForWithBreakInIfStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testDoUntilWithBreakInIf_Function() {
        String scriptBodyTestForWithBreakInIfStr = "var input = [-1, -2, -3, -4];\nvar output = 10;\nvar i = 0;\nforBreak();\nfunction forBreak() {\n   do {\n        output = i;\n        if (i === 1) {\n            output = input[i];\n            break;\n        }\n        output = i;\n        i++;\n    }\n    until (i > input.size()) \n}return {\n    msg: [output, i]\n};\n";
        LinkedHashMap expected = new LinkedHashMap();
        ArrayList<Integer> expIntList = new ArrayList<Integer>();
        expIntList.add(-2);
        expIntList.add(1);
        expected.put("msg", expIntList);
        Object actual = this.executeScript(scriptBodyTestForWithBreakInIfStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testForVar_a_FunctionWithForVar_a() {
        String scriptBodyTestForWithBreakInIfStr = "var output = 0;\nfor (var a = 0; a < 10; a++) {\n    output = testBreak(output);\n}\nreturn {\n    msg: [output]\n};\nfunction testBreak(val) {\n    for (var a = 0; a< 9; a++) {\n        val++;\n    }\n    return val;\n}\n";
        LinkedHashMap expected = new LinkedHashMap();
        ArrayList<Integer> expIntList = new ArrayList<Integer>();
        expIntList.add(90);
        expected.put("msg", expIntList);
        Object actual = this.executeScript(scriptBodyTestForWithBreakInIfStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testLeve0ForVar_a_Level0_a_unresolvable() {
        String scriptBodyTestForWithBreakInIfStr = "var output = 0;\nfor (var a = 0; a < 10; a++) {\n}\noutput = a;\nreturn {\n    msg: [output]\n};\n\n";
        try {
            this.executeScript(scriptBodyTestForWithBreakInIfStr);
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("unresolvable property or identifier: a"));
        }
    }

    public void testLeve0ForVar_a_And_FunctionWithForVar_a_Function_Calling_Level0() {
        String scriptBodyTestForWithBreakInIfStr = "var output = 0;\noutput = testBreak(output);\nfor (var a = 0; a < 10; a++) {\n}\nfor (var y = 0; y < 2; y++) {\n        output++;\n}\nfor (var r = 0; r < 10; r++) {\n}\nreturn {\n    msg: [output]\n};\nfunction testBreak(val) {\n    var b = 45;\n    for (var r = 0; r < 5; r++) {\n        output++;\n    }\n    val = output;\n    for (var a = 0; a < 9; a++) {\n        val++;\n    }\n    return val;\n}\n";
        LinkedHashMap expected = new LinkedHashMap();
        ArrayList<Integer> expIntList = new ArrayList<Integer>();
        expIntList.add(16);
        expected.put("msg", expIntList);
        Object actual = this.executeScript(scriptBodyTestForWithBreakInIfStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testOneNameVar_In_Another_Procedure_NotTimeout() {
        String scriptBodyTestForWithBreakInIfStr = "var output = 0;\nfor (var a = 0; a < 100; a++) {\n    output = testBug(output);\n}\noutput = testBug(output);\nreturn {\n    msg: [output]\n};\nfunction testBug(val) {\n    for (var a = 0; a < 9; a++) {\n        val++;\n    }\n    return val;\n}";
        LinkedHashMap expected = new LinkedHashMap();
        ArrayList<Integer> expIntList = new ArrayList<Integer>();
        expIntList.add(909);
        expected.put("msg", expIntList);
        Object actual = this.executeScript(scriptBodyTestForWithBreakInIfStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testInnerFunctionForReturn() {
        String body = "var output = 0;\n\noutput = testBug(output);\n\nreturn output;\n\nfunction testBug(val) {\n    for (var i=0 ;i<10;i++) {\n        return 1;\n    }\n    return 2;\n}";
        Object result = this.executeScript(body);
        TbExpressionsTest.assertTrue((boolean)(result instanceof Integer));
        TbExpressionsTest.assertEquals((Object)1, (Object)result);
    }

    public void testInnerFunctionForConditionalReturn() {
        String body = "var output = 0;\n\noutput = testBug(output);\n\nreturn output;\n\nfunction testBug(val) {\n    for (var i=0 ;i<10;i++) {\n        if (i > 5) {\n             return i;\n        }\n    }\n    return 2;\n}";
        Object result = this.executeScript(body);
        TbExpressionsTest.assertTrue((boolean)(result instanceof Integer));
        TbExpressionsTest.assertEquals((Object)6, (Object)result);
    }

    public void testInnerFunctionWhileReturn() {
        String body = "var output = 0;\n\noutput = testBug(output);\n\nreturn output;\n\nfunction testBug(val) {\n    var i = 0;              \n    while ( i < 10) {\n        return 1;\n    }\n    return 2;\n}";
        Object result = this.executeScript(body);
        TbExpressionsTest.assertTrue((boolean)(result instanceof Integer));
        TbExpressionsTest.assertEquals((Object)1, (Object)result);
    }

    public void testInnerFunctionWhileConditionalReturn() {
        String body = "var output = 0;\n\noutput = testBug(output);\n\nreturn output;\n\nfunction testBug(val) {\n    var i = 0;              \n    while ( i < 10) {\n        if (i > 5) {\n           return i;\n        }\n        i++;    }\n    return 2;\n}";
        Object result = this.executeScript(body);
        TbExpressionsTest.assertTrue((boolean)(result instanceof Integer));
        TbExpressionsTest.assertEquals((Object)6, (Object)result);
    }

    public void testIntegerToLongFromJson() {
        Integer sunriseValueOld = 1695435081;
        Long sunriseValueNew = Long.valueOf(sunriseValueOld.intValue()) * 1000L;
        String sunriseName = "sunrise";
        LinkedHashMap vars = new LinkedHashMap();
        LinkedHashMap<String, Integer> msg = new LinkedHashMap<String, Integer>();
        msg.put("sys", sunriseValueOld);
        vars.put("msg", msg);
        String body = "var time = msg.sys * 1000;\nmsg." + sunriseName + " = time;\nreturn {\"msg\": msg};";
        Object actual = this.executeScript(body, vars);
        LinkedHashMap expected = vars;
        ((LinkedHashMap)expected.get("msg")).put(sunriseName, sunriseValueNew);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testIntegerToIntegerFromJson() {
        Integer sunriseValueOld = 169543;
        Integer sunriseValueNew = sunriseValueOld * 10;
        String sunriseName = "sunrise";
        LinkedHashMap vars = new LinkedHashMap();
        LinkedHashMap<String, Integer> msg = new LinkedHashMap<String, Integer>();
        msg.put("sys", sunriseValueOld);
        vars.put("msg", msg);
        String body = "var time = msg.sys * 10;\nmsg." + sunriseName + " = time;\nreturn {\"msg\": msg};";
        Object actual = this.executeScript(body, vars);
        LinkedHashMap expected = vars;
        ((LinkedHashMap)expected.get("msg")).put(sunriseName, sunriseValueNew);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testIntegerAsObjectToLongFromJson_Ok() {
        Integer sunriseValueOld = 1695435081;
        Long sunriseValueNew = Long.valueOf(sunriseValueOld.intValue()) * 1000L;
        String sunriseName = "sunrise";
        LinkedHashMap vars = new LinkedHashMap();
        LinkedHashMap<String, Integer> msg = new LinkedHashMap<String, Integer>();
        msg.put("sys", sunriseValueOld);
        vars.put("msg", msg);
        String body = "var time = " + sunriseValueOld + " * 1000;\nmsg." + sunriseName + " = time;\nreturn {\"msg\": msg};";
        Object actual = this.executeScript(body, vars);
        LinkedHashMap expected = vars;
        ((LinkedHashMap)expected.get("msg")).put(sunriseName, sunriseValueNew);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testIntegerAsObjectToLongFromJson_If_result_less_Integer_MIN_VALUE() {
        Integer sunriseValueOld = -1695435081;
        Long sunriseValueNew = Long.valueOf(sunriseValueOld.intValue()) * -1000L;
        String sunriseName = "sunrise";
        LinkedHashMap vars = new LinkedHashMap();
        LinkedHashMap<String, Integer> msg = new LinkedHashMap<String, Integer>();
        msg.put("sys", sunriseValueOld);
        vars.put("msg", msg);
        String body = "var time = " + sunriseValueOld + " * -1000;\nmsg." + sunriseName + " = time;\nreturn {\"msg\": msg};";
        Object actual = this.executeScript(body, vars);
        LinkedHashMap expected = vars;
        ((LinkedHashMap)expected.get("msg")).put(sunriseName, sunriseValueNew);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testIntegerToIntegerFromJson_If_result_less_Integer_MIN_VALUE() {
        Integer sunriseValueOld = -1695435081;
        Long sunriseValueNew = Long.valueOf(sunriseValueOld.intValue()) * 10000L;
        String sunriseName = "sunrise";
        LinkedHashMap vars = new LinkedHashMap();
        LinkedHashMap<String, Integer> msg = new LinkedHashMap<String, Integer>();
        msg.put("sys", sunriseValueOld);
        vars.put("msg", msg);
        String body = "var time = msg.sys * 10000;\nmsg." + sunriseName + " = time;\nreturn {\"msg\": msg};";
        Object actual = this.executeScript(body, vars);
        LinkedHashMap expected = vars;
        ((LinkedHashMap)expected.get("msg")).put(sunriseName, sunriseValueNew);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testExecutionArrayListToString() {
        String body = "var list = ['hello', 34567];\nvar res = '' + list;\nreturn res;";
        Object result = this.executeScript(body);
        TbExpressionsTest.assertTrue((boolean)(result instanceof String));
        TbExpressionsTest.assertEquals((Object)"[hello, 34567]", (Object)result);
    }

    public void testExecutionArrayListJoin() {
        String body = "var list = [];\nreturn list.join();";
        Object result = this.executeScript(body);
        TbExpressionsTest.assertTrue((boolean)(result instanceof String));
        TbExpressionsTest.assertEquals((Object)"", (Object)result);
        body = "var list = ['hello', 34567];\nreturn list.join();";
        result = this.executeScript(body);
        TbExpressionsTest.assertTrue((boolean)(result instanceof String));
        TbExpressionsTest.assertEquals((Object)"hello,34567", (Object)result);
        body = "var list = ['hello', 34567];\nreturn list.join(':');";
        result = this.executeScript(body);
        TbExpressionsTest.assertTrue((boolean)(result instanceof String));
        TbExpressionsTest.assertEquals((Object)"hello:34567", (Object)result);
        body = "var matrix = [\n[1, [12, 22, \"Things2\"], 2, \"Things\"],\n  [4, 5, 6],\n  245, \"Test_Join\",\n  [7, \"8\", [13, [14, 24, \"Things4\"], 23, \"Things3\"], 9],\n];\nreturn matrix.join();";
        result = this.executeScript(body);
        TbExpressionsTest.assertTrue((boolean)(result instanceof String));
        TbExpressionsTest.assertEquals((Object)"1,12,22,Things2,2,Things,4,5,6,245,Test_Join,7,8,13,14,24,Things4,23,Things3,9", (Object)result);
    }

    public void testExecutionHashMapToString() {
        String body = "var map = {hello: 'world', testmap: 'toString'};\nreturn '' + map;";
        Object result = this.executeScript(body);
        TbExpressionsTest.assertTrue((boolean)(result instanceof String));
        TbExpressionsTest.assertEquals((Object)"{hello=world, testmap=toString}", (Object)result);
    }

    public void testExecutionHashMapKeys() {
        String body = "var map = {hello: 'world', testmap: 'toString'};\nreturn map.keys();";
        Object result = this.executeScript(body);
        TbExpressionsTest.assertTrue((boolean)(result instanceof List));
        TbExpressionsTest.assertEquals((int)2, (int)((List)result).size());
        TbExpressionsTest.assertEquals((Object)"hello", ((List)result).get(0));
        TbExpressionsTest.assertEquals((Object)"testmap", ((List)result).get(1));
    }

    public void testExecutionHashMapValues() {
        String body = "var map = {hello: 'world', testmap: 'toString'};\nreturn map.values();";
        Object result = this.executeScript(body);
        TbExpressionsTest.assertTrue((boolean)(result instanceof List));
        TbExpressionsTest.assertEquals((int)2, (int)((List)result).size());
        TbExpressionsTest.assertEquals((Object)"world", ((List)result).get(0));
        TbExpressionsTest.assertEquals((Object)"toString", ((List)result).get(1));
    }

    public void testExecutionArrayListSortAsc() {
        String body = "var msg = {};\nvar arrayString = ['March', 'Feb', 'Jan', 'Dec'];\narrayString.sort();\nvar arrayInt = [1, 30, 4, -214748, 57, 214748, 100000];\narrayInt.sort();\nvar arrayLong = [45, 9223372036854775807, 30, 40,  -9223372036854775808, 1000];\narrayLong.sort();\nvar arrayFloat = [3.40282, 34.17549467, 45.40283, 1.1754943];\narrayFloat.sort();\nvar mixedNumericArray = [\"8\", \"9\", \"700\", 40, 1, 5, 200];\nmixedNumericArray.sort();\nmsg.arrayString = arrayString;\nmsg.arrayInt = arrayInt;\nmsg.arrayLong = arrayLong;\nmsg.arrayFloat = arrayFloat;\nmsg.mixedNumericArray = mixedNumericArray;\nreturn {msg: msg};";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        String[] arrayString = new String[]{"Dec", "Feb", "Jan", "March"};
        List<String> expectedArrayString = Arrays.asList(arrayString);
        List actualArray = (List)resMap.get("arrayString");
        TbExpressionsTest.assertEquals(expectedArrayString, (Object)actualArray);
        Integer[] arrayInt = new Integer[]{-214748, 1, 4, 30, 57, 100000, 214748};
        List<Integer> expectedArrayInteger = Arrays.asList(arrayInt);
        actualArray = (List)resMap.get("arrayInt");
        TbExpressionsTest.assertEquals(expectedArrayInteger, (Object)actualArray);
        ArrayList<Number> expectedArrayIntLong = new ArrayList<Number>();
        expectedArrayIntLong.add(Long.MIN_VALUE);
        expectedArrayIntLong.add(30);
        expectedArrayIntLong.add(40);
        expectedArrayIntLong.add(45);
        expectedArrayIntLong.add(1000);
        expectedArrayIntLong.add(Long.MAX_VALUE);
        actualArray = (List)resMap.get("arrayLong");
        TbExpressionsTest.assertEquals(expectedArrayIntLong, (Object)actualArray);
        Double[] arrayFloat = new Double[]{1.1754943, 3.40282, 34.17549467, 45.40283};
        List<Double> expectedArrayFloat = Arrays.asList(arrayFloat);
        actualArray = (List)resMap.get("arrayFloat");
        TbExpressionsTest.assertEquals(expectedArrayFloat, (Object)actualArray);
        ArrayList<Object> expectedArrayMixedNumeric = new ArrayList<Object>();
        expectedArrayMixedNumeric.add(1);
        expectedArrayMixedNumeric.add(5);
        expectedArrayMixedNumeric.add("8");
        expectedArrayMixedNumeric.add("9");
        expectedArrayMixedNumeric.add(40);
        expectedArrayMixedNumeric.add(200);
        expectedArrayMixedNumeric.add("700");
        actualArray = (List)resMap.get("mixedNumericArray");
        TbExpressionsTest.assertEquals(expectedArrayMixedNumeric, (Object)actualArray);
    }

    public void testExecutionArrayListSortDesc() {
        String body = "var msg = {};\nvar arrayString = ['March', 'Feb', 'Jan', 'Dec'];\narrayString.sort(false);\nvar arrayInt = [1, 30, 4, -214748, 57, 214748, 100000];\narrayInt.sort(false);\nvar arrayLong = [45, 9223372036854775807, 30, 40,  -9223372036854775808, 1000];\narrayLong.sort(false);\nvar arrayFloat = [3.40282, 34.17549467, 45.40283, 1.1754943];\narrayFloat.sort(false);\nvar mixedNumericArray = [\"8\", \"9\", \"700\", 40, 1, 5, 200];\nmixedNumericArray.sort(false);\nmsg.arrayString = arrayString;\nmsg.arrayInt = arrayInt;\nmsg.arrayLong = arrayLong;\nmsg.arrayFloat = arrayFloat;\nmsg.mixedNumericArray = mixedNumericArray;\nreturn {msg: msg};";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        String[] arrayString = new String[]{"Dec", "Feb", "Jan", "March"};
        List<String> expectedArrayString = Arrays.asList(arrayString);
        Collections.reverse(expectedArrayString);
        List actualArray = (List)resMap.get("arrayString");
        TbExpressionsTest.assertEquals(expectedArrayString, (Object)actualArray);
        Integer[] arrayInt = new Integer[]{214748, 100000, 57, 30, 4, 1, -214748};
        List<Integer> expectedArrayInteger = Arrays.asList(arrayInt);
        actualArray = (List)resMap.get("arrayInt");
        TbExpressionsTest.assertEquals(expectedArrayInteger, (Object)actualArray);
        ArrayList<Number> expectedArrayIntLong = new ArrayList<Number>();
        expectedArrayIntLong.add(Long.MIN_VALUE);
        expectedArrayIntLong.add(30);
        expectedArrayIntLong.add(40);
        expectedArrayIntLong.add(45);
        expectedArrayIntLong.add(1000);
        expectedArrayIntLong.add(Long.MAX_VALUE);
        Collections.reverse(expectedArrayIntLong);
        actualArray = (List)resMap.get("arrayLong");
        TbExpressionsTest.assertEquals(expectedArrayIntLong, (Object)actualArray);
        Double[] arrayFloat = new Double[]{45.40283, 34.17549467, 3.40282, 1.1754943};
        List<Double> expectedArrayFloat = Arrays.asList(arrayFloat);
        actualArray = (List)resMap.get("arrayFloat");
        TbExpressionsTest.assertEquals(expectedArrayFloat, (Object)actualArray);
        ArrayList<Object> expectedArrayMixedNumeric = new ArrayList<Object>();
        expectedArrayMixedNumeric.add(1);
        expectedArrayMixedNumeric.add(5);
        expectedArrayMixedNumeric.add("8");
        expectedArrayMixedNumeric.add("9");
        expectedArrayMixedNumeric.add(40);
        expectedArrayMixedNumeric.add(200);
        expectedArrayMixedNumeric.add("700");
        Collections.reverse(expectedArrayMixedNumeric);
        actualArray = (List)resMap.get("mixedNumericArray");
        TbExpressionsTest.assertEquals(expectedArrayMixedNumeric, (Object)actualArray);
    }

    public void testExecutionArrayList_toSorted() {
        String body = "var msg = {};\nvar array = [\"8\", 40, 9223372036854775807, \"1234567\", \"-9223372036854775808\"];\nvar arraySort = array.toSorted();\nmsg.array = array;\nmsg.arraySort = arraySort;\nreturn {msg: msg}";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        ArrayList<Object> expectedArray = new ArrayList<Object>();
        expectedArray.add("8");
        expectedArray.add(40);
        expectedArray.add(Long.MAX_VALUE);
        expectedArray.add("1234567");
        expectedArray.add("-9223372036854775808");
        List actualArray = (List)resMap.get("array");
        TbExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        actualArray = (List)resMap.get("arraySort");
        expectedArray.sort(numericCompAsc);
        TbExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
    }

    public void testExecutionHashMapSortByValueAsc() {
        String body = "var msg = {};\nvar sortValString = {2:\"21Dragon\", 3:\"Brain\", 4:\"20\", 1:\"30\"};\nsortValString.sortByValue();\nvar sortValInt = {2:1, 5:30, 225:4, 8:-214748, 1:57, 3:214748, 9:100000};\nsortValInt.sortByValue();\nvar sortValIntLong = {2:45, 5:9223372036854775807, 225:30, 8:40,  3:-9223372036854775808, 9:1000};\nsortValIntLong.sortByValue();\nvar sortValFloat = {2:3.40282, 225:34.17549467, 3:45.40283, 5:1.1754943};\nsortValFloat.sortByValue();\nvar sortValMixedNumeric = {2:\"8\", 225:\"-9223372036854775808\", 3:\"700\", 5:40, 9:9223372036854775807, 4:5, 300:200};\nsortValMixedNumeric.sortByValue();\n\nmsg.sortValString = sortValString;\nmsg.sortValInt = sortValInt;\nmsg.sortValIntLong = sortValIntLong;\nmsg.sortValFloat = sortValFloat;\nmsg.sortValMixedNumeric = sortValMixedNumeric;\nreturn {\n    msg: msg\n};";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        LinkedHashMap<Integer, String> expectedSortValString = new LinkedHashMap<Integer, String>();
        expectedSortValString.put(4, "20");
        expectedSortValString.put(2, "21Dragon");
        expectedSortValString.put(1, "30");
        expectedSortValString.put(3, "Brain");
        LinkedHashMap actualHashMap = (LinkedHashMap)resMap.get("sortValString");
        TbExpressionsTest.assertEquals(expectedSortValString, (Object)actualHashMap);
        ArrayList expectedList = new ArrayList(expectedSortValString.values());
        ArrayList actualList = new ArrayList(actualHashMap.values());
        TbExpressionsTest.assertEquals(expectedList, actualList);
        LinkedHashMap<Integer, Integer> expectedSortValInt = new LinkedHashMap<Integer, Integer>();
        expectedSortValInt.put(8, -214748);
        expectedSortValInt.put(2, 1);
        expectedSortValInt.put(225, 4);
        expectedSortValInt.put(5, 30);
        expectedSortValInt.put(1, 57);
        expectedSortValInt.put(9, 100000);
        expectedSortValInt.put(3, 214748);
        actualHashMap = (LinkedHashMap)resMap.get("sortValInt");
        TbExpressionsTest.assertEquals(expectedSortValInt, (Object)actualHashMap);
        expectedList = new ArrayList(expectedSortValInt.values());
        actualList = new ArrayList(actualHashMap.values());
        TbExpressionsTest.assertEquals(expectedList, actualList);
        LinkedHashMap<Integer, Number> expectedSortValIntLong = new LinkedHashMap<Integer, Number>();
        expectedSortValIntLong.put(3, Long.MIN_VALUE);
        expectedSortValIntLong.put(225, 30);
        expectedSortValIntLong.put(8, 40);
        expectedSortValIntLong.put(2, 45);
        expectedSortValIntLong.put(9, 1000);
        expectedSortValIntLong.put(5, Long.MAX_VALUE);
        actualHashMap = (LinkedHashMap)resMap.get("sortValIntLong");
        TbExpressionsTest.assertEquals(expectedSortValIntLong, (Object)actualHashMap);
        expectedList = new ArrayList(expectedSortValIntLong.values());
        actualList = new ArrayList(actualHashMap.values());
        TbExpressionsTest.assertEquals(expectedList, actualList);
        LinkedHashMap<Integer, Double> expectedSortValFloat = new LinkedHashMap<Integer, Double>();
        expectedSortValFloat.put(5, 1.1754943);
        expectedSortValFloat.put(2, 3.40282);
        expectedSortValFloat.put(225, 34.17549467);
        expectedSortValFloat.put(3, 45.40283);
        actualHashMap = (LinkedHashMap)resMap.get("sortValFloat");
        TbExpressionsTest.assertEquals(expectedSortValFloat, (Object)actualHashMap);
        expectedList = new ArrayList(expectedSortValFloat.values());
        actualList = new ArrayList(actualHashMap.values());
        TbExpressionsTest.assertEquals(expectedList, actualList);
        LinkedHashMap<Integer, Object> expectedSortValMixedNumeric = new LinkedHashMap<Integer, Object>();
        expectedSortValMixedNumeric.put(225, "-9223372036854775808");
        expectedSortValMixedNumeric.put(4, 5);
        expectedSortValMixedNumeric.put(2, "8");
        expectedSortValMixedNumeric.put(5, 40);
        expectedSortValMixedNumeric.put(300, 200);
        expectedSortValMixedNumeric.put(3, "700");
        expectedSortValMixedNumeric.put(9, Long.MAX_VALUE);
        actualHashMap = (LinkedHashMap)resMap.get("sortValMixedNumeric");
        TbExpressionsTest.assertEquals(expectedSortValMixedNumeric, (Object)actualHashMap);
        expectedList = new ArrayList(expectedSortValMixedNumeric.values());
        actualList = new ArrayList(actualHashMap.values());
        TbExpressionsTest.assertEquals(expectedList, actualList);
    }

    public void testExecutionHashMapSortByValueDesc() {
        String body = "var msg = {};\nvar sortValString = {2:\"21Dragon\", 3:\"Brain\", 4:\"20\", 1:\"30\"};\nsortValString.sortByValue(false);\nvar sortValInt = {2:1, 5:30, 225:4, 8:-214748, 1:57, 3:214748, 9:100000};\nsortValInt.sortByValue(false);\nvar sortValIntLong = {2:45, 5:9223372036854775807, 225:30, 8:40,  3:-9223372036854775808, 9:1000};\nsortValIntLong.sortByValue(false);\nvar sortValFloat = {2:3.40282, 225:34.17549467, 3:45.40283, 5:1.1754943};\nsortValFloat.sortByValue(false);\nvar sortValMixedNumeric = {2:\"8\", 225:\"-9223372036854775808\", 3:\"700\", 5:40, 9:9223372036854775807, 4:5, 300:200};\nsortValMixedNumeric.sortByValue(false);\n\nmsg.sortValString = sortValString;\nmsg.sortValInt = sortValInt;\nmsg.sortValIntLong = sortValIntLong;\nmsg.sortValFloat = sortValFloat;\nmsg.sortValMixedNumeric = sortValMixedNumeric;\nreturn {\n    msg: msg\n};";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        LinkedHashMap<Integer, String> expectedSortValString = new LinkedHashMap<Integer, String>();
        expectedSortValString.put(4, "20");
        expectedSortValString.put(2, "21Dragon");
        expectedSortValString.put(1, "30");
        expectedSortValString.put(3, "Brain");
        LinkedHashMap actualHashMap = (LinkedHashMap)resMap.get("sortValString");
        TbExpressionsTest.assertEquals(expectedSortValString, (Object)actualHashMap);
        ArrayList expectedList = new ArrayList(expectedSortValString.values());
        ArrayList actualList = new ArrayList(actualHashMap.values());
        Collections.reverse(expectedList);
        TbExpressionsTest.assertEquals(expectedList, actualList);
        LinkedHashMap<Integer, Integer> expectedSortValInt = new LinkedHashMap<Integer, Integer>();
        expectedSortValInt.put(8, -214748);
        expectedSortValInt.put(2, 1);
        expectedSortValInt.put(225, 4);
        expectedSortValInt.put(5, 30);
        expectedSortValInt.put(1, 57);
        expectedSortValInt.put(9, 100000);
        expectedSortValInt.put(3, 214748);
        actualHashMap = (LinkedHashMap)resMap.get("sortValInt");
        TbExpressionsTest.assertEquals(expectedSortValInt, (Object)actualHashMap);
        expectedList = new ArrayList(expectedSortValInt.values());
        actualList = new ArrayList(actualHashMap.values());
        Collections.reverse(expectedList);
        TbExpressionsTest.assertEquals(expectedList, actualList);
        LinkedHashMap<Integer, Number> expectedSortValIntLong = new LinkedHashMap<Integer, Number>();
        expectedSortValIntLong.put(3, Long.MIN_VALUE);
        expectedSortValIntLong.put(225, 30);
        expectedSortValIntLong.put(8, 40);
        expectedSortValIntLong.put(2, 45);
        expectedSortValIntLong.put(9, 1000);
        expectedSortValIntLong.put(5, Long.MAX_VALUE);
        actualHashMap = (LinkedHashMap)resMap.get("sortValIntLong");
        TbExpressionsTest.assertEquals(expectedSortValIntLong, (Object)actualHashMap);
        expectedList = new ArrayList(expectedSortValIntLong.values());
        actualList = new ArrayList(actualHashMap.values());
        Collections.reverse(expectedList);
        TbExpressionsTest.assertEquals(expectedList, actualList);
        LinkedHashMap<Integer, Double> expectedSortValFloat = new LinkedHashMap<Integer, Double>();
        expectedSortValFloat.put(5, 1.1754943);
        expectedSortValFloat.put(2, 3.40282);
        expectedSortValFloat.put(225, 34.17549467);
        expectedSortValFloat.put(3, 45.40283);
        actualHashMap = (LinkedHashMap)resMap.get("sortValFloat");
        TbExpressionsTest.assertEquals(expectedSortValFloat, (Object)actualHashMap);
        expectedList = new ArrayList(expectedSortValFloat.values());
        actualList = new ArrayList(actualHashMap.values());
        Collections.reverse(expectedList);
        TbExpressionsTest.assertEquals(expectedList, actualList);
        LinkedHashMap<Integer, Object> expectedSortValMixedNumeric = new LinkedHashMap<Integer, Object>();
        expectedSortValMixedNumeric.put(225, "-9223372036854775808");
        expectedSortValMixedNumeric.put(4, 5);
        expectedSortValMixedNumeric.put(2, "8");
        expectedSortValMixedNumeric.put(5, 40);
        expectedSortValMixedNumeric.put(300, 200);
        expectedSortValMixedNumeric.put(3, "700");
        expectedSortValMixedNumeric.put(9, Long.MAX_VALUE);
        actualHashMap = (LinkedHashMap)resMap.get("sortValMixedNumeric");
        TbExpressionsTest.assertEquals(expectedSortValMixedNumeric, (Object)actualHashMap);
        expectedList = new ArrayList(expectedSortValMixedNumeric.values());
        actualList = new ArrayList(actualHashMap.values());
        Collections.reverse(expectedList);
        TbExpressionsTest.assertEquals(expectedList, actualList);
    }

    public void testExecutionHashMapSortByKeyAsc() {
        String body = "var msg = {};\nvar sortValString = {\"21Dragon\":2, \"Brain\":3, \"20\":4, \"30\":1};\nsortValString.sortByKey();\nvar sortValInt = {2:1, 5:30, 225:4, 8:-214748, 1:57, 3:214748, 9:100000};\nsortValInt.sortByKey();\nvar sortValIntLong = {2:45, 9223372036854775807:5, 225:30, 8:40, -9223372036854775808:3, 9:1000};\nsortValIntLong.sortByKey();\nvar sortValFloat = {3.40282:2, 34.17549467:225, 45.40283:3, 1.1754943:5};\nsortValFloat.sortByKey();\nvar sortValMixedNumeric = {\"8\":21, \"-9223372036854775808\":225, \"700\":3, 40:40, 9223372036854775807:9, 4:5, 300:200};\nsortValMixedNumeric.sortByKey();\n\nmsg.sortValString = sortValString;\nmsg.sortValInt = sortValInt;\nmsg.sortValIntLong = sortValIntLong;\nmsg.sortValFloat = sortValFloat;\nmsg.sortValMixedNumeric = sortValMixedNumeric;\nreturn {\n    msg: msg\n};";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        LinkedHashMap<String, Integer> expectedSortKeyString = new LinkedHashMap<String, Integer>();
        expectedSortKeyString.put("20", 4);
        expectedSortKeyString.put("21Dragon", 2);
        expectedSortKeyString.put("30", 1);
        expectedSortKeyString.put("Brain", 3);
        LinkedHashMap actualHashMap = (LinkedHashMap)resMap.get("sortValString");
        TbExpressionsTest.assertEquals(expectedSortKeyString, (Object)actualHashMap);
        TbExpressionsTest.assertEquals(expectedSortKeyString.keySet(), actualHashMap.keySet());
        ArrayList expectedList = new ArrayList(expectedSortKeyString.keySet());
        ArrayList actualList = new ArrayList(actualHashMap.keySet());
        TbExpressionsTest.assertEquals(expectedList, actualList);
        LinkedHashMap<Integer, Integer> expectedSortKeyInt = new LinkedHashMap<Integer, Integer>();
        expectedSortKeyInt.put(1, 57);
        expectedSortKeyInt.put(2, 1);
        expectedSortKeyInt.put(3, 214748);
        expectedSortKeyInt.put(5, 30);
        expectedSortKeyInt.put(8, -214748);
        expectedSortKeyInt.put(9, 100000);
        expectedSortKeyInt.put(225, 4);
        actualHashMap = (LinkedHashMap)resMap.get("sortValInt");
        TbExpressionsTest.assertEquals(expectedSortKeyInt, (Object)actualHashMap);
        expectedList = new ArrayList(expectedSortKeyInt.keySet());
        actualList = new ArrayList(actualHashMap.keySet());
        TbExpressionsTest.assertEquals(expectedList, actualList);
        LinkedHashMap<Number, Integer> expectedSortKeyIntLong = new LinkedHashMap<Number, Integer>();
        expectedSortKeyIntLong.put(Long.MIN_VALUE, 3);
        expectedSortKeyIntLong.put(2, 45);
        expectedSortKeyIntLong.put(8, 40);
        expectedSortKeyIntLong.put(9, 1000);
        expectedSortKeyIntLong.put(225, 30);
        expectedSortKeyIntLong.put(Long.MAX_VALUE, 5);
        actualHashMap = (LinkedHashMap)resMap.get("sortValIntLong");
        TbExpressionsTest.assertEquals(expectedSortKeyIntLong, (Object)actualHashMap);
        expectedList = new ArrayList(expectedSortKeyIntLong.keySet());
        actualList = new ArrayList(actualHashMap.keySet());
        TbExpressionsTest.assertEquals(expectedList, actualList);
        LinkedHashMap<Double, Integer> expectedSortValFloat = new LinkedHashMap<Double, Integer>();
        expectedSortValFloat.put(1.1754943, 5);
        expectedSortValFloat.put(3.40282, 2);
        expectedSortValFloat.put(34.17549467, 225);
        expectedSortValFloat.put(45.40283, 3);
        actualHashMap = (LinkedHashMap)resMap.get("sortValFloat");
        TbExpressionsTest.assertEquals(expectedSortValFloat, (Object)actualHashMap);
        expectedList = new ArrayList(expectedSortValFloat.keySet());
        actualList = new ArrayList(actualHashMap.keySet());
        TbExpressionsTest.assertEquals(expectedList, actualList);
        LinkedHashMap<Object, Integer> expectedSortValMixedNumeric = new LinkedHashMap<Object, Integer>();
        expectedSortValMixedNumeric.put("-9223372036854775808", 225);
        expectedSortValMixedNumeric.put(4, 5);
        expectedSortValMixedNumeric.put("8", 21);
        expectedSortValMixedNumeric.put(40, 40);
        expectedSortValMixedNumeric.put(300, 200);
        expectedSortValMixedNumeric.put("700", 3);
        expectedSortValMixedNumeric.put(Long.MAX_VALUE, 9);
        actualHashMap = (LinkedHashMap)resMap.get("sortValMixedNumeric");
        TbExpressionsTest.assertEquals(expectedSortValMixedNumeric, (Object)actualHashMap);
        expectedList = new ArrayList(expectedSortValMixedNumeric.keySet());
        actualList = new ArrayList(actualHashMap.keySet());
        TbExpressionsTest.assertEquals(expectedList, actualList);
    }

    public void testExecutionHashMapSortByKeyDesc() {
        String body = "var msg = {};\nvar sortValString = {\"21Dragon\":2, \"Brain\":3, \"20\":4, \"30\":1};\nsortValString.sortByKey(false);\nvar sortValInt = {2:1, 5:30, 225:4, 8:-214748, 1:57, 3:214748, 9:100000};\nsortValInt.sortByKey(false);\nvar sortValIntLong = {2:45, 9223372036854775807:5, 225:30, 8:40, -9223372036854775808:3, 9:1000};\nsortValIntLong.sortByKey(false);\nvar sortValFloat = {3.40282:2, 34.17549467:225, 45.40283:3, 1.1754943:5};\nsortValFloat.sortByKey(false);\nvar sortValMixedNumeric = {\"8\":21, \"-9223372036854775808\":225, \"700\":3, 40:40, 9223372036854775807:9, 4:5, 300:200};\nsortValMixedNumeric.sortByKey(false);\n\nmsg.sortValString = sortValString;\nmsg.sortValInt = sortValInt;\nmsg.sortValIntLong = sortValIntLong;\nmsg.sortValFloat = sortValFloat;\nmsg.sortValMixedNumeric = sortValMixedNumeric;\nreturn {\n    msg: msg\n};";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        LinkedHashMap<String, Integer> expectedSortKeyString = new LinkedHashMap<String, Integer>();
        expectedSortKeyString.put("20", 4);
        expectedSortKeyString.put("21Dragon", 2);
        expectedSortKeyString.put("30", 1);
        expectedSortKeyString.put("Brain", 3);
        LinkedHashMap actualHashMap = (LinkedHashMap)resMap.get("sortValString");
        TbExpressionsTest.assertEquals(expectedSortKeyString, (Object)actualHashMap);
        ArrayList expectedList = new ArrayList(expectedSortKeyString.keySet());
        ArrayList actualList = new ArrayList(actualHashMap.keySet());
        Collections.reverse(expectedList);
        TbExpressionsTest.assertEquals(expectedList, actualList);
        LinkedHashMap<Integer, Integer> expectedSortKeyInt = new LinkedHashMap<Integer, Integer>();
        expectedSortKeyInt.put(1, 57);
        expectedSortKeyInt.put(2, 1);
        expectedSortKeyInt.put(3, 214748);
        expectedSortKeyInt.put(5, 30);
        expectedSortKeyInt.put(8, -214748);
        expectedSortKeyInt.put(9, 100000);
        expectedSortKeyInt.put(225, 4);
        actualHashMap = (LinkedHashMap)resMap.get("sortValInt");
        TbExpressionsTest.assertEquals(expectedSortKeyInt, (Object)actualHashMap);
        expectedList = new ArrayList(expectedSortKeyInt.keySet());
        actualList = new ArrayList(actualHashMap.keySet());
        Collections.reverse(expectedList);
        TbExpressionsTest.assertEquals(expectedList, actualList);
        LinkedHashMap<Number, Integer> expectedSortKeyIntLong = new LinkedHashMap<Number, Integer>();
        expectedSortKeyIntLong.put(Long.MIN_VALUE, 3);
        expectedSortKeyIntLong.put(2, 45);
        expectedSortKeyIntLong.put(8, 40);
        expectedSortKeyIntLong.put(9, 1000);
        expectedSortKeyIntLong.put(225, 30);
        expectedSortKeyIntLong.put(Long.MAX_VALUE, 5);
        actualHashMap = (LinkedHashMap)resMap.get("sortValIntLong");
        TbExpressionsTest.assertEquals(expectedSortKeyIntLong, (Object)actualHashMap);
        expectedList = new ArrayList(expectedSortKeyIntLong.keySet());
        actualList = new ArrayList(actualHashMap.keySet());
        Collections.reverse(expectedList);
        TbExpressionsTest.assertEquals(expectedList, actualList);
        LinkedHashMap<Double, Integer> expectedSortValFloat = new LinkedHashMap<Double, Integer>();
        expectedSortValFloat.put(1.1754943, 5);
        expectedSortValFloat.put(3.40282, 2);
        expectedSortValFloat.put(34.17549467, 225);
        expectedSortValFloat.put(45.40283, 3);
        actualHashMap = (LinkedHashMap)resMap.get("sortValFloat");
        TbExpressionsTest.assertEquals(expectedSortValFloat, (Object)actualHashMap);
        expectedList = new ArrayList(expectedSortValFloat.keySet());
        actualList = new ArrayList(actualHashMap.keySet());
        Collections.reverse(expectedList);
        TbExpressionsTest.assertEquals(expectedList, actualList);
        LinkedHashMap<Object, Integer> expectedSortValMixedNumeric = new LinkedHashMap<Object, Integer>();
        expectedSortValMixedNumeric.put("-9223372036854775808", 225);
        expectedSortValMixedNumeric.put(4, 5);
        expectedSortValMixedNumeric.put("8", 21);
        expectedSortValMixedNumeric.put(40, 40);
        expectedSortValMixedNumeric.put(300, 200);
        expectedSortValMixedNumeric.put("700", 3);
        expectedSortValMixedNumeric.put(Long.MAX_VALUE, 9);
        actualHashMap = (LinkedHashMap)resMap.get("sortValMixedNumeric");
        TbExpressionsTest.assertEquals(expectedSortValMixedNumeric, (Object)actualHashMap);
        expectedList = new ArrayList(expectedSortValMixedNumeric.keySet());
        actualList = new ArrayList(actualHashMap.keySet());
        Collections.reverse(expectedList);
        TbExpressionsTest.assertEquals(expectedList, actualList);
    }

    public void testExecutionArrayListSortNumericWithString_Error() {
        String body = "var msg = {};\nvar mixedNumericStringArray = [\"8\", \"9\", 'Jabnm', 40, 1, 5, 200];\nmixedNumericStringArray.sort();\nmsg.mixedNumericStringArray = mixedNumericStringArray;\nreturn {msg: msg};";
        try {
            this.executeScript(body);
            TbExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("For input string: \"Jabnm\""));
        }
    }

    public void testExecutionHashMapSortByValueNumericWithString_Error() {
        String body = "var msg = {};\nvar sortValMixedNumeric = {2:\"8\", 225:\"-9223372036854775808\", 3:\"rt700\", 5:40, 9:9223372036854775807, 4:5, 300:200};\nsortValMixedNumeric.sortByValue(false);\nmsg.sortValMixedNumeric = sortValMixedNumeric;\nreturn {\n    msg: msg\n};";
        try {
            this.executeScript(body);
            TbExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("For input string: \"rt700\""));
        }
    }

    public void testExecutionHashMapSortByKeyNumericWithString_Error() {
        String body = "var msg = {};\nvar sortValMixedNumeric = {\"8\":21, \"-9223372036854775808\":225, \"rt700\":3, 40:40, 9223372036854775807:9, 4:5, 300:200};\nsortValMixedNumeric.sortByKey();\n\n\nmsg.sortValMixedNumeric = sortValMixedNumeric;\nreturn {\n    msg: msg\n};";
        try {
            this.executeScript(body);
            TbExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("For input string: \"rt700\""));
        }
    }

    public void testExecutionArrayList_Reverse() {
        String body = "var msg = {};\nvar array = [\"8\", 40, 9223372036854775807, \"Dec\", \"-9223372036854775808\"];\nmsg.array = array.slice();\narray.reverse();\nmsg.arrayRev = array;\nreturn {msg: msg};";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        ArrayList<Object> expectedArray = new ArrayList<Object>();
        expectedArray.add("8");
        expectedArray.add(40);
        expectedArray.add(Long.MAX_VALUE);
        expectedArray.add("Dec");
        expectedArray.add("-9223372036854775808");
        List actualArray = (List)resMap.get("array");
        TbExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        Collections.reverse(expectedArray);
        actualArray = (List)resMap.get("arrayRev");
        TbExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
    }

    public void testExecutionArrayList_toReversed() {
        String body = "var msg = {};\nvar array = [\"8\", 40, 9223372036854775807, \"Dec\", \"-9223372036854775808\"];\nmsg.array = array;\nmsg.arrayRev = array.toReversed();\nreturn {msg: msg}";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        ArrayList<Object> expectedArray = new ArrayList<Object>();
        expectedArray.add("8");
        expectedArray.add(40);
        expectedArray.add(Long.MAX_VALUE);
        expectedArray.add("Dec");
        expectedArray.add("-9223372036854775808");
        List actualArray = (List)resMap.get("array");
        TbExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        Collections.reverse(expectedArray);
        actualArray = (List)resMap.get("arrayRev");
        TbExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
    }

    public void testExecutionArrayList_slice() {
        String body = "var msg = {};\nvar arrayWithEmpty = [\"8\", 40, 9223372036854775807, , \"-9223372036854775808\"];\nvar array = [\"8\", 40, 9223372036854775807, \"Dec\", \"-9223372036854775808\"];\nmsg.array = array;\nmsg.arrayWithEmpty = arrayWithEmpty;\nmsg.arraySlice = array.slice();\nmsg.arraySliceWithEmpty = arrayWithEmpty.slice();\nmsg.arraySlice2 = array.slice(2);\nmsg.arraySlice5 = array.slice(5);\nmsg.arraySlice2_4 = array.slice(2, 4);\nmsg.arraySlice1_5 = array.slice(1, 5);\nmsg.arraySliceStr3_4 = array.slice(\"3\", \"4\");\nmsg.arraySlice_2 = array.slice(-2);\nmsg.arraySlice2_1 = array.slice(2, -1);\nreturn {msg: msg}";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        List actualArray = (List)resMap.get("arrayWithEmpty");
        List expectedArray = (List)resMap.get("arraySliceWithEmpty");
        TbExpressionsTest.assertEquals((Object)expectedArray, (Object)actualArray);
        List expected = actualArray = (List)resMap.get("array");
        expectedArray = (List)resMap.get("arraySlice");
        TbExpressionsTest.assertEquals((Object)expectedArray, (Object)actualArray);
        expectedArray = expected.subList(2, expected.size());
        actualArray = (List)resMap.get("arraySlice2");
        TbExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        expectedArray = expected.subList(5, expected.size());
        actualArray = (List)resMap.get("arraySlice5");
        TbExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        expectedArray = expected.subList(2, 4);
        actualArray = (List)resMap.get("arraySlice2_4");
        TbExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        expectedArray = expected.subList(1, 5);
        actualArray = (List)resMap.get("arraySlice1_5");
        TbExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        expectedArray = expected.subList(3, 4);
        actualArray = (List)resMap.get("arraySliceStr3_4");
        TbExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        expectedArray = expected.subList(-2 + expected.size(), 5);
        actualArray = (List)resMap.get("arraySlice_2");
        TbExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        expectedArray = expected.subList(2, -1 + expected.size());
        actualArray = (List)resMap.get("arraySlice2_1");
        TbExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
    }

    public void testExecutionArrayList_sliceWithStartMoreEnd_Error() {
        String body = "var msg = {};\nvar array = [\"8\", 40, 9223372036854775807, \"Dec\", \"-9223372036854775808\"];\nmsg.arraySlice6 = array.slice(6);\nreturn {msg: msg}";
        try {
            this.executeScript(body);
            TbExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("fromIndex(6) > toIndex(5)"));
        }
    }

    public void testExecutionArrayList_sliceWithStartNotNumeric_Error() {
        String body = "var msg = {};\nvar array = [\"8\", 40, 9223372036854775807, \"Dec\", \"-9223372036854775808\"];\nmsg.arraySlice6 = array.slice(\"rt\", \"2\");\nreturn {msg: msg}";
        try {
            this.executeScript(body);
            TbExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("For input string: \"rt\""));
        }
    }

    public void testExecutionArrayList_sliceWithEndNotNumeric_Error() {
        String body = "var msg = {};\nvar array = [\"8\", 40, 9223372036854775807, \"Dec\", \"-9223372036854775808\"];\nmsg.arraySlice6 = array.slice(\"1\", \"Dec\");\nreturn {msg: msg}";
        try {
            this.executeScript(body);
            TbExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("For input string: \"Dec\""));
        }
    }

    public void testExecutionArrayList_indexOf() {
        String body = "var msg = {};\nvar arrayInd = [\"a\", 34, \"a\", 34, \"a\", \"a\"];\nvar msg.rezInd = arrayInd.indexOf(\"a\", 1) ;\nreturn {msg: msg}";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        int actualInd = (Integer)resMap.get("rezInd");
        TbExpressionsTest.assertEquals((int)2, (int)actualInd);
        body = "var msg = {};\nvar arrayInd = [\"a\", 34, \"a\", 34, \"a\", \"a\"];\nvar msg.rezInd = arrayInd.indexOf(\"a\", 3) ;\nreturn {msg: msg}";
        result = this.executeScript(body);
        resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        actualInd = (Integer)resMap.get("rezInd");
        TbExpressionsTest.assertEquals((int)4, (int)actualInd);
        body = "var msg = {};\nvar arrayInd = [\"a\", 34, \"a\", 34, \"a\", \"a\"];\nvar msg.rezInd = arrayInd.indexOf(\"a\", 5) ;\nreturn {msg: msg}";
        result = this.executeScript(body);
        resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        actualInd = (Integer)resMap.get("rezInd");
        TbExpressionsTest.assertEquals((int)5, (int)actualInd);
        body = "var msg = {};\nvar arrayInd = [\"a\", 34, \"a\", 34, \"a\", \"a\"];\nvar msg.rezInd = arrayInd.indexOf(\"a\", 5) ;\nreturn {msg: msg}";
        result = this.executeScript(body);
        resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        actualInd = (Integer)resMap.get("rezInd");
        TbExpressionsTest.assertEquals((int)5, (int)actualInd);
        body = "var msg = {};\nvar arrayInd = [\"a\", 34, \"a\", 34, \"a\", \"a\"];\nvar msg.rezInd = arrayInd.indexOf(34, 2) ;\nreturn {msg: msg}";
        result = this.executeScript(body);
        resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        actualInd = (Integer)resMap.get("rezInd");
        TbExpressionsTest.assertEquals((int)3, (int)actualInd);
        body = "var msg = {};\nvar arrayInd = [\"a\", 34, \"a\", 34, \"a\", \"a\"];\nvar msg.rezInd = arrayInd.indexOf(34, 4) ;\nreturn {msg: msg}";
        result = this.executeScript(body);
        resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        actualInd = (Integer)resMap.get("rezInd");
        TbExpressionsTest.assertEquals((int)-1, (int)actualInd);
    }

    public void testExecutionArrayList_concat() {
        String body = "var msg = {};\nvar letters = [\"Dec\", \"Feb\", \"Jan\"];\nvar numbers = [1, 2, 3];\nvar alphaNumeric = letters.concat(numbers);\nmsg.letters = letters;\nmsg.numbers = numbers;\nmsg.alphaNumeric = alphaNumeric;\nreturn {msg: msg};";
        Object result = this.executeScript(body);
        ArrayList<String> expectedArrayString = new ArrayList<String>();
        expectedArrayString.add("Dec");
        expectedArrayString.add("Feb");
        expectedArrayString.add("Jan");
        ArrayList<Integer> expectedArrayNumbers = new ArrayList<Integer>();
        expectedArrayNumbers.add(1);
        expectedArrayNumbers.add(2);
        expectedArrayNumbers.add(3);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        List actualArray = (List)resMap.get("letters");
        TbExpressionsTest.assertEquals(expectedArrayString, (Object)actualArray);
        actualArray = (List)resMap.get("numbers");
        TbExpressionsTest.assertEquals(expectedArrayNumbers, (Object)actualArray);
        expectedArrayString.addAll(expectedArrayNumbers);
        actualArray = (List)resMap.get("alphaNumeric");
        TbExpressionsTest.assertEquals(expectedArrayString, (Object)actualArray);
    }

    public void testExecutionArrayList_splice_Inserts_index_1() {
        String body = "var msg = {};\nvar months = ['Jan', 'March', 'April', 'June'];\nvar removed = months.splice(1, 0, 'Feb');\nmsg.months = months;\nmsg.removed = removed;\nreturn {msg: msg};";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        ArrayList<String> expectedArray = new ArrayList<String>();
        expectedArray.add("Jan");
        expectedArray.add("Feb");
        expectedArray.add("March");
        expectedArray.add("April");
        expectedArray.add("June");
        List actualArray = (List)resMap.get("removed");
        TbExpressionsTest.assertEquals((int)0, (int)actualArray.size());
        actualArray = (List)resMap.get("months");
        TbExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
    }

    public void testExecutionArrayList_splice_Remove_zero_Insert_2_element_at_index_4() {
        String body = "var msg = {};\nvar months = [\"angel\", \"clown\", \"mandarin\", \"sturgeon\"];\nvar removed = months.splice(2, 0, \"drum\", \"guitar\");\nmsg.months = months;\nmsg.removed = removed;\nreturn {msg: msg};";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        ArrayList<String> expectedArray = new ArrayList<String>();
        expectedArray.add("angel");
        expectedArray.add("clown");
        expectedArray.add("drum");
        expectedArray.add("guitar");
        expectedArray.add("mandarin");
        expectedArray.add("sturgeon");
        ArrayList<String> expectedArrayRemoved = new ArrayList<String>();
        expectedArrayRemoved.add("June");
        List actualArray = (List)resMap.get("removed");
        TbExpressionsTest.assertEquals((int)0, (int)actualArray.size());
        actualArray = (List)resMap.get("months");
        TbExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
    }

    public void testExecutionArrayList_splice_Remove_2_Insert_3_element_at_index_1() {
        String body = "var msg = {};\nvar months = [\"angel\", \"clown\", \"trumpet\", \"sturgeon\"];\nvar removed = months.splice(1, 2, \"parrot\", \"anemone\", \"blue\");\nmsg.months = months;\nmsg.removed = removed;\nreturn {msg: msg};";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        ArrayList<String> expectedArray = new ArrayList<String>();
        expectedArray.add("angel");
        expectedArray.add("parrot");
        expectedArray.add("anemone");
        expectedArray.add("blue");
        expectedArray.add("sturgeon");
        ArrayList<String> expectedArrayRemoved = new ArrayList<String>();
        expectedArrayRemoved.add("clown");
        expectedArrayRemoved.add("trumpet");
        List actualArray = (List)resMap.get("removed");
        TbExpressionsTest.assertEquals(expectedArrayRemoved, (Object)actualArray);
        actualArray = (List)resMap.get("months");
        TbExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
    }

    public void testExecutionArrayList_splice_Replaces_2_element_at_index_4() {
        String body = "var msg = {};\nvar months = [\"Jan\", \"Feb\", \"March\", \"April\", \"June\"];\nvar removed = months.splice(4, 1, 'May');\nmsg.months = months;\nmsg.removed = removed;\nreturn {msg: msg};";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        ArrayList<String> expectedArray = new ArrayList<String>();
        expectedArray.add("Jan");
        expectedArray.add("Feb");
        expectedArray.add("March");
        expectedArray.add("April");
        expectedArray.add("May");
        ArrayList<String> expectedArrayRemoved = new ArrayList<String>();
        expectedArrayRemoved.add("June");
        List actualArray = (List)resMap.get("removed");
        TbExpressionsTest.assertEquals(expectedArrayRemoved, (Object)actualArray);
        actualArray = (List)resMap.get("months");
        TbExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
    }

    public void testExecutionArrayList_splice_Remove_1_element_at_index_Minus_3() {
        String body = "var msg = {};\nvar months = [\"angel\", \"clown\", \"mandarin\", \"sturgeon\"];\nvar removed = months.splice(-3, 1);\nmsg.months = months;\nmsg.removed = removed;\nreturn {msg: msg};";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        ArrayList<String> expectedArray = new ArrayList<String>();
        expectedArray.add("angel");
        expectedArray.add("mandarin");
        expectedArray.add("sturgeon");
        ArrayList<String> expectedArrayRemoved = new ArrayList<String>();
        expectedArrayRemoved.add("clown");
        List actualArray = (List)resMap.get("removed");
        TbExpressionsTest.assertEquals(expectedArrayRemoved, (Object)actualArray);
        actualArray = (List)resMap.get("months");
        TbExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
    }

    public void testExecutionArrayList_splice_Remove_All_element_at_index_3() {
        String body = "var msg = {};\nvar months = [\"angel\", \"clown\", \"mandarin\", \"sturgeon\"];\nvar removed = months.splice(3);\nmsg.months = months;\nmsg.removed = removed;\nreturn {msg: msg};";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        ArrayList<String> expectedArray = new ArrayList<String>();
        expectedArray.add("angel");
        expectedArray.add("clown");
        expectedArray.add("mandarin");
        List actualArray = (List)resMap.get("months");
        TbExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        ArrayList<String> expectedArrayRemoved = new ArrayList<String>();
        expectedArrayRemoved.add("sturgeon");
        actualArray = (List)resMap.get("removed");
        TbExpressionsTest.assertEquals(expectedArrayRemoved, (Object)actualArray);
    }

    public void testExecutionArrayList_splice_Remove_All_element_at_index_Minus_3() {
        String body = "var msg = {};\nvar months = [\"angel\", \"clown\", \"mandarin\", \"sturgeon\"];\nvar removed = months.splice(-3);\nmsg.months = months;\nmsg.removed = removed;\nreturn {msg: msg};";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        ArrayList<String> expectedArrayMonth = new ArrayList<String>();
        expectedArrayMonth.add("angel");
        ArrayList<String> expectedArrayRemoved = new ArrayList<String>();
        expectedArrayRemoved.add("clown");
        expectedArrayRemoved.add("mandarin");
        expectedArrayRemoved.add("sturgeon");
        List actualArray = (List)resMap.get("removed");
        TbExpressionsTest.assertEquals(expectedArrayRemoved, (Object)actualArray);
        actualArray = (List)resMap.get("months");
        TbExpressionsTest.assertEquals(expectedArrayMonth, (Object)actualArray);
    }

    public void testExecutionArrayList_splice_Return_Clone() {
        String body = "var msg = {};\nvar months = [\"angel\", \"clown\", \"mandarin\", \"sturgeon\"];\nvar removed = months.splice(-3);\nmsg.months = months;\nmsg.removed = removed;\nreturn {msg: msg};";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        ArrayList<String> expectedArrayMonth = new ArrayList<String>();
        expectedArrayMonth.add("angel");
        ArrayList<String> expectedArrayRemoved = new ArrayList<String>();
        expectedArrayRemoved.add("clown");
        expectedArrayRemoved.add("mandarin");
        expectedArrayRemoved.add("sturgeon");
        List actualArray = (List)resMap.get("removed");
        TbExpressionsTest.assertEquals(expectedArrayRemoved, (Object)actualArray);
        actualArray = (List)resMap.get("months");
        TbExpressionsTest.assertEquals(expectedArrayMonth, (Object)actualArray);
    }

    public void testExecutionArrayList_splice_Remove_All_element_at_index_Minus_5_Size_4() {
        String body = "var msg = {};\nvar months = [\"angel\", \"clown\", \"mandarin\", \"sturgeon\"];\nvar removed = months.splice(-5);\nmsg.months = months;\nmsg.removed = removed;\nreturn {msg: msg};";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        ArrayList<String> expectedArrayRemoved = new ArrayList<String>();
        expectedArrayRemoved.add("angel");
        expectedArrayRemoved.add("clown");
        expectedArrayRemoved.add("mandarin");
        expectedArrayRemoved.add("sturgeon");
        List actualArray = (List)resMap.get("removed");
        TbExpressionsTest.assertEquals(expectedArrayRemoved, (Object)actualArray);
        actualArray = (List)resMap.get("months");
        TbExpressionsTest.assertEquals((int)0, (int)actualArray.size());
    }

    public void testExecutionArrayList_toSpliced_Inserts_Element_1_index_1() {
        String body = "var msg = {};\nvar months = ['Jan', 'March', 'April', 'June'];\nvar newMonths = months.toSpliced(1, 0, 'Feb');\nmsg.months = months;\nmsg.newMonths = newMonths;\nreturn {msg: msg};";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        ArrayList<String> expectedArray = new ArrayList<String>();
        expectedArray.add("Jan");
        expectedArray.add("March");
        expectedArray.add("April");
        expectedArray.add("June");
        ArrayList<String> expectedNewArray = new ArrayList<String>();
        expectedNewArray.add("Jan");
        expectedNewArray.add("Feb");
        expectedNewArray.add("March");
        expectedNewArray.add("April");
        expectedNewArray.add("June");
        List actualArray = (List)resMap.get("months");
        TbExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        actualArray = (List)resMap.get("newMonths");
        TbExpressionsTest.assertEquals(expectedNewArray, (Object)actualArray);
    }

    public void testExecutionArrayList_toSpliced_Delete_Element_2_index_1() {
        String body = "var msg = {};\nvar months = [\"Jan\", \"Feb\", \"March\", \"Apr\", \"May\"];\nvar newMonths = months.toSpliced(1, 2);\nmsg. months =  months;\nmsg. newMonths =  newMonths;\nreturn {msg: msg};";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        ArrayList<String> expectedArray = new ArrayList<String>();
        expectedArray.add("Jan");
        expectedArray.add("Feb");
        expectedArray.add("March");
        expectedArray.add("Apr");
        expectedArray.add("May");
        ArrayList<String> expectedNewArray = new ArrayList<String>();
        expectedNewArray.add("Jan");
        expectedNewArray.add("Apr");
        expectedNewArray.add("May");
        List actualArray = (List)resMap.get("months");
        TbExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        actualArray = (List)resMap.get("newMonths");
        TbExpressionsTest.assertEquals(expectedNewArray, (Object)actualArray);
    }

    public void testExecutionArrayList_toSpliced_Complex() {
        String body = "var msg = {};\nvar months = [\"Jan\", \"Mar\", \"Apr\", \"May\"];\nvar months2 = months.toSpliced(1, 0, \"Feb\");\nmsg.months2 = months2;\nvar months3 = months2.toSpliced(2, 2);\nmsg.months3 = months3;\nvar months4 = months3.toSpliced(1, 1, \"Feb\", \"Mar\");\nmsg.months4 = months4; \nmsg.months = months; \nreturn {msg: msg};";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        ArrayList<String> expectedArray = new ArrayList<String>();
        expectedArray.add("Jan");
        expectedArray.add("Mar");
        expectedArray.add("Apr");
        expectedArray.add("May");
        ArrayList<String> expectedNewArray2 = new ArrayList<String>();
        expectedNewArray2.add("Jan");
        expectedNewArray2.add("Feb");
        expectedNewArray2.add("Mar");
        expectedNewArray2.add("Apr");
        expectedNewArray2.add("May");
        ArrayList<String> expectedNewArray3 = new ArrayList<String>();
        expectedNewArray3.add("Jan");
        expectedNewArray3.add("Feb");
        expectedNewArray3.add("May");
        ArrayList<String> expectedNewArray4 = new ArrayList<String>();
        expectedNewArray4.add("Jan");
        expectedNewArray4.add("Feb");
        expectedNewArray4.add("Mar");
        expectedNewArray4.add("May");
        List actualArray = (List)resMap.get("months");
        TbExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        actualArray = (List)resMap.get("months2");
        TbExpressionsTest.assertEquals(expectedNewArray2, (Object)actualArray);
        actualArray = (List)resMap.get("months3");
        TbExpressionsTest.assertEquals(expectedNewArray3, (Object)actualArray);
        actualArray = (List)resMap.get("months4");
        TbExpressionsTest.assertEquals(expectedNewArray4, (Object)actualArray);
    }

    public void testExecutionArrayList_With_Index_Ok() {
        String body = "var msg = {};\nvar arr = [1, 2, 3, 4, 5];\nvar arrWith = arr.with(2, 6);\nmsg.arr = arr;\nmsg.arrWith = arrWith;\nreturn {msg: msg};";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        ArrayList<Integer> expectedArray = new ArrayList<Integer>();
        expectedArray.add(1);
        expectedArray.add(2);
        expectedArray.add(3);
        expectedArray.add(4);
        expectedArray.add(5);
        List actualArray = (List)resMap.get("arr");
        TbExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        expectedArray.add(2, 6);
        actualArray = (List)resMap.get("arrWith");
        TbExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
    }

    public void testExecutionArrayList_With_Index_Bad() {
        String body = "var msg = {};\nvar arr = [1, 2, 3, 4, 5];\nvar arrWith = arr.with(6, 6);\nmsg.arr = arr;\nmsg.arrWith = arrWith;\nreturn {msg: msg};";
        try {
            this.executeScript(body);
            TbExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("arr.with(6, 6): Index: 6, Size: 5"));
        }
        body = "var msg = {};\nvar arr = [1, 2, 3, 4, 5];\nvar arrWith = arr.with(-6, 6);\nmsg.arr = arr;\nmsg.arrWith = arrWith;\nreturn {msg: msg};";
        try {
            this.executeScript(body);
            TbExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("arr.with(-6, 6): Index: -6, Size: 5"));
        }
    }

    public void testExecutionArrayList_Fill_Index_Ok() {
        String parameter = "4";
        String body1 = "var msg = {};\nvar arr = [1, 2, 3];\nvar arrFill = arr.fill(";
        String body2 = ");\nmsg.arr = arr;\nmsg.arrFill = arrFill;\nreturn {msg: msg};";
        String body = body1 + parameter + body2;
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        ArrayList<Integer> expectedArray = new ArrayList<Integer>();
        expectedArray.add(4);
        expectedArray.add(4);
        expectedArray.add(4);
        List actualArray = (List)resMap.get("arr");
        TbExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        actualArray = (List)resMap.get("arrFill");
        TbExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        parameter = "4, 1";
        body = body1 + parameter + body2;
        expectedArray.set(0, 1);
        result = this.executeScript(body);
        resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        actualArray = (List)resMap.get("arr");
        TbExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        actualArray = (List)resMap.get("arrFill");
        TbExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        parameter = "4, 1, 2";
        body = body1 + parameter + body2;
        expectedArray.set(2, 3);
        result = this.executeScript(body);
        resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        actualArray = (List)resMap.get("arr");
        TbExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        actualArray = (List)resMap.get("arrFill");
        TbExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        parameter = "4, 1, 1";
        body = body1 + parameter + body2;
        expectedArray.set(0, 1);
        expectedArray.set(1, 2);
        result = this.executeScript(body);
        resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        actualArray = (List)resMap.get("arr");
        TbExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        actualArray = (List)resMap.get("arrFill");
        TbExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        parameter = "4, -3, -2";
        body = body1 + parameter + body2;
        expectedArray.set(0, 4);
        result = this.executeScript(body);
        resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        actualArray = (List)resMap.get("arr");
        TbExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        actualArray = (List)resMap.get("arrFill");
        TbExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        parameter = "4, 3, 5";
        body = body1 + parameter + body2;
        expectedArray.set(0, 1);
        result = this.executeScript(body);
        resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        actualArray = (List)resMap.get("arr");
        TbExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        actualArray = (List)resMap.get("arrFill");
        TbExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
    }

    private Object executeScript(String ex, Map vars, ExecutionContext executionContext, long timeoutMs) throws Exception {
        CountDownLatch countDown = new CountDownLatch(1);
        AtomicReference result = new AtomicReference();
        AtomicReference exception = new AtomicReference();
        Thread thread = new Thread(() -> {
            try {
                result.set(this.executeScript(ex, vars, executionContext));
            }
            catch (Exception e) {
                exception.set(e);
            }
            finally {
                countDown.countDown();
            }
        });
        thread.start();
        try {
            countDown.await(timeoutMs, TimeUnit.MILLISECONDS);
            executionContext.stop();
            countDown.await(500L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (exception.get() != null) {
            throw (Exception)exception.get();
        }
        return result.get();
    }

    private Object executeScript(String ex) {
        return this.executeScript(ex, new HashMap());
    }

    private Object executeScript(String ex, Map vars) {
        return this.executeScript(ex, vars, new ExecutionContext(this.parserConfig));
    }

    private Object executeScript(String ex, Map vars, ExecutionContext executionContext) {
        Serializable compiled = MVEL.compileExpression((String)ex, (ParserContext)new ParserContext());
        this.currentExecutionContext = executionContext;
        return MVEL.executeTbExpression((Object)compiled, (ExecutionContext)this.currentExecutionContext, (Map)vars);
    }

    public static final class MyTestClass {
        private final String innerValue;

        public MyTestClass(String val) {
            this.innerValue = val;
        }

        public String getValue() {
            return this.innerValue;
        }
    }

    public static final class TestUtil {
        public static String getFoo(Map input) {
            if (input.containsKey("foo")) {
                return input.get("foo") != null ? input.get("foo").toString() : "null";
            }
            return "Not found!";
        }

        public static Map methodWithExecContext(String key, Object val, ExecutionContext ctx) {
            ExecutionHashMap map = new ExecutionHashMap(1, ctx);
            map.put(key, val);
            return map;
        }

        public static Map methodWithExecContext2(String key, ExecutionContext ctx, Object val) {
            ExecutionHashMap map = new ExecutionHashMap(1, ctx);
            map.put(key, val);
            return map;
        }

        public static Map methodWithExecContext3(ExecutionContext ctx, String key, Object val) {
            ExecutionHashMap map = new ExecutionHashMap(1, ctx);
            map.put(key, val);
            return map;
        }

        public static List methodWithExecContextVarArgs(ExecutionContext ctx, Object ... vals) {
            ExecutionArrayList list = new ExecutionArrayList(Arrays.asList(vals), ctx);
            return list;
        }
    }
}

