/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.tests.core;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.mvel2.CompileException;
import org.mvel2.ExecutionContext;
import org.mvel2.MVEL;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;
import org.mvel2.SandboxedParserConfiguration;
import org.mvel2.execution.ExecutionArrayList;
import org.mvel2.optimizers.OptimizerFactory;
import org.mvel2.util.MethodStub;

public class TbUtilsExpressionsTest
extends TestCase {
    private SandboxedParserConfiguration parserConfig;

    protected void setUp() throws Exception {
        OptimizerFactory.setDefaultOptimizer((String)OptimizerFactory.SAFE_REFLECTIVE);
        super.setUp();
        this.parserConfig = ParserContext.enableSandboxedMode();
        try {
            TbUtils.register((ParserConfiguration)this.parserConfig);
            this.parserConfig.addImport(TbUtils.class);
        }
        catch (Exception e) {
            System.out.println("Cannot register functions " + e.getMessage());
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        ParserContext.disableSandboxedMode();
    }

    public void testStringToBytes_ArgumentTypeIsString_Ok() throws Exception {
        String expectedStr = "{\"hello\": \"world\"}";
        String scriptBody = "var input = \"{\\\"hello\\\": \\\"world\\\"}\"; \nvar newMsg = stringToBytes(input);\n\nreturn {msg: newMsg};";
        LinkedHashMap<String, List<Byte>> expected = new LinkedHashMap<String, List<Byte>>();
        List<Byte> expIntList = this.bytesToList(expectedStr.getBytes());
        expected.put("msg", expIntList);
        Object actual = this.executeScript(scriptBody);
        TbUtilsExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testStringToBytes_ArgumentTypeIsObjectAsString_Ok() throws Exception {
        String expectedStr = "world";
        String scriptBody = "var dataMap = {};\ndataMap.hello = \"world\";\nvar newMsg =  stringToBytes(dataMap.get(\"hello\"));\nreturn {msg: newMsg}";
        LinkedHashMap<String, List<Byte>> expected = new LinkedHashMap<String, List<Byte>>();
        List<Byte> expIntList = this.bytesToList(expectedStr.getBytes());
        expected.put("msg", expIntList);
        Object actual = this.executeScript(scriptBody);
        TbUtilsExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testStringToBytes_ArgumentTypeIsNotStringLineNotZero_Bad() throws Exception {
        String argument = "msgTest";
        String scriptBody = "var " + argument + "  = {\"hello\": \"world\"}; \nvar newMsg = stringToBytes(" + argument + ");\n\nreturn {msg: newMsg};";
        try {
            this.executeScript(scriptBody);
            TbUtilsExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbUtilsExpressionsTest.assertTrue((boolean)e.getMessage().equals("[Error: stringToBytes(msgTest): Invalid type parameter [ExecutionHashMap]. Expected 'String']\n[Near : {... var newMsg = stringToBytes(msgTest); ....}]\n                          ^\n[Line: 2, Column: 14]"));
        }
    }

    private Object executeScript(String ex) {
        return this.executeScript(ex, new HashMap());
    }

    private Object executeScript(String ex, Map vars) {
        return this.executeScript(ex, vars, new ExecutionContext(this.parserConfig));
    }

    private Object executeScript(String ex, Map vars, ExecutionContext executionContext) {
        Serializable compiled = MVEL.compileExpression((String)ex, (ParserContext)new ParserContext());
        return MVEL.executeTbExpression((Object)compiled, (ExecutionContext)executionContext, (Map)vars);
    }

    private List<Byte> bytesToList(byte[] bytes) {
        ArrayList<Byte> list = new ArrayList<Byte>();
        for (byte aByte : bytes) {
            list.add(aByte);
        }
        return list;
    }

    public static class TbUtils {
        private static final byte[] HEX_ARRAY = "0123456789ABCDEF".getBytes(StandardCharsets.US_ASCII);

        public static void register(ParserConfiguration parserConfig) throws Exception {
            parserConfig.addImport("stringToBytes", new MethodStub(TbUtils.class.getMethod("stringToBytes", ExecutionContext.class, Object.class)));
            parserConfig.addImport("stringToBytes", new MethodStub(TbUtils.class.getMethod("stringToBytes", ExecutionContext.class, Object.class, String.class)));
            parserConfig.registerNonConvertableMethods(TbUtils.class, Collections.singleton("stringToBytes"));
        }

        public static List<Byte> stringToBytes(ExecutionContext ctx, Object str) throws IllegalAccessException {
            if (str instanceof String) {
                byte[] bytes = str.toString().getBytes();
                return TbUtils.bytesToList(ctx, bytes);
            }
            throw new IllegalAccessException("Invalid type parameter [" + str.getClass().getSimpleName() + "]. Expected 'String'");
        }

        public static List<Byte> stringToBytes(ExecutionContext ctx, Object str, String charsetName) throws UnsupportedEncodingException, IllegalAccessException {
            if (str instanceof String) {
                byte[] bytes = str.toString().getBytes(charsetName);
                return TbUtils.bytesToList(ctx, bytes);
            }
            throw new IllegalAccessException("Invalid type parameter [" + str.getClass().getSimpleName() + "]. Expected 'String'");
        }

        private static List<Byte> bytesToList(ExecutionContext ctx, byte[] bytes) {
            ExecutionArrayList list = new ExecutionArrayList(ctx);
            for (byte aByte : bytes) {
                list.add(aByte);
            }
            return list;
        }
    }
}

