/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.tests.core;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.tests.core.AbstractTest;

public class ThreadUnsafeTest
extends AbstractTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testClassImportResolver() {
        MVEL.RUNTIME_OPT_THREAD_UNSAFE = true;
        try {
            ParserContext pCtx = new ParserContext();
            AlgoContext ctx = new AlgoContext();
            ExpressionContext expressionContext = new ExpressionContext();
            ctx.setExpressionContext(expressionContext);
            expressionContext.setContext(ctx);
            Order order = new Order(1L, 10, 100.49);
            OrderHelper helper = new OrderHelper();
            helper.setOrder(order);
            expressionContext.setHelper(helper);
            Serializable compiledExpression = MVEL.compileExpression((String)"import java.util.List; total", (ParserContext)pCtx);
            Serializable compiledExpression1 = MVEL.compileExpression((String)"import java.util.List; farTouchPrice", (ParserContext)pCtx);
            double total = (Double)MVEL.executeExpression((Object)compiledExpression, (Object)expressionContext, expressionContext.getVariableMap());
            ThreadUnsafeTest.assertEquals((double)1004.9, (double)total, (double)0.1);
            double farrouchprice = (Double)MVEL.executeExpression((Object)compiledExpression1, (Object)expressionContext, expressionContext.getVariableMap());
            ThreadUnsafeTest.assertEquals((Object)101.4, (Object)farrouchprice);
            order = new Order(2L, 20, 101.49);
            helper.setOrder(order);
            total = (Double)MVEL.executeExpression((Object)compiledExpression, (Object)expressionContext, expressionContext.getVariableMap());
            ThreadUnsafeTest.assertEquals((double)2029.8, (double)total, (double)0.1);
        }
        finally {
            MVEL.RUNTIME_OPT_THREAD_UNSAFE = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStackResolver() {
        MVEL.RUNTIME_OPT_THREAD_UNSAFE = true;
        try {
            ParserContext pCtx = new ParserContext();
            AlgoContext ctx = new AlgoContext();
            ExpressionContext expressionContext = new ExpressionContext();
            ctx.setExpressionContext(expressionContext);
            expressionContext.setContext(ctx);
            Order order = new Order(1L, 10, 100.49);
            OrderHelper helper = new OrderHelper();
            helper.setOrder(order);
            expressionContext.setHelper(helper);
            Serializable compiledExpression = MVEL.compileExpression((String)"total", (ParserContext)pCtx);
            double total = (Double)MVEL.executeExpression((Object)compiledExpression, (Object)expressionContext, expressionContext.getVariableMap());
            ThreadUnsafeTest.assertEquals((double)1004.9, (double)total, (double)0.1);
            Serializable compiledExpression1 = MVEL.compileExpression((String)"leavesQty <10 ? 1.0 : (RemainSecond <30? 2.0 : 0.66)", (ParserContext)pCtx);
            double remaining = (Double)MVEL.executeExpression((Object)compiledExpression1, (Object)expressionContext, expressionContext.getVariableMap());
            ThreadUnsafeTest.assertEquals((double)0.66, (double)remaining, (double)0.1);
            order = new Order(2L, 20, 101.49);
            helper.setOrder(order);
            total = (Double)MVEL.executeExpression((Object)compiledExpression, (Object)expressionContext, expressionContext.getVariableMap(), Double.class);
            ThreadUnsafeTest.assertEquals((double)2029.8, (double)total, (double)0.1);
            Serializable compiledExpression2 = MVEL.compileExpression((String)"LeavesUnreservedQty<10 ? 1 : (RemainingSeconds<30?2:0.66)", (ParserContext)pCtx);
            int remainingSeconds = (Integer)MVEL.executeExpression((Object)compiledExpression2, (Object)expressionContext, expressionContext.getVariableMap());
            ThreadUnsafeTest.assertEquals((int)2, (int)remainingSeconds);
        }
        finally {
            MVEL.RUNTIME_OPT_THREAD_UNSAFE = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testClassImportResolver2() {
        MVEL.RUNTIME_OPT_THREAD_UNSAFE = true;
        try {
            ParserContext pCtx = new ParserContext();
            AlgoContext ctx = new AlgoContext();
            ExpressionContext expressionContext = new ExpressionContext();
            ctx.setExpressionContext(expressionContext);
            expressionContext.setContext(ctx);
            Order order = new Order(1L, 10, 100.49);
            OrderHelper helper = new OrderHelper();
            helper.setOrder(order);
            expressionContext.setHelper(helper);
            Serializable compiledExpression3 = MVEL.compileExpression((String)"import java.util.List; LeavesUnreservedQty<10 ? 1 : (RemainingSeconds<30?2:0.66)", (ParserContext)pCtx);
            int remainingSeconds = (Integer)MVEL.executeExpression((Object)compiledExpression3, (Object)expressionContext, expressionContext.getVariableMap());
            ThreadUnsafeTest.assertEquals((int)2, (int)remainingSeconds);
        }
        finally {
            MVEL.RUNTIME_OPT_THREAD_UNSAFE = false;
        }
    }

    public static class AlgoContext {
        ExpressionContext expressionContext;

        public ExpressionContext getExpressionContext() {
            return this.expressionContext;
        }

        public void setExpressionContext(ExpressionContext expressionContext) {
            this.expressionContext = expressionContext;
        }

        public double getFarTouchPrice() {
            return 101.4;
        }
    }

    public class ExpressionContext {
        AlgoContext context;
        OrderHelper helper;
        Map<String, Object> variableMap = new HashMap<String, Object>();

        public AlgoContext getContext() {
            return this.context;
        }

        public void setContext(AlgoContext context) {
            this.context = context;
        }

        public OrderHelper getHelper() {
            return this.helper;
        }

        public void setHelper(OrderHelper helper) {
            this.helper = helper;
        }

        public double getTotal() {
            return this.helper.getQty() * this.helper.getPrice();
        }

        public Map<String, Object> getVariableMap() {
            return this.variableMap;
        }

        public double getFarTouchPrice() {
            return this.context.getFarTouchPrice();
        }

        public void setVariableMap(Map<String, Object> variableMap) {
            this.variableMap = variableMap;
        }

        public boolean HAS(String key) {
            return this.variableMap.containsKey(key);
        }

        public Object GET(String key) {
            return this.variableMap.get(key);
        }

        public void SET(String key, Object obj) {
            this.variableMap.put(key, obj);
        }

        public double getleavesQty() {
            return this.helper.getQty();
        }

        public int getRemainSecond() {
            return 30;
        }

        public long getLeavesUnreservedQty() {
            return (long)this.helper.getQty();
        }

        public int getRemainingSeconds() {
            return 5;
        }
    }

    public static class Order {
        long orderId;
        int qty;
        double price;

        public Order(long id, int qty, double price) {
            this.orderId = id;
            this.qty = qty;
            this.price = price;
        }

        public int getQty() {
            return this.qty;
        }

        public void setQty(int qty) {
            this.qty = qty;
        }

        public double getPrice() {
            return this.price;
        }

        public void setPrice(double price) {
            this.price = price;
        }

        public long getOrderId() {
            return this.orderId;
        }

        public void setOrderId(long orderId) {
            this.orderId = orderId;
        }
    }

    public static class OrderHelper {
        Order order;

        public double getQty() {
            return this.order.getQty();
        }

        public double getPrice() {
            return this.order.getPrice();
        }

        public void setOrder(Order order) {
            this.order = order;
        }
    }
}

