/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.execution;

import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.mvel2.ExecutionContext;
import org.mvel2.execution.ExecutionArrayList;
import org.mvel2.execution.ExecutionEntry;
import org.mvel2.execution.ExecutionObject;

public class ExecutionHashMap<K, V>
extends LinkedHashMap<K, V>
implements ExecutionObject {
    private static final Comparator compByValueStringAsc = new Comparator(){

        public int compare(Object o1, Object o2) {
            String first = String.valueOf(((Map.Entry)o1).getValue());
            String second = String.valueOf(((Map.Entry)o2).getValue());
            return first.compareTo(second);
        }
    };
    private static final Comparator compByValueStringDesc = new Comparator(){

        public int compare(Object o1, Object o2) {
            String first = String.valueOf(((Map.Entry)o1).getValue());
            String second = String.valueOf(((Map.Entry)o2).getValue());
            return second.compareTo(first);
        }
    };
    private static final Comparator compByValueDoubleAsc = new Comparator(){

        public int compare(Object o1, Object o2) {
            Double first = Double.parseDouble(String.valueOf(((Map.Entry)o1).getValue()));
            Double second = Double.parseDouble(String.valueOf(((Map.Entry)o2).getValue()));
            return first.compareTo(second);
        }
    };
    private static final Comparator compByValueDoubleDesc = new Comparator(){

        public int compare(Object o1, Object o2) {
            Double first = Double.parseDouble(String.valueOf(((Map.Entry)o1).getValue()));
            Double second = Double.parseDouble(String.valueOf(((Map.Entry)o2).getValue()));
            return second.compareTo(first);
        }
    };
    private final ExecutionContext executionContext;
    private final int id;
    private long memorySize = 0L;

    public ExecutionHashMap(int size, ExecutionContext executionContext) {
        super(size);
        this.executionContext = executionContext;
        this.id = executionContext.nextId();
    }

    @Override
    public V put(K key, V value) {
        Object res;
        if (this.containsKey(key)) {
            Object prevValue = this.get(key);
            this.memorySize -= this.executionContext.onValRemove(this, key, prevValue);
        }
        if (value != null) {
            res = super.put(key, value);
            this.memorySize += this.executionContext.onValAdd(this, key, value);
        } else {
            res = super.remove(key);
        }
        return res;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        LinkedHashSet<Map.Entry<K, V>> executionEntries = new LinkedHashSet<Map.Entry<K, V>>();
        for (Map.Entry entry : super.entrySet()) {
            executionEntries.add(new ExecutionEntry(entry.getKey(), entry.getValue()));
        }
        return executionEntries;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        super.putAll(m);
        for (Map.Entry<K, V> val : m.entrySet()) {
            this.memorySize += this.executionContext.onValAdd(this, val.getKey(), val.getValue());
        }
    }

    @Override
    public V putIfAbsent(K key, V value) {
        if (!super.containsKey(key)) {
            this.memorySize += this.executionContext.onValAdd(this, key, value);
        }
        return super.putIfAbsent(key, value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        boolean result = super.replace(key, oldValue, newValue);
        if (result) {
            this.memorySize -= this.executionContext.onValRemove(this, key, oldValue);
            this.memorySize += this.executionContext.onValAdd(this, key, newValue);
        }
        return result;
    }

    @Override
    public V replace(K key, V value) {
        this.memorySize += this.executionContext.onValAdd(this, key, value);
        return super.replace(key, value);
    }

    @Override
    public V remove(Object key) {
        if (this.containsKey(key)) {
            Object value = this.get(key);
            this.memorySize -= this.executionContext.onValRemove(this, key, value);
        }
        return super.remove(key);
    }

    @Override
    public int getExecutionObjectId() {
        return this.id;
    }

    @Override
    public long memorySize() {
        return this.memorySize;
    }

    @Override
    public ExecutionArrayList<V> values() {
        return new ExecutionArrayList(super.values(), this.executionContext);
    }

    public ExecutionArrayList<K> keys() {
        return new ExecutionArrayList(super.keySet(), this.executionContext);
    }

    public void sortByValue() {
        this.sortByValue(true);
    }

    public void sortByValue(boolean asc) {
        Map<K, V> valueSort = this.sortMapByValue((HashMap)super.clone(), asc);
        valueSort.keySet().forEach(this::remove);
        this.putAll(valueSort);
    }

    public void sortByKey() {
        this.sortByKey(true);
    }

    public void sortByKey(boolean asc) {
        ExecutionArrayList<K> keys = this.keys();
        keys.sort(asc);
        LinkedHashMap keysMapSort = new LinkedHashMap();
        keys.forEach((Consumer<K>)((Consumer<Object>)k -> keysMapSort.put(k, this.get(k))));
        ((HashMap)keysMapSort).keySet().forEach(this::remove);
        this.putAll(keysMapSort);
    }

    private <K, V extends Comparable<? super V>> Map<K, V> sortMapByValue(Map<K, V> map, boolean asc) {
        boolean isString = ((ExecutionArrayList)this.values()).validateClazzInArrayIsOnlyString();
        Comparator cmp = isString ? (asc ? compByValueStringAsc : compByValueStringDesc) : (asc ? compByValueDoubleAsc : compByValueDoubleDesc);
        return map.entrySet().stream().sorted(cmp).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }
}

