/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.tests.core;

import java.io.Serializable;
import java.util.HashMap;
import junit.framework.TestCase;
import org.mvel2.MVEL;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.MapVariableResolverFactory;
import org.mvel2.optimizers.OptimizerFactory;

public class MvelArrayTest
extends TestCase {
    private final String biglistTestScript = "list = [];\nlist.add(1);\nlist.add(2);\nlist.add(3);\nlist.add(null);\nlist.add(5);\nlist.add(6);\nlist.add(7);\nlist.add(8);\nlist.add(9);\nlist.add(10);\nlist.add(11);\nlist.add(12);\njava.util.Collections.replaceAll( list, null, 25 );\njava.util.Collections.max( list );\n";
    private final String smallListTestScript = "list = [];\nlist.add(1);\nlist.add(2);\nlist.add(3);\nlist.add(null);\nlist.add(5);\nlist.add(6);\njava.util.Collections.replaceAll( list, null, 25 );\njava.util.Collections.max( list );\n";

    public void testAsmOptimizerDiesWithBigList() {
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        Serializable compileExpression = MVEL.compileExpression((String)"list = [];\nlist.add(1);\nlist.add(2);\nlist.add(3);\nlist.add(null);\nlist.add(5);\nlist.add(6);\nlist.add(7);\nlist.add(8);\nlist.add(9);\nlist.add(10);\nlist.add(11);\nlist.add(12);\njava.util.Collections.replaceAll( list, null, 25 );\njava.util.Collections.max( list );\n");
        MapVariableResolverFactory factory = new MapVariableResolverFactory(new HashMap());
        int actual = (Integer)MVEL.executeExpression((Object)compileExpression, (VariableResolverFactory)factory);
        MvelArrayTest.assertEquals((int)actual, (int)25);
    }

    public void testReflectiveOptimizerWorksFine() {
        OptimizerFactory.setDefaultOptimizer((String)"reflective");
        Serializable compileExpression = MVEL.compileExpression((String)"list = [];\nlist.add(1);\nlist.add(2);\nlist.add(3);\nlist.add(null);\nlist.add(5);\nlist.add(6);\nlist.add(7);\nlist.add(8);\nlist.add(9);\nlist.add(10);\nlist.add(11);\nlist.add(12);\njava.util.Collections.replaceAll( list, null, 25 );\njava.util.Collections.max( list );\n");
        MapVariableResolverFactory factory = new MapVariableResolverFactory(new HashMap());
        int actual = (Integer)MVEL.executeExpression((Object)compileExpression, (VariableResolverFactory)factory);
        MvelArrayTest.assertEquals((int)actual, (int)25);
    }

    public void testDynamicOptimizerWorksFine() {
        OptimizerFactory.setDefaultOptimizer((String)"dynamic");
        Serializable compileExpression = MVEL.compileExpression((String)"list = [];\nlist.add(1);\nlist.add(2);\nlist.add(3);\nlist.add(null);\nlist.add(5);\nlist.add(6);\nlist.add(7);\nlist.add(8);\nlist.add(9);\nlist.add(10);\nlist.add(11);\nlist.add(12);\njava.util.Collections.replaceAll( list, null, 25 );\njava.util.Collections.max( list );\n");
        MapVariableResolverFactory factory = new MapVariableResolverFactory(new HashMap());
        int actual = (Integer)MVEL.executeExpression((Object)compileExpression, (VariableResolverFactory)factory);
        MvelArrayTest.assertEquals((int)actual, (int)25);
    }

    public void testAsmOptimizerWithSmallListIsFine() {
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        Serializable compileExpression = MVEL.compileExpression((String)"list = [];\nlist.add(1);\nlist.add(2);\nlist.add(3);\nlist.add(null);\nlist.add(5);\nlist.add(6);\njava.util.Collections.replaceAll( list, null, 25 );\njava.util.Collections.max( list );\n");
        MapVariableResolverFactory factory = new MapVariableResolverFactory(new HashMap());
        int actual = (Integer)MVEL.executeExpression((Object)compileExpression, (VariableResolverFactory)factory);
        MvelArrayTest.assertEquals((int)actual, (int)25);
    }
}

