/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.tests.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.TestCase;
import org.junit.Assert;
import org.mvel2.CompileException;
import org.mvel2.ExecutionContext;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.SandboxedParserConfiguration;
import org.mvel2.ScriptMemoryOverflowException;
import org.mvel2.ScriptRuntimeException;
import org.mvel2.execution.ExecutionArrayList;
import org.mvel2.execution.ExecutionHashMap;
import org.mvel2.optimizers.OptimizerFactory;
import org.mvel2.util.MethodStub;

public class TbExpressionsTest
extends TestCase {
    private SandboxedParserConfiguration parserConfig;
    private ExecutionContext currentExecutionContext;

    protected void setUp() throws Exception {
        OptimizerFactory.setDefaultOptimizer((String)OptimizerFactory.SAFE_REFLECTIVE);
        super.setUp();
        this.parserConfig = ParserContext.enableSandboxedMode();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        ParserContext.disableSandboxedMode();
    }

    public void testCreateSingleValueArray() {
        Object res = this.executeScript("m = {5}; m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof List));
        TbExpressionsTest.assertEquals((int)1, (int)((List)res).size());
        TbExpressionsTest.assertEquals((Object)5, ((List)res).get(0));
    }

    public void testCreateMap() {
        Object res = this.executeScript("m = {a: 1}; m.a");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)1, (Object)res);
    }

    public void testCreateEmptyMapAndAssignField() {
        Object res = this.executeScript("m = {}; m.test = 1; m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Map));
        TbExpressionsTest.assertEquals((int)1, (int)((Map)res).size());
        TbExpressionsTest.assertEquals((Object)1, ((Map)res).get("test"));
    }

    public void testAssignmentWhitespaces() {
        Object res = this.executeScript("var m= 2; m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)2, (Object)res);
        res = this.executeScript("var m=2; m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)2, (Object)res);
        res = this.executeScript("var m =2; m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)2, (Object)res);
        res = this.executeScript("m=2; m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)2, (Object)res);
        res = this.executeScript("m= 2; m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)2, (Object)res);
        res = this.executeScript("int m= 2; m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)2, (Object)res);
        res = this.executeScript("int m=2; m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)2, (Object)res);
        res = this.executeScript("int m=2; m=3; m= 4; m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)4, (Object)res);
        res = this.executeScript("int m=2; m+=3; m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)5, (Object)res);
        res = this.executeScript("int m=2; m +=3; m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)5, (Object)res);
        res = this.executeScript("int m=2; m+= 3; m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)5, (Object)res);
        res = this.executeScript("int m=2; m\n+=\n3; m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)5, (Object)res);
        res = this.executeScript("var \n\n  m= 2;     m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)2, (Object)res);
        res = this.executeScript("var   m= 2;     m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)2, (Object)res);
        res = this.executeScript("var  m= 2;     m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)2, (Object)res);
        res = this.executeScript("var m= 2;     m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)2, (Object)res);
        res = this.executeScript("int   m =  2;     m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)2, (Object)res);
        res = this.executeScript("  \n\n    m  \n\n  =  \n\n 2;  \n\n   m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)2, (Object)res);
        res = this.executeScript("  \n\n  var \n\n  m  \n\n  =  \n\n 2;  \n\n   m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)2, (Object)res);
    }

    public void testNonExistentMapField() {
        Object res = this.executeScript("m = {}; t = m.test; t");
        TbExpressionsTest.assertNull((Object)res);
    }

    public void testEqualsOperator() {
        Object res = this.executeScript("m = 'abc'; m === 'abc'");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Boolean));
        TbExpressionsTest.assertTrue((boolean)((Boolean)res));
        res = this.executeScript("m = 'abc'; m = 1; m == 1");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Boolean));
        TbExpressionsTest.assertTrue((boolean)((Boolean)res));
    }

    public void testFunctionOrder() {
        Object res = this.executeScript("function testFunc(m) {m.a +=1;} m = {a: 1}; testFunc(m);   m.a");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)2, (Object)res);
        res = this.executeScript("m = {a: 1}; testFunc(m); function testFunc(m) {m.a +=1;}  m.a");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)2, (Object)res);
    }

    public void testVariableScope() {
        Object res = this.executeScript("var m = 25; function testFunc(a) {   function testFunc3(e) {       var m;       m = e + 5\n;        return m   };   var t = 2;\n   m = a * t;   return testFunc3(testFunc2(m + t));}function testFunc2(b) {   var c = 3;m = b * c; return m;}function testFunc4(m) {   return m * 2;}var m2 = m + testFunc(m); \nreturn testFunc4(m2)");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)372, (Object)res);
        res = this.executeScript("var array = [1, 2, 3];\nfunction sum(array){\n    var result = 0;\n    for(int i = 0; i < array.length; i++){\n        result += array[i];\n        var element = array[i];\n        result += element;\n    }\n    return result;\n}\nreturn sum(array)");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)12, (Object)res);
        res = this.executeScript("var array = [1, 2, 3];\n    var result = 0;\n    for(int i = 0; i < array.length; i++){\n        result += array[i];\n        var element = array[i];\n        result += element;\n    }\nreturn result");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)12, (Object)res);
        res = this.executeScript("var array = [1, 2, 3];\nfunction sum(array){\n    var result = 0;\n    var i = 0;\n    while(i < array.length){\n        result += array[i];\n        var element = array[i];\n        result += element;\n        i++;\n    }\n    return result;\n}\nreturn sum(array)");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)12, (Object)res);
        res = this.executeScript("var array = [1, 2, 3];\n    var result = 0;\n    var i = 0;\n    while(i < array.length){\n        result += array[i];\n        var element = array[i];\n        result += element;\n        i++;\n    }\nreturn result");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)12, (Object)res);
    }

    public void testComments() {
        Object res = this.executeScript("//var df = sdfsdf; \n // test comment: comment2 \n m = {\n// c: d, \n /* e: \n\nf, */ a: 2 }; m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof HashMap));
        TbExpressionsTest.assertEquals((int)1, (int)((Map)res).size());
        TbExpressionsTest.assertEquals((Object)2, ((Map)res).get("a"));
    }

    public void testStopExecution() throws Exception {
        AtomicReference capturedException = new AtomicReference();
        CountDownLatch countDown = new CountDownLatch(1);
        Thread thread = new Thread(() -> {
            try {
                this.executeScript("t = 0; while(true) { t  = 1}; t");
            }
            catch (Exception e) {
                capturedException.set(e);
            }
            finally {
                countDown.countDown();
            }
        });
        thread.start();
        boolean result = countDown.await(500L, TimeUnit.MILLISECONDS);
        TbExpressionsTest.assertFalse((boolean)result);
        this.currentExecutionContext.stop();
        result = countDown.await(500L, TimeUnit.MILLISECONDS);
        TbExpressionsTest.assertTrue((boolean)result);
        Exception exception = (Exception)capturedException.get();
        TbExpressionsTest.assertNotNull((Object)exception);
        TbExpressionsTest.assertEquals((String)"Script execution is stopped!", (String)exception.getMessage());
    }

    public void testMemoryOverflowVariable() {
        long memoryLimit = 0x500000L;
        try {
            this.executeScript("t = 'abc'; while(true) { t  += t}; t", new HashMap(), new ExecutionContext(this.parserConfig, memoryLimit));
            TbExpressionsTest.fail((String)"Should throw ScriptMemoryOverflowException");
        }
        catch (ScriptMemoryOverflowException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Script memory overflow"));
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("" + memoryLimit));
        }
    }

    public void testMemoryOverflowInnerVariable() {
        long memoryLimit = 0x500000L;
        try {
            this.executeScript("doMemoryOverflow(); function doMemoryOverflow() { var t = 'abc'; while(true) { t  += t}; } ", new HashMap(), new ExecutionContext(this.parserConfig, memoryLimit));
            TbExpressionsTest.fail((String)"Should throw ScriptMemoryOverflowException");
        }
        catch (ScriptMemoryOverflowException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Script memory overflow"));
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("" + memoryLimit));
        }
    }

    public void testMemoryOverflowInnerMap1() {
        long memoryLimit = 0x500000L;
        try {
            this.executeScript("m = {}; m.put('a', {}); i =0; while(true) { m.get('a').put(i++, 'aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa' + Math.random());}; m", new HashMap(), new ExecutionContext(this.parserConfig, memoryLimit));
            TbExpressionsTest.fail((String)"Should throw ScriptMemoryOverflowException");
        }
        catch (ScriptMemoryOverflowException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Script memory overflow"));
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("" + memoryLimit));
        }
    }

    public void testMemoryOverflowInnerMap2() {
        long memoryLimit = 0x500000L;
        try {
            this.executeScript("m = {}; m.a = {}; i =0; while(true) { m.a[i++] = 'aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa' + Math.random();}; m", new HashMap(), new ExecutionContext(this.parserConfig, memoryLimit));
            TbExpressionsTest.fail((String)"Should throw ScriptMemoryOverflowException");
        }
        catch (ScriptMemoryOverflowException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Script memory overflow"));
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("" + memoryLimit));
        }
    }

    public void testMemoryOverflowArray() {
        long memoryLimit = 0x500000L;
        try {
            this.executeScript("m = []; i =0; while(true) { m.add('aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa' + Math.random())}; m", new HashMap(), new ExecutionContext(this.parserConfig, memoryLimit));
            TbExpressionsTest.fail((String)"Should throw ScriptMemoryOverflowException");
        }
        catch (ScriptMemoryOverflowException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Script memory overflow"));
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("" + memoryLimit));
        }
    }

    public void testMemoryOverflowArrayInnerMap() {
        long memoryLimit = 0x500000L;
        try {
            this.executeScript("m = [1]; m[0] = {}; i =0; while(true) { m[0].put(i++, 'aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa' + Math.random())}; m", new HashMap(), new ExecutionContext(this.parserConfig, memoryLimit));
            TbExpressionsTest.fail((String)"Should throw ScriptMemoryOverflowException");
        }
        catch (ScriptMemoryOverflowException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Script memory overflow"));
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("" + memoryLimit));
        }
    }

    public void testMemoryOverflowAddAll() throws Exception {
        long memoryLimit = 0x500000L;
        try {
            this.executeScript("a = ['aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa']; b = []; while(true) { b.addAll(a)}; m", new HashMap(), new ExecutionContext(this.parserConfig, memoryLimit), 10000L);
            TbExpressionsTest.fail((String)"Should throw ScriptMemoryOverflowException");
        }
        catch (ScriptMemoryOverflowException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Script memory overflow"));
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("" + memoryLimit));
        }
    }

    public void testArrayMemoryOverflow() {
        long memoryLimit = 0x500000L;
        try {
            this.executeScript("m = new byte[5 * 1024 * 1024]; m", new HashMap(), new ExecutionContext(this.parserConfig, memoryLimit));
            TbExpressionsTest.fail((String)"Should throw ScriptMemoryOverflowException");
        }
        catch (ScriptMemoryOverflowException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Max array length overflow"));
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("" + memoryLimit / 2L));
        }
    }

    public void testMethodArgumentsLength() {
        long memoryLimit = 0x500000L;
        int argsLimit = 5;
        try {
            this.executeScript("var s = '%s'; for (var i = 0; i < 20; i++) { s = s + s; }\n\nreturn '\\n12Result is :\\n' + String.format(s, s, s, s, s, s, s, s, s, s, s);", new HashMap(), new ExecutionContext(this.parserConfig, memoryLimit, argsLimit));
            TbExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Maximum method arguments count overflow"));
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("" + argsLimit));
        }
    }

    public void testMethodInvocationForStringRepeat() {
        long memoryLimit = 0x500000L;
        try {
            this.executeScript("'a'.repeat(Integer.MAX_VALUE-100)", new HashMap(), new ExecutionContext(this.parserConfig, memoryLimit));
            TbExpressionsTest.fail((String)"Should throw ScriptMemoryOverflowException");
        }
        catch (ScriptMemoryOverflowException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Max string length overflow"));
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("" + memoryLimit / 2L));
        }
    }

    public void testMethodInvocationForStringConcat() {
        long memoryLimit = 0x500000L;
        try {
            this.executeScript("var toConcat = 'a'.repeat(5 * 1024 * 1024 / 2 - 'abc'.length() + 1); 'abc'.concat(toConcat);", new HashMap(), new ExecutionContext(this.parserConfig, memoryLimit));
            TbExpressionsTest.fail((String)"Should throw ScriptMemoryOverflowException");
        }
        catch (ScriptMemoryOverflowException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Max string length overflow"));
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("" + memoryLimit / 2L));
        }
    }

    public void testMethodInvocationForStringReplace() {
        long memoryLimit = 0x500000L;
        try {
            this.executeScript("var repl = 'a'.repeat(5 * 1024 * 1024 / 100 + 1); 'abc'.replace('a', repl);", new HashMap(), new ExecutionContext(this.parserConfig, memoryLimit));
            TbExpressionsTest.fail((String)"Should throw ScriptMemoryOverflowException");
        }
        catch (ScriptMemoryOverflowException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Max replacement length overflow"));
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("" + memoryLimit / 100L));
        }
        try {
            this.executeScript("var repl = 'a'.repeat(5 * 1024 * 1024 / 100 + 1); 'abc'.replaceAll('a', repl);", new HashMap(), new ExecutionContext(this.parserConfig, memoryLimit));
            TbExpressionsTest.fail((String)"Should throw ScriptMemoryOverflowException");
        }
        catch (ScriptMemoryOverflowException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Max replacement length overflow"));
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("" + memoryLimit / 100L));
        }
    }

    public void testForbidCustomObjects() {
        try {
            this.executeScript("m = new java.util.HashMap(); m");
            TbExpressionsTest.fail((String)"Should throw ScriptRuntimeException");
        }
        catch (ScriptRuntimeException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Invalid statement: new java.util.HashMap()"));
        }
    }

    public void testForbiddenMethodAccess() {
        try {
            this.parserConfig.addImport("JSON", MyTestClass.class);
            this.executeScript("JSON.getModule().getClassLoader().loadClass(\"java.lang.Runtime\")");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("unable to resolve method: " + MyTestClass.class.getName() + ".getModule"));
        }
    }

    public void testForbiddenClassAccess() {
        try {
            this.executeScript("new StringBuffer();");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("could not resolve class: StringBuffer"));
        }
        try {
            this.executeScript("new java.lang.StringBuffer();");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("could not resolve class: java.lang.StringBuffer"));
        }
        try {
            this.executeScript("new StringBuilder();");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("could not resolve class: StringBuilder"));
        }
        try {
            this.executeScript("new java.lang.StringBuilder();");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("could not resolve class: java.lang.StringBuilder"));
        }
        try {
            this.executeScript("\n\nClass c;");
            TbExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("unknown class or illegal statement: Class"));
        }
        try {
            this.executeScript("m = {5}; System.exit(-1); m");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("unresolvable property or identifier: System"));
        }
        try {
            this.executeScript("m = {5}; for (int i=0;i<10;i++) {System.exit(-1);}; m");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("unresolvable property or identifier: System"));
        }
        try {
            this.executeScript("m = {5}; function test() {System.exit(-1);}; test(); m");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("unresolvable property or identifier: System"));
        }
        try {
            this.executeScript("m = {5}; exit(-1); m");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("function not found: exit"));
        }
        try {
            this.executeScript("m = {5}; java.lang.System.exit(-1); m");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("unresolvable property or identifier: java"));
        }
        try {
            this.executeScript("m = {5}; Runtime.getRuntime().exec(\"echo hi\"); m");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("unresolvable property or identifier: Runtime"));
        }
        try {
            this.executeScript("m = {5}; m.getClass().getClassLoader()");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("unable to resolve method: getClass()"));
        }
        try {
            this.executeScript("Array.newInstance(Object, 1000, 1000, 1000, 1000);");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("unresolvable property or identifier: Array"));
        }
        try {
            this.executeScript("m = {5}; m.class");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("could not access property: class"));
        }
        try {
            this.executeScript("m = new java.io.File(\"password.txt\").exists(); m");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("could not resolve class: java.io.File"));
        }
        try {
            this.executeScript("m = MVEL.eval(\"System.exit(-1);\"); m");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("unresolvable property or identifier: MVEL"));
        }
        try {
            this.executeScript("m = org.mvel2.MVEL.eval(\"System.exit(-1);\"); m");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("unresolvable property or identifier: org"));
        }
        try {
            this.executeScript("java.util.concurrent.Executors.newFixedThreadPool(2)");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("unresolvable property or identifier: java"));
        }
        Object res = this.executeScript("m = {class: 5}; m.class");
        TbExpressionsTest.assertNotNull((Object)res);
        TbExpressionsTest.assertEquals((Object)5, (Object)res);
    }

    public void testForbidImport() {
        try {
            this.executeScript("import java.util.HashMap; m = new HashMap(); m.put('t', 10); m");
            TbExpressionsTest.fail((String)"Should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Import is forbidden!"));
        }
    }

    public void testPrimitiveArray() {
        Object res = this.executeScript("var m = new byte[1000]; m[5] = 1; m[500] = 20; m[40] = 0x0B; m");
        TbExpressionsTest.assertNotNull((Object)res);
        TbExpressionsTest.assertTrue((boolean)(res instanceof List));
        TbExpressionsTest.assertEquals((int)1000, (int)((List)res).size());
        TbExpressionsTest.assertEquals((Object)1, ((List)res).get(5));
        TbExpressionsTest.assertEquals((Object)20, ((List)res).get(500));
        TbExpressionsTest.assertEquals((Object)11, ((List)res).get(40));
        res = this.executeScript("var m = 'Hello world'; a = m.toCharArray(); a");
        TbExpressionsTest.assertNotNull((Object)res);
        TbExpressionsTest.assertTrue((boolean)(res instanceof List));
        Object[] boxedArray = ((List)res).toArray();
        int len = boxedArray.length;
        char[] array = new char[len];
        for (int i = 0; i < len; ++i) {
            array[i] = ((Character)boxedArray[i]).charValue();
        }
        TbExpressionsTest.assertEquals((String)"Hello world", (String)String.valueOf(array));
        res = this.executeScript("var m = new int[]{1, 2, 3}; m");
        TbExpressionsTest.assertNotNull((Object)res);
        TbExpressionsTest.assertTrue((boolean)(res instanceof List));
        TbExpressionsTest.assertEquals((int)3, (int)((List)res).size());
        TbExpressionsTest.assertEquals((Object)1, ((List)res).get(0));
        TbExpressionsTest.assertEquals((Object)2, ((List)res).get(1));
        TbExpressionsTest.assertEquals((Object)3, ((List)res).get(2));
    }

    public void testByteOperations() {
        Object res = this.executeScript("var m = new byte[]{(byte)0x0F,(byte)0x02}; b = m[0] == 0x0F; b");
        TbExpressionsTest.assertNotNull((Object)res);
        TbExpressionsTest.assertTrue((boolean)(res instanceof Boolean));
        TbExpressionsTest.assertTrue((boolean)((Boolean)res));
        res = this.executeScript("var a = 0x0F; b = 0x0A; c = a + b; c");
        TbExpressionsTest.assertNotNull((Object)res);
        TbExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbExpressionsTest.assertEquals((Object)25, (Object)res);
        res = this.executeScript("var a = (byte)0x0F; b = a << 24 >> 16; b");
        TbExpressionsTest.assertNotNull((Object)res);
        TbExpressionsTest.assertEquals((Object)3840, (Object)res);
    }

    public void testUnterminatedStatement() {
        Object res = this.executeScript("var a = \"A\";\nvar b = \"B\"\n;var c = \"C\"\n;result = a + b\n;result = c\t\n;\n{msg: result, \n\nmetadata: {}, msgType: ''}");
        TbExpressionsTest.assertNotNull((Object)res);
        TbExpressionsTest.assertTrue((boolean)(res instanceof Map));
        TbExpressionsTest.assertEquals((Object)"C", ((Map)res).get("msg"));
        try {
            this.executeScript("var a = \"A\";\nvar b = \"B\"\n;var c = \"C\"\n;result = a + b\n;result = c\n\n{msg: result, \n\nmetadata: {}, msgType: ''}");
            TbExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().equals("[Error: Unterminated statement!]\n[Near : {... ;result = c ....}]\n                       ^\n[Line: 5, Column: 11]"));
        }
    }

    public void testStringTermination() {
        Object res = this.executeScript("var c = 'abc' + \n'def1' + ('a' + 'b') + \n 'def2';\n c");
        TbExpressionsTest.assertNotNull((Object)res);
        TbExpressionsTest.assertEquals((Object)"abcdef1abdef2", (Object)res);
    }

    public void testRuntimeAndCompileErrors() {
        try {
            this.executeScript("threshold = def (x) { x >= 10 ? x : 0 };\nresult = cost + threshold(lowerBound);");
            TbExpressionsTest.fail((String)"Should throw ScriptRuntimeException");
        }
        catch (ScriptRuntimeException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().equals("[Error: Invalid statement: def (x) { x >= 10 ? x : 0 }]\n[Near : {... threshold = def (x) { x >= 10 ? x : 0 }; ....}]\n                         ^\n[Line: 1, Column: 13]"));
        }
        try {
            this.executeScript("a = [1,2;\n");
            TbExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().equals("[Error: unbalanced braces [ ... ]]\n[Near : {... a = [1,2; ....}]\n                 ^\n[Line: 1, Column: 5]"));
        }
        try {
            this.executeScript("a = [1,2];\n function c(a) {\nvar b = 0;\nb += a[0].toInt();\nreturn b;}\n c(a);");
            TbExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().equals("[Error: unable to resolve method: java.lang.Integer.toInt() [arglength=0]]\n[Near : {... b += a[0].toInt(); ....}]\n                 ^\n[Line: 4, Column: 5]"));
        }
    }

    public void testUseClassImport() {
        try {
            this.executeScript("MyTestUtil.getFoo({foo: 'foo-bar'})");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            junit.framework.Assert.assertTrue((boolean)e.getMessage().contains("unresolvable property or identifier: MyTestUtil"));
        }
        this.parserConfig.addImport("MyTestUtil", TestUtil.class);
        Object res = this.executeScript("MyTestUtil.getFoo({foo: 'foo-bar'})");
        TbExpressionsTest.assertEquals((Object)"foo-bar", (Object)res);
        res = this.executeScript("MyTestUtil.getFoo({})");
        TbExpressionsTest.assertEquals((Object)"Not found!", (Object)res);
        res = this.executeScript("MyTestUtil.methodWithExecContext('key1', 'val1')");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Map));
        TbExpressionsTest.assertEquals((Object)"val1", ((Map)res).get("key1"));
        res = this.executeScript("MyTestUtil.methodWithExecContext2('key2', 'val2')");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Map));
        TbExpressionsTest.assertEquals((Object)"val2", ((Map)res).get("key2"));
        res = this.executeScript("MyTestUtil.methodWithExecContext3('key3', 'val3')");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Map));
        TbExpressionsTest.assertEquals((Object)"val3", ((Map)res).get("key3"));
        res = this.executeScript("MyTestUtil.methodWithExecContextVarArgs('a1', 'a2', 'a3', 'a4', 'a5')");
        TbExpressionsTest.assertTrue((boolean)(res instanceof List));
        TbExpressionsTest.assertEquals((int)5, (int)((List)res).size());
        Assert.assertArrayEquals((Object[])new String[]{"a1", "a2", "a3", "a4", "a5"}, (Object[])((List)res).toArray(new String[5]));
    }

    public void testUseStaticMethodImport() throws Exception {
        this.parserConfig.addImport("getFoo", new MethodStub(TestUtil.class.getMethod("getFoo", Map.class)));
        Object res = this.executeScript("getFoo({foo: 'foo-bar'})");
        TbExpressionsTest.assertEquals((Object)"foo-bar", (Object)res);
        res = this.executeScript("getFoo({})");
        TbExpressionsTest.assertEquals((Object)"Not found!", (Object)res);
        try {
            this.executeScript("currentTimeMillis()");
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            junit.framework.Assert.assertTrue((boolean)e.getMessage().contains("function not found: currentTimeMillis"));
        }
        this.parserConfig.addImport("currentTimeMillis", new MethodStub(System.class.getMethod("currentTimeMillis", new Class[0])));
        res = this.executeScript("currentTimeMillis()");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Long));
        TbExpressionsTest.assertEquals((long)(System.currentTimeMillis() / 100L), (long)((Long)res / 100L));
        this.parserConfig.addImport("methodWithExecContext", new MethodStub(TestUtil.class.getMethod("methodWithExecContext", String.class, Object.class, ExecutionContext.class)));
        res = this.executeScript("methodWithExecContext('key1', 'val1')");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Map));
        TbExpressionsTest.assertEquals((Object)"val1", ((Map)res).get("key1"));
        this.parserConfig.addImport("methodWithExecContext2", new MethodStub(TestUtil.class.getMethod("methodWithExecContext2", String.class, ExecutionContext.class, Object.class)));
        res = this.executeScript("methodWithExecContext2('key2', 'val2')");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Map));
        TbExpressionsTest.assertEquals((Object)"val2", ((Map)res).get("key2"));
        this.parserConfig.addImport("methodWithExecContext3", new MethodStub(TestUtil.class.getMethod("methodWithExecContext3", ExecutionContext.class, String.class, Object.class)));
        res = this.executeScript("methodWithExecContext3('key3', 'val3')");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Map));
        TbExpressionsTest.assertEquals((Object)"val3", ((Map)res).get("key3"));
        this.parserConfig.addImport("methodWithExecContextVarArgs", new MethodStub(TestUtil.class.getMethod("methodWithExecContextVarArgs", ExecutionContext.class, Object[].class)));
        res = this.executeScript("methodWithExecContextVarArgs('a1', 'a2', 'a3', 'a4', 'a5')");
        TbExpressionsTest.assertTrue((boolean)(res instanceof List));
        TbExpressionsTest.assertEquals((int)5, (int)((List)res).size());
        Assert.assertArrayEquals((Object[])new String[]{"a1", "a2", "a3", "a4", "a5"}, (Object[])((List)res).toArray(new String[5]));
    }

    public void testRegisterDataType() {
        try {
            this.executeScript("var t = new MyTest('test val'); t");
            TbExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            junit.framework.Assert.assertTrue((boolean)e.getMessage().contains("could not resolve class: MyTest"));
        }
        this.parserConfig.registerDataType("MyTest", MyTestClass.class, val -> val.getValue().getBytes().length);
        Object res = this.executeScript("var t = new MyTest('test val'); t");
        TbExpressionsTest.assertTrue((boolean)(res instanceof MyTestClass));
        TbExpressionsTest.assertEquals((String)"test val", (String)((MyTestClass)res).getValue());
        try {
            this.executeScript("var t = new MyTest('test val'); t", new HashMap(), new ExecutionContext(this.parserConfig, 7L));
            TbExpressionsTest.fail((String)"Should throw ScriptMemoryOverflowException");
        }
        catch (ScriptMemoryOverflowException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Script memory overflow"));
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("8 > 7"));
        }
    }

    public void testDate() {
        Object res = this.executeScript("var t = new java.util.Date(); t");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Date));
        TbExpressionsTest.assertEquals((long)(System.currentTimeMillis() / 100L), (long)(((Date)res).getTime() / 100L));
        res = this.executeScript("var t = new java.util.Date(); var m = {date: t}; m");
        TbExpressionsTest.assertTrue((boolean)(res instanceof Map));
        TbExpressionsTest.assertTrue((boolean)(((Map)res).get("date") instanceof Date));
    }

    public void testIdIdJsFormat() {
        String scriptBodyTestIdIdPointStr = "var msg = {};\nvar msg_sub = {};\nmsg_sub[\"entityGroup\"] = \"ENTITY_GROUP\";\nmsg_sub[\"id2\"] = \"4e7b7e10-c27d-11ed-a0ab-058763ffd58e\";\nmsg[\"id1\"] =  msg_sub;\nreturn {\n    msg: {\n        entryPoint_bad: \"/api/entityGroup/\" + msg.id1.id2\n    }\n};";
        String scriptBodyTestIdIdJsFormatStr = "var msg = {};\nvar msg_sub = {};\nmsg_sub[\"entityGroup\"] = \"ENTITY_GROUP\";\nmsg_sub[\"id2\"] = \"4e7b7e10-c27d-11ed-a0ab-058763ffd58e\";\nmsg[\"id1\"] =  msg_sub;\nreturn {\n    msg: {\n        entryPoint_bad: \"/api/entityGroup/\" + msg[\"id1\"][\"id2\"]\n    }\n};";
        Object actual = this.executeScript(scriptBodyTestIdIdJsFormatStr);
        Object expected = this.executeScript(scriptBodyTestIdIdPointStr);
        TbExpressionsTest.assertEquals((Object)expected, (Object)actual);
    }

    public void testSwitchNodeStandardCaseOneValue_Ok() {
        String scriptBodyTestSwitchNodeStr = "\nvar msg = {};\nmsg[\"temperature\"] = 120;\nswitch (msg.temperature){\n    case 120.0:\n        msg.temperature = 1.0;\n         break;\n    case 241:\n        msg.temperature = 2.0;\n        break;\n    default:\n        msg.temperature = 3.0;\n\n}\nreturn {temp: msg.temperature};\n";
        LinkedHashMap<String, Double> expected = new LinkedHashMap<String, Double>();
        Double dd = 1.0;
        expected.put("temp", dd);
        Object actual = this.executeScript(scriptBodyTestSwitchNodeStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testSwitchNodeStandardCaseTwoValue_Ok() {
        String scriptBodyTestSwitchNodeStr = "\nvar msg = {};\nmsg[\"temperature\"] = 241;\nswitch (msg.temperature){\n    case 120.0:\n        msg.temperature = 1.0;\n         break;\n    case 241:\n        msg.temperature = 2.0;\n        break;\n    default:\n        msg.temperature = 3.0;\n\n}\nreturn {temp: msg.temperature};\n";
        LinkedHashMap<String, Double> expected = new LinkedHashMap<String, Double>();
        Double dd = 2.0;
        expected.put("temp", dd);
        Object actual = this.executeScript(scriptBodyTestSwitchNodeStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testSwitchNodeStandardDefault_Ok() {
        String scriptBodyTestSwitchNodeStr = "\nvar msg = {};\nmsg[\"temperature\"] = 130.0;\nswitch (msg.temperature){\n    case 120.0:\n        msg.temperature = 1.0;\n         break;\n    case 241:\n        msg.temperature = 2.0;\n        break;\n    default:\n        msg.temperature = msg.temperature;\n\n}\nreturn {temp: msg.temperature};\n";
        LinkedHashMap<String, Double> expected = new LinkedHashMap<String, Double>();
        Double dd = 130.0;
        expected.put("temp", dd);
        Object actual = this.executeScript(scriptBodyTestSwitchNodeStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testSwitchNodeOnlyCase_Ok() {
        String scriptBodyTestSwitchNodeStr = "\nvar msg = {};\nmsg[\"temperature\"] = 120.0;\nswitch (msg.temperature){\n    case 120.0:\n        msg.temperature = 1.0;\n\n}\nreturn {temp: msg.temperature};\n";
        LinkedHashMap<String, Double> expected = new LinkedHashMap<String, Double>();
        Double dd = 1.0;
        expected.put("temp", dd);
        Object actual = this.executeScript(scriptBodyTestSwitchNodeStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testSwitchNodeCaseDoubleValue_Ok() {
        String scriptBodyTestSwitchNodeStr = "\nvar msg = {};\nmsg[\"temperature\"] = 123;\nswitch (msg.temperature){\n    case 120.0:\n    case 123.0:\n    case 126.0:\n        msg.temperature = 1.0;\n         break;\n    case 241:\n        msg.temperature = 2.0;\n        break;\n    default:\n        msg.temperature = 3.0;\n\n}\nreturn {temp: msg.temperature};\n";
        LinkedHashMap<String, Double> expected = new LinkedHashMap<String, Double>();
        Double dd = 1.0;
        expected.put("temp", dd);
        Object actual = this.executeScript(scriptBodyTestSwitchNodeStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testSwitchNodeSwitchInSwitch_Ok() {
        String scriptBodyTestSwitchNodeStr = "\nvar msg = {};\nmsg[\"temperature\"] = 19.0;\nvar a = 25;\n\nif (msg.temperature === 19){\n    msg.temperature = 20.0;\n} else if (msg.temperature === 24){\n    msg.temperature = 23.11;\n}  else {\n    msg.temperature = msg.temperature;\n}\n\nswitch (msg.temperature){\n    case 20.0:\n    case 120.0:\n         switch (msg.temperature){\n            case 122.4:\n            case 100.0:\n                 msg.temperature = 130.1;\n                 break;\n            case 112.0:\n                msg.temperature = 101;\n                break;\n            case 20.0:\n                msg.temperature = 105.6789;\n                msg.temperature += a;\n                msg.temperature = msg.temperature/2;\n                break;\n           default:\n                msg.temperature = 105.6789;\n                msg.temperature += a;\n                msg.temperature = msg.temperature/2;\n        }\n         break;\n    case 12.0:\n        msg.temperature = 1;\n        break;\n    case 15.0:\n        msg.temperature = 5;\n        break;\n    default:\n        msg.temperature = 2;\n\n}\nreturn {temp: msg.temperature};\n";
        LinkedHashMap<String, Double> expected = new LinkedHashMap<String, Double>();
        Double dd = 65.33945;
        expected.put("temp", dd);
        Object actual = this.executeScript(scriptBodyTestSwitchNodeStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testSwitchNodeParameterString_Ok() {
        String scriptBodyTestSwitchNodeStr = "\nvar msg = {};\nmsg[\"temperature\"] = 120.0;\nvar par = \"test1\";\n\nswitch (par){\n    case \"test\":\n         msg.temperature = 1.0;\n         break;\n    case \"test1\":\n        msg.temperature = 2.0;\n        break;\n    case 15.0:\n        msg.temperature = 3;\n        break;\n    default:\n        msg.temperature = 4;\n}\nreturn {temp: msg.temperature};\n";
        LinkedHashMap<String, Double> expected = new LinkedHashMap<String, Double>();
        Double dd = 2.0;
        expected.put("temp", dd);
        Object actual = this.executeScript(scriptBodyTestSwitchNodeStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testSwitchNodeInFunctionWithReturn_Ok() {
        String scriptBodyTestSwitchNodeStr = "\nvar msg = {};\nmsg[\"temperature\"] = 120.0;\nvar par = \"test\";\n\nswitch (par){\n    case \"test\":\n         msg.temperature = switchReturn(par) ;\n         return {temp: msg.temperature};\n    case \"test2\":\n         msg.temperature = 1.0;\n}\nreturn {temp: msg.temperature};\nfunction switchReturn(val) {\n    switch (val) {\n        case \"test\":\n            return 48.0;\n        case 12.0:\n            msg.temperature = 4.0 / 2;\n           return 5.0;\n        case 15.0:\n            msg.temperature = 3;\n            break;\n        default:\n            msg.temperature = msg.temperature;\n    }\n    return 48;\n\n}";
        LinkedHashMap<String, Double> expected = new LinkedHashMap<String, Double>();
        Double dd = 48.0;
        expected.put("temp", dd);
        Object actual = this.executeScript(scriptBodyTestSwitchNodeStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testSwitchNodeWithReturnInCase_Ok() {
        String scriptBodyTestSwitchNodeStr = "\nvar msg = {};\nmsg[\"temperature\"] = 120.0;\nvar par = \"test\";\n\nswitch (par){\n    case \"test\":\n         msg.temperature = 3.0;\n         return {temp: msg.temperature};\n    case \"test2\":\n         msg.temperature = 1.0;\n}\nreturn {temp: msg.temperature};\n";
        LinkedHashMap<String, Double> expected = new LinkedHashMap<String, Double>();
        Double dd = 3.0;
        expected.put("temp", dd);
        Object actual = this.executeScript(scriptBodyTestSwitchNodeStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testSwitchNodeWithComments_Ok() {
        String scriptBodyTestSwitchNodeStr = " \n//switch (parCase){\nvar msg = {};\nmsg[\"temperature\"] = 120.0;\nvar parCase = 15.0;\n\nswitch (parCase){\n    case \"test\":\n        /**\n         // commit3\n         **/\n         msg.temperature = 1.0;\n        // bdreak_stop; \n         break;\n    case 12.0:\n        /*\n        commit2\n        \n        */\n        msg.temperature = 4.0;\n        break;\n        // case:;\n    case 15.0:\n        msg.temperature = 3.3;\n        break;\n        // default:;\n    default:\n        msg.temperature = msg.temperature;\n}\nreturn {temp: msg.temperature};\n";
        LinkedHashMap<String, Double> expected = new LinkedHashMap<String, Double>();
        Double dd = 3.3;
        expected.put("temp", dd);
        Object actual = this.executeScript(scriptBodyTestSwitchNodeStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testSwitchNodeParameterNumberAsStringQuotes() {
        String scriptBodyTestSwitchNodeStr = "\nvar msg = {};\nmsg[\"temperature\"] = 120.0;\nvar par = \"203\";\n\nswitch (par){\n    case \"test\":\n         msg.temperature = 1.0;\n         break;\n    case 203:\n        msg.temperature = 2.0;\n        break;\n    case 15.0:\n        msg.temperature = 3;\n        break;\n    default:\n        msg.temperature = 4;\n}\nreturn {temp: msg.temperature};\n";
        LinkedHashMap<String, Double> expected = new LinkedHashMap<String, Double>();
        Double dd = 2.0;
        expected.put("temp", dd);
        Object actual = this.executeScript(scriptBodyTestSwitchNodeStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testSwitchNodeWithoutDefault() {
        String scriptBodyTestSwitchNodeStr = "\nvar msg = {};\nmsg[\"temperature\"] = 115.0;\nvar a = 25;\n\nif (msg.temperature === 19){\n    msg.temperature = 19;\n} else if (msg.temperature === 24){\n    msg.temperature = 23.11;\n}  else {\n    msg.temperature = msg.temperature;\n}\n\nswitch (msg.temperature){\n    case 115.0:\n    case 10.0:\n         switch (msg.temperature){\n            case 122.4:\n            case 10.0:\n                 msg.temperature = 130.1;\n                 break;\n            case 112.0:\n                msg.temperature = 101;\n                break;\n            case 115.0:\n                msg.temperature = 105.6789;\n                msg.temperature += a;\n                msg.temperature = msg.temperature/2;\n        }\n         break;\n    case 12.0:\n        msg.temperature = 1;\n        break;\n    case 15.0:\n        msg.temperature = 5;\n        break;\n    default:\n        msg.temperature = 2;\n\n}\nreturn {temp: msg.temperature};\n";
        LinkedHashMap<String, Double> expected = new LinkedHashMap<String, Double>();
        Double dd = 65.33945;
        expected.put("temp", dd);
        Object actual = this.executeScript(scriptBodyTestSwitchNodeStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testSwitchNodeParameterStringWithoutEscapingQuotes_Error() {
        String scriptBodyTestSwitchNodeStr = "\nvar msg = {};\nmsg[\"temperature\"] = 120.0;\nvar par = \"test1\";\n\nswitch (par){\n    case test:\n         msg.temperature = 1.0;\n         break;\n    case \"test1\":\n        msg.temperature = 2.0;\n        break;\n    case 15.0:\n        msg.temperature = 3;\n        break;\n    default:\n        msg.temperature = 4;\n}\nreturn {temp: msg.temperature};\n";
        LinkedHashMap<String, Double> expected = new LinkedHashMap<String, Double>();
        Double dd = 2.0;
        expected.put("temp", dd);
        try {
            Object actual = this.executeScript(scriptBodyTestSwitchNodeStr);
            TbExpressionsTest.assertEquals(expected, (Object)actual);
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("unresolvable property or identifier: test"));
        }
    }

    public void testSwitchNodeWithout_Bracket_Error() {
        try {
            String scriptBodyTestSwitchNodeStr = "\nvar msg = {};\nmsg[\"temperature\"] = 100.0;\nvar a = 25;\n\nswitch msg.temperature){\n    case 115.0:\n    case 100.0:\n        msg.temperature = 1;\n        break;\n    case 12.0:\n        msg.temperature = 2;\n        break;\n    case 15.0:\n        msg.temperature = 5;\n        break;\n    default:\n        msg.temperature = 6;\n}\nreturn {temp: msg.temperature};\n";
            this.executeScript(scriptBodyTestSwitchNodeStr);
            TbExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Switch without expression or not find start/end of switch block"));
        }
    }

    public void testSwitchNodeWithout_Brace_Error() {
        try {
            String scriptBodyTestSwitchNodeStr = "\nvar msg = {};\nmsg[\"temperature\"] = 100.0;\nvar a = 25;\n\nswitch (msg.temperature) \n    case 115.0:\n    case 100.0:\n        msg.temperature = 1;\n        break;\n    case 12.0:\n        msg.temperature = 2;\n        break;\n    case 15.0:\n        msg.temperature = 5;\n        break;\n    default:\n        msg.temperature = 6;\n}\nreturn {temp: msg.temperature};\n";
            this.executeScript(scriptBodyTestSwitchNodeStr);
            TbExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Switch without expression or not find start/end of switch block"));
        }
    }

    public void testSwitchNodeWithout_BraceClose_Error() {
        try {
            String scriptBodyTestSwitchNodeStr = "\nvar msg = {};\nmsg[\"temperature\"] = 100.0;\nvar a = 25;\n\nswitch (msg.temperature) {\n    case 115.0:\n    case 100.0:\n        msg.temperature = 1;\n        break;\n    case 12.0:\n        msg.temperature = 2;\n        break;\n    case 15.0:\n        msg.temperature = 5;\n        break;\n    default:\n        msg.temperature = 6;\n\nreturn {temp: msg.temperature};\n";
            this.executeScript(scriptBodyTestSwitchNodeStr);
            TbExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("unbalanced braces { ... }"));
        }
    }

    public void testSwitchNodeFailedDefault_Error() {
        try {
            String scriptBodyTestSwitchNodeStr = "\nvar msg = {};\nmsg[\"temperature\"] = 100.0;\nvar a = 25;\n\nswitch (msg.temperature) {\n    case 115.0:\n    case 100.0:\n        msg.temperature = 1;\n        break;\n    case 12.0:\n        msg.temperature = 2;\n        break;\n    case 15.0:\n        msg.temperature = 5;\n        break;\n    default r :\n        msg.temperature = 6;\n}\nreturn {temp: msg.temperature};\n";
            this.executeScript(scriptBodyTestSwitchNodeStr);
            TbExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("after \"default\" expected ':' but encountered: r"));
        }
    }

    public void testSwitchNodeWithoutCaseWithDefault_Error() {
        try {
            String scriptBodyTestSwitchNodeStr = "\nvar msg = {};\nmsg[\"temperature\"] = 100.0;\nvar a = 25;\n\nswitch (msg.temperature) {\n    default:\n        msg.temperature = 6;\n}\nreturn {temp: msg.temperature};\n";
            this.executeScript(scriptBodyTestSwitchNodeStr);
            TbExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("statement expected"));
        }
    }

    public void testSwitchNodeEmpty_Error() {
        try {
            String scriptBodyTestSwitchNodeStr = "\nvar msg = {};\nmsg[\"temperature\"] = 100.0;\nvar a = 25;\n\nswitch (msg.temperature) {\n}\nreturn {temp: msg.temperature};\n";
            this.executeScript(scriptBodyTestSwitchNodeStr);
            TbExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("Switch without expression or not find start/end of switch block"));
        }
    }

    public void testSwitchNodeWithoutCaseAndDefault_Error() {
        try {
            String scriptBodyTestSwitchNodeStr = "\nvar msg = {};\nmsg[\"temperature\"] = 100.0;\nvar a = 25;\n\nswitch (msg.temperature) {\nrty\n}\nreturn {temp: msg.temperature};\n";
            this.executeScript(scriptBodyTestSwitchNodeStr);
            TbExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("statement expected"));
        }
    }

    public void testSwitchNode_CaseWithoutSwitch_Error() {
        String scriptBodyTestSwitchNodeStr = "\nvar msg = {};\nmsg[\"temperature\"] = 120;\ncase (msg.temperature){\n    case 120.0:\n        msg.temperature = 1.0;\n         break;\n    case 241:\n        msg.temperature = 2.0;\n        break;\n    default:\n        msg.temperature = 3.0;\n\n}\nreturn {temp: msg.temperature};\n";
        try {
            this.executeScript(scriptBodyTestSwitchNodeStr);
            TbExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("case without switch"));
        }
    }

    public void testSwitchNodeDefaultWithoutCase_Error() {
        String scriptBodyTestSwitchNodeStr = "\nvar msg = {};\nmsg[\"temperature\"] = 120;\nswitch (msg.temperature){\n    default:\n        msg.temperature = 3.0;\n\n}\nreturn {temp: msg.temperature};\n";
        try {
            this.executeScript(scriptBodyTestSwitchNodeStr);
            TbExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("statement expected"));
        }
    }

    public void testSwitchNodeDefaultWithoutSwitch_Error() {
        String scriptBodyTestSwitchNodeStr = "\nvar msg = {};\nmsg[\"temperature\"] = 120;\ndefault (msg.temperature){\n    case 120.0:\n        msg.temperature = 1.0;\n         break;\n    default:\n        msg.temperature = 3.0;\n\n}\nreturn {temp: msg.temperature};\n";
        try {
            this.executeScript(scriptBodyTestSwitchNodeStr);
            TbExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("default without switch"));
        }
    }

    public void testForWithBreakInIf_OnlyBreak() {
        String scriptBodyTestForWithBreakInIfStr = "var y = 0;\nfor (int i =0; i< 100; i++) {\n        y=i;\n        if (i > 2) {\n            break;\n        }\n    }\nreturn {\n    msg: y\n};";
        LinkedHashMap<String, Integer> expected = new LinkedHashMap<String, Integer>();
        expected.put("msg", 3);
        Object actual = this.executeScript(scriptBodyTestForWithBreakInIfStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testForWithBreakInIf_Function() {
        String scriptBodyTestForWithBreakInIfStr = "var input = [1, 2, 3, 4];\nvar output = 10;\nforBreak();\nfunction forBreak() {\n    for (var i = 0; i < input.size; i++) {\n        output = i;\n        if (i === 1) {\n            output = input[i];\n            break;\n        }\n        output = i;\n    }\n}return {\n    msg: output\n};\n";
        LinkedHashMap<String, Integer> expected = new LinkedHashMap<String, Integer>();
        expected.put("msg", 2);
        Object actual = this.executeScript(scriptBodyTestForWithBreakInIfStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testForWithBreakOneFor() {
        String scriptBodyTestForWithBreakInIfStr = "var input = [-1, -7, -3, -4];\nvar output = 9;\nfor (var i = 0; i < input.size; i++) {\n    output = i * 10;\n    if (i === 3) {\n        output = input[i];\n        break;\n        output = i * 100;\n    }\n    output = i * 1000;\n}\n    output = output * 10000;\nreturn {msg: output};";
        LinkedHashMap<String, Integer> expected = new LinkedHashMap<String, Integer>();
        expected.put("msg", -40000);
        Object actual = this.executeScript(scriptBodyTestForWithBreakInIfStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testForWithBreakIncludesForWithBreak() {
        String scriptBodyTestForWithBreakInIfStr = "var input = [-1, -7, -3, -4];\nvar output = 9;\nvar outputY = 19;\nfor (var i = 0; i < input.size; i++) {\n      output = i*10;\n    if (i === 2) {\n      output = input[i];\n      break;\n      output = i*100;\n    } else if ( i === 0) {\n      outputY = 19;\n      for (var y = 0; y < input.size; y++) {\n        outputY = y*10*2;\n        if (y === 1) {\n          outputY = input[y];\n          break;\n          outputY = y*100*2;\n        }\n        outputY = y*1000*2;\n      }\n    }\n    output = i*1000;\n}\nreturn {msg: [output, outputY]};";
        LinkedHashMap expected = new LinkedHashMap();
        ArrayList<Integer> expIntList = new ArrayList<Integer>();
        expIntList.add(-3);
        expIntList.add(-7);
        expected.put("msg", expIntList);
        Object actual = this.executeScript(scriptBodyTestForWithBreakInIfStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testForWithBreakWithIncrementIndex() {
        String scriptBodyTestSwitchNodeStr = "var input = [0x02, 0x75, 45, 0x01, 0x75, 55, 0x03, 0x76,  75];\nvar output = { \"telemetry\": {\"battery\": 130}};\nfor (var i = 0; i < input.size;) {\n        var channel_id = input[i++];\n        var channel_type = input[i++];\n        // BATTERY\n        if (channel_id === 0x01 && channel_type === 0x75) {\n            output.telemetry.battery = input[i];\n            break;\n        }\n        i += 1;\n\n}\n\nreturn {msg: output.telemetry.battery};";
        LinkedHashMap<String, Integer> expected = new LinkedHashMap<String, Integer>();
        expected.put("msg", 55);
        Object actual = this.executeScript(scriptBodyTestSwitchNodeStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testForeachWithBreakIncludesForeachWithBreak() {
        String scriptBodyTestForWithBreakInIfStr = "var input = [-1, -10, -3, -4];\nvar output = 9;\nvar outputY = 19;\nvar i = 0;\nvar y = 0;\nforeach(a: input) {\n    output = i * 10;\n    if (i === 2) {\n        output = a;\n        break;\n        output = i * 100;\n    } else if (i === 0) {\n        outputY = 19;\n        y = 0;\n        foreach(b: input) {\n            outputY = y * 10 * 2;\n            if (y === 1) {\n                outputY = b;\n                break;\n                outputY = y * 100 * 2;\n            }\n            outputY = y * 1000 * 2;\n            y++;\n        }\n    }\n    output = i * 1000;\n    i++;\n}\noutput = output * 4;\noutputY = outputY / 2;\nreturn {\n    msg: [output, outputY, i, y]\n};";
        LinkedHashMap expected = new LinkedHashMap();
        ArrayList<Integer> expIntList = new ArrayList<Integer>();
        expIntList.add(-12);
        expIntList.add(-5);
        expIntList.add(2);
        expIntList.add(1);
        expected.put("msg", expIntList);
        Object actual = this.executeScript(scriptBodyTestForWithBreakInIfStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testForeachWithBreakInIf_Function() {
        String scriptBodyTestForWithBreakInIfStr = "var input = [-1, -2, -3, -4];\nvar output = 10;\nvar i = 0;\nforBreak();\nfunction forBreak() {\n    foreach(a: input) {\n        output = i;\n        if (i === 1) {\n            output = a;\n            break;\n        }\n        output = i;\n        i++;\n    }\n}return {\n    msg: output\n};\n";
        LinkedHashMap<String, Integer> expected = new LinkedHashMap<String, Integer>();
        expected.put("msg", -2);
        Object actual = this.executeScript(scriptBodyTestForWithBreakInIfStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testWhileWithBreak() {
        String scriptBodyTestForWithBreakInIfStr = "var input = [-1, -7, -3, -4];\nvar output = -9;\nvar i = 0;\nwhile (i < input.size()) {\n    output = i * 10;\n    if (i === 1) {\n        output = input[i];\n        break;\n        output = i * 100;\n    }\n    i++;\n    output = i * 1000;\n}\noutput = output * 4;\nreturn {\n    msg: [output, i]\n};";
        LinkedHashMap expected = new LinkedHashMap();
        ArrayList<Integer> expIntList = new ArrayList<Integer>();
        expIntList.add(-28);
        expIntList.add(1);
        expected.put("msg", expIntList);
        Object actual = this.executeScript(scriptBodyTestForWithBreakInIfStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testWhileWithBreakIncludesWhileWithBreak() {
        String scriptBodyTestForWithBreakInIfStr = "var input = [-1, -10, -3, -4];\nvar output = -9;\nvar outputY = -19;\nvar i = 0;\nvar y = 0;\nwhile (i < input.size()) {\n    output = i * 10;\n    if (i === 2) {\n        output = input[i];\n        break;\n        output = i * 100;\n    } else if (i === 0) {\n        outputY = -20;\n        y = 0;\n       while (y < input.size()) {\n            outputY = y * 10 * 2;\n            if (y === 1) {\n                outputY = input[y];\n                break;\n                outputY = y * 100 * 2;\n            }\n            outputY = y * 1000 * 2;\n            y++;\n        }\n    }\n    output = i * 1000;\n    i++;\n}\noutput = output * 4;\noutputY = outputY / 2;\nreturn {\n    msg: [output, outputY, i, y]\n};";
        LinkedHashMap expected = new LinkedHashMap();
        ArrayList<Integer> expIntList = new ArrayList<Integer>();
        expIntList.add(-12);
        expIntList.add(-5);
        expIntList.add(2);
        expIntList.add(1);
        expected.put("msg", expIntList);
        Object actual = this.executeScript(scriptBodyTestForWithBreakInIfStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testWhileWithBreakInIf_Function() {
        String scriptBodyTestForWithBreakInIfStr = "var input = [-1, -2, -3, -4];\nvar output = 10;\nvar i = 0;\nforBreak();\nfunction forBreak() {\n    while (i < input.size()) {\n        output = i;\n        if (i === 1) {\n            output = input[i];\n            break;\n        }\n        output = i;\n        i++;\n    }\n}return {\n    msg: [output, i]\n};\n";
        LinkedHashMap expected = new LinkedHashMap();
        ArrayList<Integer> expIntList = new ArrayList<Integer>();
        expIntList.add(-2);
        expIntList.add(1);
        expected.put("msg", expIntList);
        Object actual = this.executeScript(scriptBodyTestForWithBreakInIfStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testDoWithBreak() {
        String scriptBodyTestForWithBreakInIfStr = "var input = [-1, -7, -3, -4];\nvar output = -9;\nvar i = 0;\ndo {\n    output = i * 10;\n    if (i === 1) {\n        output = input[i];\n        break;\n        output = i * 100;\n    }\n    i++;\n    output = i * 1000;\n}\nwhile (i < input.size()) \noutput = output * 4;\nreturn {\n    msg: [output, i]\n};";
        LinkedHashMap expected = new LinkedHashMap();
        ArrayList<Integer> expIntList = new ArrayList<Integer>();
        expIntList.add(-28);
        expIntList.add(1);
        expected.put("msg", expIntList);
        Object actual = this.executeScript(scriptBodyTestForWithBreakInIfStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testDoWithBreakIncludesDoWithBreak() {
        String scriptBodyTestForWithBreakInIfStr = "var input = [-1, -10, -3, -4];\nvar output = -9;\nvar outputY = -19;\nvar i = 0;\nvar y = 0;\ndo {\n    output = i * 10;\n    if (i === 2) {\n        output = input[i];\n        break;\n        output = i * 100;\n    } else if (i === 0) {\n        outputY = -20;\n        y = 0;\n       do {\n            outputY = y * 10 * 2;\n            if (y === 1) {\n                outputY = input[y];\n                break;\n                outputY = y * 100 * 2;\n            }\n            outputY = y * 1000 * 2;\n            y++;\n        }\n       while (y < input.size()) \n    }\n    output = i * 1000;\n    i++;\n}\nwhile (i < input.size()) \noutput = output * 4;\noutputY = outputY / 2;\nreturn {\n    msg: [output, outputY, i, y]\n};";
        LinkedHashMap expected = new LinkedHashMap();
        ArrayList<Integer> expIntList = new ArrayList<Integer>();
        expIntList.add(-12);
        expIntList.add(-5);
        expIntList.add(2);
        expIntList.add(1);
        expected.put("msg", expIntList);
        Object actual = this.executeScript(scriptBodyTestForWithBreakInIfStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testDoWithBreakInIf_Function() {
        String scriptBodyTestForWithBreakInIfStr = "var input = [-1, -2, -3, -4];\nvar output = 10;\nvar i = 0;\nforBreak();\nfunction forBreak() {\n   do {\n        output = i;\n        if (i === 1) {\n            output = input[i];\n            break;\n        }\n        output = i;\n        i++;\n    }\n    while (i < input.size()) \n}return {\n    msg: [output, i]\n};\n";
        LinkedHashMap expected = new LinkedHashMap();
        ArrayList<Integer> expIntList = new ArrayList<Integer>();
        expIntList.add(-2);
        expIntList.add(1);
        expected.put("msg", expIntList);
        Object actual = this.executeScript(scriptBodyTestForWithBreakInIfStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testDoUntilWithBreak() {
        String scriptBodyTestForWithBreakInIfStr = "var input = [-1, -7, -3, -4];\nvar output = -9;\nvar i = 0;\ndo {\n    output = i * 10;\n    if (i === 2) {\n        output = input[i];\n        break;\n        output = i * 100;\n    }\n    i++;\n    output = i * 1000;\n}\nuntil (i > input.size()) \noutput = output * 4;\nreturn {\n    msg: [output, i]\n};";
        LinkedHashMap expected = new LinkedHashMap();
        ArrayList<Integer> expIntList = new ArrayList<Integer>();
        expIntList.add(-12);
        expIntList.add(2);
        expected.put("msg", expIntList);
        Object actual = this.executeScript(scriptBodyTestForWithBreakInIfStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testDoUntilWithBreakIncludesDoWithBreak() {
        String scriptBodyTestForWithBreakInIfStr = "var input = [-1, -7, -3, -4];\nvar output = -9;\nvar outputY = -19;\nvar i = 0;\nvar y = 0;\ndo {\n    output = i * 10;\n    if (i === 2) {\n        output = input[i];\n        break;\n        output = i * 100;\n    } else if (i === 0) {\n        outputY = -20;\n        y = 0;\n       do {\n            outputY = y * 10 * 2;\n            if (y === 1) {\n                outputY = input[y];\n                break;\n                outputY = y * 100 * 2;\n            }\n            outputY = y * 1000 * 2;\n            y++;\n       }\n       until (y > input.size()) \n    }\n    i++;\n    output = i * 1000;\n}\nuntil (i > input.size()) \noutput = output * 4;\nreturn {\n    msg: [output, outputY, i, y]\n};";
        LinkedHashMap expected = new LinkedHashMap();
        ArrayList<Integer> expIntList = new ArrayList<Integer>();
        expIntList.add(-12);
        expIntList.add(-7);
        expIntList.add(2);
        expIntList.add(1);
        expected.put("msg", expIntList);
        Object actual = this.executeScript(scriptBodyTestForWithBreakInIfStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testDoUntilWithBreakInIf_Function() {
        String scriptBodyTestForWithBreakInIfStr = "var input = [-1, -2, -3, -4];\nvar output = 10;\nvar i = 0;\nforBreak();\nfunction forBreak() {\n   do {\n        output = i;\n        if (i === 1) {\n            output = input[i];\n            break;\n        }\n        output = i;\n        i++;\n    }\n    until (i > input.size()) \n}return {\n    msg: [output, i]\n};\n";
        LinkedHashMap expected = new LinkedHashMap();
        ArrayList<Integer> expIntList = new ArrayList<Integer>();
        expIntList.add(-2);
        expIntList.add(1);
        expected.put("msg", expIntList);
        Object actual = this.executeScript(scriptBodyTestForWithBreakInIfStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testForVar_a_FunctionWithForVar_a() {
        String scriptBodyTestForWithBreakInIfStr = "var output = 0;\nfor (var a = 0; a < 10; a++) {\n    output = testBreak(output);\n}\nreturn {\n    msg: [output]\n};\nfunction testBreak(val) {\n    for (var a = 0; a< 9; a++) {\n        val++;\n    }\n    return val;\n}\n";
        LinkedHashMap expected = new LinkedHashMap();
        ArrayList<Integer> expIntList = new ArrayList<Integer>();
        expIntList.add(90);
        expected.put("msg", expIntList);
        Object actual = this.executeScript(scriptBodyTestForWithBreakInIfStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testLeve0ForVar_a_Level0_a_unresolvable() {
        String scriptBodyTestForWithBreakInIfStr = "var output = 0;\nfor (var a = 0; a < 10; a++) {\n}\noutput = a;\nreturn {\n    msg: [output]\n};\n\n";
        try {
            this.executeScript(scriptBodyTestForWithBreakInIfStr);
            TbExpressionsTest.fail((String)"Should throw PropertyAccessException");
        }
        catch (CompileException e) {
            TbExpressionsTest.assertTrue((boolean)e.getMessage().contains("unresolvable property or identifier: a"));
        }
    }

    public void testLeve0ForVar_a_And_FunctionWithForVar_a_Function_Calling_Level0() {
        String scriptBodyTestForWithBreakInIfStr = "var output = 0;\noutput = testBreak(output);\nfor (var a = 0; a < 10; a++) {\n}\nfor (var y = 0; y < 2; y++) {\n        output++;\n}\nfor (var r = 0; r < 10; r++) {\n}\nreturn {\n    msg: [output]\n};\nfunction testBreak(val) {\n    var b = 45;\n    for (var r = 0; r < 5; r++) {\n        output++;\n    }\n    val = output;\n    for (var a = 0; a < 9; a++) {\n        val++;\n    }\n    return val;\n}\n";
        LinkedHashMap expected = new LinkedHashMap();
        ArrayList<Integer> expIntList = new ArrayList<Integer>();
        expIntList.add(16);
        expected.put("msg", expIntList);
        Object actual = this.executeScript(scriptBodyTestForWithBreakInIfStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testOneNameVar_In_Another_Procedure_NotTimeout() {
        String scriptBodyTestForWithBreakInIfStr = "var output = 0;\nfor (var a = 0; a < 100; a++) {\n    output = testBug(output);\n}\noutput = testBug(output);\nreturn {\n    msg: [output]\n};\nfunction testBug(val) {\n    for (var a = 0; a < 9; a++) {\n        val++;\n    }\n    return val;\n}";
        LinkedHashMap expected = new LinkedHashMap();
        ArrayList<Integer> expIntList = new ArrayList<Integer>();
        expIntList.add(909);
        expected.put("msg", expIntList);
        Object actual = this.executeScript(scriptBodyTestForWithBreakInIfStr);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testInnerFunctionForReturn() {
        String body = "var output = 0;\n\noutput = testBug(output);\n\nreturn output;\n\nfunction testBug(val) {\n    for (var i=0 ;i<10;i++) {\n        return 1;\n    }\n    return 2;\n}";
        Object result = this.executeScript(body);
        TbExpressionsTest.assertTrue((boolean)(result instanceof Integer));
        TbExpressionsTest.assertEquals((Object)1, (Object)result);
    }

    public void testInnerFunctionForConditionalReturn() {
        String body = "var output = 0;\n\noutput = testBug(output);\n\nreturn output;\n\nfunction testBug(val) {\n    for (var i=0 ;i<10;i++) {\n        if (i > 5) {\n             return i;\n        }\n    }\n    return 2;\n}";
        Object result = this.executeScript(body);
        TbExpressionsTest.assertTrue((boolean)(result instanceof Integer));
        TbExpressionsTest.assertEquals((Object)6, (Object)result);
    }

    public void testInnerFunctionWhileReturn() {
        String body = "var output = 0;\n\noutput = testBug(output);\n\nreturn output;\n\nfunction testBug(val) {\n    var i = 0;              \n    while ( i < 10) {\n        return 1;\n    }\n    return 2;\n}";
        Object result = this.executeScript(body);
        TbExpressionsTest.assertTrue((boolean)(result instanceof Integer));
        TbExpressionsTest.assertEquals((Object)1, (Object)result);
    }

    public void testInnerFunctionWhileConditionalReturn() {
        String body = "var output = 0;\n\noutput = testBug(output);\n\nreturn output;\n\nfunction testBug(val) {\n    var i = 0;              \n    while ( i < 10) {\n        if (i > 5) {\n           return i;\n        }\n        i++;    }\n    return 2;\n}";
        Object result = this.executeScript(body);
        TbExpressionsTest.assertTrue((boolean)(result instanceof Integer));
        TbExpressionsTest.assertEquals((Object)6, (Object)result);
    }

    public void testIntegerToIntegerFromJson_OperationMULT_If_result_More_Integer_MIN_VALUE_And_Lees_Integer_MAX_VALUE() {
        Integer sunriseValueOld = 0x6666666;
        Integer sunriseValueNew = Integer.valueOf(sunriseValueOld) * 10;
        String sunriseName = "sunrise";
        LinkedHashMap vars = new LinkedHashMap();
        LinkedHashMap<String, Integer> msg = new LinkedHashMap<String, Integer>();
        msg.put("sys", sunriseValueOld);
        vars.put("msg", msg);
        String body = "var time = msg.sys * 10;\nmsg." + sunriseName + " = time;\nreturn {\"msg\": msg};";
        Object actual = this.executeScript(body, vars);
        LinkedHashMap expected = vars;
        ((LinkedHashMap)expected.get("msg")).put(sunriseName, sunriseValueNew);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
        sunriseValueOld = -107374182;
        sunriseValueNew = Integer.valueOf(sunriseValueOld) * 10;
        vars = new LinkedHashMap();
        msg = new LinkedHashMap();
        msg.put("sys", sunriseValueOld);
        vars.put("msg", msg);
        body = "var time = msg.sys * 10;\nmsg." + sunriseName + " = time;\nreturn {\"msg\": msg};";
        actual = this.executeScript(body, vars);
        expected = vars;
        ((LinkedHashMap)expected.get("msg")).put(sunriseName, sunriseValueNew);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testIntegerToLongFromJson_OperationMULT_If_result_less_Integer_MIN_VALUE() {
        Integer sunriseValueOld = Integer.MIN_VALUE;
        Long sunriseValueNew = Long.valueOf(sunriseValueOld.intValue()) * 10000L;
        String sunriseName = "sunrise";
        LinkedHashMap vars = new LinkedHashMap();
        LinkedHashMap<String, Integer> msg = new LinkedHashMap<String, Integer>();
        msg.put("sys", sunriseValueOld);
        vars.put("msg", msg);
        String body = "var time = msg.sys * 10000;\nmsg." + sunriseName + " = time;\nreturn {\"msg\": msg};";
        Object actual = this.executeScript(body, vars);
        LinkedHashMap expected = vars;
        ((LinkedHashMap)expected.get("msg")).put(sunriseName, sunriseValueNew);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testIntegerToLongFromJson_OperationMULT_If_result_more_Integer_MAX_VALUE() {
        Integer sunriseValueOld = Integer.MAX_VALUE;
        Long sunriseValueNew = Long.valueOf(sunriseValueOld.intValue()) * 10000L;
        String sunriseName = "sunrise";
        LinkedHashMap vars = new LinkedHashMap();
        LinkedHashMap<String, Integer> msg = new LinkedHashMap<String, Integer>();
        msg.put("sys", sunriseValueOld);
        vars.put("msg", msg);
        String body = "var time = msg.sys * 10000;\nmsg." + sunriseName + " = time;\nreturn {\"msg\": msg};";
        Object actual = this.executeScript(body, vars);
        LinkedHashMap expected = vars;
        ((LinkedHashMap)expected.get("msg")).put(sunriseName, sunriseValueNew);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testIntegerToIntegerFromJson_OperationADD_If_result_More_Integer_MIN_VALUE_And_Lees_Integer_MAX_VALUE() {
        Integer sunriseValueOld = 2147483627;
        Integer sunriseValueNew = Integer.valueOf(sunriseValueOld) + 10;
        String sunriseName = "sunrise";
        LinkedHashMap vars = new LinkedHashMap();
        LinkedHashMap<String, Integer> msg = new LinkedHashMap<String, Integer>();
        msg.put("sys", sunriseValueOld);
        vars.put("msg", msg);
        String body = "var time = msg.sys + 10;\nmsg." + sunriseName + " = time;\nreturn {\"msg\": msg};";
        Object actual = this.executeScript(body, vars);
        LinkedHashMap expected = vars;
        ((LinkedHashMap)expected.get("msg")).put(sunriseName, sunriseValueNew);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
        sunriseValueOld = Integer.MIN_VALUE;
        sunriseValueNew = Integer.valueOf(sunriseValueOld) + 10;
        vars = new LinkedHashMap();
        msg = new LinkedHashMap();
        msg.put("sys", sunriseValueOld);
        vars.put("msg", msg);
        body = "var time = msg.sys + 10;\nmsg." + sunriseName + " = time;\nreturn {\"msg\": msg};";
        actual = this.executeScript(body, vars);
        expected = vars;
        ((LinkedHashMap)expected.get("msg")).put(sunriseName, sunriseValueNew);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testIntegerToLongFromJson_OperationADD_If_result_more_Integer_MAX_VALUE() {
        Integer sunriseValueOld = Integer.MAX_VALUE;
        Long sunriseValueNew = Long.valueOf(sunriseValueOld.intValue()) + 10L;
        String sunriseName = "sunrise";
        LinkedHashMap vars = new LinkedHashMap();
        LinkedHashMap<String, Integer> msg = new LinkedHashMap<String, Integer>();
        msg.put("sys", sunriseValueOld);
        vars.put("msg", msg);
        String body = "var time = msg.sys + 10;\nmsg." + sunriseName + " = time;\nreturn {\"msg\": msg};";
        Object actual = this.executeScript(body, vars);
        LinkedHashMap expected = vars;
        ((LinkedHashMap)expected.get("msg")).put(sunriseName, sunriseValueNew);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testIntegerToLongFromJson_OperationADD_If_result_lees_Integer_MIN_VALUE() {
        Integer sunriseValueOld = Integer.MIN_VALUE;
        Integer addValue = -10;
        Long sunriseValueNew = Long.valueOf(sunriseValueOld.intValue()) + (long)addValue.intValue();
        String sunriseName = "sunrise";
        LinkedHashMap vars = new LinkedHashMap();
        LinkedHashMap<String, Integer> msg = new LinkedHashMap<String, Integer>();
        msg.put("sys", sunriseValueOld);
        vars.put("msg", msg);
        String body = "var addValue = -10;\nvar time = msg.sys + addValue;\nmsg." + sunriseName + " = time;\nreturn {\"msg\": msg};";
        Object actual = this.executeScript(body, vars);
        LinkedHashMap expected = vars;
        ((LinkedHashMap)expected.get("msg")).put(sunriseName, sunriseValueNew);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testIntegerToIntegerFromJson_OperationSUB_If_result_More_Integer_MIN_VALUE_And_Lees_Integer_MAX_VALUE() {
        Integer sunriseValueOld = Integer.MAX_VALUE;
        Integer sunriseValueNew = Integer.valueOf(sunriseValueOld) - 10;
        String sunriseName = "sunrise";
        LinkedHashMap vars = new LinkedHashMap();
        LinkedHashMap<String, Integer> msg = new LinkedHashMap<String, Integer>();
        msg.put("sys", sunriseValueOld);
        vars.put("msg", msg);
        String body = "var time = msg.sys - 10;\nmsg." + sunriseName + " = time;\nreturn {\"msg\": msg};";
        Object actual = this.executeScript(body, vars);
        LinkedHashMap expected = vars;
        ((LinkedHashMap)expected.get("msg")).put(sunriseName, sunriseValueNew);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
        sunriseValueOld = -2147483628;
        sunriseValueNew = Integer.valueOf(sunriseValueOld) - 10;
        vars = new LinkedHashMap();
        msg = new LinkedHashMap();
        msg.put("sys", sunriseValueOld);
        vars.put("msg", msg);
        body = "var time = msg.sys - 10;\nmsg." + sunriseName + " = time;\nreturn {\"msg\": msg};";
        actual = this.executeScript(body, vars);
        expected = vars;
        ((LinkedHashMap)expected.get("msg")).put(sunriseName, sunriseValueNew);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testIntegerToLongFromJson_OperationSUB_If_result_more_Integer_MAX_VALUE() {
        Integer sunriseValueOld = Integer.MAX_VALUE;
        Integer addValue = -10;
        Long sunriseValueNew = Long.valueOf(sunriseValueOld.intValue()) - (long)addValue.intValue();
        String sunriseName = "sunrise";
        LinkedHashMap vars = new LinkedHashMap();
        LinkedHashMap<String, Integer> msg = new LinkedHashMap<String, Integer>();
        msg.put("sys", sunriseValueOld);
        vars.put("msg", msg);
        String body = "var addValue = -10;\nvar time = msg.sys - addValue;\nmsg." + sunriseName + " = time;\nreturn {\"msg\": msg};";
        Object actual = this.executeScript(body, vars);
        LinkedHashMap expected = vars;
        ((LinkedHashMap)expected.get("msg")).put(sunriseName, sunriseValueNew);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testIntegerToLongFromJson_OperationSUB_If_result_lees_Integer_MIN_VALUE() {
        Integer sunriseValueOld = Integer.MIN_VALUE;
        Long sunriseValueNew = Long.valueOf(sunriseValueOld.intValue()) - 10L;
        String sunriseName = "sunrise";
        LinkedHashMap vars = new LinkedHashMap();
        LinkedHashMap<String, Integer> msg = new LinkedHashMap<String, Integer>();
        msg.put("sys", sunriseValueOld);
        vars.put("msg", msg);
        String body = "var time = msg.sys - 10;\nmsg." + sunriseName + " = time;\nreturn {\"msg\": msg};";
        Object actual = this.executeScript(body, vars);
        LinkedHashMap expected = vars;
        ((LinkedHashMap)expected.get("msg")).put(sunriseName, sunriseValueNew);
        TbExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testExpectType_InputKnownEgressTypeAsInterface() {
        String body = "var newMsg = {\n    \"entityFilter\": {\n        \"type\": \"entityType\",\n        \"resolveMultiple\": true,\n        \"entityType\": \"DEVICE\"\n    },\n    \"pageLink\": {\n        \"page\": 0,\n        \"pageSize\": 10,\n        \"textSearch\": null,\n        \"dynamic\": true,\n        \"sortOrder\": {\n            \"key\": {\n                \"key\": \"name\",\n                \"type\": \"ENTITY_FIELD\"\n            },\n            \"direction\": \"ASC\"\n        }\n    },\n    \"keyFilters\": [{\n        \"key\": {\n            \"type\": \"ATTRIBUTE\",\n            \"key\": \"active\"\n        },\n        \"valueType\": \"BOOLEAN\",\n        \"predicate\": {\n            \"operation\": \"EQUAL\",\n            \"value\": {\n                \"defaultValue\": true,\n                \"dynamicValue\": null\n            },\n            \"type\": \"BOOLEAN\"\n        }\n    }]\n};\nreturn {\n    msg: newMsg\n};";
        Object result = this.executeScript(body);
        String actual = result.toString();
        String expected = "{msg={entityFilter={type=entityType, resolveMultiple=true, entityType=DEVICE}, pageLink={page=0, pageSize=10, dynamic=true, sortOrder={key={key=name, type=ENTITY_FIELD}, direction=ASC}}, keyFilters=[{key={type=ATTRIBUTE, key=active}, valueType=BOOLEAN, predicate={operation=EQUAL, value={defaultValue=true}, type=BOOLEAN}}]}}";
        TbExpressionsTest.assertEquals((String)expected, (String)actual);
    }

    public void testExecutionHashMap_Public_Key_Value() {
        String body = "var msg1 = {\n    \"temperature\": 22.4,\n    \"humidity\": 78\n};\n\nvar map = {\n    \"test\": 42,\n    \"nested\": {\n        \"rssi\": 130\n    }\n};\nforeach(element: map) {\n    msg1[element.key] = element.value;\n}\nreturn {\n    msg1\n};";
        Object result = this.executeScript(body);
        String expected = "[{temperature=22.4, humidity=78, test=42, nested={rssi=130}}]";
        TbExpressionsTest.assertEquals((String)expected, (String)result.toString());
    }

    public void testExecutionHashMap_getKey_getValue() {
        String body = "var msg1 = {\n    \"temperature\": 22.4,\n    \"humidity\": 78\n};\n\nvar map = {\n    \"test\": 42,\n    \"nested\": {\n        \"rssi\": 130\n    }\n};\nforeach(element: map) {\n    msg1[element.getKey()] = element.getValue();\n}\nreturn {\n    msg1\n};";
        Object result = this.executeScript(body);
        String expected = "[{temperature=22.4, humidity=78, test=42, nested={rssi=130}}]";
        TbExpressionsTest.assertEquals((String)expected, (String)result.toString());
    }

    public void testBooleanBitwiseOperations() {
        String body = " var x = true;\nvar y = false;\nvar a = 1;\nvar b = 0;\nvar andResultAB = a & b;\nvar andResult = x & y;\nvar orResult = x | y;\nvar xorResult = x ^ y;\nvar leftShift = x << y;\nvar rightShift = x >> y;\nvar rightUnShift = x >>> y;\nvar rez = {\n    \"andResultAB\": andResultAB,\n    \"andResult\": andResult,\n    \"orResult\": orResult,\n    \"xorResult\": xorResult,\n    \"leftShift\": leftShift,\n    \"rightShift\": rightShift,\n    \"rightUnShift\": rightUnShift\n};\nreturn {\n    rez\n};";
        Object result = this.executeScript(body);
        String expected = "[{andResultAB=0, andResult=0, orResult=1, xorResult=1, leftShift=1, rightShift=1, rightUnShift=1}]";
        TbExpressionsTest.assertEquals((String)expected, (String)result.toString());
    }

    private Object executeScript(String ex, Map vars, ExecutionContext executionContext, long timeoutMs) throws Exception {
        CountDownLatch countDown = new CountDownLatch(1);
        AtomicReference result = new AtomicReference();
        AtomicReference exception = new AtomicReference();
        Thread thread = new Thread(() -> {
            try {
                result.set(this.executeScript(ex, vars, executionContext));
            }
            catch (Exception e) {
                exception.set(e);
            }
            finally {
                countDown.countDown();
            }
        });
        thread.start();
        try {
            countDown.await(timeoutMs, TimeUnit.MILLISECONDS);
            executionContext.stop();
            countDown.await(500L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (exception.get() != null) {
            throw (Exception)exception.get();
        }
        return result.get();
    }

    private Object executeScript(String ex) {
        return this.executeScript(ex, new HashMap());
    }

    private Object executeScript(String ex, Map vars) {
        return this.executeScript(ex, vars, new ExecutionContext(this.parserConfig));
    }

    private Object executeScript(String ex, Map vars, ExecutionContext executionContext) {
        Serializable compiled = MVEL.compileExpression((String)ex, (ParserContext)new ParserContext());
        this.currentExecutionContext = executionContext;
        return MVEL.executeTbExpression((Object)compiled, (ExecutionContext)this.currentExecutionContext, (Map)vars);
    }

    public static final class MyTestClass {
        private final String innerValue;

        public MyTestClass(String val) {
            this.innerValue = val;
        }

        public String getValue() {
            return this.innerValue;
        }
    }

    public static final class TestUtil {
        public static String getFoo(Map input) {
            if (input.containsKey("foo")) {
                return input.get("foo") != null ? input.get("foo").toString() : "null";
            }
            return "Not found!";
        }

        public static Map methodWithExecContext(String key, Object val, ExecutionContext ctx) {
            ExecutionHashMap map = new ExecutionHashMap(1, ctx);
            map.put(key, val);
            return map;
        }

        public static Map methodWithExecContext2(String key, ExecutionContext ctx, Object val) {
            ExecutionHashMap map = new ExecutionHashMap(1, ctx);
            map.put(key, val);
            return map;
        }

        public static Map methodWithExecContext3(ExecutionContext ctx, String key, Object val) {
            ExecutionHashMap map = new ExecutionHashMap(1, ctx);
            map.put(key, val);
            return map;
        }

        public static List methodWithExecContextVarArgs(ExecutionContext ctx, Object ... vals) {
            ExecutionArrayList list = new ExecutionArrayList(Arrays.asList(vals), ctx);
            return list;
        }
    }
}

