/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.tests.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.mvel2.CompileException;
import org.mvel2.ExecutionContext;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.SandboxedParserConfiguration;
import org.mvel2.optimizers.OptimizerFactory;

public class TbMapArrayListExpressionsTest
extends TestCase {
    private static final Comparator stringCompAsc = new Comparator(){

        public int compare(Object o1, Object o2) {
            String first = String.valueOf(o1);
            String second = String.valueOf(o2);
            return first.compareTo(second);
        }
    };
    private static final Comparator stringCompDesc = new Comparator(){

        public int compare(Object o1, Object o2) {
            String first = String.valueOf(o1);
            String second = String.valueOf(o2);
            return second.compareTo(first);
        }
    };
    private final List<String> expectedArrayString = Arrays.asList("Dec", "Feb", "Jan", "March");
    private final List expectedArrayInteger = Arrays.asList(-214748, 1, 4, 30, 57, 100000, 214748);
    private final List expectedArrayIntLong = Arrays.asList(Long.MIN_VALUE, 30L, 40L, 45L, 1000L, Long.MAX_VALUE);
    private final List expectedArrayFloat = Arrays.asList(Float.valueOf(1.1754943f), Float.valueOf(3.40282f), Float.valueOf(34.175495f), Float.valueOf(45.40283f));
    private final List expectedArrayDouble = Arrays.asList(-9.223372036851755E11, 45.40283, 1754.40282, 9.223372036854776E18);
    private final List expectedArrayMixedNumeric = Arrays.asList(1, 5, "8", "9", 40, 200, "700");
    private final List expectedArrayMixedNumericString = Arrays.asList(1, 200, 40, 5, "8", "9", "Aabnm", "Babnm", "Zxc");
    private SandboxedParserConfiguration parserConfig;
    private ExecutionContext currentExecutionContext;

    protected void setUp() throws Exception {
        OptimizerFactory.setDefaultOptimizer((String)OptimizerFactory.SAFE_REFLECTIVE);
        super.setUp();
        this.parserConfig = ParserContext.enableSandboxedMode();
    }

    public void testExecutionHashMapCreate() {
        Object res = this.executeScript("m = {a: 1}; m.a");
        TbMapArrayListExpressionsTest.assertTrue((boolean)(res instanceof Integer));
        TbMapArrayListExpressionsTest.assertEquals((Object)1, (Object)res);
    }

    public void testExecutionHashMapCreateEmptyMapAndAssignField() {
        Object res = this.executeScript("m = {}; m.test = 1; m");
        TbMapArrayListExpressionsTest.assertTrue((boolean)(res instanceof Map));
        TbMapArrayListExpressionsTest.assertEquals((int)1, (int)((Map)res).size());
        TbMapArrayListExpressionsTest.assertEquals((Object)1, ((Map)res).get("test"));
    }

    public void testExecutionHashMapNonExistentField() {
        Object res = this.executeScript("m = {}; t = m.test; t");
        TbMapArrayListExpressionsTest.assertNull((Object)res);
    }

    public void testExecutionHashMapToString() {
        String body = "var map = {hello: 'world', testmap: 'toString'};\nreturn '' + map;";
        Object result = this.executeScript(body);
        TbMapArrayListExpressionsTest.assertTrue((boolean)(result instanceof String));
        TbMapArrayListExpressionsTest.assertEquals((Object)"{hello=world, testmap=toString}", (Object)result);
    }

    public void testExecutionHashMapKeys() {
        String body = "var map = {hello: 'world', testmap: 'toString'};\nreturn map.keys();";
        Object result = this.executeScript(body);
        TbMapArrayListExpressionsTest.assertTrue((boolean)(result instanceof List));
        TbMapArrayListExpressionsTest.assertEquals((int)2, (int)((List)result).size());
        TbMapArrayListExpressionsTest.assertEquals((Object)"hello", ((List)result).get(0));
        TbMapArrayListExpressionsTest.assertEquals((Object)"testmap", ((List)result).get(1));
    }

    public void testExecutionHashMapValues() {
        String body = "var map = {hello: 'world', testmap: 'toString'};\nreturn map.values();";
        Object result = this.executeScript(body);
        TbMapArrayListExpressionsTest.assertTrue((boolean)(result instanceof List));
        TbMapArrayListExpressionsTest.assertEquals((int)2, (int)((List)result).size());
        TbMapArrayListExpressionsTest.assertEquals((Object)"world", ((List)result).get(0));
        TbMapArrayListExpressionsTest.assertEquals((Object)"toString", ((List)result).get(1));
    }

    public void testExecutionHashMapSortByValueAsc() {
        String body = "var msg = {};\nvar sortValString = {4:\"March\", 2:\"Feb\", 3:\"Jan\", 1:\"Dec\"};\nsortValString.sortByValue();\nvar sortValInt = {2: 1, 4: 30, 3: 4, 1: -214748, 5: 57, 7: 214748, 6: 100000};\nsortValInt.sortByValue();\nvar sortValIntLong = {4:45L, 6:9223372036854775807L, 2:30L, 3:40L,  1:-9223372036854775808L, 5:1000L};\nsortValIntLong.sortByValue();\nvar sortValFloat = {2:3.40282f, 3:34.175495f, 4:45.40283f, 1:1.1754943f};\nsortValFloat.sortByValue();\nvar sortValDouble = {3:1754.40282d, 4:9.223372036854776E18d, 2:45.40283d, 1:-9.223372036851755E11d};\nsortValDouble.sortByValue();\nvar sortValMixedNumeric = {3:\"8\", 4:\"9\", 7:\"700\", 1:1, 5:40, 2:5, 6:200};\nsortValMixedNumeric.sortByValue();\nvar sortValMixedNumericString = {5:\"8\", 9:\"Zxc\", 6:\"9\", 7:\"Aabnm\", 1:1, 3:40, 8:\"Babnm\", 4:5, 2:200};\nsortValMixedNumericString.sortByValue();\nmsg.sortValString = sortValString;\nmsg.sortValInt = sortValInt;\nmsg.sortValIntLong = sortValIntLong;\nmsg.sortValFloat = sortValFloat;\nmsg.sortValDouble = sortValDouble;\nmsg.sortValMixedNumeric = sortValMixedNumeric;\nmsg.sortValMixedNumericString = sortValMixedNumericString;\nreturn {\n    msg: msg\n};";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        LinkedHashMap<Integer, String> expectedSortValString = new LinkedHashMap<Integer, String>();
        expectedSortValString.put(1, this.expectedArrayString.get(0));
        expectedSortValString.put(2, this.expectedArrayString.get(1));
        expectedSortValString.put(3, this.expectedArrayString.get(2));
        expectedSortValString.put(4, this.expectedArrayString.get(3));
        LinkedHashMap actualHashMap = (LinkedHashMap)resMap.get("sortValString");
        TbMapArrayListExpressionsTest.assertEquals(expectedSortValString, (Object)actualHashMap);
        ArrayList expectedList = new ArrayList(expectedSortValString.values());
        ArrayList actualList = new ArrayList(actualHashMap.values());
        TbMapArrayListExpressionsTest.assertEquals(expectedList, actualList);
        LinkedHashMap<Integer, Integer> expectedSortValInt = new LinkedHashMap<Integer, Integer>();
        expectedSortValInt.put(1, (Integer)this.expectedArrayInteger.get(0));
        expectedSortValInt.put(2, (Integer)this.expectedArrayInteger.get(1));
        expectedSortValInt.put(3, (Integer)this.expectedArrayInteger.get(2));
        expectedSortValInt.put(4, (Integer)this.expectedArrayInteger.get(3));
        expectedSortValInt.put(5, (Integer)this.expectedArrayInteger.get(4));
        expectedSortValInt.put(6, (Integer)this.expectedArrayInteger.get(5));
        expectedSortValInt.put(7, (Integer)this.expectedArrayInteger.get(6));
        actualHashMap = (LinkedHashMap)resMap.get("sortValInt");
        TbMapArrayListExpressionsTest.assertEquals(expectedSortValInt, (Object)actualHashMap);
        expectedList = new ArrayList(expectedSortValInt.values());
        actualList = new ArrayList(actualHashMap.values());
        TbMapArrayListExpressionsTest.assertEquals(expectedList, actualList);
        LinkedHashMap<Integer, Long> expectedSortValIntLong = new LinkedHashMap<Integer, Long>();
        expectedSortValIntLong.put(1, (Long)this.expectedArrayIntLong.get(0));
        expectedSortValIntLong.put(2, (Long)this.expectedArrayIntLong.get(1));
        expectedSortValIntLong.put(3, (Long)this.expectedArrayIntLong.get(2));
        expectedSortValIntLong.put(4, (Long)this.expectedArrayIntLong.get(3));
        expectedSortValIntLong.put(5, (Long)this.expectedArrayIntLong.get(4));
        expectedSortValIntLong.put(6, (Long)this.expectedArrayIntLong.get(5));
        actualHashMap = (LinkedHashMap)resMap.get("sortValIntLong");
        TbMapArrayListExpressionsTest.assertEquals(expectedSortValIntLong, (Object)actualHashMap);
        expectedList = new ArrayList(expectedSortValIntLong.values());
        actualList = new ArrayList(actualHashMap.values());
        TbMapArrayListExpressionsTest.assertEquals(expectedList, actualList);
        LinkedHashMap<Integer, Float> expectedSortValFloat = new LinkedHashMap<Integer, Float>();
        expectedSortValFloat.put(1, (Float)this.expectedArrayFloat.get(0));
        expectedSortValFloat.put(2, (Float)this.expectedArrayFloat.get(1));
        expectedSortValFloat.put(3, (Float)this.expectedArrayFloat.get(2));
        expectedSortValFloat.put(4, (Float)this.expectedArrayFloat.get(3));
        actualHashMap = (LinkedHashMap)resMap.get("sortValFloat");
        TbMapArrayListExpressionsTest.assertEquals(expectedSortValFloat, (Object)actualHashMap);
        expectedList = new ArrayList(expectedSortValFloat.values());
        actualList = new ArrayList(actualHashMap.values());
        TbMapArrayListExpressionsTest.assertEquals(expectedList, actualList);
        LinkedHashMap<Integer, Double> expectedSortValDouble = new LinkedHashMap<Integer, Double>();
        expectedSortValDouble.put(1, (Double)this.expectedArrayDouble.get(0));
        expectedSortValDouble.put(2, (Double)this.expectedArrayDouble.get(1));
        expectedSortValDouble.put(3, (Double)this.expectedArrayDouble.get(2));
        expectedSortValDouble.put(4, (Double)this.expectedArrayDouble.get(3));
        actualHashMap = (LinkedHashMap)resMap.get("sortValDouble");
        TbMapArrayListExpressionsTest.assertEquals(expectedSortValDouble, (Object)actualHashMap);
        expectedList = new ArrayList(expectedSortValDouble.values());
        actualList = new ArrayList(actualHashMap.values());
        TbMapArrayListExpressionsTest.assertEquals(expectedList, actualList);
        LinkedHashMap expectedSortValMixedNumeric = new LinkedHashMap();
        expectedSortValMixedNumeric.put(1, this.expectedArrayMixedNumeric.get(0));
        expectedSortValMixedNumeric.put(2, this.expectedArrayMixedNumeric.get(1));
        expectedSortValMixedNumeric.put(3, this.expectedArrayMixedNumeric.get(2));
        expectedSortValMixedNumeric.put(4, this.expectedArrayMixedNumeric.get(3));
        expectedSortValMixedNumeric.put(5, this.expectedArrayMixedNumeric.get(4));
        expectedSortValMixedNumeric.put(6, this.expectedArrayMixedNumeric.get(5));
        expectedSortValMixedNumeric.put(7, this.expectedArrayMixedNumeric.get(6));
        actualHashMap = (LinkedHashMap)resMap.get("sortValMixedNumeric");
        TbMapArrayListExpressionsTest.assertEquals(expectedSortValMixedNumeric, (Object)actualHashMap);
        expectedList = new ArrayList(expectedSortValMixedNumeric.values());
        actualList = new ArrayList(actualHashMap.values());
        TbMapArrayListExpressionsTest.assertEquals(expectedList, actualList);
        LinkedHashMap expectedSortValMixedNumericString = new LinkedHashMap();
        expectedSortValMixedNumericString.put(1, this.expectedArrayMixedNumericString.get(0));
        expectedSortValMixedNumericString.put(2, this.expectedArrayMixedNumericString.get(1));
        expectedSortValMixedNumericString.put(3, this.expectedArrayMixedNumericString.get(2));
        expectedSortValMixedNumericString.put(4, this.expectedArrayMixedNumericString.get(3));
        expectedSortValMixedNumericString.put(5, this.expectedArrayMixedNumericString.get(4));
        expectedSortValMixedNumericString.put(6, this.expectedArrayMixedNumericString.get(5));
        expectedSortValMixedNumericString.put(7, this.expectedArrayMixedNumericString.get(6));
        expectedSortValMixedNumericString.put(8, this.expectedArrayMixedNumericString.get(7));
        expectedSortValMixedNumericString.put(9, this.expectedArrayMixedNumericString.get(8));
        actualHashMap = (LinkedHashMap)resMap.get("sortValMixedNumericString");
        TbMapArrayListExpressionsTest.assertEquals(expectedSortValMixedNumericString, (Object)actualHashMap);
        expectedList = new ArrayList(expectedSortValMixedNumericString.values());
        actualList = new ArrayList(actualHashMap.values());
        TbMapArrayListExpressionsTest.assertEquals(expectedList, actualList);
    }

    public void testExecutionHashMapSortByValueDesc() {
        String body = "var msg = {};\nvar sortValString = {4:\"March\", 2:\"Feb\", 3:\"Jan\", 1:\"Dec\"};\nsortValString.sortByValue(false);\nvar sortValInt = {2: 1, 4: 30, 3: 4, 1: -214748, 5: 57, 7: 214748, 6: 100000};\nsortValInt.sortByValue(false);\nvar sortValIntLong = {4:45L, 6:9223372036854775807L, 2:30L, 3:40L,  1:-9223372036854775808L, 5:1000L};\nsortValIntLong.sortByValue(false);\nvar sortValFloat = {2:3.40282f, 3:34.175495f, 4:45.40283f, 1:1.1754943f};\nsortValFloat.sortByValue(false);\nvar sortValDouble = {3:1754.40282d, 4:9.223372036854776E18d, 2:45.40283d, 1:-9.223372036851755E11d};\nsortValDouble.sortByValue(false);\nvar sortValMixedNumeric = {3:\"8\", 4:\"9\", 7:\"700\", 1:1, 5:40, 2:5, 6:200};\nsortValMixedNumeric.sortByValue(false);\nvar sortValMixedNumericString = {5:\"8\", 6:\"9\", 7:\"Aabnm\", 1:1, 3:40, 4:5, 2:200};\nsortValMixedNumericString.sortByValue(false);\nmsg.sortValString = sortValString;\nmsg.sortValInt = sortValInt;\nmsg.sortValIntLong = sortValIntLong;\nmsg.sortValFloat = sortValFloat;\nmsg.sortValDouble = sortValDouble;\nmsg.sortValMixedNumeric = sortValMixedNumeric;\nmsg.sortValMixedNumericString = sortValMixedNumericString;\nreturn {\n    msg: msg\n};";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        LinkedHashMap<Integer, String> expectedSortValString = new LinkedHashMap<Integer, String>();
        expectedSortValString.put(1, this.expectedArrayString.get(0));
        expectedSortValString.put(2, this.expectedArrayString.get(1));
        expectedSortValString.put(3, this.expectedArrayString.get(2));
        expectedSortValString.put(4, this.expectedArrayString.get(3));
        LinkedHashMap actualHashMap = (LinkedHashMap)resMap.get("sortValString");
        TbMapArrayListExpressionsTest.assertEquals(expectedSortValString, (Object)actualHashMap);
        ArrayList expectedList = new ArrayList(expectedSortValString.values());
        ArrayList actualList = new ArrayList(actualHashMap.values());
        Collections.reverse(expectedList);
        TbMapArrayListExpressionsTest.assertEquals(expectedList, actualList);
        LinkedHashMap expectedSortValInt = new LinkedHashMap();
        expectedSortValInt.put(1, this.expectedArrayInteger.get(0));
        expectedSortValInt.put(2, this.expectedArrayInteger.get(1));
        expectedSortValInt.put(3, this.expectedArrayInteger.get(2));
        expectedSortValInt.put(4, this.expectedArrayInteger.get(3));
        expectedSortValInt.put(5, this.expectedArrayInteger.get(4));
        expectedSortValInt.put(6, this.expectedArrayInteger.get(5));
        expectedSortValInt.put(7, this.expectedArrayInteger.get(6));
        actualHashMap = (LinkedHashMap)resMap.get("sortValInt");
        TbMapArrayListExpressionsTest.assertEquals(expectedSortValInt, (Object)actualHashMap);
        expectedList = new ArrayList(expectedSortValInt.values());
        actualList = new ArrayList(actualHashMap.values());
        Collections.reverse(expectedList);
        TbMapArrayListExpressionsTest.assertEquals(expectedList, actualList);
        LinkedHashMap<Integer, Long> expectedSortValIntLong = new LinkedHashMap<Integer, Long>();
        expectedSortValIntLong.put(1, (Long)this.expectedArrayIntLong.get(0));
        expectedSortValIntLong.put(2, (Long)this.expectedArrayIntLong.get(1));
        expectedSortValIntLong.put(3, (Long)this.expectedArrayIntLong.get(2));
        expectedSortValIntLong.put(4, (Long)this.expectedArrayIntLong.get(3));
        expectedSortValIntLong.put(5, (Long)this.expectedArrayIntLong.get(4));
        expectedSortValIntLong.put(6, (Long)this.expectedArrayIntLong.get(5));
        actualHashMap = (LinkedHashMap)resMap.get("sortValIntLong");
        TbMapArrayListExpressionsTest.assertEquals(expectedSortValIntLong, (Object)actualHashMap);
        expectedList = new ArrayList(expectedSortValIntLong.values());
        actualList = new ArrayList(actualHashMap.values());
        Collections.reverse(expectedList);
        TbMapArrayListExpressionsTest.assertEquals(expectedList, actualList);
        LinkedHashMap<Integer, Float> expectedSortValFloat = new LinkedHashMap<Integer, Float>();
        expectedSortValFloat.put(1, (Float)this.expectedArrayFloat.get(0));
        expectedSortValFloat.put(2, (Float)this.expectedArrayFloat.get(1));
        expectedSortValFloat.put(3, (Float)this.expectedArrayFloat.get(2));
        expectedSortValFloat.put(4, (Float)this.expectedArrayFloat.get(3));
        actualHashMap = (LinkedHashMap)resMap.get("sortValFloat");
        TbMapArrayListExpressionsTest.assertEquals(expectedSortValFloat, (Object)actualHashMap);
        expectedList = new ArrayList(expectedSortValFloat.values());
        actualList = new ArrayList(actualHashMap.values());
        Collections.reverse(expectedList);
        TbMapArrayListExpressionsTest.assertEquals(expectedList, actualList);
        LinkedHashMap<Integer, Double> expectedSortValDouble = new LinkedHashMap<Integer, Double>();
        expectedSortValDouble.put(1, (Double)this.expectedArrayDouble.get(0));
        expectedSortValDouble.put(2, (Double)this.expectedArrayDouble.get(1));
        expectedSortValDouble.put(3, (Double)this.expectedArrayDouble.get(2));
        expectedSortValDouble.put(4, (Double)this.expectedArrayDouble.get(3));
        actualHashMap = (LinkedHashMap)resMap.get("sortValDouble");
        TbMapArrayListExpressionsTest.assertEquals(expectedSortValDouble, (Object)actualHashMap);
        expectedList = new ArrayList(expectedSortValDouble.values());
        actualList = new ArrayList(actualHashMap.values());
        Collections.reverse(expectedList);
        TbMapArrayListExpressionsTest.assertEquals(expectedList, actualList);
        LinkedHashMap expectedSortValMixedNumeric = new LinkedHashMap();
        expectedSortValMixedNumeric.put(1, this.expectedArrayMixedNumeric.get(0));
        expectedSortValMixedNumeric.put(2, this.expectedArrayMixedNumeric.get(1));
        expectedSortValMixedNumeric.put(3, this.expectedArrayMixedNumeric.get(2));
        expectedSortValMixedNumeric.put(4, this.expectedArrayMixedNumeric.get(3));
        expectedSortValMixedNumeric.put(5, this.expectedArrayMixedNumeric.get(4));
        expectedSortValMixedNumeric.put(6, this.expectedArrayMixedNumeric.get(5));
        expectedSortValMixedNumeric.put(7, this.expectedArrayMixedNumeric.get(6));
        actualHashMap = (LinkedHashMap)resMap.get("sortValMixedNumeric");
        TbMapArrayListExpressionsTest.assertEquals(expectedSortValMixedNumeric, (Object)actualHashMap);
        expectedList = new ArrayList(expectedSortValMixedNumeric.values());
        actualList = new ArrayList(actualHashMap.values());
        Collections.reverse(expectedList);
        TbMapArrayListExpressionsTest.assertEquals(expectedList, actualList);
        LinkedHashMap expectedSortValMixedNumericString = new LinkedHashMap();
        expectedSortValMixedNumericString.put(1, this.expectedArrayMixedNumericString.get(0));
        expectedSortValMixedNumericString.put(2, this.expectedArrayMixedNumericString.get(1));
        expectedSortValMixedNumericString.put(3, this.expectedArrayMixedNumericString.get(2));
        expectedSortValMixedNumericString.put(4, this.expectedArrayMixedNumericString.get(3));
        expectedSortValMixedNumericString.put(5, this.expectedArrayMixedNumericString.get(4));
        expectedSortValMixedNumericString.put(6, this.expectedArrayMixedNumericString.get(5));
        expectedSortValMixedNumericString.put(7, this.expectedArrayMixedNumericString.get(6));
        actualHashMap = (LinkedHashMap)resMap.get("sortValMixedNumericString");
        TbMapArrayListExpressionsTest.assertEquals(expectedSortValMixedNumericString, (Object)actualHashMap);
        expectedList = new ArrayList(expectedSortValMixedNumericString.values());
        actualList = new ArrayList(actualHashMap.values());
        Collections.reverse(expectedList);
        TbMapArrayListExpressionsTest.assertEquals(expectedList, actualList);
    }

    public void testExecutionHashMapToSortedByValueAsc() {
        String body = "var msg = {};\nvar sortValString = {4:\"March\", 2:\"Feb\", 3:\"Jan\", 1:\"Dec\"};\nmsg.toSortedValString = sortValString.toSortedByValue();\nmsg.sortValString = sortValString;\nreturn {\n    msg: msg\n};";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        LinkedHashMap<Integer, String> expectedSortedValString = new LinkedHashMap<Integer, String>();
        expectedSortedValString.put(4, this.expectedArrayString.get(3));
        expectedSortedValString.put(2, this.expectedArrayString.get(1));
        expectedSortedValString.put(3, this.expectedArrayString.get(2));
        expectedSortedValString.put(1, this.expectedArrayString.get(0));
        LinkedHashMap actualHashMap = (LinkedHashMap)resMap.get("sortValString");
        TbMapArrayListExpressionsTest.assertEquals(expectedSortedValString, (Object)actualHashMap);
        ArrayList expectedList = new ArrayList(expectedSortedValString.values());
        ArrayList actualList = new ArrayList(actualHashMap.values());
        TbMapArrayListExpressionsTest.assertEquals(expectedList, actualList);
        LinkedHashMap<Integer, String> expectedToSortedValString = new LinkedHashMap<Integer, String>();
        expectedToSortedValString.put(1, this.expectedArrayString.get(0));
        expectedToSortedValString.put(2, this.expectedArrayString.get(1));
        expectedToSortedValString.put(3, this.expectedArrayString.get(2));
        expectedToSortedValString.put(4, this.expectedArrayString.get(3));
        actualHashMap = (LinkedHashMap)resMap.get("toSortedValString");
        TbMapArrayListExpressionsTest.assertEquals(expectedToSortedValString, (Object)actualHashMap);
        expectedList = new ArrayList(expectedToSortedValString.values());
        actualList = new ArrayList(actualHashMap.values());
        TbMapArrayListExpressionsTest.assertEquals(expectedList, actualList);
    }

    public void testExecutionHashMapToSortedByValueDesc() {
        String body = "var msg = {};\nvar sortValString = {4:\"March\", 2:\"Feb\", 3:\"Jan\", 1:\"Dec\"};\nmsg.toSortedValString = sortValString.toSortedByValue(false);\nmsg.sortValString = sortValString;\nreturn {\n    msg: msg\n};";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        LinkedHashMap<Integer, String> expectedSortedValString = new LinkedHashMap<Integer, String>();
        expectedSortedValString.put(4, this.expectedArrayString.get(3));
        expectedSortedValString.put(2, this.expectedArrayString.get(1));
        expectedSortedValString.put(3, this.expectedArrayString.get(2));
        expectedSortedValString.put(1, this.expectedArrayString.get(0));
        LinkedHashMap actualHashMap = (LinkedHashMap)resMap.get("sortValString");
        TbMapArrayListExpressionsTest.assertEquals(expectedSortedValString, (Object)actualHashMap);
        ArrayList expectedList = new ArrayList(expectedSortedValString.values());
        ArrayList actualList = new ArrayList(actualHashMap.values());
        TbMapArrayListExpressionsTest.assertEquals(expectedList, actualList);
        LinkedHashMap<Integer, String> expectedToSortedValString = new LinkedHashMap<Integer, String>();
        expectedToSortedValString.put(4, this.expectedArrayString.get(3));
        expectedToSortedValString.put(3, this.expectedArrayString.get(2));
        expectedToSortedValString.put(2, this.expectedArrayString.get(1));
        expectedToSortedValString.put(1, this.expectedArrayString.get(0));
        actualHashMap = (LinkedHashMap)resMap.get("toSortedValString");
        TbMapArrayListExpressionsTest.assertEquals(expectedToSortedValString, (Object)actualHashMap);
        expectedList = new ArrayList(expectedToSortedValString.values());
        actualList = new ArrayList(actualHashMap.values());
        TbMapArrayListExpressionsTest.assertEquals(expectedList, actualList);
    }

    public void testExecutionHashMapSortByKeyAsc() {
        String body = "var msg = {};\nvar sortKeyString = {\"Feb\":2, \"March\":4, \"Dec\":1, \"Jan\":3, \"March\":4};\nsortKeyString.sortByKey();\nvar sortKeyInt = {1:2, 57:5, 30:4, 214748:7, -214748:1, 4:3, 100000:6};\nsortKeyInt.sortByKey();\nvar sortKeyIntLong = {30L:2, 1000L:5, 40L:3, -9223372036854775808L:1, 45L:4};\nsortKeyIntLong.sortByKey();\nvar sortKeyFloat = {3.40282f:2, 34.175495f:3, 45.40283f:4, 1.1754943f:1};\nsortKeyFloat.sortByKey();\nvar sortKeyDouble = {45.40283d:2, 9223372036854775807.17549467d:4, -922337203685.1754943d:1,1754.40282d:3};\nsortKeyDouble.sortByKey();\nvar sortKeyMixedNumeric = {\"9\":4,5:2, \"8\":3, \"700\":7, 1:1, 40:5, 200:6};\nsortKeyMixedNumeric.sortByKey();\nvar sortKeyMixedNumericString = {\"Babnm\":8, 200:2, 40:3, \"Zxc\":9, 5:4, \"8\":5, 1:1, \"9\":6, \"Aabnm\":7};\nsortKeyMixedNumericString.sortByKey();\nmsg.sortKeyString = sortKeyString;\nmsg.sortKeyInt = sortKeyInt;\nmsg.sortKeyIntLong = sortKeyIntLong;\nmsg.sortKeyFloat = sortKeyFloat;\nmsg.sortKeyDouble = sortKeyDouble;\nmsg.sortKeyMixedNumeric = sortKeyMixedNumeric;\nmsg.sortKeyMixedNumericString = sortKeyMixedNumericString;\nreturn {\n    msg: msg\n};";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        LinkedHashMap<String, Integer> expectedSortKeyString = new LinkedHashMap<String, Integer>();
        expectedSortKeyString.put(this.expectedArrayString.get(0), 1);
        expectedSortKeyString.put(this.expectedArrayString.get(1), 2);
        expectedSortKeyString.put(this.expectedArrayString.get(2), 3);
        expectedSortKeyString.put(this.expectedArrayString.get(3), 4);
        LinkedHashMap actualHashMap = (LinkedHashMap)resMap.get("sortKeyString");
        TbMapArrayListExpressionsTest.assertEquals(expectedSortKeyString, (Object)actualHashMap);
        TbMapArrayListExpressionsTest.assertEquals(expectedSortKeyString.keySet(), actualHashMap.keySet());
        ArrayList<Object> expectedList = new ArrayList(expectedSortKeyString.keySet());
        ArrayList<Object> actualList = new ArrayList(actualHashMap.keySet());
        TbMapArrayListExpressionsTest.assertEquals(expectedList, actualList);
        LinkedHashMap<Integer, Integer> expectedSortKeyInt = new LinkedHashMap<Integer, Integer>();
        expectedSortKeyInt.put((Integer)this.expectedArrayInteger.get(0), 1);
        expectedSortKeyInt.put((Integer)this.expectedArrayInteger.get(1), 2);
        expectedSortKeyInt.put((Integer)this.expectedArrayInteger.get(2), 3);
        expectedSortKeyInt.put((Integer)this.expectedArrayInteger.get(3), 4);
        expectedSortKeyInt.put((Integer)this.expectedArrayInteger.get(4), 5);
        expectedSortKeyInt.put((Integer)this.expectedArrayInteger.get(5), 6);
        expectedSortKeyInt.put((Integer)this.expectedArrayInteger.get(6), 7);
        actualHashMap = (LinkedHashMap)resMap.get("sortKeyInt");
        TbMapArrayListExpressionsTest.assertEquals(expectedSortKeyInt, (Object)actualHashMap);
        expectedList = new ArrayList(expectedSortKeyInt.keySet());
        actualList = new ArrayList(actualHashMap.keySet());
        TbMapArrayListExpressionsTest.assertEquals(expectedList, actualList);
        LinkedHashMap<Long, Integer> expectedSortKeyIntLong = new LinkedHashMap<Long, Integer>();
        expectedSortKeyIntLong.put((Long)this.expectedArrayIntLong.get(0), 1);
        expectedSortKeyIntLong.put((Long)this.expectedArrayIntLong.get(1), 2);
        expectedSortKeyIntLong.put((Long)this.expectedArrayIntLong.get(2), 3);
        expectedSortKeyIntLong.put((Long)this.expectedArrayIntLong.get(3), 4);
        expectedSortKeyIntLong.put((Long)this.expectedArrayIntLong.get(4), 5);
        actualHashMap = (LinkedHashMap)resMap.get("sortKeyIntLong");
        TbMapArrayListExpressionsTest.assertEquals(expectedSortKeyIntLong, (Object)actualHashMap);
        expectedList = new ArrayList(expectedSortKeyIntLong.keySet());
        actualList = new ArrayList(actualHashMap.keySet());
        TbMapArrayListExpressionsTest.assertEquals(expectedList, actualList);
        LinkedHashMap<Float, Integer> expectedSortKeyFloat = new LinkedHashMap<Float, Integer>();
        expectedSortKeyFloat.put((Float)this.expectedArrayFloat.get(0), 1);
        expectedSortKeyFloat.put((Float)this.expectedArrayFloat.get(1), 2);
        expectedSortKeyFloat.put((Float)this.expectedArrayFloat.get(2), 3);
        expectedSortKeyFloat.put((Float)this.expectedArrayFloat.get(3), 4);
        actualHashMap = (LinkedHashMap)resMap.get("sortKeyFloat");
        TbMapArrayListExpressionsTest.assertEquals(expectedSortKeyFloat, (Object)actualHashMap);
        expectedList = new ArrayList(expectedSortKeyFloat.keySet());
        actualList = new ArrayList(actualHashMap.keySet());
        TbMapArrayListExpressionsTest.assertEquals(expectedList, actualList);
        LinkedHashMap<Double, Integer> expectedSortKeyDouble = new LinkedHashMap<Double, Integer>();
        expectedSortKeyDouble.put((Double)this.expectedArrayDouble.get(0), 1);
        expectedSortKeyDouble.put((Double)this.expectedArrayDouble.get(1), 2);
        expectedSortKeyDouble.put((Double)this.expectedArrayDouble.get(2), 3);
        expectedSortKeyDouble.put((Double)this.expectedArrayDouble.get(3), 4);
        actualHashMap = (LinkedHashMap)resMap.get("sortKeyDouble");
        TbMapArrayListExpressionsTest.assertEquals(expectedSortKeyDouble, (Object)actualHashMap);
        expectedList = new ArrayList(expectedSortKeyDouble.keySet());
        actualList = new ArrayList(actualHashMap.keySet());
        TbMapArrayListExpressionsTest.assertEquals(expectedList, actualList);
        LinkedHashMap expectedSortKeyMixedNumeric = new LinkedHashMap();
        expectedSortKeyMixedNumeric.put(this.expectedArrayMixedNumeric.get(0), 1);
        expectedSortKeyMixedNumeric.put(this.expectedArrayMixedNumeric.get(1), 2);
        expectedSortKeyMixedNumeric.put(this.expectedArrayMixedNumeric.get(2), 3);
        expectedSortKeyMixedNumeric.put(this.expectedArrayMixedNumeric.get(3), 4);
        expectedSortKeyMixedNumeric.put(this.expectedArrayMixedNumeric.get(4), 5);
        expectedSortKeyMixedNumeric.put(this.expectedArrayMixedNumeric.get(5), 6);
        expectedSortKeyMixedNumeric.put(this.expectedArrayMixedNumeric.get(6), 7);
        actualHashMap = (LinkedHashMap)resMap.get("sortKeyMixedNumeric");
        TbMapArrayListExpressionsTest.assertEquals(expectedSortKeyMixedNumeric, (Object)actualHashMap);
        expectedList = new ArrayList(expectedSortKeyMixedNumeric.values());
        actualList = new ArrayList(actualHashMap.values());
        TbMapArrayListExpressionsTest.assertEquals(expectedList, actualList);
        LinkedHashMap expectedSortKeyMixedNumericString = new LinkedHashMap();
        expectedSortKeyMixedNumericString.put(this.expectedArrayMixedNumericString.get(0), 1);
        expectedSortKeyMixedNumericString.put(this.expectedArrayMixedNumericString.get(1), 2);
        expectedSortKeyMixedNumericString.put(this.expectedArrayMixedNumericString.get(2), 3);
        expectedSortKeyMixedNumericString.put(this.expectedArrayMixedNumericString.get(3), 4);
        expectedSortKeyMixedNumericString.put(this.expectedArrayMixedNumericString.get(4), 5);
        expectedSortKeyMixedNumericString.put(this.expectedArrayMixedNumericString.get(5), 6);
        expectedSortKeyMixedNumericString.put(this.expectedArrayMixedNumericString.get(6), 7);
        expectedSortKeyMixedNumericString.put(this.expectedArrayMixedNumericString.get(7), 8);
        expectedSortKeyMixedNumericString.put(this.expectedArrayMixedNumericString.get(8), 9);
        actualHashMap = (LinkedHashMap)resMap.get("sortKeyMixedNumericString");
        TbMapArrayListExpressionsTest.assertEquals(expectedSortKeyMixedNumericString, (Object)actualHashMap);
        expectedList = new ArrayList(expectedSortKeyMixedNumericString.values());
        actualList = new ArrayList(actualHashMap.values());
        TbMapArrayListExpressionsTest.assertEquals(expectedList, actualList);
    }

    public void testExecutionHashMapSortByKeyDesc() {
        String body = "var msg = {};\nvar sortKeyString = {\"Feb\":2, \"March\":4, \"Dec\":1, \"Jan\":3, \"March\":4};\nsortKeyString.sortByKey(false);\nvar sortKeyInt = {1:2, 57:5, 30:4, 214748:7, -214748:1, 4:3, 100000:6};\nsortKeyInt.sortByKey(false);\nvar sortKeyIntLong = {30L:2, 1000L:5, 40L:3, -9223372036854775808L:1, 45L:4};\nsortKeyIntLong.sortByKey(false);\nvar sortKeyFloat = {3.40282f:2, 34.175495f:3, 45.40283f:4, 1.1754943f:1};\nsortKeyFloat.sortByKey(false);\nvar sortKeyDouble = {45.40283d:2, 9223372036854775807.17549467d:4, -922337203685.1754943d:1,1754.40282d:3};\nsortKeyDouble.sortByKey(false);\nvar sortKeyMixedNumeric = {\"9\":4,5:2, \"8\":3, \"700\":7, 1:1, 40:5, 200:6};\nsortKeyMixedNumeric.sortByKey(false);\nvar sortKeyMixedNumericString = {\"Babnm\":8, 200:2, 40:3, \"Zxc\":9, 5:4, \"8\":5, 1:1, \"9\":6, \"Aabnm\":7};\nsortKeyMixedNumericString.sortByKey(false);\nmsg.sortKeyString = sortKeyString;\nmsg.sortKeyInt = sortKeyInt;\nmsg.sortKeyIntLong = sortKeyIntLong;\nmsg.sortKeyFloat = sortKeyFloat;\nmsg.sortKeyDouble = sortKeyDouble;\nmsg.sortKeyMixedNumeric = sortKeyMixedNumeric;\nmsg.sortKeyMixedNumericString = sortKeyMixedNumericString;\nreturn {\n    msg: msg\n};";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        LinkedHashMap<String, Integer> expectedSortKeyString = new LinkedHashMap<String, Integer>();
        expectedSortKeyString.put(this.expectedArrayString.get(0), 1);
        expectedSortKeyString.put(this.expectedArrayString.get(1), 2);
        expectedSortKeyString.put(this.expectedArrayString.get(2), 3);
        expectedSortKeyString.put(this.expectedArrayString.get(3), 4);
        LinkedHashMap actualHashMap = (LinkedHashMap)resMap.get("sortKeyString");
        TbMapArrayListExpressionsTest.assertEquals(expectedSortKeyString, (Object)actualHashMap);
        TbMapArrayListExpressionsTest.assertEquals(expectedSortKeyString.keySet(), actualHashMap.keySet());
        ArrayList<Object> expectedList = new ArrayList(expectedSortKeyString.keySet());
        ArrayList<Object> actualList = new ArrayList(actualHashMap.keySet());
        Collections.reverse(expectedList);
        TbMapArrayListExpressionsTest.assertEquals(expectedList, actualList);
        LinkedHashMap<Integer, Integer> expectedSortKeyInt = new LinkedHashMap<Integer, Integer>();
        expectedSortKeyInt.put((Integer)this.expectedArrayInteger.get(0), 1);
        expectedSortKeyInt.put((Integer)this.expectedArrayInteger.get(1), 2);
        expectedSortKeyInt.put((Integer)this.expectedArrayInteger.get(2), 3);
        expectedSortKeyInt.put((Integer)this.expectedArrayInteger.get(3), 4);
        expectedSortKeyInt.put((Integer)this.expectedArrayInteger.get(4), 5);
        expectedSortKeyInt.put((Integer)this.expectedArrayInteger.get(5), 6);
        expectedSortKeyInt.put((Integer)this.expectedArrayInteger.get(6), 7);
        actualHashMap = (LinkedHashMap)resMap.get("sortKeyInt");
        TbMapArrayListExpressionsTest.assertEquals(expectedSortKeyInt, (Object)actualHashMap);
        expectedList = new ArrayList(expectedSortKeyInt.keySet());
        actualList = new ArrayList(actualHashMap.keySet());
        Collections.reverse(expectedList);
        TbMapArrayListExpressionsTest.assertEquals(expectedList, actualList);
        LinkedHashMap<Long, Integer> expectedSortKeyIntLong = new LinkedHashMap<Long, Integer>();
        expectedSortKeyIntLong.put((Long)this.expectedArrayIntLong.get(0), 1);
        expectedSortKeyIntLong.put((Long)this.expectedArrayIntLong.get(1), 2);
        expectedSortKeyIntLong.put((Long)this.expectedArrayIntLong.get(2), 3);
        expectedSortKeyIntLong.put((Long)this.expectedArrayIntLong.get(3), 4);
        expectedSortKeyIntLong.put((Long)this.expectedArrayIntLong.get(4), 5);
        actualHashMap = (LinkedHashMap)resMap.get("sortKeyIntLong");
        TbMapArrayListExpressionsTest.assertEquals(expectedSortKeyIntLong, (Object)actualHashMap);
        expectedList = new ArrayList(expectedSortKeyIntLong.keySet());
        actualList = new ArrayList(actualHashMap.keySet());
        Collections.reverse(expectedList);
        TbMapArrayListExpressionsTest.assertEquals(expectedList, actualList);
        LinkedHashMap<Float, Integer> expectedSortKeyFloat = new LinkedHashMap<Float, Integer>();
        expectedSortKeyFloat.put((Float)this.expectedArrayFloat.get(0), 1);
        expectedSortKeyFloat.put((Float)this.expectedArrayFloat.get(1), 2);
        expectedSortKeyFloat.put((Float)this.expectedArrayFloat.get(2), 3);
        expectedSortKeyFloat.put((Float)this.expectedArrayFloat.get(3), 4);
        actualHashMap = (LinkedHashMap)resMap.get("sortKeyFloat");
        TbMapArrayListExpressionsTest.assertEquals(expectedSortKeyFloat, (Object)actualHashMap);
        expectedList = new ArrayList(expectedSortKeyFloat.keySet());
        actualList = new ArrayList(actualHashMap.keySet());
        Collections.reverse(expectedList);
        TbMapArrayListExpressionsTest.assertEquals(expectedList, actualList);
        LinkedHashMap<Double, Integer> expectedSortKeyDouble = new LinkedHashMap<Double, Integer>();
        expectedSortKeyDouble.put((Double)this.expectedArrayDouble.get(0), 1);
        expectedSortKeyDouble.put((Double)this.expectedArrayDouble.get(1), 2);
        expectedSortKeyDouble.put((Double)this.expectedArrayDouble.get(2), 3);
        expectedSortKeyDouble.put((Double)this.expectedArrayDouble.get(3), 4);
        actualHashMap = (LinkedHashMap)resMap.get("sortKeyDouble");
        TbMapArrayListExpressionsTest.assertEquals(expectedSortKeyDouble, (Object)actualHashMap);
        expectedList = new ArrayList(expectedSortKeyDouble.keySet());
        actualList = new ArrayList(actualHashMap.keySet());
        Collections.reverse(expectedList);
        TbMapArrayListExpressionsTest.assertEquals(expectedList, actualList);
        LinkedHashMap expectedSortKeyMixedNumeric = new LinkedHashMap();
        expectedSortKeyMixedNumeric.put(this.expectedArrayMixedNumeric.get(0), 1);
        expectedSortKeyMixedNumeric.put(this.expectedArrayMixedNumeric.get(1), 2);
        expectedSortKeyMixedNumeric.put(this.expectedArrayMixedNumeric.get(2), 3);
        expectedSortKeyMixedNumeric.put(this.expectedArrayMixedNumeric.get(3), 4);
        expectedSortKeyMixedNumeric.put(this.expectedArrayMixedNumeric.get(4), 5);
        expectedSortKeyMixedNumeric.put(this.expectedArrayMixedNumeric.get(5), 6);
        expectedSortKeyMixedNumeric.put(this.expectedArrayMixedNumeric.get(6), 7);
        actualHashMap = (LinkedHashMap)resMap.get("sortKeyMixedNumeric");
        TbMapArrayListExpressionsTest.assertEquals(expectedSortKeyMixedNumeric, (Object)actualHashMap);
        expectedList = new ArrayList(expectedSortKeyMixedNumeric.values());
        actualList = new ArrayList(actualHashMap.values());
        Collections.reverse(expectedList);
        TbMapArrayListExpressionsTest.assertEquals(expectedList, actualList);
        LinkedHashMap expectedSortKeyMixedNumericString = new LinkedHashMap();
        expectedSortKeyMixedNumericString.put(this.expectedArrayMixedNumericString.get(0), 1);
        expectedSortKeyMixedNumericString.put(this.expectedArrayMixedNumericString.get(1), 2);
        expectedSortKeyMixedNumericString.put(this.expectedArrayMixedNumericString.get(2), 3);
        expectedSortKeyMixedNumericString.put(this.expectedArrayMixedNumericString.get(3), 4);
        expectedSortKeyMixedNumericString.put(this.expectedArrayMixedNumericString.get(4), 5);
        expectedSortKeyMixedNumericString.put(this.expectedArrayMixedNumericString.get(5), 6);
        expectedSortKeyMixedNumericString.put(this.expectedArrayMixedNumericString.get(6), 7);
        expectedSortKeyMixedNumericString.put(this.expectedArrayMixedNumericString.get(7), 8);
        expectedSortKeyMixedNumericString.put(this.expectedArrayMixedNumericString.get(8), 9);
        actualHashMap = (LinkedHashMap)resMap.get("sortKeyMixedNumericString");
        TbMapArrayListExpressionsTest.assertEquals(expectedSortKeyMixedNumericString, (Object)actualHashMap);
        expectedList = new ArrayList(expectedSortKeyMixedNumericString.values());
        actualList = new ArrayList(actualHashMap.values());
        Collections.reverse(expectedList);
        TbMapArrayListExpressionsTest.assertEquals(expectedList, actualList);
    }

    public void testExecutionHashMapToSortedByKeyAsc() {
        String body = "var msg = {};\nvar sortKeyString = {\"Feb\":2, \"March\":4, \"Dec\":1, \"Jan\":3, \"March\":4};\nmsg.toSortedKeyString = sortKeyString.toSortedByKey();\nmsg.sortKeyString = sortKeyString;\nreturn {\n    msg: msg\n};";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        LinkedHashMap<String, Integer> expectedSortKeyString = new LinkedHashMap<String, Integer>();
        expectedSortKeyString.put(this.expectedArrayString.get(1), 2);
        expectedSortKeyString.put(this.expectedArrayString.get(3), 4);
        expectedSortKeyString.put(this.expectedArrayString.get(0), 1);
        expectedSortKeyString.put(this.expectedArrayString.get(2), 3);
        LinkedHashMap actualHashMap = (LinkedHashMap)resMap.get("sortKeyString");
        TbMapArrayListExpressionsTest.assertEquals(expectedSortKeyString, (Object)actualHashMap);
        TbMapArrayListExpressionsTest.assertEquals(expectedSortKeyString.keySet(), actualHashMap.keySet());
        ArrayList expectedList = new ArrayList(expectedSortKeyString.keySet());
        ArrayList actualList = new ArrayList(actualHashMap.keySet());
        TbMapArrayListExpressionsTest.assertEquals(expectedList, actualList);
        LinkedHashMap<String, Integer> expectedToSortedKeyString = new LinkedHashMap<String, Integer>();
        expectedToSortedKeyString.put(this.expectedArrayString.get(0), 1);
        expectedToSortedKeyString.put(this.expectedArrayString.get(1), 2);
        expectedToSortedKeyString.put(this.expectedArrayString.get(2), 3);
        expectedToSortedKeyString.put(this.expectedArrayString.get(3), 4);
        actualHashMap = (LinkedHashMap)resMap.get("toSortedKeyString");
        TbMapArrayListExpressionsTest.assertEquals(expectedToSortedKeyString, (Object)actualHashMap);
        TbMapArrayListExpressionsTest.assertEquals(expectedToSortedKeyString.keySet(), actualHashMap.keySet());
        expectedList = new ArrayList(expectedToSortedKeyString.keySet());
        actualList = new ArrayList(actualHashMap.keySet());
        TbMapArrayListExpressionsTest.assertEquals(expectedList, actualList);
    }

    public void testExecutionHashMapToSortedByKeyDesc() {
        String body = "var msg = {};\nvar sortKeyString = {\"Feb\":2, \"March\":4, \"Dec\":1, \"Jan\":3, \"March\":4};\nmsg.toSortedKeyString = sortKeyString.toSortedByKey(false);\nmsg.sortKeyString = sortKeyString;\nreturn {\n    msg: msg\n};";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        LinkedHashMap<String, Integer> expectedSortKeyString = new LinkedHashMap<String, Integer>();
        expectedSortKeyString.put(this.expectedArrayString.get(1), 2);
        expectedSortKeyString.put(this.expectedArrayString.get(3), 4);
        expectedSortKeyString.put(this.expectedArrayString.get(0), 1);
        expectedSortKeyString.put(this.expectedArrayString.get(2), 3);
        LinkedHashMap actualHashMap = (LinkedHashMap)resMap.get("sortKeyString");
        TbMapArrayListExpressionsTest.assertEquals(expectedSortKeyString, (Object)actualHashMap);
        TbMapArrayListExpressionsTest.assertEquals(expectedSortKeyString.keySet(), actualHashMap.keySet());
        ArrayList expectedList = new ArrayList(expectedSortKeyString.keySet());
        ArrayList actualList = new ArrayList(actualHashMap.keySet());
        TbMapArrayListExpressionsTest.assertEquals(expectedList, actualList);
        LinkedHashMap<String, Integer> expectedToSortedKeyString = new LinkedHashMap<String, Integer>();
        expectedToSortedKeyString.put(this.expectedArrayString.get(3), 4);
        expectedToSortedKeyString.put(this.expectedArrayString.get(2), 3);
        expectedToSortedKeyString.put(this.expectedArrayString.get(1), 2);
        expectedToSortedKeyString.put(this.expectedArrayString.get(0), 1);
        actualHashMap = (LinkedHashMap)resMap.get("toSortedKeyString");
        TbMapArrayListExpressionsTest.assertEquals(expectedToSortedKeyString, (Object)actualHashMap);
        TbMapArrayListExpressionsTest.assertEquals(expectedToSortedKeyString.keySet(), actualHashMap.keySet());
        expectedList = new ArrayList(expectedToSortedKeyString.keySet());
        actualList = new ArrayList(actualHashMap.keySet());
        TbMapArrayListExpressionsTest.assertEquals(expectedList, actualList);
    }

    public void testExecutionHashMap_invert() {
        String body = "var msg = {};\nvar map = {\"Babnm\":\"thing\", 200:2, 40:3, \"Zxc\":9, 5:\"4\", \"8\":5, 1:1, \"9\":6, \"Aabnm\":7};\nmap.invert();\nmsg.map = map;\nreturn {msg: msg}";
        Object result = this.executeScript(body);
        LinkedHashMap expectedMap = new LinkedHashMap();
        expectedMap.put("thing", this.expectedArrayMixedNumericString.get(7));
        expectedMap.put(2, this.expectedArrayMixedNumericString.get(1));
        expectedMap.put(3, this.expectedArrayMixedNumericString.get(2));
        expectedMap.put(9, this.expectedArrayMixedNumericString.get(8));
        expectedMap.put("4", this.expectedArrayMixedNumericString.get(3));
        expectedMap.put(5, this.expectedArrayMixedNumericString.get(4));
        expectedMap.put(1, this.expectedArrayMixedNumericString.get(0));
        expectedMap.put(6, this.expectedArrayMixedNumericString.get(5));
        expectedMap.put(7, this.expectedArrayMixedNumericString.get(6));
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        LinkedHashMap actualMap = (LinkedHashMap)resMap.get("map");
        TbMapArrayListExpressionsTest.assertEquals(expectedMap, (Object)actualMap);
        TbMapArrayListExpressionsTest.assertEquals(expectedMap.keySet(), actualMap.keySet());
        boolean eq = expectedMap.values().equals(actualMap.values());
        eq = eq ? eq : this.equalsList(expectedMap.values(), actualMap.values());
        TbMapArrayListExpressionsTest.assertTrue((boolean)eq);
    }

    public void testExecutionHashMap_invert_KeyToValueMany() {
        String body = "var msg = {};\nvar map = {\"Babnm\":\"thing\", 200:2, 40:\"thing\", \"Zxc\":9, 5:\"4\", \"8\":5, 1:\"thing\", \"9\":6, \"Aabnm\":7};\nmap.invert();\nmsg.map = map;\nreturn {msg: msg}";
        Object result = this.executeScript(body);
        LinkedHashMap<Object, List<Object>> expectedMap = new LinkedHashMap<Object, List<Object>>();
        expectedMap.put("thing", Arrays.asList(this.expectedArrayMixedNumericString.get(7), this.expectedArrayMixedNumericString.get(2), this.expectedArrayMixedNumericString.get(0)));
        expectedMap.put(2, (List<Object>)this.expectedArrayMixedNumericString.get(1));
        expectedMap.put(9, (List<Object>)this.expectedArrayMixedNumericString.get(8));
        expectedMap.put("4", (List<Object>)this.expectedArrayMixedNumericString.get(3));
        expectedMap.put(5, (List<Object>)this.expectedArrayMixedNumericString.get(4));
        expectedMap.put(6, (List<Object>)this.expectedArrayMixedNumericString.get(5));
        expectedMap.put(7, (List<Object>)this.expectedArrayMixedNumericString.get(6));
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        LinkedHashMap actualMap = (LinkedHashMap)resMap.get("map");
        TbMapArrayListExpressionsTest.assertEquals(expectedMap, (Object)actualMap);
        TbMapArrayListExpressionsTest.assertEquals(expectedMap.keySet(), actualMap.keySet());
        boolean eq = expectedMap.values().equals(actualMap.values());
        eq = eq ? eq : this.equalsList(expectedMap.values(), actualMap.values());
        TbMapArrayListExpressionsTest.assertTrue((boolean)eq);
    }

    public void testExecutionHashMap_toInverted() {
        String body = "var msg = {};\nvar map = {\"Babnm\":\"thing\", 200:2, 40:3, \"Zxc\":9, 5:\"4\", \"8\":5, 1:1, \"9\":6, \"Aabnm\":7};\nmsg.toInverted = map.toInverted();\nmsg.map = map;\nreturn {msg: msg}";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        LinkedHashMap expectedMap = new LinkedHashMap();
        expectedMap.put(this.expectedArrayMixedNumericString.get(7), "thing");
        expectedMap.put(this.expectedArrayMixedNumericString.get(1), 2);
        expectedMap.put(this.expectedArrayMixedNumericString.get(2), 3);
        expectedMap.put(this.expectedArrayMixedNumericString.get(8), 9);
        expectedMap.put(this.expectedArrayMixedNumericString.get(3), "4");
        expectedMap.put(this.expectedArrayMixedNumericString.get(4), 5);
        expectedMap.put(this.expectedArrayMixedNumericString.get(0), 1);
        expectedMap.put(this.expectedArrayMixedNumericString.get(5), 6);
        expectedMap.put(this.expectedArrayMixedNumericString.get(6), 7);
        LinkedHashMap actualMap = (LinkedHashMap)resMap.get("map");
        TbMapArrayListExpressionsTest.assertEquals(expectedMap, (Object)actualMap);
        TbMapArrayListExpressionsTest.assertEquals(expectedMap.keySet(), actualMap.keySet());
        boolean eq = expectedMap.values().equals(actualMap.values());
        eq = eq ? true : this.equalsList(expectedMap.values(), actualMap.values());
        TbMapArrayListExpressionsTest.assertTrue((boolean)eq);
        LinkedHashMap expectedInvertedMap = new LinkedHashMap();
        expectedInvertedMap.put("thing", this.expectedArrayMixedNumericString.get(7));
        expectedInvertedMap.put(2, this.expectedArrayMixedNumericString.get(1));
        expectedInvertedMap.put(3, this.expectedArrayMixedNumericString.get(2));
        expectedInvertedMap.put(9, this.expectedArrayMixedNumericString.get(8));
        expectedInvertedMap.put("4", this.expectedArrayMixedNumericString.get(3));
        expectedInvertedMap.put(5, this.expectedArrayMixedNumericString.get(4));
        expectedInvertedMap.put(1, this.expectedArrayMixedNumericString.get(0));
        expectedInvertedMap.put(6, this.expectedArrayMixedNumericString.get(5));
        expectedInvertedMap.put(7, this.expectedArrayMixedNumericString.get(6));
        actualMap = (LinkedHashMap)resMap.get("toInverted");
        TbMapArrayListExpressionsTest.assertEquals(expectedInvertedMap, (Object)actualMap);
        TbMapArrayListExpressionsTest.assertEquals(expectedInvertedMap.keySet(), actualMap.keySet());
        eq = expectedInvertedMap.values().equals(actualMap.values());
        eq = eq ? true : this.equalsList(expectedInvertedMap.values(), actualMap.values());
        TbMapArrayListExpressionsTest.assertTrue((boolean)eq);
    }

    public void testExecutionHashMap_toInverted_KeyToValueMany() {
        String body = "var msg = {};\nvar map = {\"Babnm\":\"thing\", 200:2, 40:\"thing\", \"Zxc\":9, 5:\"4\", \"8\":5, 1:\"thing\", \"9\":6, \"Aabnm\":7};\nmsg.toInverted = map.toInverted();\nmsg.map = map;\nreturn {msg: msg}";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        LinkedHashMap<Object, Object> expectedMap = new LinkedHashMap<Object, Object>();
        expectedMap.put(this.expectedArrayMixedNumericString.get(7), "thing");
        expectedMap.put(this.expectedArrayMixedNumericString.get(1), 2);
        expectedMap.put(this.expectedArrayMixedNumericString.get(2), "thing");
        expectedMap.put(this.expectedArrayMixedNumericString.get(8), 9);
        expectedMap.put(this.expectedArrayMixedNumericString.get(3), "4");
        expectedMap.put(this.expectedArrayMixedNumericString.get(4), 5);
        expectedMap.put(this.expectedArrayMixedNumericString.get(0), "thing");
        expectedMap.put(this.expectedArrayMixedNumericString.get(5), 6);
        expectedMap.put(this.expectedArrayMixedNumericString.get(6), 7);
        LinkedHashMap actualMap = (LinkedHashMap)resMap.get("map");
        TbMapArrayListExpressionsTest.assertEquals(expectedMap, (Object)actualMap);
        TbMapArrayListExpressionsTest.assertEquals(expectedMap.keySet(), actualMap.keySet());
        boolean eq = expectedMap.values().equals(actualMap.values());
        eq = eq ? true : this.equalsList(expectedMap.values(), actualMap.values());
        TbMapArrayListExpressionsTest.assertTrue((boolean)eq);
        expectedMap = new LinkedHashMap();
        expectedMap.put("thing", Arrays.asList(this.expectedArrayMixedNumericString.get(7), this.expectedArrayMixedNumericString.get(2), this.expectedArrayMixedNumericString.get(0)));
        expectedMap.put(2, this.expectedArrayMixedNumericString.get(1));
        expectedMap.put(9, this.expectedArrayMixedNumericString.get(8));
        expectedMap.put("4", this.expectedArrayMixedNumericString.get(3));
        expectedMap.put(5, this.expectedArrayMixedNumericString.get(4));
        expectedMap.put(6, this.expectedArrayMixedNumericString.get(5));
        expectedMap.put(7, this.expectedArrayMixedNumericString.get(6));
        actualMap = (LinkedHashMap)resMap.get("toInverted");
        TbMapArrayListExpressionsTest.assertEquals(expectedMap, (Object)actualMap);
        TbMapArrayListExpressionsTest.assertEquals(expectedMap.keySet(), actualMap.keySet());
        eq = expectedMap.values().equals(actualMap.values());
        eq = eq ? eq : this.equalsList(expectedMap.values(), actualMap.values());
        TbMapArrayListExpressionsTest.assertTrue((boolean)eq);
    }

    public void testExecutionHashMap_slice() {
        String body = "var msg = {};\nvar map = {\"Babnm\":\"thing\", 200:2, 40:3, \"Zxc\":9, 5:\"4\", \"8\":5, 1:1, \"9\":6, \"Aabnm\":7};\nmsg.map = map;\nmsg.mapSlice = map.slice();\nmsg.mapSlice2 = map.slice(2);\nmsg.mapSlice2_4 = map.slice(2, 4);\nmsg.mapSlice_2 = map.slice(-2);\nmsg.mapSlice2_1 = map.slice(2, -1);\nreturn {msg: msg}";
        LinkedHashMap expectedMap = new LinkedHashMap();
        expectedMap.put(this.expectedArrayMixedNumericString.get(7), "thing");
        expectedMap.put(this.expectedArrayMixedNumericString.get(1), 2);
        expectedMap.put(this.expectedArrayMixedNumericString.get(2), 3);
        expectedMap.put(this.expectedArrayMixedNumericString.get(8), 9);
        expectedMap.put(this.expectedArrayMixedNumericString.get(3), "4");
        expectedMap.put(this.expectedArrayMixedNumericString.get(4), 5);
        expectedMap.put(this.expectedArrayMixedNumericString.get(0), 1);
        expectedMap.put(this.expectedArrayMixedNumericString.get(5), 6);
        expectedMap.put(this.expectedArrayMixedNumericString.get(6), 7);
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        LinkedHashMap actualMap = (LinkedHashMap)resMap.get("map");
        TbMapArrayListExpressionsTest.assertEquals(expectedMap, (Object)actualMap);
        TbMapArrayListExpressionsTest.assertEquals(expectedMap.keySet(), actualMap.keySet());
        boolean eq = expectedMap.values().equals(actualMap.values());
        eq = eq ? true : this.equalsList(expectedMap.values(), actualMap.values());
        TbMapArrayListExpressionsTest.assertTrue((boolean)eq);
        actualMap = (LinkedHashMap)resMap.get("mapSlice");
        TbMapArrayListExpressionsTest.assertEquals(expectedMap, (Object)actualMap);
        TbMapArrayListExpressionsTest.assertEquals(expectedMap.keySet(), actualMap.keySet());
        eq = expectedMap.values().equals(actualMap.values());
        eq = eq ? true : this.equalsList(expectedMap.values(), actualMap.values());
        TbMapArrayListExpressionsTest.assertTrue((boolean)eq);
        expectedMap = new LinkedHashMap();
        expectedMap.put(this.expectedArrayMixedNumericString.get(2), 3);
        expectedMap.put(this.expectedArrayMixedNumericString.get(8), 9);
        expectedMap.put(this.expectedArrayMixedNumericString.get(3), "4");
        expectedMap.put(this.expectedArrayMixedNumericString.get(4), 5);
        expectedMap.put(this.expectedArrayMixedNumericString.get(0), 1);
        expectedMap.put(this.expectedArrayMixedNumericString.get(5), 6);
        expectedMap.put(this.expectedArrayMixedNumericString.get(6), 7);
        actualMap = (LinkedHashMap)resMap.get("mapSlice2");
        TbMapArrayListExpressionsTest.assertEquals(expectedMap, (Object)actualMap);
        TbMapArrayListExpressionsTest.assertEquals(expectedMap.keySet(), actualMap.keySet());
        eq = expectedMap.values().equals(actualMap.values());
        eq = eq ? true : this.equalsList(expectedMap.values(), actualMap.values());
        TbMapArrayListExpressionsTest.assertTrue((boolean)eq);
        expectedMap = new LinkedHashMap();
        expectedMap.put(this.expectedArrayMixedNumericString.get(2), 3);
        expectedMap.put(this.expectedArrayMixedNumericString.get(8), 9);
        actualMap = (LinkedHashMap)resMap.get("mapSlice2_4");
        TbMapArrayListExpressionsTest.assertEquals(expectedMap, (Object)actualMap);
        TbMapArrayListExpressionsTest.assertEquals(expectedMap.keySet(), actualMap.keySet());
        eq = expectedMap.values().equals(actualMap.values());
        eq = eq ? true : this.equalsList(expectedMap.values(), actualMap.values());
        TbMapArrayListExpressionsTest.assertTrue((boolean)eq);
        expectedMap = new LinkedHashMap();
        expectedMap.put(this.expectedArrayMixedNumericString.get(5), 6);
        expectedMap.put(this.expectedArrayMixedNumericString.get(6), 7);
        actualMap = (LinkedHashMap)resMap.get("mapSlice_2");
        TbMapArrayListExpressionsTest.assertEquals(expectedMap, (Object)actualMap);
        TbMapArrayListExpressionsTest.assertEquals(expectedMap.keySet(), actualMap.keySet());
        eq = expectedMap.values().equals(actualMap.values());
        eq = eq ? true : this.equalsList(expectedMap.values(), actualMap.values());
        TbMapArrayListExpressionsTest.assertTrue((boolean)eq);
        expectedMap = new LinkedHashMap();
        expectedMap.put(this.expectedArrayMixedNumericString.get(2), 3);
        expectedMap.put(this.expectedArrayMixedNumericString.get(8), 9);
        expectedMap.put(this.expectedArrayMixedNumericString.get(3), "4");
        expectedMap.put(this.expectedArrayMixedNumericString.get(4), 5);
        expectedMap.put(this.expectedArrayMixedNumericString.get(0), 1);
        expectedMap.put(this.expectedArrayMixedNumericString.get(5), 6);
        actualMap = (LinkedHashMap)resMap.get("mapSlice2_1");
        TbMapArrayListExpressionsTest.assertEquals(expectedMap, (Object)actualMap);
        TbMapArrayListExpressionsTest.assertEquals(expectedMap.keySet(), actualMap.keySet());
        eq = expectedMap.values().equals(actualMap.values());
        eq = eq ? true : this.equalsList(expectedMap.values(), actualMap.values());
        TbMapArrayListExpressionsTest.assertTrue((boolean)eq);
    }

    public void testExecutionHashMap_reverse() {
        String body = "var msg = {};\nvar map = {\"Babnm\":\"thing\", 200:2, 40:3, \"Zxc\":9, 5:\"4\", \"8\":5, 1:1, \"9\":6, \"Aabnm\":7};\nmap.reverse();\nmsg.map = map;\nreturn {msg: msg}";
        LinkedHashMap expectedMap = new LinkedHashMap();
        expectedMap.put(this.expectedArrayMixedNumericString.get(6), 7);
        expectedMap.put(this.expectedArrayMixedNumericString.get(5), 6);
        expectedMap.put(this.expectedArrayMixedNumericString.get(0), 1);
        expectedMap.put(this.expectedArrayMixedNumericString.get(4), 5);
        expectedMap.put(this.expectedArrayMixedNumericString.get(3), "4");
        expectedMap.put(this.expectedArrayMixedNumericString.get(8), 9);
        expectedMap.put(this.expectedArrayMixedNumericString.get(2), 3);
        expectedMap.put(this.expectedArrayMixedNumericString.get(1), 2);
        expectedMap.put(this.expectedArrayMixedNumericString.get(7), "thing");
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        LinkedHashMap actualMap = (LinkedHashMap)resMap.get("map");
        TbMapArrayListExpressionsTest.assertEquals(expectedMap, (Object)actualMap);
        TbMapArrayListExpressionsTest.assertEquals(expectedMap.keySet(), actualMap.keySet());
        boolean eq = expectedMap.values().equals(actualMap.values());
        eq = eq ? true : this.equalsList(expectedMap.values(), actualMap.values());
        TbMapArrayListExpressionsTest.assertTrue((boolean)eq);
    }

    public void testExecutionHashMap_ToReversed() {
        String body = "var msg = {};\nvar map = {\"Babnm\":\"thing\", 200:2, 40:3, \"Zxc\":9, 5:\"4\", \"8\":5, 1:1, \"9\":6, \"Aabnm\":7};\nmsg.toReversed = map.toReversed();\nmsg.map = map;\nreturn {msg: msg}";
        LinkedHashMap expectedMap = new LinkedHashMap();
        expectedMap.put(this.expectedArrayMixedNumericString.get(7), "thing");
        expectedMap.put(this.expectedArrayMixedNumericString.get(1), 2);
        expectedMap.put(this.expectedArrayMixedNumericString.get(2), 3);
        expectedMap.put(this.expectedArrayMixedNumericString.get(8), 9);
        expectedMap.put(this.expectedArrayMixedNumericString.get(3), "4");
        expectedMap.put(this.expectedArrayMixedNumericString.get(4), 5);
        expectedMap.put(this.expectedArrayMixedNumericString.get(0), 1);
        expectedMap.put(this.expectedArrayMixedNumericString.get(5), 6);
        expectedMap.put(this.expectedArrayMixedNumericString.get(6), 7);
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        LinkedHashMap actualMap = (LinkedHashMap)resMap.get("map");
        TbMapArrayListExpressionsTest.assertEquals(expectedMap, (Object)actualMap);
        TbMapArrayListExpressionsTest.assertEquals(expectedMap.keySet(), actualMap.keySet());
        boolean eq = expectedMap.values().equals(actualMap.values());
        eq = eq ? true : this.equalsList(expectedMap.values(), actualMap.values());
        TbMapArrayListExpressionsTest.assertTrue((boolean)eq);
        expectedMap = new LinkedHashMap();
        expectedMap.put(this.expectedArrayMixedNumericString.get(6), 7);
        expectedMap.put(this.expectedArrayMixedNumericString.get(5), 6);
        expectedMap.put(this.expectedArrayMixedNumericString.get(0), 1);
        expectedMap.put(this.expectedArrayMixedNumericString.get(4), 5);
        expectedMap.put(this.expectedArrayMixedNumericString.get(3), "4");
        expectedMap.put(this.expectedArrayMixedNumericString.get(8), 9);
        expectedMap.put(this.expectedArrayMixedNumericString.get(2), 3);
        expectedMap.put(this.expectedArrayMixedNumericString.get(1), 2);
        expectedMap.put(this.expectedArrayMixedNumericString.get(7), "thing");
        actualMap = (LinkedHashMap)resMap.get("toReversed");
        TbMapArrayListExpressionsTest.assertEquals(expectedMap, (Object)actualMap);
        TbMapArrayListExpressionsTest.assertEquals(expectedMap.keySet(), actualMap.keySet());
        eq = expectedMap.values().equals(actualMap.values());
        eq = eq ? true : this.equalsList(expectedMap.values(), actualMap.values());
        TbMapArrayListExpressionsTest.assertTrue((boolean)eq);
    }

    public void testCreateSingleValueArray() {
        Object res = this.executeScript("m = {5}; m");
        TbMapArrayListExpressionsTest.assertTrue((boolean)(res instanceof List));
        TbMapArrayListExpressionsTest.assertEquals((int)1, (int)((List)res).size());
        TbMapArrayListExpressionsTest.assertEquals((Object)5, ((List)res).get(0));
    }

    public void testExecutionArrayListToString() {
        String body = "var list = ['hello', 34567];\nvar res = '' + list;\nreturn res;";
        Object result = this.executeScript(body);
        TbMapArrayListExpressionsTest.assertTrue((boolean)(result instanceof String));
        TbMapArrayListExpressionsTest.assertEquals((Object)"[hello, 34567]", (Object)result);
    }

    public void testExecutionArrayListSortAsc() {
        String body = "var msg = {};\nvar arrayString = ['March', 'Feb', 'Jan', 'Dec'];\narrayString.sort();\nvar arrayInt = [1, 30, 4, -214748, 57, 214748, 100000];\narrayInt.sort();\nvar arrayLong = [45l, 9223372036854775807l, 30l, 40l,  -9223372036854775808l, 1000l];\narrayLong.sort();\nvar arrayFloat = [3.40282F, 34.175495F, 45.40283F, 1.1754943F];\narrayFloat.sort();\nvar arrayDouble = [45.40283d, -9.223372036851755E11d, 9223372036854775807.17549467d, 1754.40282d];\narrayDouble.sort();\nvar mixedNumericArray = [\"8\", \"9\", \"700\", 40, 1, 5, 200];\nmixedNumericArray.sort();\nmsg.arrayString = arrayString;\nmsg.arrayInt = arrayInt;\nmsg.arrayLong = arrayLong;\nmsg.arrayFloat = arrayFloat;\nmsg.arrayDouble = arrayDouble;\nmsg.mixedNumericArray = mixedNumericArray;\nvar mixedNumericString = [\"8\", \"Zxc\", \"9\", 'Babnm',  40, \"Aabnm\", 1, 5, 200];\nmixedNumericString.sort();\nmsg.mixedNumericString = mixedNumericString;\nreturn {msg: msg};";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        List actualArray = (List)resMap.get("arrayString");
        TbMapArrayListExpressionsTest.assertEquals(this.expectedArrayString, (Object)actualArray);
        actualArray = (List)resMap.get("arrayInt");
        TbMapArrayListExpressionsTest.assertEquals((Object)this.expectedArrayInteger, (Object)actualArray);
        actualArray = (List)resMap.get("arrayLong");
        TbMapArrayListExpressionsTest.assertEquals((Object)this.expectedArrayIntLong, (Object)actualArray);
        actualArray = (List)resMap.get("arrayFloat");
        TbMapArrayListExpressionsTest.assertEquals((Object)this.expectedArrayFloat, (Object)actualArray);
        actualArray = (List)resMap.get("arrayDouble");
        TbMapArrayListExpressionsTest.assertEquals((Object)this.expectedArrayDouble, (Object)actualArray);
        actualArray = (List)resMap.get("mixedNumericArray");
        TbMapArrayListExpressionsTest.assertEquals((Object)this.expectedArrayMixedNumeric, (Object)actualArray);
        actualArray = (List)resMap.get("mixedNumericString");
        TbMapArrayListExpressionsTest.assertEquals((Object)this.expectedArrayMixedNumericString, (Object)actualArray);
    }

    public void testExecutionArrayListSortDesc() {
        String body = "var msg = {};\nvar arrayString = ['March', 'Feb', 'Jan', 'Dec'];\narrayString.sort(false);\nvar arrayInt = [1, 30, 4, -214748, 57, 214748, 100000];\narrayInt.sort(false);\nvar arrayLong = [45l, 9223372036854775807l, 30l, 40l,  -9223372036854775808l, 1000l];\narrayLong.sort(false);\nvar arrayFloat = [3.40282f, 34.175495f, 45.40283f, 1.1754943f];\narrayFloat.sort(false);\nvar arrayDouble = [45.40283d, 9223372036854775807.17549467d, 1754.40282d, -922337203685.1754943d];\narrayDouble.sort(false);\nvar mixedNumericArray = [\"8\", \"9\", \"700\", 40, 1, 5, 200];\nmsg.mixedNumericArray = mixedNumericArray;\nvar mixedNumericStringArray = [\"8\", \"Zxc\", \"9\", 'Babnm',  40, \"Aabnm\", 1, 5, 200];\nmixedNumericStringArray.sort(false);\nmixedNumericArray.sort(false);\nmsg.arrayString = arrayString;\nmsg.arrayInt = arrayInt;\nmsg.arrayLong = arrayLong;\nmsg.arrayFloat = arrayFloat;\nmsg.arrayDouble = arrayDouble;\nmsg.mixedNumericStringArray = mixedNumericStringArray;\nreturn {msg: msg};";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        Collections.reverse(this.expectedArrayString);
        List actualArray = (List)resMap.get("arrayString");
        TbMapArrayListExpressionsTest.assertEquals(this.expectedArrayString, (Object)actualArray);
        Collections.reverse(this.expectedArrayInteger);
        actualArray = (List)resMap.get("arrayInt");
        TbMapArrayListExpressionsTest.assertEquals((Object)this.expectedArrayInteger, (Object)actualArray);
        Collections.reverse(this.expectedArrayIntLong);
        actualArray = (List)resMap.get("arrayLong");
        TbMapArrayListExpressionsTest.assertEquals((Object)this.expectedArrayIntLong, (Object)actualArray);
        Collections.reverse(this.expectedArrayFloat);
        actualArray = (List)resMap.get("arrayFloat");
        TbMapArrayListExpressionsTest.assertEquals((Object)this.expectedArrayFloat, (Object)actualArray);
        Collections.reverse(this.expectedArrayDouble);
        actualArray = (List)resMap.get("arrayDouble");
        TbMapArrayListExpressionsTest.assertEquals((Object)this.expectedArrayDouble, (Object)actualArray);
        Collections.reverse(this.expectedArrayMixedNumeric);
        actualArray = (List)resMap.get("mixedNumericArray");
        TbMapArrayListExpressionsTest.assertEquals((Object)this.expectedArrayMixedNumeric, (Object)actualArray);
        Collections.reverse(this.expectedArrayMixedNumericString);
        actualArray = (List)resMap.get("mixedNumericStringArray");
        TbMapArrayListExpressionsTest.assertEquals((Object)this.expectedArrayMixedNumericString, (Object)actualArray);
    }

    public void testExecutionArrayList_toSorted() {
        String body = "var msg = {};\nvar array = [\"Babnm\", 5, \"8\", \"9\", \"Aabnm\", 1, 200, 40, \"Zxc\"];\nvar arraySortAsc = array.toSorted();\nvar arraySortDesc = array.toSorted(false);\nmsg.array = array;\nmsg.arraySortAsc = arraySortAsc;\nmsg.arraySortDesc = arraySortDesc;\nreturn {msg: msg}";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        List actualArray = (List)resMap.get("array");
        List<Serializable> expectedArray = Arrays.asList("Babnm", 5, "8", "9", "Aabnm", 1, 200, 40, "Zxc");
        TbMapArrayListExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        actualArray = (List)resMap.get("arraySortAsc");
        expectedArray.sort(stringCompAsc);
        TbMapArrayListExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        actualArray = (List)resMap.get("arraySortDesc");
        expectedArray.sort(stringCompDesc);
        TbMapArrayListExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
    }

    public void testExecutionArrayList_Reverse() {
        String body = "var msg = {};\nvar array = [\"8\", 40, 9223372036854775807, \"Dec\", \"-9223372036854775808\"];\nmsg.array = array.slice();\narray.reverse();\nmsg.arrayRev = array;\nreturn {msg: msg};";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        ArrayList<Object> expectedArray = new ArrayList<Object>();
        expectedArray.add("8");
        expectedArray.add(40);
        expectedArray.add(Long.MAX_VALUE);
        expectedArray.add("Dec");
        expectedArray.add("-9223372036854775808");
        List actualArray = (List)resMap.get("array");
        TbMapArrayListExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        Collections.reverse(expectedArray);
        actualArray = (List)resMap.get("arrayRev");
        TbMapArrayListExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
    }

    public void testExecutionArrayList_toReversed() {
        String body = "var msg = {};\nvar array = [\"8\", 40, 9223372036854775807, \"Dec\", \"-9223372036854775808\"];\nmsg.array = array;\nmsg.arrayRev = array.toReversed();\nreturn {msg: msg}";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        ArrayList<Object> expectedArray = new ArrayList<Object>();
        expectedArray.add("8");
        expectedArray.add(40);
        expectedArray.add(Long.MAX_VALUE);
        expectedArray.add("Dec");
        expectedArray.add("-9223372036854775808");
        List actualArray = (List)resMap.get("array");
        TbMapArrayListExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        Collections.reverse(expectedArray);
        actualArray = (List)resMap.get("arrayRev");
        TbMapArrayListExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
    }

    public void testExecutionArrayList_slice() {
        String body = "var msg = {};\nvar arrayWithEmpty = [\"8\", 40, 9223372036854775807, , \"-9223372036854775808\"];\nvar array = [\"8\", 40, 9223372036854775807, \"Dec\", \"-9223372036854775808\"];\nmsg.array = array;\nmsg.arrayWithEmpty = arrayWithEmpty;\nmsg.arraySlice = array.slice();\nmsg.arraySliceWithEmpty = arrayWithEmpty.slice();\nmsg.arraySlice2 = array.slice(2);\nmsg.arraySlice5 = array.slice(5);\nmsg.arraySlice2_4 = array.slice(2, 4);\nmsg.arraySlice1_5 = array.slice(1, 5);\nmsg.arraySliceStr3_4 = array.slice(\"3\", \"4\");\nmsg.arraySlice_2 = array.slice(-2);\nmsg.arraySlice2_1 = array.slice(2, -1);\nreturn {msg: msg}";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        List actualArray = (List)resMap.get("arrayWithEmpty");
        List expectedArray = (List)resMap.get("arraySliceWithEmpty");
        TbMapArrayListExpressionsTest.assertEquals((Object)expectedArray, (Object)actualArray);
        List expected = actualArray = (List)resMap.get("array");
        expectedArray = (List)resMap.get("arraySlice");
        TbMapArrayListExpressionsTest.assertEquals((Object)expectedArray, (Object)actualArray);
        expectedArray = expected.subList(2, expected.size());
        actualArray = (List)resMap.get("arraySlice2");
        TbMapArrayListExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        expectedArray = expected.subList(5, expected.size());
        actualArray = (List)resMap.get("arraySlice5");
        TbMapArrayListExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        expectedArray = expected.subList(2, 4);
        actualArray = (List)resMap.get("arraySlice2_4");
        TbMapArrayListExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        expectedArray = expected.subList(1, 5);
        actualArray = (List)resMap.get("arraySlice1_5");
        TbMapArrayListExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        expectedArray = expected.subList(3, 4);
        actualArray = (List)resMap.get("arraySliceStr3_4");
        TbMapArrayListExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        expectedArray = expected.subList(-2 + expected.size(), 5);
        actualArray = (List)resMap.get("arraySlice_2");
        TbMapArrayListExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        expectedArray = expected.subList(2, -1 + expected.size());
        actualArray = (List)resMap.get("arraySlice2_1");
        TbMapArrayListExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
    }

    public void testExecutionArrayList_sliceWithStartMoreEnd_Error() {
        String body = "var msg = {};\nvar array = [\"8\", 40, 9223372036854775807, \"Dec\", \"-9223372036854775808\"];\nmsg.arraySlice6 = array.slice(6);\nreturn {msg: msg}";
        try {
            this.executeScript(body);
            TbMapArrayListExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbMapArrayListExpressionsTest.assertTrue((boolean)e.getMessage().contains("fromIndex(6) > toIndex(5)"));
        }
    }

    public void testExecutionArrayList_sliceWithStartNotNumeric_Error() {
        String body = "var msg = {};\nvar array = [\"8\", 40, 9223372036854775807, \"Dec\", \"-9223372036854775808\"];\nmsg.arraySlice6 = array.slice(\"rt\", \"2\");\nreturn {msg: msg}";
        try {
            this.executeScript(body);
            TbMapArrayListExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbMapArrayListExpressionsTest.assertTrue((boolean)e.getMessage().contains("For input string: \"rt\""));
        }
    }

    public void testExecutionArrayList_sliceWithEndNotNumeric_Error() {
        String body = "var msg = {};\nvar array = [\"8\", 40, 9223372036854775807, \"Dec\", \"-9223372036854775808\"];\nmsg.arraySlice6 = array.slice(\"1\", \"Dec\");\nreturn {msg: msg}";
        try {
            this.executeScript(body);
            TbMapArrayListExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbMapArrayListExpressionsTest.assertTrue((boolean)e.getMessage().contains("For input string: \"Dec\""));
        }
    }

    public void testExecutionArrayList_shift() {
        String body = "var msg = {};\nvar array = [\"8\", 40, 9223372036854775807, \"Dec\", \"-9223372036854775808\"];\nmsg.arraySlice = array.slice();\nmsg.arrayShift = array.shift();\nmsg.array = array;\nreturn {msg: msg}";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        Object actualShift = resMap.get("arrayShift");
        List actualArraySlice = (List)resMap.get("arraySlice");
        List actualArrayShift = (List)resMap.get("array");
        TbMapArrayListExpressionsTest.assertEquals(actualArraySlice.get(0), actualShift);
        actualArraySlice.remove(0);
        TbMapArrayListExpressionsTest.assertEquals((Object)actualArraySlice, (Object)actualArrayShift);
    }

    public void testExecutionArrayList_unshift() {
        String body = "var msg = {};\nvar array = [\"8\", 40, 9223372036854775807, \"Dec\", \"-9223372036854775808\"];\nmsg.arraySlice = array.slice();\narray.unshift(42, \"Dec\");\nmsg.array = array;\nreturn {msg: msg}";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        List actualArraySlice = (List)resMap.get("arraySlice");
        List actualArrayShift = (List)resMap.get("array");
        actualArraySlice.add(0, "Dec");
        actualArraySlice.add(0, 42);
        TbMapArrayListExpressionsTest.assertEquals((Object)actualArraySlice, (Object)actualArrayShift);
    }

    public void testExecutionArrayList_indexOf() {
        String body = "var msg = {};\nvar arrayInd = [\"a\", 34, \"a\", 34, \"a\", \"a\"];\nvar msg.rezInd = arrayInd.indexOf(\"a\", 1) ;\nreturn {msg: msg}";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        int actualInd = (Integer)resMap.get("rezInd");
        TbMapArrayListExpressionsTest.assertEquals((int)2, (int)actualInd);
        body = "var msg = {};\nvar arrayInd = [\"a\", 34, \"a\", 34, \"a\", \"a\"];\nvar msg.rezInd = arrayInd.indexOf(\"a\", 3) ;\nreturn {msg: msg}";
        result = this.executeScript(body);
        resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        actualInd = (Integer)resMap.get("rezInd");
        TbMapArrayListExpressionsTest.assertEquals((int)4, (int)actualInd);
        body = "var msg = {};\nvar arrayInd = [\"a\", 34, \"a\", 34, \"a\", \"a\"];\nvar msg.rezInd = arrayInd.indexOf(\"a\", 5) ;\nreturn {msg: msg}";
        result = this.executeScript(body);
        resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        actualInd = (Integer)resMap.get("rezInd");
        TbMapArrayListExpressionsTest.assertEquals((int)5, (int)actualInd);
        body = "var msg = {};\nvar arrayInd = [\"a\", 34, \"a\", 34, \"a\", \"a\"];\nvar msg.rezInd = arrayInd.indexOf(\"a\", 5) ;\nreturn {msg: msg}";
        result = this.executeScript(body);
        resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        actualInd = (Integer)resMap.get("rezInd");
        TbMapArrayListExpressionsTest.assertEquals((int)5, (int)actualInd);
        body = "var msg = {};\nvar arrayInd = [\"a\", 34, \"a\", 34, \"a\", \"a\"];\nvar msg.rezInd = arrayInd.indexOf(34, 2) ;\nreturn {msg: msg}";
        result = this.executeScript(body);
        resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        actualInd = (Integer)resMap.get("rezInd");
        TbMapArrayListExpressionsTest.assertEquals((int)3, (int)actualInd);
        body = "var msg = {};\nvar arrayInd = [\"a\", 34, \"a\", 34, \"a\", \"a\"];\nvar msg.rezInd = arrayInd.indexOf(34, 4) ;\nreturn {msg: msg}";
        result = this.executeScript(body);
        resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        actualInd = (Integer)resMap.get("rezInd");
        TbMapArrayListExpressionsTest.assertEquals((int)-1, (int)actualInd);
    }

    public void testExecutionArrayList_concat() {
        String body = "var msg = {};\nvar letters = [\"Dec\", \"Feb\", \"Jan\"];\nvar numbers = [1, 2, 3];\nvar alphaNumeric = letters.concat(numbers);\nmsg.letters = letters;\nmsg.numbers = numbers;\nmsg.alphaNumeric = alphaNumeric;\nreturn {msg: msg};";
        Object result = this.executeScript(body);
        ArrayList<String> expectedArrayString = new ArrayList<String>();
        expectedArrayString.add("Dec");
        expectedArrayString.add("Feb");
        expectedArrayString.add("Jan");
        ArrayList<Integer> expectedArrayNumbers = new ArrayList<Integer>();
        expectedArrayNumbers.add(1);
        expectedArrayNumbers.add(2);
        expectedArrayNumbers.add(3);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        List actualArray = (List)resMap.get("letters");
        TbMapArrayListExpressionsTest.assertEquals(expectedArrayString, (Object)actualArray);
        actualArray = (List)resMap.get("numbers");
        TbMapArrayListExpressionsTest.assertEquals(expectedArrayNumbers, (Object)actualArray);
        expectedArrayString.addAll(expectedArrayNumbers);
        actualArray = (List)resMap.get("alphaNumeric");
        TbMapArrayListExpressionsTest.assertEquals(expectedArrayString, (Object)actualArray);
    }

    public void testExecutionArrayList_splice_Inserts_index_1() {
        String body = "var msg = {};\nvar months = ['Jan', 'March', 'April', 'June'];\nvar removed = months.splice(1, 0, 'Feb');\nmsg.months = months;\nmsg.removed = removed;\nreturn {msg: msg};";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        ArrayList<String> expectedArray = new ArrayList<String>();
        expectedArray.add("Jan");
        expectedArray.add("Feb");
        expectedArray.add("March");
        expectedArray.add("April");
        expectedArray.add("June");
        List actualArray = (List)resMap.get("removed");
        TbMapArrayListExpressionsTest.assertEquals((int)0, (int)actualArray.size());
        actualArray = (List)resMap.get("months");
        TbMapArrayListExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
    }

    public void testExecutionArrayList_splice_Remove_zero_Insert_2_element_at_index_4() {
        String body = "var msg = {};\nvar months = [\"angel\", \"clown\", \"mandarin\", \"sturgeon\"];\nvar removed = months.splice(2, 0, \"drum\", \"guitar\");\nmsg.months = months;\nmsg.removed = removed;\nreturn {msg: msg};";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        ArrayList<String> expectedArray = new ArrayList<String>();
        expectedArray.add("angel");
        expectedArray.add("clown");
        expectedArray.add("drum");
        expectedArray.add("guitar");
        expectedArray.add("mandarin");
        expectedArray.add("sturgeon");
        ArrayList<String> expectedArrayRemoved = new ArrayList<String>();
        expectedArrayRemoved.add("June");
        List actualArray = (List)resMap.get("removed");
        TbMapArrayListExpressionsTest.assertEquals((int)0, (int)actualArray.size());
        actualArray = (List)resMap.get("months");
        TbMapArrayListExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
    }

    public void testExecutionArrayList_splice_Remove_2_Insert_3_element_at_index_1() {
        String body = "var msg = {};\nvar months = [\"angel\", \"clown\", \"trumpet\", \"sturgeon\"];\nvar removed = months.splice(1, 2, \"parrot\", \"anemone\", \"blue\");\nmsg.months = months;\nmsg.removed = removed;\nreturn {msg: msg};";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        ArrayList<String> expectedArray = new ArrayList<String>();
        expectedArray.add("angel");
        expectedArray.add("parrot");
        expectedArray.add("anemone");
        expectedArray.add("blue");
        expectedArray.add("sturgeon");
        ArrayList<String> expectedArrayRemoved = new ArrayList<String>();
        expectedArrayRemoved.add("clown");
        expectedArrayRemoved.add("trumpet");
        List actualArray = (List)resMap.get("removed");
        TbMapArrayListExpressionsTest.assertEquals(expectedArrayRemoved, (Object)actualArray);
        actualArray = (List)resMap.get("months");
        TbMapArrayListExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
    }

    public void testExecutionArrayList_splice_Replaces_2_element_at_index_4() {
        String body = "var msg = {};\nvar months = [\"Jan\", \"Feb\", \"March\", \"April\", \"June\"];\nvar removed = months.splice(4, 1, 'May');\nmsg.months = months;\nmsg.removed = removed;\nreturn {msg: msg};";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        ArrayList<String> expectedArray = new ArrayList<String>();
        expectedArray.add("Jan");
        expectedArray.add("Feb");
        expectedArray.add("March");
        expectedArray.add("April");
        expectedArray.add("May");
        ArrayList<String> expectedArrayRemoved = new ArrayList<String>();
        expectedArrayRemoved.add("June");
        List actualArray = (List)resMap.get("removed");
        TbMapArrayListExpressionsTest.assertEquals(expectedArrayRemoved, (Object)actualArray);
        actualArray = (List)resMap.get("months");
        TbMapArrayListExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
    }

    public void testExecutionArrayList_splice_Remove_1_element_at_index_Minus_3() {
        String body = "var msg = {};\nvar months = [\"angel\", \"clown\", \"mandarin\", \"sturgeon\"];\nvar removed = months.splice(-3, 1);\nmsg.months = months;\nmsg.removed = removed;\nreturn {msg: msg};";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        ArrayList<String> expectedArray = new ArrayList<String>();
        expectedArray.add("angel");
        expectedArray.add("mandarin");
        expectedArray.add("sturgeon");
        ArrayList<String> expectedArrayRemoved = new ArrayList<String>();
        expectedArrayRemoved.add("clown");
        List actualArray = (List)resMap.get("removed");
        TbMapArrayListExpressionsTest.assertEquals(expectedArrayRemoved, (Object)actualArray);
        actualArray = (List)resMap.get("months");
        TbMapArrayListExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
    }

    public void testExecutionArrayList_splice_Remove_All_element_at_index_3() {
        String body = "var msg = {};\nvar months = [\"angel\", \"clown\", \"mandarin\", \"sturgeon\"];\nvar removed = months.splice(3);\nmsg.months = months;\nmsg.removed = removed;\nreturn {msg: msg};";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        ArrayList<String> expectedArray = new ArrayList<String>();
        expectedArray.add("angel");
        expectedArray.add("clown");
        expectedArray.add("mandarin");
        List actualArray = (List)resMap.get("months");
        TbMapArrayListExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        ArrayList<String> expectedArrayRemoved = new ArrayList<String>();
        expectedArrayRemoved.add("sturgeon");
        actualArray = (List)resMap.get("removed");
        TbMapArrayListExpressionsTest.assertEquals(expectedArrayRemoved, (Object)actualArray);
    }

    public void testExecutionArrayList_splice_Remove_All_element_at_index_Minus_3() {
        String body = "var msg = {};\nvar months = [\"angel\", \"clown\", \"mandarin\", \"sturgeon\"];\nvar removed = months.splice(-3);\nmsg.months = months;\nmsg.removed = removed;\nreturn {msg: msg};";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        ArrayList<String> expectedArrayMonth = new ArrayList<String>();
        expectedArrayMonth.add("angel");
        ArrayList<String> expectedArrayRemoved = new ArrayList<String>();
        expectedArrayRemoved.add("clown");
        expectedArrayRemoved.add("mandarin");
        expectedArrayRemoved.add("sturgeon");
        List actualArray = (List)resMap.get("removed");
        TbMapArrayListExpressionsTest.assertEquals(expectedArrayRemoved, (Object)actualArray);
        actualArray = (List)resMap.get("months");
        TbMapArrayListExpressionsTest.assertEquals(expectedArrayMonth, (Object)actualArray);
    }

    public void testExecutionArrayList_splice_Return_Clone() {
        String body = "var msg = {};\nvar months = [\"angel\", \"clown\", \"mandarin\", \"sturgeon\"];\nvar removed = months.splice(-3);\nmsg.months = months;\nmsg.removed = removed;\nreturn {msg: msg};";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        ArrayList<String> expectedArrayMonth = new ArrayList<String>();
        expectedArrayMonth.add("angel");
        ArrayList<String> expectedArrayRemoved = new ArrayList<String>();
        expectedArrayRemoved.add("clown");
        expectedArrayRemoved.add("mandarin");
        expectedArrayRemoved.add("sturgeon");
        List actualArray = (List)resMap.get("removed");
        TbMapArrayListExpressionsTest.assertEquals(expectedArrayRemoved, (Object)actualArray);
        actualArray = (List)resMap.get("months");
        TbMapArrayListExpressionsTest.assertEquals(expectedArrayMonth, (Object)actualArray);
    }

    public void testExecutionArrayList_splice_Remove_All_element_at_index_Minus_5_Size_4() {
        String body = "var msg = {};\nvar months = [\"angel\", \"clown\", \"mandarin\", \"sturgeon\"];\nvar removed = months.splice(-5);\nmsg.months = months;\nmsg.removed = removed;\nreturn {msg: msg};";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        ArrayList<String> expectedArrayRemoved = new ArrayList<String>();
        expectedArrayRemoved.add("angel");
        expectedArrayRemoved.add("clown");
        expectedArrayRemoved.add("mandarin");
        expectedArrayRemoved.add("sturgeon");
        List actualArray = (List)resMap.get("removed");
        TbMapArrayListExpressionsTest.assertEquals(expectedArrayRemoved, (Object)actualArray);
        actualArray = (List)resMap.get("months");
        TbMapArrayListExpressionsTest.assertEquals((int)0, (int)actualArray.size());
    }

    public void testExecutionArrayList_toSpliced_Inserts_Element_1_index_1() {
        String body = "var msg = {};\nvar months = ['Jan', 'March', 'April', 'June'];\nvar newMonths = months.toSpliced(1, 0, 'Feb');\nmsg.months = months;\nmsg.newMonths = newMonths;\nreturn {msg: msg};";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        ArrayList<String> expectedArray = new ArrayList<String>();
        expectedArray.add("Jan");
        expectedArray.add("March");
        expectedArray.add("April");
        expectedArray.add("June");
        ArrayList<String> expectedNewArray = new ArrayList<String>();
        expectedNewArray.add("Jan");
        expectedNewArray.add("Feb");
        expectedNewArray.add("March");
        expectedNewArray.add("April");
        expectedNewArray.add("June");
        List actualArray = (List)resMap.get("months");
        TbMapArrayListExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        actualArray = (List)resMap.get("newMonths");
        TbMapArrayListExpressionsTest.assertEquals(expectedNewArray, (Object)actualArray);
    }

    public void testExecutionArrayList_toSpliced_Delete_Element_2_index_1() {
        String body = "var msg = {};\nvar months = [\"Jan\", \"Feb\", \"March\", \"Apr\", \"May\"];\nvar newMonths = months.toSpliced(1, 2);\nmsg. months =  months;\nmsg. newMonths =  newMonths;\nreturn {msg: msg};";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        ArrayList<String> expectedArray = new ArrayList<String>();
        expectedArray.add("Jan");
        expectedArray.add("Feb");
        expectedArray.add("March");
        expectedArray.add("Apr");
        expectedArray.add("May");
        ArrayList<String> expectedNewArray = new ArrayList<String>();
        expectedNewArray.add("Jan");
        expectedNewArray.add("Apr");
        expectedNewArray.add("May");
        List actualArray = (List)resMap.get("months");
        TbMapArrayListExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        actualArray = (List)resMap.get("newMonths");
        TbMapArrayListExpressionsTest.assertEquals(expectedNewArray, (Object)actualArray);
    }

    public void testExecutionArrayList_toSpliced_Complex() {
        String body = "var msg = {};\nvar months = [\"Jan\", \"Mar\", \"Apr\", \"May\"];\nvar months2 = months.toSpliced(1, 0, \"Feb\");\nmsg.months2 = months2;\nvar months3 = months2.toSpliced(2, 2);\nmsg.months3 = months3;\nvar months4 = months3.toSpliced(1, 1, \"Feb\", \"Mar\");\nmsg.months4 = months4; \nmsg.months = months; \nreturn {msg: msg};";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        ArrayList<String> expectedArray = new ArrayList<String>();
        expectedArray.add("Jan");
        expectedArray.add("Mar");
        expectedArray.add("Apr");
        expectedArray.add("May");
        ArrayList<String> expectedNewArray2 = new ArrayList<String>();
        expectedNewArray2.add("Jan");
        expectedNewArray2.add("Feb");
        expectedNewArray2.add("Mar");
        expectedNewArray2.add("Apr");
        expectedNewArray2.add("May");
        ArrayList<String> expectedNewArray3 = new ArrayList<String>();
        expectedNewArray3.add("Jan");
        expectedNewArray3.add("Feb");
        expectedNewArray3.add("May");
        ArrayList<String> expectedNewArray4 = new ArrayList<String>();
        expectedNewArray4.add("Jan");
        expectedNewArray4.add("Feb");
        expectedNewArray4.add("Mar");
        expectedNewArray4.add("May");
        List actualArray = (List)resMap.get("months");
        TbMapArrayListExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        actualArray = (List)resMap.get("months2");
        TbMapArrayListExpressionsTest.assertEquals(expectedNewArray2, (Object)actualArray);
        actualArray = (List)resMap.get("months3");
        TbMapArrayListExpressionsTest.assertEquals(expectedNewArray3, (Object)actualArray);
        actualArray = (List)resMap.get("months4");
        TbMapArrayListExpressionsTest.assertEquals(expectedNewArray4, (Object)actualArray);
    }

    public void testExecutionArrayList_toSpliced_Remove_All_element_at_index_3() {
        String body = "var msg = {};\nvar months = [\"angel\", \"clown\", \"mandarin\", \"sturgeon\"];\nvar removed = months.toSpliced(3);\nmsg.months = months;\nmsg.removed = removed;\nreturn {msg: msg};";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        ArrayList<String> expectedArray = new ArrayList<String>();
        expectedArray.add("angel");
        expectedArray.add("clown");
        expectedArray.add("mandarin");
        expectedArray.add("sturgeon");
        List actualArray = (List)resMap.get("months");
        TbMapArrayListExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        expectedArray.remove("sturgeon");
        actualArray = (List)resMap.get("removed");
        TbMapArrayListExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
    }

    public void testExecutionArrayList_With_Index_Ok() {
        String body = "var msg = {};\nvar arr = [1, 2, 3, 4, 5];\nvar arrWith = arr.with(2, 6);\nmsg.arr = arr;\nmsg.arrWith = arrWith;\nreturn {msg: msg};";
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        ArrayList<Integer> expectedArray = new ArrayList<Integer>();
        expectedArray.add(1);
        expectedArray.add(2);
        expectedArray.add(3);
        expectedArray.add(4);
        expectedArray.add(5);
        List actualArray = (List)resMap.get("arr");
        TbMapArrayListExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        expectedArray.add(2, 6);
        actualArray = (List)resMap.get("arrWith");
        TbMapArrayListExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
    }

    public void testExecutionArrayList_With_Index_Bad() {
        String body = "var msg = {};\nvar arr = [1, 2, 3, 4, 5];\nvar arrWith = arr.with(6, 6);\nmsg.arr = arr;\nmsg.arrWith = arrWith;\nreturn {msg: msg};";
        try {
            this.executeScript(body);
            TbMapArrayListExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbMapArrayListExpressionsTest.assertTrue((boolean)e.getMessage().contains("arr.with(6, 6): Index: 6, Size: 5"));
        }
        body = "var msg = {};\nvar arr = [1, 2, 3, 4, 5];\nvar arrWith = arr.with(-6, 6);\nmsg.arr = arr;\nmsg.arrWith = arrWith;\nreturn {msg: msg};";
        try {
            this.executeScript(body);
            TbMapArrayListExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbMapArrayListExpressionsTest.assertTrue((boolean)e.getMessage().contains("arr.with(-6, 6): Index: -6, Size: 5"));
        }
    }

    public void testExecutionArrayList_Fill_Index_Ok() {
        String parameter = "4";
        String body1 = "var msg = {};\nvar arr = [1, 2, 3];\nvar arrFill = arr.fill(";
        String body2 = ");\nmsg.arr = arr;\nmsg.arrFill = arrFill;\nreturn {msg: msg};";
        String body = body1 + parameter + body2;
        Object result = this.executeScript(body);
        LinkedHashMap resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        ArrayList<Integer> expectedArray = new ArrayList<Integer>();
        expectedArray.add(4);
        expectedArray.add(4);
        expectedArray.add(4);
        List actualArray = (List)resMap.get("arr");
        TbMapArrayListExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        actualArray = (List)resMap.get("arrFill");
        TbMapArrayListExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        parameter = "4, 1";
        body = body1 + parameter + body2;
        expectedArray.set(0, 1);
        result = this.executeScript(body);
        resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        actualArray = (List)resMap.get("arr");
        TbMapArrayListExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        actualArray = (List)resMap.get("arrFill");
        TbMapArrayListExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        parameter = "4, 1, 2";
        body = body1 + parameter + body2;
        expectedArray.set(2, 3);
        result = this.executeScript(body);
        resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        actualArray = (List)resMap.get("arr");
        TbMapArrayListExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        actualArray = (List)resMap.get("arrFill");
        TbMapArrayListExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        parameter = "4, 1, 1";
        body = body1 + parameter + body2;
        expectedArray.set(0, 1);
        expectedArray.set(1, 2);
        result = this.executeScript(body);
        resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        actualArray = (List)resMap.get("arr");
        TbMapArrayListExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        actualArray = (List)resMap.get("arrFill");
        TbMapArrayListExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        parameter = "4, -3, -2";
        body = body1 + parameter + body2;
        expectedArray.set(0, 4);
        result = this.executeScript(body);
        resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        actualArray = (List)resMap.get("arr");
        TbMapArrayListExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        actualArray = (List)resMap.get("arrFill");
        TbMapArrayListExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        parameter = "4, 3, 5";
        body = body1 + parameter + body2;
        expectedArray.set(0, 1);
        result = this.executeScript(body);
        resMap = (LinkedHashMap)((LinkedHashMap)result).get("msg");
        actualArray = (List)resMap.get("arr");
        TbMapArrayListExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
        actualArray = (List)resMap.get("arrFill");
        TbMapArrayListExpressionsTest.assertEquals(expectedArray, (Object)actualArray);
    }

    public void testExecutionArrayListJoin() {
        String body = "var list = [];\nreturn list.join();";
        Object result = this.executeScript(body);
        TbMapArrayListExpressionsTest.assertTrue((boolean)(result instanceof String));
        TbMapArrayListExpressionsTest.assertEquals((Object)"", (Object)result);
        body = "var list = ['hello', 34567];\nreturn list.join();";
        result = this.executeScript(body);
        TbMapArrayListExpressionsTest.assertTrue((boolean)(result instanceof String));
        TbMapArrayListExpressionsTest.assertEquals((Object)"hello,34567", (Object)result);
        body = "var list = ['hello', 34567];\nreturn list.join(':');";
        result = this.executeScript(body);
        TbMapArrayListExpressionsTest.assertTrue((boolean)(result instanceof String));
        TbMapArrayListExpressionsTest.assertEquals((Object)"hello:34567", (Object)result);
        body = "var matrix = [\n[1, [12, 22, \"Things2\"], 2, \"Things\"],\n  [4, 5, 6],\n  245, \"Test_Join\",\n  [7, \"8\", [13, [14, 24, \"Things4\"], 23, \"Things3\"], 9],\n];\nreturn matrix.join();";
        result = this.executeScript(body);
        TbMapArrayListExpressionsTest.assertTrue((boolean)(result instanceof String));
        TbMapArrayListExpressionsTest.assertEquals((Object)"1,12,22,Things2,2,Things,4,5,6,245,Test_Join,7,8,13,14,24,Things4,23,Things3,9", (Object)result);
    }

    public void testExecutionArrayList_Unmodifiable() {
        String body = "var msg = {};\nvar original = [];\noriginal.add(0x35);\nvar unmodifiable = original.toUnmodifiable();\nmsg.result = unmodifiable;\nreturn {msg: msg};";
        Object result = this.executeScript(body);
        String expected = "{msg={result=[53]}}";
        TbMapArrayListExpressionsTest.assertEquals((String)expected, (String)result.toString());
        String errorArray = "Error: unmodifiable.add(0x35): List is unmodifiable";
        body = "var msg = {};\nvar original = [];\noriginal.add(0x67);\nvar unmodifiable = original.toUnmodifiable();\nunmodifiable.add(0x35);\nmsg.result = unmodifiable;\nreturn {msg: msg};";
        try {
            this.executeScript(body);
            TbMapArrayListExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbMapArrayListExpressionsTest.assertTrue((boolean)e.getMessage().contains(errorArray));
        }
    }

    public void testExecutionHashMap_EntrySet() {
        String body = "var msg = {};\nvar original = {};\nvar list1 = [13, 15];\nvar list2 = [23, 25];\noriginal.put(\"entry1\", list1);\noriginal.put(\"entry2\", list2);\nvar result1 = original.entrySet();\nresult1.add(25);\nvar list3 = [33, 35];\noriginal.put(\"entry3\", list3);\nmsg.original = original;\nmsg.result1 = result1;\nmsg.result2 = original.entrySet();\nreturn {msg: msg};";
        Object result = this.executeScript(body);
        String expected = "{msg={original={entry1=[13, 15], entry2=[23, 25], entry3=[33, 35]}, result1=[entry1=[13, 15], entry2=[23, 25], 25], result2=[entry1=[13, 15], entry2=[23, 25], entry3=[33, 35]]}}";
        TbMapArrayListExpressionsTest.assertEquals((String)expected, (String)result.toString());
    }

    public void testExecutionList_Unmodifiable() {
        String body = "var msg = {};\nvar original = [33, 45, \"value1\"];\noriginal.add(\"entry2\");\nvar unmodifiable = original.toUnmodifiable();\nmsg.result = unmodifiable;\noriginal.add(\"entry3\");\nmsg.original = original;\nreturn {msg: msg};";
        Object result = this.executeScript(body);
        String expected = "{msg={result=[33, 45, value1, entry2, entry3], original=[33, 45, value1, entry2, entry3]}}";
        TbMapArrayListExpressionsTest.assertEquals((String)expected, (String)result.toString());
        String errorArray = "Error: unmodifiable.add(\"entry2\"): List is unmodifiable";
        body = "var msg = {};\nvar original = [33, 45, \"value1\"];\nvar unmodifiable = original.toUnmodifiable();\nunmodifiable.add(\"entry2\");\nmsg.result = unmodifiable;\nreturn {msg: msg};";
        try {
            this.executeScript(body);
            TbMapArrayListExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbMapArrayListExpressionsTest.assertTrue((boolean)e.getMessage().contains(errorArray));
        }
    }

    public void testExecutionHashMap_Unmodifiable() {
        String body = "var msg = {};\nvar original = {};\noriginal.putIfAbsent(\"entry1\", 73);\nvar unmodifiable = original.toUnmodifiable();\nmsg.result = unmodifiable;\nreturn {msg: msg};";
        Object result = this.executeScript(body);
        String expected = "{msg={result={entry1=73}}}";
        TbMapArrayListExpressionsTest.assertEquals((String)expected, (String)result.toString());
        body = "var msg = {};\nvar original = {};\noriginal.put(\"temperature1\", 73);\nvar entrySet = original.entrySet();\nvar unmodifiable = entrySet.toUnmodifiable();\nmsg.result = unmodifiable;\nreturn {msg: msg};";
        result = this.executeScript(body);
        expected = "{msg={result=[temperature1=73]}}";
        TbMapArrayListExpressionsTest.assertEquals((String)expected, (String)result.toString());
        String errorArray = "Error: unmodifiable.put(\"temperature1\", 96): Map is unmodifiable";
        body = "var msg = {};\nvar original = {};\noriginal.humidity = 73;\nvar unmodifiable = original.toUnmodifiable();\nunmodifiable.put(\"temperature1\", 96);\nmsg.result = unmodifiable;\nreturn {msg: msg};";
        try {
            this.executeScript(body);
            TbMapArrayListExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbMapArrayListExpressionsTest.assertTrue((boolean)e.getMessage().contains(errorArray));
        }
    }

    public void testExecutionHashMapEntrySet_Unmodifiable() {
        String body = "var msg = {};\nvar original = {};\noriginal.put(\"entry1\", 73);\nvar entrySet1 = original.entrySet();\nentrySet1.add(25);\nmsg.result = entrySet1;\nreturn {msg: msg};";
        Object result = this.executeScript(body);
        String expected = "{msg={result=[entry1=73, 25]}}";
        TbMapArrayListExpressionsTest.assertEquals((String)expected, (String)result.toString());
        String errorArray = "Error: unmodifiable.add(25): List is unmodifiable";
        body = "var msg = {};\nvar original = {};\noriginal.put(\"temperature1\", 73);\nvar entrySet = original.entrySet();\nvar unmodifiable = entrySet.toUnmodifiable();\nunmodifiable.add(25);\nmsg.result = unmodifiable;\nreturn {msg: msg};";
        try {
            this.executeScript(body);
            TbMapArrayListExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbMapArrayListExpressionsTest.assertTrue((boolean)e.getMessage().contains(errorArray));
        }
    }

    private Object executeScript(String ex) {
        Serializable compiled = MVEL.compileExpression((String)ex, (ParserContext)new ParserContext());
        this.currentExecutionContext = new ExecutionContext(this.parserConfig);
        return MVEL.executeTbExpression((Object)compiled, (ExecutionContext)this.currentExecutionContext, new HashMap());
    }

    private <V> boolean equalsList(Collection l1, Collection l2) {
        boolean eq;
        block1: {
            Object o;
            boolean bl = eq = l1.size() == l2.size();
            if (!eq) break block1;
            Iterator iterator = l1.iterator();
            while (iterator.hasNext() && (eq = l2.contains(o = iterator.next()))) {
            }
        }
        return eq;
    }
}

