/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.execution;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.mvel2.ExecutionContext;
import org.mvel2.execution.ExecutionArrayList;
import org.mvel2.execution.ExecutionCollections;
import org.mvel2.execution.ExecutionObject;

public class ExecutionLinkedHashSet<E>
extends LinkedHashSet<E>
implements ExecutionObject {
    private final ExecutionContext executionContext;
    private long memorySize = 0L;

    public ExecutionLinkedHashSet(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    public ExecutionLinkedHashSet(Set<? extends E> s, ExecutionContext executionContext) {
        super(s);
        this.executionContext = executionContext;
        for (Object val : this) {
            this.memorySize += this.executionContext.onValAdd(this, val);
        }
    }

    @Override
    public boolean add(E e) {
        if (super.add(e)) {
            this.memorySize += this.executionContext.onValAdd(this, e);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (super.remove(o)) {
            this.memorySize -= this.executionContext.onValRemove(this, o);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        for (Object val : this) {
            this.executionContext.onValRemove(this, val);
        }
        super.clear();
        this.memorySize = 0L;
    }

    @Override
    public long memorySize() {
        return this.memorySize;
    }

    public List<E> toUnmodifiable() {
        return ExecutionCollections.unmodifiableExecutionList(new ExecutionArrayList(new ArrayList(this), this.executionContext), this.executionContext);
    }
}

