/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mvel2.SandboxedParserConfiguration;
import org.mvel2.ScriptExecutionStoppedException;
import org.mvel2.ScriptMemoryOverflowException;
import org.mvel2.ScriptRuntimeException;
import org.mvel2.execution.ExecutionArrayList;
import org.mvel2.execution.ExecutionObject;
import org.mvel2.util.TriFunction;

public class ExecutionContext
implements Serializable {
    private final Map<Object, ValueReference> valueReferenceMap = new IdentityHashMap<Object, ValueReference>();
    private final Map<VarKey, Object> variablesMap = new HashMap<VarKey, Object>();
    private final SandboxedParserConfiguration parserConfig;
    private final long maxAllowedMemory;
    private final int maxAllowedMethodArgs;
    private int stackLevel = 0;
    private long memorySize = 0L;
    private final AtomicInteger idSequence = new AtomicInteger(0);
    private volatile boolean stopped = false;

    public ExecutionContext(SandboxedParserConfiguration parserConfig) {
        this(parserConfig, -1L);
    }

    public ExecutionContext(SandboxedParserConfiguration parserConfig, long maxAllowedMemory) {
        this(parserConfig, maxAllowedMemory, 10);
    }

    public ExecutionContext(SandboxedParserConfiguration parserConfig, long maxAllowedMemory, int maxAllowedMethodArgs) {
        this.parserConfig = parserConfig;
        this.maxAllowedMemory = maxAllowedMemory;
        this.maxAllowedMethodArgs = maxAllowedMethodArgs;
    }

    public void checkExecution() {
        if (this.stopped) {
            throw new ScriptExecutionStoppedException("Script execution is stopped!");
        }
    }

    public Object[] checkInvocation(Method method, Object ctx, Object[] args) {
        if (args != null && this.maxAllowedMethodArgs > 0 && args.length > this.maxAllowedMethodArgs) {
            throw new ScriptRuntimeException("Maximum method arguments count overflow (" + args.length + " > " + this.maxAllowedMethodArgs + ")!");
        }
        TriFunction<ExecutionContext, Object, Object[], Object[]> invocationChecker = this.parserConfig.getMethodInvocationChecker(method);
        if (invocationChecker != null) {
            return invocationChecker.apply(this, ctx, args);
        }
        return args;
    }

    public void stop() {
        this.stopped = true;
    }

    public void enterStack() {
        ++this.stackLevel;
    }

    public void leaveStack() {
        int level = this.stackLevel--;
        List<VarKey> keysToRemove = this.variablesMap.keySet().stream().filter(varKey -> varKey.level == level).collect(Collectors.toList());
        keysToRemove.forEach(key -> this.checkAssignVariable((VarKey)key, null));
    }

    public void checkArray(Class<?> componentType, int ... dimensions) {
        if (componentType.isPrimitive()) {
            long arraySize = 1L;
            for (int i = 0; i < dimensions.length; ++i) {
                arraySize *= (long)dimensions[i];
            }
            long arrayMemorySize = arraySize * (long)ExecutionContext.componentTypeSize(componentType);
            if (this.maxAllowedMemory > 0L && arrayMemorySize > this.maxAllowedMemory / 2L) {
                throw new ScriptMemoryOverflowException("Max array length overflow (" + arrayMemorySize + " > " + this.maxAllowedMemory / 2L + ")!");
            }
        } else {
            throw new ScriptRuntimeException("Unsupported array type: " + String.valueOf(componentType));
        }
    }

    public Object checkAssignGlobalVariable(String varName, Object value) {
        return this.checkAssignVariable(new VarKey(0, varName), value);
    }

    public Object checkAssignLocalVariable(String varName, Object value) {
        return this.checkAssignVariable(new VarKey(this.stackLevel, varName), value);
    }

    private Object checkAssignVariable(VarKey varKey, Object value) {
        Object prevValue;
        ValueReference reference;
        if (this.variablesMap.containsKey(varKey) && (reference = this.valueReferenceMap.get(prevValue = this.variablesMap.get(varKey))) != null && reference.removeReference(varKey)) {
            this.valueReferenceMap.remove(prevValue);
            this.memorySize -= reference.getSize();
        }
        if (value != null) {
            Object converted = this.convertValue(value);
            this.variablesMap.put(varKey, converted);
            reference = this.valueReferenceMap.computeIfAbsent(value, o -> {
                ValueReference newReference = new ValueReference();
                newReference.setSize(this.getValueSize(converted));
                this.memorySize += newReference.getSize();
                return newReference;
            });
            reference.addReference(varKey);
            value = converted;
        } else {
            this.variablesMap.remove(varKey);
        }
        this.checkMemoryLimit();
        return value;
    }

    public long onValRemove(ExecutionObject obj, Object val) {
        return this.onValRemove(obj, null, val);
    }

    public long onValRemove(ExecutionObject obj, Object key, Object val) {
        ValueReference reference;
        long valSize = this.getValueSize(val);
        if (key != null) {
            valSize += this.getValueSize(key);
        }
        if ((reference = this.valueReferenceMap.get(obj)) != null) {
            reference.setSize(reference.getSize() - valSize);
        }
        this.memorySize -= valSize;
        return valSize;
    }

    public long onValAdd(ExecutionObject obj, Object val) {
        return this.onValAdd(obj, null, val);
    }

    public long onValAdd(ExecutionObject obj, Object key, Object val) {
        ValueReference reference;
        long valSize = this.getValueSize(val);
        if (key != null) {
            valSize += this.getValueSize(key);
        }
        if ((reference = this.valueReferenceMap.get(obj)) != null) {
            reference.setSize(reference.getSize() + valSize);
        }
        this.memorySize += valSize;
        this.checkMemoryLimit();
        return valSize;
    }

    public void dumpVars() {
        System.out.println("VARS:");
        this.variablesMap.forEach((key, value) -> System.out.println(String.valueOf(key) + " = " + String.valueOf(value)));
    }

    public void dumpValueReferences() {
        System.out.println("VALUE REFERENCES:");
        this.valueReferenceMap.forEach((key, value) -> System.out.println(String.valueOf(key) + " = " + String.valueOf(value)));
    }

    public long getMemorySize() {
        return this.memorySize;
    }

    public long getMaxAllowedMemory() {
        return this.maxAllowedMemory;
    }

    private void checkMemoryLimit() {
        if (this.maxAllowedMemory > 0L && this.memorySize > this.maxAllowedMemory) {
            throw new ScriptMemoryOverflowException("Script memory overflow (" + this.memorySize + " > " + this.maxAllowedMemory + ")!");
        }
    }

    private Object convertValue(Object value) {
        if (value.getClass().isArray() && !value.getClass().getComponentType().isPrimitive()) {
            value = new ExecutionArrayList<Object>(Arrays.asList((Object[])value), this);
        }
        return value;
    }

    private long getValueSize(Object value) {
        if (value == null) {
            return 0L;
        }
        Function<Object, Long> valueSizeFunction = this.parserConfig.getValueSizeFunction(value.getClass());
        if (valueSizeFunction != null) {
            return valueSizeFunction.apply(value);
        }
        if (value instanceof ExecutionObject) {
            if (this.valueReferenceMap.containsKey(value)) {
                return 4L;
            }
            return ((ExecutionObject)value).memorySize();
        }
        if (value instanceof String) {
            return ((String)value).getBytes().length;
        }
        if (value instanceof Byte) {
            return 1L;
        }
        if (value instanceof Character) {
            return 1L;
        }
        if (value instanceof Short) {
            return 2L;
        }
        if (value instanceof Integer) {
            return 4L;
        }
        if (value instanceof Long) {
            return 8L;
        }
        if (value instanceof Float) {
            return 4L;
        }
        if (value instanceof Double) {
            return 8L;
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).bitLength() / 8 + 1;
        }
        if (value instanceof Boolean) {
            return 1L;
        }
        if (value instanceof UUID) {
            return 16L;
        }
        if (value instanceof Date) {
            return 8L;
        }
        if (value.getClass().isArray() && value.getClass().getComponentType().isPrimitive()) {
            return (long)Array.getLength(value) * (long)ExecutionContext.componentTypeSize(value.getClass().getComponentType());
        }
        throw new ScriptRuntimeException("Unsupported value type: " + String.valueOf(value.getClass()));
    }

    private static int componentTypeSize(Class<?> componentType) {
        if (Byte.TYPE.equals(componentType)) {
            return 1;
        }
        if (Character.TYPE.equals(componentType)) {
            return 1;
        }
        if (Short.TYPE.equals(componentType)) {
            return 2;
        }
        if (Integer.TYPE.equals(componentType)) {
            return 4;
        }
        if (Long.TYPE.equals(componentType)) {
            return 8;
        }
        if (Float.TYPE.equals(componentType)) {
            return 4;
        }
        if (Double.TYPE.equals(componentType)) {
            return 8;
        }
        if (Boolean.TYPE.equals(componentType)) {
            return 1;
        }
        throw new ScriptRuntimeException("Unsupported array primitive type: " + String.valueOf(componentType));
    }

    private static final class VarKey {
        private final int level;
        private final String name;

        VarKey(int level, String name) {
            this.level = level;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VarKey varKey = (VarKey)o;
            return this.level == varKey.level && Objects.equals(this.name, varKey.name);
        }

        public int hashCode() {
            return Objects.hash(this.level, this.name);
        }
    }

    private static final class ValueReference {
        private final Set<VarKey> references = new HashSet<VarKey>();
        private long size = 0L;

        private ValueReference() {
        }

        void addReference(VarKey varKey) {
            this.references.add(varKey);
        }

        boolean removeReference(VarKey varKey) {
            this.references.remove(varKey);
            return this.references.isEmpty();
        }

        public long getSize() {
            return this.size;
        }

        public void setSize(long size) {
            this.size = size;
        }

        public String toString() {
            return "ValueReference[size: " + this.size + "; references: " + String.valueOf(this.references) + "]";
        }
    }
}

