/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.tests.core;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.mvel2.CompileException;
import org.mvel2.ExecutionContext;
import org.mvel2.MVEL;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;
import org.mvel2.SandboxedParserConfiguration;
import org.mvel2.execution.ExecutionArrayList;
import org.mvel2.optimizers.OptimizerFactory;
import org.mvel2.util.MethodStub;

public class TbUtilsExpressionsTest
extends TestCase {
    private SandboxedParserConfiguration parserConfig;
    private static final int BYTES_LEN_LONG_MAX = 8;
    private static final int HEX_RADIX = 16;

    protected void setUp() throws Exception {
        OptimizerFactory.setDefaultOptimizer((String)OptimizerFactory.SAFE_REFLECTIVE);
        super.setUp();
        this.parserConfig = ParserContext.enableSandboxedMode();
        try {
            TbUtils.register((ParserConfiguration)this.parserConfig);
            this.parserConfig.addImport(TbUtils.class);
        }
        catch (Exception e) {
            System.out.println("Cannot register functions " + e.getMessage());
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        ParserContext.disableSandboxedMode();
    }

    public void testStringToBytes_ArgumentTypeIsString_Ok() throws Exception {
        String expectedStr = "{\"hello\": \"world\"}";
        String scriptBody = "var input = \"{\\\"hello\\\": \\\"world\\\"}\"; \nvar newMsg = stringToBytes(input);\n\nreturn {msg: newMsg};";
        LinkedHashMap<String, List<Byte>> expected = new LinkedHashMap<String, List<Byte>>();
        List<Byte> expIntList = this.bytesToList(expectedStr.getBytes());
        expected.put("msg", expIntList);
        Object actual = this.executeScript(scriptBody);
        TbUtilsExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testStringToBytes_ArgumentTypeIsObjectAsString_Ok() throws Exception {
        String expectedStr = "world";
        String scriptBody = "var dataMap = {};\ndataMap.hello = \"world\";\nvar newMsg =  stringToBytes(dataMap.get(\"hello\"));\nreturn {msg: newMsg}";
        LinkedHashMap<String, List<Byte>> expected = new LinkedHashMap<String, List<Byte>>();
        List<Byte> expIntList = this.bytesToList(expectedStr.getBytes());
        expected.put("msg", expIntList);
        Object actual = this.executeScript(scriptBody);
        TbUtilsExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testStringToBytes_ArgumentTypeIsNotStringLineNotZero_Bad() throws Exception {
        String argument = "msgTest";
        String scriptBody = "var " + argument + "  = {\"hello\": \"world\"}; \nvar newMsg = stringToBytes(" + argument + ");\n\nreturn {msg: newMsg};";
        try {
            this.executeScript(scriptBody);
            TbUtilsExpressionsTest.fail((String)"Should throw CompileException");
        }
        catch (CompileException e) {
            TbUtilsExpressionsTest.assertTrue((boolean)e.getMessage().equals("[Error: stringToBytes(msgTest): Invalid type parameter [ExecutionHashMap]. Expected 'String']\n[Near : {... var newMsg = stringToBytes(msgTest); ....}]\n                          ^\n[Line: 2, Column: 14]"));
        }
    }

    public void testSHexToBytes_InFunction_Ok() throws Exception {
        String scriptBody = "var data = frm();\nfunction frm(){\n    var out = {};\n    out.bb = hexToBytes(\"0x01752B0367FA000500010488FFFFFFFFFFFFFFFF33\");\n    return out;\n}\nvar result = {\n   msg: data\n};\nreturn result;";
        LinkedHashMap expected = new LinkedHashMap();
        byte[] expectedBytes = new byte[]{1, 117, 43, 3, 103, -6, 0, 5, 0, 1, 4, -120, -1, -1, -1, -1, -1, -1, -1, -1, 51};
        List<Byte> expBytesToList = this.bytesToList(expectedBytes);
        LinkedHashMap<String, List<Byte>> expIntList = new LinkedHashMap<String, List<Byte>>();
        expIntList.put("bb", expBytesToList);
        expected.put("msg", expIntList);
        Object actual = this.executeScript(scriptBody);
        TbUtilsExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testIntToHex_ArgumentIntMax_Ok() throws Exception {
        String expectedStr = "0x7FFFFFFF";
        String scriptBody = "\nvar newMsg = intToHex(0x7FFFFFFF, true, true);\nreturn {msg: newMsg}";
        LinkedHashMap<String, String> expected = new LinkedHashMap<String, String>();
        expected.put("msg", expectedStr);
        Object actual = this.executeScript(scriptBody);
        TbUtilsExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testIntToHex_ArgumentIntMoreMax_Ok() throws Exception {
        String expectedStr = "0xFFD8FFA6";
        String scriptBody = "\nvar newMsg = longToHex(0xFFD8FFA6, true, true);\nreturn {msg: newMsg}";
        LinkedHashMap<String, String> expected = new LinkedHashMap<String, String>();
        expected.put("msg", expectedStr);
        Object actual = this.executeScript(scriptBody);
        TbUtilsExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testIntToHex_ArgumentIntMin_Ok() throws Exception {
        String expectedStr = "0x80000000";
        String scriptBody = "\nvar newMsg = intToHex(0x80000000, true, true);\nreturn {msg: newMsg}";
        LinkedHashMap<String, String> expected = new LinkedHashMap<String, String>();
        expected.put("msg", expectedStr);
        Object actual = this.executeScript(scriptBody);
        TbUtilsExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testLongToHex_ArgumentLongMax_Ok() throws Exception {
        String expectedStr = "0x7FFFFFFFFFFFFFFF";
        String scriptBody = "\nvar newMsg = longToHex(0x7FFFFFFFFFFFFFFF, true, true);\nreturn {msg: newMsg}";
        LinkedHashMap<String, String> expected = new LinkedHashMap<String, String>();
        expected.put("msg", expectedStr);
        Object actual = this.executeScript(scriptBody);
        TbUtilsExpressionsTest.assertEquals(expected, (Object)actual);
    }

    public void testLongToHex_ArgumentLonMin_Ok() throws Exception {
        String expectedStr = "0x8000000000000000";
        String scriptBody = "\nvar newMsg = longToHex(0x8000000000000000, true, true);\nreturn {msg: newMsg}";
        LinkedHashMap<String, String> expected = new LinkedHashMap<String, String>();
        expected.put("msg", expectedStr);
        Object actual = this.executeScript(scriptBody);
        TbUtilsExpressionsTest.assertEquals(expected, (Object)actual);
    }

    private Object executeScript(String ex) {
        return this.executeScript(ex, new HashMap());
    }

    private Object executeScript(String ex, Map vars) {
        return this.executeScript(ex, vars, new ExecutionContext(this.parserConfig));
    }

    private Object executeScript(String ex, Map vars, ExecutionContext executionContext) {
        Serializable compiled = MVEL.compileExpression((String)ex, (ParserContext)new ParserContext());
        return MVEL.executeTbExpression((Object)compiled, (ExecutionContext)executionContext, (Map)vars);
    }

    private List<Byte> bytesToList(byte[] bytes) {
        ArrayList<Byte> list = new ArrayList<Byte>();
        for (byte aByte : bytes) {
            list.add(aByte);
        }
        return list;
    }

    public static class TbUtils {
        private static final byte[] HEX_ARRAY = "0123456789ABCDEF".getBytes(StandardCharsets.US_ASCII);
        private static final int HEX_LEN_MIN = -1;
        private static final int HEX_LEN_LONG_MAX = 16;
        private static final int BYTES_LEN_LONG_MAX = 8;
        private static final int HEX_LEN_INT_MAX = 8;

        public static void register(ParserConfiguration parserConfig) throws Exception {
            parserConfig.addImport("stringToBytes", new MethodStub(TbUtils.class.getMethod("stringToBytes", ExecutionContext.class, Object.class)));
            parserConfig.addImport("stringToBytes", new MethodStub(TbUtils.class.getMethod("stringToBytes", ExecutionContext.class, Object.class, String.class)));
            parserConfig.registerNonConvertableMethods(TbUtils.class, Collections.singleton("stringToBytes"));
            parserConfig.addImport("hexToBytes", new MethodStub(TbUtils.class.getMethod("hexToBytes", ExecutionContext.class, String.class)));
            parserConfig.addImport("longToHex", new MethodStub(TbUtils.class.getMethod("longToHex", Long.class, Boolean.TYPE, Boolean.TYPE)));
            parserConfig.addImport("intToHex", new MethodStub(TbUtils.class.getMethod("intToHex", Integer.class, Boolean.TYPE, Boolean.TYPE)));
        }

        public static List<Byte> stringToBytes(ExecutionContext ctx, Object str) throws IllegalAccessException {
            if (str instanceof String) {
                byte[] bytes = str.toString().getBytes();
                return TbUtils.bytesToList(ctx, bytes);
            }
            throw new IllegalAccessException("Invalid type parameter [" + str.getClass().getSimpleName() + "]. Expected 'String'");
        }

        public static List<Byte> stringToBytes(ExecutionContext ctx, Object str, String charsetName) throws UnsupportedEncodingException, IllegalAccessException {
            if (str instanceof String) {
                byte[] bytes = str.toString().getBytes(charsetName);
                return TbUtils.bytesToList(ctx, bytes);
            }
            throw new IllegalAccessException("Invalid type parameter [" + str.getClass().getSimpleName() + "]. Expected 'String'");
        }

        public static ExecutionArrayList<Byte> hexToBytes(ExecutionContext ctx, String value) {
            String hex = TbUtils.prepareNumberString(value, true);
            int len = hex.length();
            if (len % 2 > 0) {
                throw new IllegalArgumentException("Hex string must be even-length.");
            }
            ExecutionArrayList data = new ExecutionArrayList(ctx);
            for (int i = 0; i < hex.length(); i += 2) {
                String byteString = hex.substring(i, i + 2);
                byte byteValue = (byte)Integer.parseInt(byteString, 16);
                data.add((Object)byteValue);
            }
            return data;
        }

        private static List<Byte> bytesToList(ExecutionContext ctx, byte[] bytes) {
            ExecutionArrayList list = new ExecutionArrayList(ctx);
            for (byte aByte : bytes) {
                list.add(aByte);
            }
            return list;
        }

        private static String prepareNumberString(String value, boolean bigEndian) {
            if (TbUtils.isNotBlank(value)) {
                value = value.trim();
                value = value.replace("0x", "");
                value = value.replace("0X", "");
                value = value.replace(",", ".");
                return bigEndian ? value : TbUtils.reverseHexStringByOrder(value);
            }
            return null;
        }

        private static boolean isNotBlank(String source) {
            return source != null && !source.isEmpty() && !source.trim().isEmpty();
        }

        private static String reverseHexStringByOrder(String value) {
            String hex;
            if (value.startsWith("-")) {
                throw new IllegalArgumentException("The hexadecimal string must be without a negative sign.");
            }
            boolean isHexPref = value.startsWith("0x");
            String string = hex = isHexPref ? value.substring(2) : value;
            if (hex.length() % 2 > 0) {
                throw new IllegalArgumentException("The hexadecimal string must be even-length.");
            }
            StringBuilder reversedHex = new StringBuilder(8);
            for (int i = hex.length() - 2; i >= 0; i -= 2) {
                reversedHex.append(hex, i, i + 2);
            }
            String result = reversedHex.toString();
            return isHexPref ? "0x" + result : result;
        }

        public static String intToHex(Integer i, boolean bigEndian, boolean pref) {
            return TbUtils.prepareNumberHexString(i.longValue(), bigEndian, pref, -1, 8);
        }

        public static String longToHex(Long l, boolean bigEndian, boolean pref) {
            return TbUtils.prepareNumberHexString(l, bigEndian, pref, -1, 16);
        }

        private static String prepareNumberHexString(Long number, boolean bigEndian, boolean pref, int len, int hexLenMax) {
            String hex = Long.toHexString(number).toUpperCase();
            hexLenMax = hexLenMax < 0 ? hex.length() : hexLenMax;
            String hexWithoutZeroFF = TbUtils.removeLeadingZero_FF(hex, number, hexLenMax);
            hexWithoutZeroFF = bigEndian ? hexWithoutZeroFF : TbUtils.reverseHexStringByOrder(hexWithoutZeroFF);
            len = len == -1 ? hexWithoutZeroFF.length() : len;
            String result = hexWithoutZeroFF.substring(hexWithoutZeroFF.length() - len);
            return pref ? "0x" + result : result;
        }

        private static String removeLeadingZero_FF(String hex, Long number, int hexLenMax) {
            Object hexWithoutZero = hex.replaceFirst("^0+(?!$)", "");
            Object object = hexWithoutZero = ((String)hexWithoutZero).length() % 2 > 0 ? "0" + (String)hexWithoutZero : hexWithoutZero;
            if (number >= 0L) {
                return hexWithoutZero;
            }
            Object hexWithoutZeroFF = ((String)hexWithoutZero).replaceFirst("^F+(?!$)", "");
            Object object2 = hexWithoutZeroFF = ((String)hexWithoutZeroFF).length() % 2 > 0 ? "F" + (String)hexWithoutZeroFF : hexWithoutZeroFF;
            if (((String)hexWithoutZeroFF).length() > hexLenMax) {
                return ((String)hexWithoutZeroFF).substring(((String)hexWithoutZeroFF).length() - hexLenMax);
            }
            if (((String)hexWithoutZeroFF).length() == hexLenMax) {
                return hexWithoutZeroFF;
            }
            return "FF" + (String)hexWithoutZeroFF;
        }
    }
}

