/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.tests.core;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import org.junit.Assert;
import org.mvel2.MVEL;
import org.mvel2.tests.core.AbstractTest;

public class VarargTests
extends AbstractTest {
    public void testSingleArgMethodPreference() {
        Serializable s = MVEL.compileExpression((String)"testee.add('a')");
        MyVarargTestee testee = new MyVarargTestee();
        MVEL.executeExpression((Object)s, Collections.singletonMap("testee", testee));
        Assert.assertEquals((Object)"singleArgMethoda", (Object)testee.toString());
    }

    public void testVarargMethod() {
        Serializable s = MVEL.compileExpression((String)"testee.add('a', 'b')");
        MyVarargTestee testee = new MyVarargTestee();
        MVEL.executeExpression((Object)s, Collections.singletonMap("testee", testee));
        Assert.assertEquals((Object)"multipleArgsMethod[a, b]", (Object)testee.toString());
    }

    public void testNoArgCtorPreference() {
        Serializable s = MVEL.compileExpression((String)("new " + MyVarargTestee.class.getName() + "()"));
        MyVarargTestee result = (MyVarargTestee)MVEL.executeExpression((Object)s);
        Assert.assertEquals((Object)"", (Object)result.toString());
    }

    public void testSingleArgCtorPreference() {
        Serializable s = MVEL.compileExpression((String)("new " + MyVarargTestee.class.getName() + "('a')"));
        MyVarargTestee result = (MyVarargTestee)MVEL.executeExpression((Object)s);
        Assert.assertEquals((Object)"singleArgCtora", (Object)result.toString());
    }

    public void testVarargCtor() {
        Serializable s = MVEL.compileExpression((String)("new " + MyVarargTestee.class.getName() + "('a', 'b')"));
        MyVarargTestee result = (MyVarargTestee)MVEL.executeExpression((Object)s);
        Assert.assertEquals((Object)"multipleArgsCtor[a, b]", (Object)result.toString());
    }

    public static class MyVarargTestee {
        private StringBuilder sb = new StringBuilder();

        public MyVarargTestee() {
        }

        public MyVarargTestee(String arg) {
            this.sb.append("singleArgCtor" + arg);
        }

        public MyVarargTestee(String ... arg) {
            this.sb.append("multipleArgsCtor" + String.valueOf(Arrays.asList(arg)));
        }

        public void add(String arg) {
            this.sb.append("singleArgMethod" + arg);
        }

        public void add(String ... arg) {
            this.sb.append("multipleArgsMethod" + String.valueOf(Arrays.asList(arg)));
        }

        public String toString() {
            return this.sb.toString();
        }
    }
}

