package org.thlws.payment;

import cn.hutool.core.util.StrUtil;
import org.thlws.payment.wechat.api.WechatMpApi;
import org.thlws.payment.wechat.core.WechatMpCore;
import org.thlws.payment.wechat.entity.request.mp.MpObtainOauthTokenRequest;
import org.thlws.payment.wechat.entity.request.mp.MpRefreshOauthTokenRequest;
import org.thlws.payment.wechat.entity.request.mp.MpUserInfoRequest;
import org.thlws.payment.wechat.entity.request.mp.MpValidOauthTokenRequest;
import org.thlws.payment.wechat.entity.response.mp.*;
import org.thlws.utils.ThlwsBeanUtil;

import java.util.Map;


/**
 * 微信公众号入口Class
 * MP名称对应公众号官方网站,https://mp.weixin.qq.com
 *
 * @author Hanley Tang | hanley@thlws.com
 * @version 1.0
 *  2018 /11/16
 */
public class WechatMpClient implements WechatMpApi {


    /***
     * {@link WechatMpCore#obtainOauthAccessToken}
     * @param mapToken the map token
     * @return the oauth token response
     * @throws Exception the exception
     * @author HanleyTang
     */
    public static MpOauthTokenResponse obtainOauthAccessToken(Map<String, Object> mapToken) throws  Exception{
		
		if (null == mapToken){
			throw new Exception("mapToken can not be null");
		}

		return WechatMpCore.obtainOauthAccessToken(mapToken);

	}


	/**
	 * Obtain oauth access token mp oauth token response.
	 *
	 * @param request the request
	 * @return the mp oauth token response
	 * @throws Exception the exception
	 */
	public static MpOauthTokenResponse obtainOauthAccessToken(MpObtainOauthTokenRequest request) throws  Exception{

		if (null == request){
			throw new Exception("request can not be null");
		}

		return WechatMpCore.obtainOauthAccessToken(ThlwsBeanUtil.objectToMap(request));

	}

    /**
     * {@link WechatMpCore#refreshOauthAccessToken}
     *
     * @param mapToken the map token
     * @return the oauth token response
     * @throws Exception the exception
     * @author HanleyTang
     */
    public static MpOauthTokenResponse refreshOauthAccessToken(Map<String, Object> mapToken)throws  Exception{

		if (null == mapToken){
			throw new Exception("mapToken can not be null");
		}

		return WechatMpCore.refreshOauthAccessToken(mapToken);

	}


	/**
	 * Refresh oauth access token mp oauth token response.
	 *
	 * @param request the request
	 * @return the mp oauth token response
	 * @throws Exception the exception
	 */
	public static MpOauthTokenResponse refreshOauthAccessToken(MpRefreshOauthTokenRequest request)throws  Exception{

		if (null == request){
			throw new Exception("request can not be null");
		}
		return WechatMpCore.refreshOauthAccessToken(ThlwsBeanUtil.objectToMap(request));
	}


    /***
     * {@link WechatMpCore#generateWechatUrl}
     * @param appId the app id
     * @param scope the scope
     * @param callback the callback
     * @param bizData the biz data
     * @return string string
     * @throws Exception the exception
     */
    public static  String generateWechatUrl(String appId, String scope, String callback, String bizData) throws Exception {


		if (StrUtil.isEmpty(appId)
		|| StrUtil.isEmpty(scope)
		|| StrUtil.isEmpty(callback)
		|| StrUtil.isEmpty(bizData)){
			throw new Exception("appId,scope,callback,bizData both can not be null");
		}

		return WechatMpCore.generateWechatUrl(appId,scope,callback,bizData);
	}


    /***
     * {@link WechatMpCore#obtainUserInfo}
     * @param userInfoMap the user info map
     * @return user info response
     * @throws Exception the exception
     */
    public static MpUserInfoResponse obtainUserInfo(Map<String, Object> userInfoMap)throws  Exception{
		 
		if (null == userInfoMap){
			throw new Exception("mapToken can not be null");
		}

		return WechatMpCore.obtainUserInfo(userInfoMap);
		
	}


	/**
	 * Obtain user info mp user info response.
	 *
	 * @param request the request
	 * @return the mp user info response
	 * @throws Exception the exception
	 */
	public static MpUserInfoResponse obtainUserInfo(MpUserInfoRequest request)throws  Exception{

		if (null == request){
			throw new Exception("request can not be null");
		}

		return WechatMpCore.obtainUserInfo(ThlwsBeanUtil.objectToMap(request));

	}


    /***
     * {@link WechatMpCore#isvalidOauthAccessToken}
     * @param mapToken the map token
     * @return boolean boolean
     * @throws Exception the exception
     * @author HanleyTang
     */
    public static boolean isvalidOauthAccessToken(Map<String, Object> mapToken)throws  Exception{

		if (null == mapToken){
			throw new Exception("mapToken can not be null");
		}
		return WechatMpCore.isvalidOauthAccessToken(mapToken);

	}


	/**
	 * Isvalid oauth access token boolean.
	 *
	 * @param request the request
	 * @return the boolean
	 * @throws Exception the exception
	 */
	public static boolean isvalidOauthAccessToken(MpValidOauthTokenRequest request)throws  Exception{

		if (null == request){
			throw new Exception("request can not be null");
		}

		return WechatMpCore.isvalidOauthAccessToken(ThlwsBeanUtil.objectToMap(request));

	}


    /***
     * {@link WechatMpCore#obtainAccessToken}
     * @param appid the appid
     * @param secret the secret
     * @return token response
     * @throws Exception the exception
     */
    public static MpTokenResponse obtainAccessToken(String appid, String secret)throws  Exception{

		if (StrUtil.isEmpty(appid) || StrUtil.isEmpty(secret)){
			throw new Exception("appid,secret can not be null");
		}

		return WechatMpCore.obtainAccessToken(appid,secret);

	}


    /***
     * {@link WechatMpCore#obtainJsApiTicket}
     * @param token 普通token
     * @return js api ticket response
     * @throws Exception the exception
     */
    public static MpJsApiTicketResponse obtainJsApiTicket(String token)throws  Exception{


		if (StrUtil.isEmpty(token)){
			throw new Exception("token can not be null");
		}

		return WechatMpCore.obtainJsApiTicket(token);

	}


    /***
     * {@link WechatMpCore#obtainJsApiTicket}
     * @param appid the appid
     * @param secret the secret
     * @return js api ticket response
     * @throws Exception the exception
     */
    public static MpJsApiTicketResponse obtainJsApiTicket(String appid, String secret)throws  Exception{


		if (StrUtil.isEmpty(appid) || StrUtil.isEmpty(secret)){
			throw new Exception("appid,secret can not be null");
		}

		return WechatMpCore.obtainJsApiTicket(appid,secret);

	}


    /***
     * {@link WechatMpCore#obtainTemplateId}
     * @param access_token the access token
     * @param template_id_short the template id short
     * @return template response
     * @throws Exception the exception
     */
    public static MpTemplateResponse obtainTemplateId(String access_token, String template_id_short)throws  Exception{

		if (StrUtil.isEmpty(access_token) || StrUtil.isEmpty(template_id_short)){
			throw new Exception("access_token,template_id_short can not be null");
		}

		return WechatMpCore.obtainTemplateId(access_token,template_id_short);
	}


    /***
     * {@link WechatMpCore#setupIndustry}
     * @param access_token the access token
     * @param industry_id1 the industry id 1
     * @param industry_id2 the industry id 2
     * @return industry response
     * @throws Exception the exception
     */
    public static MpIndustryResponse setupIndustry(String access_token, String industry_id1, String industry_id2)throws  Exception{


		if (StrUtil.isEmpty(access_token)
				|| StrUtil.isEmpty(industry_id1)
				|| StrUtil.isEmpty(industry_id2)){
			throw new Exception("access_token,industry_id1,industry_id2 can not be null");
		}

		return WechatMpCore.setupIndustry(access_token,industry_id1,industry_id2);

	}

    /***
     * {@link WechatMpCore#sendMsgToUser}
     * @param access_token the access token
     * @param data json格式数据,是 {@link org.thlws.payment.wechat.entity.request.mp.MpSendDataRequest} JOSN
     * @return send data response
     * @throws Exception the exception
     */
    public static MpSendDataResponse sendMsgToUser(String access_token, String data)throws  Exception{

		if (StrUtil.isEmpty(access_token)
				|| StrUtil.isEmpty(data)){
			throw new Exception("access_token,data can not be null");
		}

		return WechatMpCore.sendMsgToUser(access_token,data);

	}

}
