/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.trade;

import com.alipay.api.AlipayResponse;
import com.alipay.api.domain.TradeFundBill;
import com.alipay.api.response.AlipayTradePrecreateResponse;
import com.alipay.api.response.AlipayTradeQueryResponse;
import com.alipay.api.response.MonitorHeartbeatSynResponse;
import com.alipay.trade.DemoHbRunner;
import com.alipay.trade.model.ExtendParams;
import com.alipay.trade.model.GoodsDetail;
import com.alipay.trade.model.builder.AlipayHeartbeatSynRequestBuilder;
import com.alipay.trade.model.builder.AlipayTradePayRequestBuilder;
import com.alipay.trade.model.builder.AlipayTradePrecreateRequestBuilder;
import com.alipay.trade.model.builder.AlipayTradeQueryRequestBuilder;
import com.alipay.trade.model.builder.AlipayTradeRefundRequestBuilder;
import com.alipay.trade.model.hb.EquipStatus;
import com.alipay.trade.model.hb.ExceptionInfo;
import com.alipay.trade.model.hb.HbStatus;
import com.alipay.trade.model.hb.PosTradeInfo;
import com.alipay.trade.model.hb.Product;
import com.alipay.trade.model.hb.SysTradeInfo;
import com.alipay.trade.model.hb.Type;
import com.alipay.trade.model.result.AlipayF2FPayResult;
import com.alipay.trade.model.result.AlipayF2FPrecreateResult;
import com.alipay.trade.model.result.AlipayF2FQueryResult;
import com.alipay.trade.model.result.AlipayF2FRefundResult;
import com.alipay.trade.service.AlipayMonitorService;
import com.alipay.trade.service.AlipayTradeService;
import com.alipay.trade.service.impl.AlipayMonitorServiceImpl;
import com.alipay.trade.service.impl.AlipayTradeServiceImpl;
import com.alipay.trade.service.impl.AlipayTradeWithHBServiceImpl;
import com.alipay.trade.utils.Utils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Main {
    private static Log log = LogFactory.getLog(Main.class);
    private static AlipayTradeService tradeService = new AlipayTradeServiceImpl.ClientBuilder().build();
    private static AlipayTradeService tradeWithHBService = new AlipayTradeWithHBServiceImpl.ClientBuilder().build();
    private static AlipayMonitorService monitorService = new AlipayMonitorServiceImpl.ClientBuilder().setGatewayUrl("http://mcloudmonitor.com/gateway.do").setCharset("GBK").setFormat("json").build();

    private void dumpResponse(AlipayResponse response) {
        if (response != null) {
            log.debug((Object)String.format("code:%s, msg:%s", response.getCode(), response.getMsg()));
            if (StringUtils.isNotEmpty((String)response.getSubCode())) {
                log.debug((Object)String.format("subCode:%s, subMsg:%s", response.getSubCode(), response.getSubMsg()));
            }
            log.debug((Object)("body:" + response.getBody()));
        }
    }

    public static void main(String[] args) {
        Main main = new Main();
        main.test_trade_precreate();
    }

    public void test_monitor_schedule_logic() {
        DemoHbRunner demoRunner = new DemoHbRunner(monitorService);
        demoRunner.setDelay(5L);
        demoRunner.setDuration(10L);
        demoRunner.schedule();
        while (Math.random() != 0.0) {
            this.test_trade_pay(tradeWithHBService);
            Utils.sleep(5000L);
        }
        demoRunner.shutdown();
    }

    public void test_monitor_sys() {
        ArrayList<SysTradeInfo> sysTradeInfoList = new ArrayList<SysTradeInfo>();
        sysTradeInfoList.add(SysTradeInfo.newInstance("00000001", 5.2, HbStatus.S));
        sysTradeInfoList.add(SysTradeInfo.newInstance("00000002", 4.4, HbStatus.F));
        sysTradeInfoList.add(SysTradeInfo.newInstance("00000003", 11.3, HbStatus.P));
        sysTradeInfoList.add(SysTradeInfo.newInstance("00000004", 3.2, HbStatus.X));
        sysTradeInfoList.add(SysTradeInfo.newInstance("00000005", 4.1, HbStatus.X));
        ArrayList<ExceptionInfo> exceptionInfoList = new ArrayList<ExceptionInfo>();
        exceptionInfoList.add(ExceptionInfo.HE_SCANER);
        HashMap<String, Object> extendInfo = new HashMap<String, Object>();
        String appAuthToken = "\u5e94\u7528\u6388\u6743\u4ee4\u724c";
        AlipayHeartbeatSynRequestBuilder builder = new AlipayHeartbeatSynRequestBuilder().setAppAuthToken(appAuthToken).setProduct(Product.FP).setType(Type.CR).setEquipmentId("cr1000001").setEquipmentStatus(EquipStatus.NORMAL).setTime(Utils.toDate(new Date())).setStoreId("store10001").setMac("0a:00:27:00:00:00").setNetworkType("LAN").setProviderId("2088911212323549").setSysTradeInfoList(sysTradeInfoList).setExtendInfo(extendInfo);
        MonitorHeartbeatSynResponse response = monitorService.heartbeatSyn(builder);
        this.dumpResponse((AlipayResponse)response);
    }

    public void test_monitor_pos() {
        ArrayList<PosTradeInfo> posTradeInfoList = new ArrayList<PosTradeInfo>();
        posTradeInfoList.add(PosTradeInfo.newInstance(HbStatus.S, "1324", 7));
        posTradeInfoList.add(PosTradeInfo.newInstance(HbStatus.X, "1326", 15));
        posTradeInfoList.add(PosTradeInfo.newInstance(HbStatus.S, "1401", 8));
        posTradeInfoList.add(PosTradeInfo.newInstance(HbStatus.F, "1405", 3));
        ArrayList<ExceptionInfo> exceptionInfoList = new ArrayList<ExceptionInfo>();
        exceptionInfoList.add(ExceptionInfo.HE_PRINTER);
        HashMap<String, Object> extendInfo = new HashMap<String, Object>();
        AlipayHeartbeatSynRequestBuilder builder = new AlipayHeartbeatSynRequestBuilder().setProduct(Product.FP).setType(Type.SOFT_POS).setEquipmentId("soft100001").setEquipmentStatus(EquipStatus.NORMAL).setTime("2015-09-28 11:14:49").setManufacturerPid("2088000000000009").setStoreId("store200001").setEquipmentPosition("31.2433190000,121.5090750000").setBbsPosition("2869719733-065|2896507033-091").setNetworkStatus("gggbbbgggnnn").setNetworkType("3G").setBattery("98").setWifiMac("0a:00:27:00:00:00").setWifiName("test_wifi_name").setIp("192.168.1.188").setPosTradeInfoList(posTradeInfoList).setExtendInfo(extendInfo);
        MonitorHeartbeatSynResponse response = monitorService.heartbeatSyn(builder);
        this.dumpResponse((AlipayResponse)response);
    }

    public void test_trade_pay(AlipayTradeService service) {
        String outTradeNo = "tradepay" + System.currentTimeMillis() + (long)(Math.random() * 1.0E7);
        String subject = "xxx\u54c1\u724cxxx\u95e8\u5e97\u5f53\u9762\u4ed8\u6d88\u8d39";
        String totalAmount = "0.01";
        String authCode = "\u7528\u6237\u81ea\u5df1\u7684\u652f\u4ed8\u5b9d\u4ed8\u6b3e\u7801";
        String undiscountableAmount = "0.0";
        String sellerId = "";
        String body = "\u8d2d\u4e70\u5546\u54c13\u4ef6\u517120.00\u5143";
        String operatorId = "test_operator_id";
        String storeId = "test_store_id";
        String providerId = "2088100200300400500";
        ExtendParams extendParams = new ExtendParams();
        extendParams.setSysServiceProviderId(providerId);
        String timeoutExpress = "5m";
        ArrayList<GoodsDetail> goodsDetailList = new ArrayList<GoodsDetail>();
        GoodsDetail goods1 = GoodsDetail.newInstance("goods_id001", "xxx\u9762\u5305", 1000L, 1);
        goodsDetailList.add(goods1);
        GoodsDetail goods2 = GoodsDetail.newInstance("goods_id002", "xxx\u7259\u5237", 500L, 2);
        goodsDetailList.add(goods2);
        String appAuthToken = "\u5e94\u7528\u6388\u6743\u4ee4\u724c";
        AlipayTradePayRequestBuilder builder = new AlipayTradePayRequestBuilder().setOutTradeNo(outTradeNo).setSubject(subject).setAuthCode(authCode).setTotalAmount(totalAmount).setStoreId(storeId).setUndiscountableAmount(undiscountableAmount).setBody(body).setOperatorId(operatorId).setExtendParams(extendParams).setSellerId(sellerId);
        AlipayF2FPayResult result = service.tradePay(builder);
        switch (result.getTradeStatus()) {
            case SUCCESS: {
                log.debug((Object)"\u652f\u4ed8\u5b9d\u652f\u4ed8\u6210\u529f: )");
                break;
            }
            case FAILED: {
                log.error((Object)"\u652f\u4ed8\u5b9d\u652f\u4ed8\u5931\u8d25!!!");
                break;
            }
            case UNKNOWN: {
                log.error((Object)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8ba2\u5355\u72b6\u6001\u672a\u77e5!!!");
                break;
            }
            default: {
                log.error((Object)"\u4e0d\u652f\u6301\u7684\u4ea4\u6613\u72b6\u6001\uff0c\u4ea4\u6613\u8fd4\u56de\u5f02\u5e38!!!");
            }
        }
    }

    public void test_trade_query() {
        String outTradeNo = "tradepay14817938139942440181";
        AlipayTradeQueryRequestBuilder builder = new AlipayTradeQueryRequestBuilder().setOutTradeNo(outTradeNo);
        AlipayF2FQueryResult result = tradeService.queryTradeResult(builder);
        switch (result.getTradeStatus()) {
            case SUCCESS: {
                log.debug((Object)"\u67e5\u8be2\u8fd4\u56de\u8be5\u8ba2\u5355\u652f\u4ed8\u6210\u529f: )");
                AlipayTradeQueryResponse response = result.getResponse();
                this.dumpResponse((AlipayResponse)response);
                log.debug((Object)response.getTradeStatus());
                if (!Utils.isListNotEmpty(response.getFundBillList())) break;
                for (TradeFundBill bill : response.getFundBillList()) {
                    log.debug((Object)(bill.getFundChannel() + ":" + bill.getAmount()));
                }
                break;
            }
            case FAILED: {
                log.error((Object)"\u67e5\u8be2\u8fd4\u56de\u8be5\u8ba2\u5355\u652f\u4ed8\u5931\u8d25\u6216\u88ab\u5173\u95ed!!!");
                break;
            }
            case UNKNOWN: {
                log.error((Object)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8ba2\u5355\u652f\u4ed8\u72b6\u6001\u672a\u77e5!!!");
                break;
            }
            default: {
                log.error((Object)"\u4e0d\u652f\u6301\u7684\u4ea4\u6613\u72b6\u6001\uff0c\u4ea4\u6613\u8fd4\u56de\u5f02\u5e38!!!");
            }
        }
    }

    public void test_trade_refund() {
        String outTradeNo = "tradepay14817938139942440181";
        String refundAmount = "0.01";
        String outRequestNo = "";
        String refundReason = "\u6b63\u5e38\u9000\u6b3e\uff0c\u7528\u6237\u4e70\u591a\u4e86";
        String storeId = "test_store_id";
        AlipayTradeRefundRequestBuilder builder = new AlipayTradeRefundRequestBuilder().setOutTradeNo(outTradeNo).setRefundAmount(refundAmount).setRefundReason(refundReason).setOutRequestNo(outRequestNo).setStoreId(storeId);
        AlipayF2FRefundResult result = tradeService.tradeRefund(builder);
        switch (result.getTradeStatus()) {
            case SUCCESS: {
                log.debug((Object)"\u652f\u4ed8\u5b9d\u9000\u6b3e\u6210\u529f: )");
                break;
            }
            case FAILED: {
                log.error((Object)"\u652f\u4ed8\u5b9d\u9000\u6b3e\u5931\u8d25!!!");
                break;
            }
            case UNKNOWN: {
                log.error((Object)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8ba2\u5355\u9000\u6b3e\u72b6\u6001\u672a\u77e5!!!");
                break;
            }
            default: {
                log.error((Object)"\u4e0d\u652f\u6301\u7684\u4ea4\u6613\u72b6\u6001\uff0c\u4ea4\u6613\u8fd4\u56de\u5f02\u5e38!!!");
            }
        }
    }

    public void test_trade_precreate() {
        String outTradeNo = "tradeprecreate" + System.currentTimeMillis() + (long)(Math.random() * 1.0E7);
        String subject = "xxx\u54c1\u724cxxx\u95e8\u5e97\u5f53\u9762\u4ed8\u626b\u7801\u6d88\u8d39";
        String totalAmount = "0.01";
        String undiscountableAmount = "0";
        String sellerId = "";
        String body = "\u8d2d\u4e70\u5546\u54c13\u4ef6\u517120.00\u5143";
        String operatorId = "test_operator_id";
        String storeId = "test_store_id";
        ExtendParams extendParams = new ExtendParams();
        extendParams.setSysServiceProviderId("2088100200300400500");
        String timeoutExpress = "120m";
        ArrayList<GoodsDetail> goodsDetailList = new ArrayList<GoodsDetail>();
        GoodsDetail goods1 = GoodsDetail.newInstance("goods_id001", "xxx\u5c0f\u9762\u5305", 1000L, 1);
        goodsDetailList.add(goods1);
        GoodsDetail goods2 = GoodsDetail.newInstance("goods_id002", "xxx\u7259\u5237", 500L, 2);
        goodsDetailList.add(goods2);
        AlipayTradePrecreateRequestBuilder builder = new AlipayTradePrecreateRequestBuilder().setSubject(subject).setTotalAmount(totalAmount).setOutTradeNo(outTradeNo).setUndiscountableAmount(undiscountableAmount).setSellerId(sellerId).setBody(body).setOperatorId(operatorId).setStoreId(storeId).setExtendParams(extendParams).setGoodsDetailList(goodsDetailList);
        AlipayF2FPrecreateResult result = tradeService.tradePrecreate(builder);
        switch (result.getTradeStatus()) {
            case SUCCESS: {
                log.debug((Object)"\u652f\u4ed8\u5b9d\u9884\u4e0b\u5355\u6210\u529f: )");
                AlipayTradePrecreateResponse response = result.getResponse();
                this.dumpResponse((AlipayResponse)response);
                String filePath = String.format("/Users/sudo/Desktop/qr-%s.png", response.getOutTradeNo());
                log.debug((Object)("filePath:" + filePath));
                break;
            }
            case FAILED: {
                log.error((Object)"\u652f\u4ed8\u5b9d\u9884\u4e0b\u5355\u5931\u8d25!!!");
                break;
            }
            case UNKNOWN: {
                log.error((Object)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u9884\u4e0b\u5355\u72b6\u6001\u672a\u77e5!!!");
                break;
            }
            default: {
                log.error((Object)"\u4e0d\u652f\u6301\u7684\u4ea4\u6613\u72b6\u6001\uff0c\u4ea4\u6613\u8fd4\u56de\u5f02\u5e38!!!");
            }
        }
    }
}

