/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.trade.model.builder;

import com.alipay.trade.model.builder.RequestBuilder;
import com.google.gson.annotations.SerializedName;
import org.apache.commons.lang.StringUtils;

public class AlipayTradeQueryRequestBuilder
extends RequestBuilder {
    private BizContent bizContent = new BizContent();

    @Override
    public BizContent getBizContent() {
        return this.bizContent;
    }

    @Override
    public boolean validate() {
        if (StringUtils.isEmpty((String)this.bizContent.tradeNo) && StringUtils.isEmpty((String)this.bizContent.outTradeNo)) {
            throw new IllegalStateException("tradeNo and outTradeNo can not both be NULL!");
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("AlipayTradeQueryRequestBuilder{");
        sb.append("bizContent=").append(this.bizContent);
        sb.append(", super=").append(super.toString());
        sb.append('}');
        return sb.toString();
    }

    @Override
    public AlipayTradeQueryRequestBuilder setAppAuthToken(String appAuthToken) {
        return (AlipayTradeQueryRequestBuilder)super.setAppAuthToken(appAuthToken);
    }

    @Override
    public AlipayTradeQueryRequestBuilder setNotifyUrl(String notifyUrl) {
        return (AlipayTradeQueryRequestBuilder)super.setNotifyUrl(notifyUrl);
    }

    public String getTradeNo() {
        return this.bizContent.tradeNo;
    }

    public AlipayTradeQueryRequestBuilder setTradeNo(String tradeNo) {
        this.bizContent.tradeNo = tradeNo;
        return this;
    }

    public String getOutTradeNo() {
        return this.bizContent.outTradeNo;
    }

    public AlipayTradeQueryRequestBuilder setOutTradeNo(String outTradeNo) {
        this.bizContent.outTradeNo = outTradeNo;
        return this;
    }

    public static class BizContent {
        @SerializedName(value="trade_no")
        private String tradeNo;
        @SerializedName(value="out_trade_no")
        private String outTradeNo;

        public String toString() {
            StringBuilder sb = new StringBuilder("BizContent{");
            sb.append("tradeNo='").append(this.tradeNo).append('\'');
            sb.append(", outTradeNo='").append(this.outTradeNo).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }
}

