/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.trade.service.impl;

import com.alipay.api.DefaultAlipayClient;
import com.alipay.trade.service.impl.AbsAlipayTradeService;
import org.apache.commons.lang.StringUtils;

public class AlipayTradeServiceImpl
extends AbsAlipayTradeService {
    public AlipayTradeServiceImpl(ClientBuilder builder) {
        if (StringUtils.isEmpty((String)builder.getGatewayUrl())) {
            throw new NullPointerException("gatewayUrl should not be NULL!");
        }
        if (StringUtils.isEmpty((String)builder.getAppid())) {
            throw new NullPointerException("appid should not be NULL!");
        }
        if (StringUtils.isEmpty((String)builder.getPrivateKey())) {
            throw new NullPointerException("privateKey should not be NULL!");
        }
        if (StringUtils.isEmpty((String)builder.getFormat())) {
            throw new NullPointerException("format should not be NULL!");
        }
        if (StringUtils.isEmpty((String)builder.getCharset())) {
            throw new NullPointerException("charset should not be NULL!");
        }
        this.client = new DefaultAlipayClient(builder.getGatewayUrl(), builder.getAppid(), builder.getPrivateKey(), builder.getFormat(), builder.getCharset(), builder.getAlipayPublicKey(), builder.getSignType());
    }

    public static class ClientBuilder {
        private String gatewayUrl;
        private String appid;
        private String privateKey;
        private String format;
        private String charset;
        private String alipayPublicKey;
        private String signType;

        public AlipayTradeServiceImpl build() {
            if (StringUtils.isEmpty((String)this.gatewayUrl)) {
                throw new NullPointerException("gatewayUrl should not be NULL!");
            }
            if (StringUtils.isEmpty((String)this.appid)) {
                throw new NullPointerException("appid should not be NULL!");
            }
            if (StringUtils.isEmpty((String)this.privateKey)) {
                throw new NullPointerException("privateKey should not be NULL!");
            }
            if (StringUtils.isEmpty((String)this.format)) {
                this.format = "json";
            }
            if (StringUtils.isEmpty((String)this.charset)) {
                this.charset = "utf-8";
            }
            if (StringUtils.isEmpty((String)this.signType)) {
                throw new NullPointerException("signType should not be NULL!");
            }
            if (this.signType.equalsIgnoreCase("RSA2") && StringUtils.isEmpty((String)this.alipayPublicKey)) {
                throw new NullPointerException("please set alipay_public_key first,when the sign_type is RSA2!");
            }
            return new AlipayTradeServiceImpl(this);
        }

        public ClientBuilder setAlipayPublicKey(String alipayPublicKey) {
            this.alipayPublicKey = alipayPublicKey;
            return this;
        }

        public ClientBuilder setAppid(String appid) {
            this.appid = appid;
            return this;
        }

        public ClientBuilder setCharset(String charset) {
            this.charset = charset;
            return this;
        }

        public ClientBuilder setFormat(String format) {
            this.format = format;
            return this;
        }

        public ClientBuilder setGatewayUrl(String gatewayUrl) {
            this.gatewayUrl = gatewayUrl;
            return this;
        }

        public ClientBuilder setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public String getAlipayPublicKey() {
            return this.alipayPublicKey;
        }

        public String getAppid() {
            return this.appid;
        }

        public String getCharset() {
            return this.charset;
        }

        public String getFormat() {
            return this.format;
        }

        public String getGatewayUrl() {
            return this.gatewayUrl;
        }

        public String getPrivateKey() {
            return this.privateKey;
        }

        public String getSignType() {
            return this.signType;
        }

        public void setSignType(String signType) {
            this.signType = signType;
        }
    }
}

